/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModular;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SUtilService;

public abstract class PHS398ModularBudgetBaseGenerator
extends S2SBaseFormGenerator {
    private static final String EMPTY_STRING = " ";
    private static final String COMMA_SEPERATOR = ",";
    protected S2SUtilService s2sUtilService = KraServiceLocator.getService(S2SUtilService.class);
    protected S2SBudgetCalculatorService s2sBudgetCalculatorService = KraServiceLocator.getService(S2SBudgetCalculatorService.class);
    protected static final int PERSONNEL_JUSTIFICATION_CODE = 35;
    protected static final int CONSORTIUM_JUSTIFICATION_CODE = 36;
    protected static final int NARRATIVE_JUSTIFICATION_CODE = 37;

    protected BudgetDecimal getTotalCost(BudgetModular budgetModular) {
        BudgetDecimal totalCost = BudgetDecimal.ZERO;
        if (budgetModular.getTotalDirectCost() != null) {
            totalCost = budgetModular.getTotalDirectCost();
        }
        for (BudgetModularIdc budgetModularIdc : budgetModular.getBudgetModularIdcs()) {
            if (budgetModularIdc.getFundsRequested() == null) continue;
            totalCost = (BudgetDecimal)totalCost.add(budgetModularIdc.getFundsRequested());
        }
        return totalCost;
    }

    protected String getCognizantFederalAgency(Rolodex rolodex) {
        StringBuilder agency = new StringBuilder();
        if (rolodex.getOrganization() != null) {
            agency.append(rolodex.getOrganization());
        }
        agency.append(COMMA_SEPERATOR);
        if (rolodex.getFirstName() != null) {
            agency.append(rolodex.getFirstName());
        }
        agency.append(EMPTY_STRING);
        if (rolodex.getLastName() != null) {
            agency.append(rolodex.getLastName());
        }
        agency.append(EMPTY_STRING);
        if (rolodex.getPhoneNumber() != null) {
            agency.append(rolodex.getPhoneNumber());
        }
        return agency.toString();
    }
}

