/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.phs398TrainingBudgetV10.PHS398TrainingBudgetDocument;
import gov.grants.apply.forms.phs398TrainingBudgetV10.PHS398TrainingBudgetYearDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.query.And;
import org.kuali.kra.budget.calculator.query.Equals;
import org.kuali.kra.budget.calculator.query.LesserThan;
import org.kuali.kra.budget.calculator.query.Or;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.rates.TrainingStipendRate;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.IndirectCostDetails;
import org.kuali.kra.s2s.generator.bo.IndirectCostInfo;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.krad.service.BusinessObjectService;

public class PHS398TrainingBudgetV1_0Generator
extends S2SBaseFormGenerator {
    private static final String TUITION_OTHER_COST_ELEMENTS = "TUITION_OTHER_COST_ELEMENTS";
    private static final String TUITION_PREDOC_SINGLE_DEG_COST_ELEMENTS = "TUITION_PREDOC_SINGLE_DEG_COST_ELEMENTS";
    private static final String TUITION_PREDOC_DUAL_DEG_COST_ELEMENTS = "TUITION_PREDOC_DUAL_DEG_COST_ELEMENTS";
    private static final String TUITION_UNDERGRAD_COST_ELEMENTS = "TUITION_UNDERGRAD_COST_ELEMENTS";
    private static final String TUITION_POSTDOC_DEG_COST_ELEMENTS = "TUITION_POSTDOC_DEG_COST_ELEMENTS";
    private static final String TUITION_POSTDOC_NONDEG_COST_ELEMENTS = "TUITION_POSTDOC_NONDEG_COST_ELEMENTS";
    private static final String SUBCONTRACT_COST_ELEMENTS = "SUBCONTRACT_COST_ELEMENTS";
    private static final String TRAINING_REL_COST_ELEMENTS = "TRAINING_REL_COST_ELEMENTS";
    private static final String TRAINEE_TRAVEL_COST_ELEMENTS = "TRAINEE_TRAVEL_COST_ELEMENTS";
    private static final String UNDERGRADS = "Undergraduates";
    private static final String PREDOC = "Predoctoral";
    private static final String POSTDOC = "Postdoctoral";
    private static final String STIPEND_AMOUNT = "amount";
    private static final String BUDGET_PERIOD = "period";
    private S2SBudgetCalculatorService s2sBudgetCalculatorService = KraServiceLocator.getService(S2SBudgetCalculatorService.class);
    private DateTimeService dateTimeService = KraServiceLocator.getService(DateTimeService.class);
    private ParameterService parameterService = KraServiceLocator.getService(ParameterService.class);
    private BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
    private static final int PHS_TRAINING_BUDGET_BUDGETJUSTIFICATION_130 = 130;
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD1 = new Integer[]{2, 5, 8, 11, 53, 54, 56};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD2 = new Integer[]{59, 60, 63, 66, 108, 109, 111};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD3 = new Integer[]{114, 115, 118, 121, 164, 165, 167};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD4 = new Integer[]{170, 171, 174, 177, 219, 220, 222};
    private static final Integer[] PREDOC_PARENT_QUESTION_IDS_PERIOD5 = new Integer[]{225, 226, 229, 232, 274, 275, 277};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD1 = new Integer[]{17, 26, 35, 44};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD2 = new Integer[]{72, 81, 90, 99};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD3 = new Integer[]{127, 136, 146, 155};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD4 = new Integer[]{183, 192, 201, 210};
    private static final Integer[] POSTDOC_PARENT_QUESTION_IDS_PERIOD5 = new Integer[]{238, 247, 256, 265};
    private static final int FN_INDEX = 0;
    private static final int SN_INDEX = 1;
    private static final int FD_INDEX = 2;
    private static final int SD_INDEX = 3;
    private static final int ZERO = 0;

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) throws S2SException {
        PHS398TrainingBudgetDocument trainingBudgetTypeDocument = PHS398TrainingBudgetDocument.Factory.newInstance();
        trainingBudgetTypeDocument.setPHS398TrainingBudget(this.getPHS398TrainingBudget(proposalDevelopmentDocument));
        return trainingBudgetTypeDocument;
    }

    private PHS398TrainingBudgetDocument.PHS398TrainingBudget getPHS398TrainingBudget(ProposalDevelopmentDocument proposalDevelopmentDocument) throws S2SException {
        DevelopmentProposal developmentProposal = proposalDevelopmentDocument.getDevelopmentProposal();
        BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(proposalDevelopmentDocument);
        PHS398TrainingBudgetDocument.PHS398TrainingBudget trainingBudgetType = PHS398TrainingBudgetDocument.PHS398TrainingBudget.Factory.newInstance();
        if (budgetDocument == null) {
            return trainingBudgetType;
        }
        Budget budget = budgetDocument.getBudget();
        trainingBudgetType.setFormVersion("1.0");
        trainingBudgetType.setBudgetType(PHS398TrainingBudgetDocument.PHS398TrainingBudget.BudgetType.PROJECT);
        this.setOrganizationData(trainingBudgetType, developmentProposal);
        HashMap hmbudgetinfo = new HashMap();
        int numPeople = 0;
        BigDecimal stipendAmountOtherFull = new BigDecimal("0");
        BigDecimal stipendAmountOtherShort = new BigDecimal("0");
        BigDecimal stipendAmountF = new BigDecimal("0");
        BigDecimal stipendAmountJ = new BigDecimal("0");
        BigDecimal stipendAmountPreSingFull = new BigDecimal("0");
        BigDecimal stipendAmountPreDualFull = new BigDecimal("0");
        BigDecimal stipendAmountPreSingShort = new BigDecimal("0");
        BigDecimal stipendAmountPreDualShort = new BigDecimal("0");
        BigDecimal stipendAmount0 = new BigDecimal("0");
        BigDecimal stipendAmount1 = new BigDecimal("0");
        BigDecimal stipendAmount2 = new BigDecimal("0");
        BigDecimal stipendAmount3 = new BigDecimal("0");
        BigDecimal stipendAmount4 = new BigDecimal("0");
        BigDecimal stipendAmount5 = new BigDecimal("0");
        BigDecimal stipendAmount6 = new BigDecimal("0");
        BigDecimal stipendAmount7 = new BigDecimal("0");
        BigDecimal stipendAmountDeg0 = new BigDecimal("0");
        BigDecimal stipendAmountDeg1 = new BigDecimal("0");
        BigDecimal stipendAmountDeg2 = new BigDecimal("0");
        BigDecimal stipendAmountDeg3 = new BigDecimal("0");
        BigDecimal stipendAmountDeg4 = new BigDecimal("0");
        BigDecimal stipendAmountDeg5 = new BigDecimal("0");
        BigDecimal stipendAmountDeg6 = new BigDecimal("0");
        BigDecimal stipendAmountDeg7 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg0 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg1 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg2 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg3 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg4 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg5 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg6 = new BigDecimal("0");
        BigDecimal stipendAmountNonDeg7 = new BigDecimal("0");
        BigDecimal cumUndergradStipends = new BigDecimal("0");
        BigDecimal cumPreDocSingleStipends = new BigDecimal("0");
        BigDecimal cumPreDocDualStipends = new BigDecimal("0");
        BigDecimal cumPreDocTotalStipends = new BigDecimal("0");
        BigDecimal cumPostDocNonDegStipends = new BigDecimal("0");
        BigDecimal cumPostDocDegStipends = new BigDecimal("0");
        BigDecimal cumPostDocTotalStipends = new BigDecimal("0");
        BigDecimal cumOtherStipends = new BigDecimal("0");
        BigDecimal cumUndergradTuition = new BigDecimal("0");
        BigDecimal cumPreDocSingleTuition = new BigDecimal("0");
        BigDecimal cumPreDocDualTuition = new BigDecimal("0");
        BigDecimal cumPreDocTotalTuition = new BigDecimal("0");
        BigDecimal cumPostDocNonDegTuition = new BigDecimal("0");
        BigDecimal cumPostDocDegTuition = new BigDecimal("0");
        BigDecimal cumPostDocTotalTuition = new BigDecimal("0");
        BigDecimal cumOtherTuition = new BigDecimal("0");
        BigDecimal cumTrainingCosts = new BigDecimal("0");
        BigDecimal cumTravelCosts = new BigDecimal("0");
        BigDecimal cumConsCosts = new BigDecimal("0");
        BigDecimal cumResearchTotalDirectCosts = new BigDecimal("0");
        BigDecimal cumTotalOtherDirectCosts = new BigDecimal("0");
        BigDecimal cumTotalDirectCosts = new BigDecimal("0");
        BigDecimal cumTotalIndCosts1 = new BigDecimal("0");
        BigDecimal cumTotalIndCosts2 = new BigDecimal("0");
        BigDecimal cumTotalIndCosts = new BigDecimal("0");
        BigDecimal cumTotalDirectAndIndCosts = new BigDecimal("0");
        BigDecimal researchDirectCosts = new BigDecimal("0");
        BigDecimal totalOtherDirectCostsRequested = new BigDecimal("0");
        List<BudgetPeriod> budgetPeriods = budget.getBudgetPeriods();
        for (BudgetPeriod budgetPeriod : budgetPeriods) {
            Double researchDirectCostValue;
            hmbudgetinfo = new HashMap();
            PHS398TrainingBudgetYearDataType phs398TrainingBudgetYearDataType = trainingBudgetType.addNewBudgetYear();
            BudgetDecimal trainingTraveCost = this.getBudgetPeriodCost(budgetPeriod, TRAINEE_TRAVEL_COST_ELEMENTS);
            phs398TrainingBudgetYearDataType.setTraineeTravelRequested(trainingTraveCost.bigDecimalValue());
            BudgetDecimal trainingCost = this.getBudgetPeriodCost(budgetPeriod, TRAINING_REL_COST_ELEMENTS);
            phs398TrainingBudgetYearDataType.setTrainingRelatedExpensesRequested(trainingCost.bigDecimalValue());
            BudgetDecimal consTrainingCost = this.getBudgetPeriodCost(budgetPeriod, SUBCONTRACT_COST_ELEMENTS);
            phs398TrainingBudgetYearDataType.setConsortiumTrainingCostsRequested(consTrainingCost.bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPostdocNonDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, TUITION_POSTDOC_NONDEG_COST_ELEMENTS).bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPostdocDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, TUITION_POSTDOC_DEG_COST_ELEMENTS).bigDecimalValue());
            phs398TrainingBudgetYearDataType.setUndergraduateTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, TUITION_UNDERGRAD_COST_ELEMENTS).bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPredocDualDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, TUITION_PREDOC_DUAL_DEG_COST_ELEMENTS).bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPredocSingleDegreeTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, TUITION_PREDOC_SINGLE_DEG_COST_ELEMENTS).bigDecimalValue());
            phs398TrainingBudgetYearDataType.setOtherTuitionAndFeesRequested(this.getBudgetPeriodCost(budgetPeriod, TUITION_OTHER_COST_ELEMENTS).bigDecimalValue());
            phs398TrainingBudgetYearDataType.setPeriodEndDate(this.dateTimeService.getCalendar((Date)budgetPeriod.getEndDate()));
            phs398TrainingBudgetYearDataType.setPeriodStartDate(this.dateTimeService.getCalendar((Date)budgetPeriod.getStartDate()));
            cumUndergradTuition = cumUndergradTuition.add(phs398TrainingBudgetYearDataType.getUndergraduateTuitionAndFeesRequested());
            cumPreDocSingleTuition = cumPreDocSingleTuition.add(phs398TrainingBudgetYearDataType.getPredocSingleDegreeTuitionAndFeesRequested());
            cumPreDocDualTuition = cumPreDocDualTuition.add(phs398TrainingBudgetYearDataType.getPredocDualDegreeTuitionAndFeesRequested());
            cumPostDocNonDegTuition = cumPostDocNonDegTuition.add(phs398TrainingBudgetYearDataType.getPostdocNonDegreeTuitionAndFeesRequested());
            cumPostDocDegTuition = cumPostDocDegTuition.add(phs398TrainingBudgetYearDataType.getPostdocDegreeTuitionAndFeesRequested());
            cumPostDocTotalTuition = cumPostDocNonDegTuition.add(cumPostDocDegTuition);
            cumOtherTuition = cumOtherTuition.add(phs398TrainingBudgetYearDataType.getOtherTuitionAndFeesRequested());
            cumTrainingCosts = cumTrainingCosts.add(phs398TrainingBudgetYearDataType.getTrainingRelatedExpensesRequested());
            cumTravelCosts = cumTravelCosts.add(phs398TrainingBudgetYearDataType.getTraineeTravelRequested());
            cumConsCosts = cumConsCosts.add(phs398TrainingBudgetYearDataType.getConsortiumTrainingCostsRequested());
            IndirectCostInfo indirectCostInfo = this.s2sBudgetCalculatorService.getIndirectCosts(budgetPeriod.getBudget(), budgetPeriod);
            List<IndirectCostDetails> cvIndirectCost = indirectCostInfo.getIndirectCostDetails();
            BigDecimal totIndCosts = new BigDecimal("0");
            int i = 0;
            while (i < cvIndirectCost.size() & i < 2) {
                IndirectCostDetails indireCost = cvIndirectCost.get(i);
                totIndCosts = totIndCosts.add(indireCost.getFunds().bigDecimalValue());
                switch (i) {
                    case 0: {
                        phs398TrainingBudgetYearDataType.setIndirectCostType1(indireCost.getCostType());
                        phs398TrainingBudgetYearDataType.setIndirectCostBase1(indireCost.getBase().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostFundsRequested1(indireCost.getFunds().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostRate1(indireCost.getRate().bigDecimalValue());
                        cumTotalIndCosts1 = cumTotalIndCosts1.add(phs398TrainingBudgetYearDataType.getIndirectCostFundsRequested1());
                        break;
                    }
                    case 1: {
                        phs398TrainingBudgetYearDataType.setIndirectCostType1(indireCost.getCostType());
                        phs398TrainingBudgetYearDataType.setIndirectCostBase2(indireCost.getBase().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostFundsRequested2(indireCost.getFunds().bigDecimalValue());
                        phs398TrainingBudgetYearDataType.setIndirectCostRate2(indireCost.getRate().bigDecimalValue());
                        cumTotalIndCosts2 = cumTotalIndCosts2.add(phs398TrainingBudgetYearDataType.getIndirectCostFundsRequested2());
                        break;
                    }
                }
                ++i;
            }
            phs398TrainingBudgetYearDataType.setTotalIndirectCostsRequested(totIndCosts);
            int numPostDocLevel4 = 0;
            int numPostDocLevel7 = 0;
            HashMap<String, String> hmNonDegree = new HashMap<String, String>();
            HashMap<String, String> hmDegree = new HashMap<String, String>();
            hmNonDegree.put("fulllevel0", "0");
            hmNonDegree.put("fulllevel1", "0");
            hmNonDegree.put("fulllevel2", "0");
            hmNonDegree.put("fulllevel3", "0");
            hmNonDegree.put("fulllevel4", "0");
            hmNonDegree.put("fulllevel5", "0");
            hmNonDegree.put("fulllevel6", "0");
            hmNonDegree.put("fulllevel7", "0");
            hmNonDegree.put("shortlevel0", "0");
            hmNonDegree.put("shortlevel1", "0");
            hmNonDegree.put("shortlevel2", "0");
            hmNonDegree.put("shortlevel3", "0");
            hmNonDegree.put("shortlevel4", "0");
            hmNonDegree.put("shortlevel5", "0");
            hmNonDegree.put("shortlevel6", "0");
            hmNonDegree.put("shortlevel7", "0");
            String answer = null;
            int preDocCountFull = 0;
            int preDocCountShort = 0;
            int undergradFirstYearNum = 0;
            int undergradJrNum = 0;
            BigDecimal otherShortStipends = new BigDecimal("0");
            BigDecimal otherFullStipends = new BigDecimal("0");
            List<AnswerHeader> answerHeaders = this.findQuestionnaireWithAnswers(developmentProposal, budgetPeriod.getBudgetPeriod());
            if (answerHeaders != null) {
                for (AnswerHeader answerHeader : answerHeaders) {
                    Questionnaire questionnaire = answerHeader.getQuestionnaire();
                    List<QuestionnaireQuestion> questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
                    for (QuestionnaireQuestion questionnaireQuestion : questionnaireQuestions) {
                        Answer answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                        answer = answerBO.getAnswer();
                        Question question = questionnaireQuestion.getQuestion();
                        if (answer == null) continue;
                        int answerIntVal = 0;
                        try {
                            answerIntVal = Integer.parseInt(answer);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                        if (this.isPreDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod)) {
                            switch (question.getQuestionIdAsInteger()) {
                                case 72: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setUndergraduateNumFullTime(answerIntVal);
                                    break;
                                }
                                case 73: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setUndergraduateNumShortTerm(answerIntVal);
                                    break;
                                }
                                case 74: {
                                    if (answer == null) break;
                                    undergradFirstYearNum += answerIntVal;
                                    break;
                                }
                                case 75: {
                                    if (answer == null) break;
                                    undergradJrNum += answerIntVal;
                                    break;
                                }
                                case 77: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocSingleDegreeNumFullTime(answerIntVal);
                                    preDocCountFull += phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumFullTime();
                                    break;
                                }
                                case 78: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocSingleDegreeNumShortTerm(answerIntVal);
                                    preDocCountShort += phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumShortTerm();
                                    break;
                                }
                                case 79: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocDualDegreeNumFullTime(answerIntVal);
                                    preDocCountFull += phs398TrainingBudgetYearDataType.getPredocDualDegreeNumFullTime();
                                    break;
                                }
                                case 80: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setPredocDualDegreeNumShortTerm(answerIntVal);
                                    preDocCountShort += phs398TrainingBudgetYearDataType.getPredocDualDegreeNumShortTerm();
                                    break;
                                }
                                case 95: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setOtherNumFullTime(answerIntVal);
                                    break;
                                }
                                case 97: {
                                    if (answer == null) break;
                                    phs398TrainingBudgetYearDataType.setOtherNumShortTerm(answerIntVal);
                                    break;
                                }
                                case 96: {
                                    if (answer == null) break;
                                    otherFullStipends = new BigDecimal(answer.toString());
                                    break;
                                }
                                case 98: {
                                    if (answer == null) break;
                                    otherShortStipends = new BigDecimal(answer.toString());
                                }
                            }
                        }
                        if (this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 0)) {
                            switch (question.getQuestionIdAsInteger()) {
                                case 86: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel0", answer);
                                    break;
                                }
                                case 87: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel1", answer);
                                    break;
                                }
                                case 88: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel2", answer);
                                    break;
                                }
                                case 89: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel3", answer);
                                    break;
                                }
                                case 90: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel4", answer);
                                    break;
                                }
                                case 91: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel5", answer);
                                    break;
                                }
                                case 92: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel6", answer);
                                    break;
                                }
                                case 93: {
                                    if (answer == null) break;
                                    hmNonDegree.put("fulllevel7", answer);
                                    break;
                                }
                            }
                        }
                        if (!this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 1)) continue;
                        switch (question.getQuestionIdAsInteger()) {
                            case 86: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel0", answer);
                                break;
                            }
                            case 87: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel1", answer);
                                break;
                            }
                            case 88: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel2", answer);
                                break;
                            }
                            case 89: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel3", answer);
                                break;
                            }
                            case 90: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel4", answer);
                                break;
                            }
                            case 91: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel5", answer);
                                break;
                            }
                            case 92: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel6", answer);
                                break;
                            }
                            case 93: {
                                if (answer == null) break;
                                hmNonDegree.put("shortlevel7", answer);
                                break;
                            }
                        }
                    }
                }
            }
            phs398TrainingBudgetYearDataType.setUndergraduateNumFirstYearSophomoreStipends(undergradFirstYearNum);
            phs398TrainingBudgetYearDataType.setUndergraduateNumJuniorSeniorStipends(undergradJrNum);
            phs398TrainingBudgetYearDataType.setOtherStipendsRequested(otherShortStipends.add(otherFullStipends));
            phs398TrainingBudgetYearDataType.setPredocTotalNumShortTerm(preDocCountShort);
            phs398TrainingBudgetYearDataType.setPredocTotalNumFullTime(preDocCountFull);
            cumOtherStipends = cumOtherStipends.add(phs398TrainingBudgetYearDataType.getOtherStipendsRequested());
            int postDocNumNonDegreeFullTime = Integer.parseInt(((String)hmNonDegree.get("fulllevel0")).toString()) + Integer.parseInt(((String)hmNonDegree.get("fulllevel1")).toString()) + Integer.parseInt(((String)hmNonDegree.get("fulllevel2")).toString()) + Integer.parseInt(((String)hmNonDegree.get("fulllevel3")).toString()) + Integer.parseInt(((String)hmNonDegree.get("fulllevel4")).toString()) + Integer.parseInt(((String)hmNonDegree.get("fulllevel5")).toString()) + Integer.parseInt(((String)hmNonDegree.get("fulllevel6")).toString()) + Integer.parseInt(((String)hmNonDegree.get("fulllevel7")).toString());
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeFullTime(postDocNumNonDegreeFullTime);
            int postDocNumNonDegreeShortTerm = Integer.parseInt(((String)hmNonDegree.get("shortlevel0")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel1")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel2")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel3")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel4")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel5")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel6")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel7")).toString());
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeShortTerm(postDocNumNonDegreeShortTerm);
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel0(Integer.parseInt(((String)hmNonDegree.get("fulllevel0")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel0")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel1(Integer.parseInt(((String)hmNonDegree.get("fulllevel1")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel1")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel2(Integer.parseInt(((String)hmNonDegree.get("fulllevel2")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel2")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel3(Integer.parseInt(((String)hmNonDegree.get("fulllevel3")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel3")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel4(Integer.parseInt(((String)hmNonDegree.get("fulllevel4")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel4")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel5(Integer.parseInt(((String)hmNonDegree.get("fulllevel5")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel5")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel6(Integer.parseInt(((String)hmNonDegree.get("fulllevel6")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel6")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumNonDegreeStipendLevel7(Integer.parseInt(((String)hmNonDegree.get("fulllevel7")).toString()) + Integer.parseInt(((String)hmNonDegree.get("shortlevel7")).toString()));
            answer = null;
            hmDegree.put("fulllevel0", "0");
            hmDegree.put("fulllevel1", "0");
            hmDegree.put("fulllevel2", "0");
            hmDegree.put("fulllevel3", "0");
            hmDegree.put("fulllevel4", "0");
            hmDegree.put("fulllevel5", "0");
            hmDegree.put("fulllevel6", "0");
            hmDegree.put("fulllevel7", "0");
            hmDegree.put("shortlevel0", "0");
            hmDegree.put("shortlevel1", "0");
            hmDegree.put("shortlevel2", "0");
            hmDegree.put("shortlevel3", "0");
            hmDegree.put("shortlevel4", "0");
            hmDegree.put("shortlevel5", "0");
            hmDegree.put("shortlevel6", "0");
            hmDegree.put("shortlevel7", "0");
            if (answerHeaders != null) {
                for (AnswerHeader answerHeader : answerHeaders) {
                    Questionnaire questionnaire = answerHeader.getQuestionnaire();
                    List<QuestionnaireQuestion> questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
                    for (QuestionnaireQuestion questionnaireQuestion : questionnaireQuestions) {
                        Answer answerBO = this.getAnswer(questionnaireQuestion, answerHeader);
                        answer = answerBO.getAnswer();
                        Question question = questionnaireQuestion.getQuestion();
                        if (answer == null) continue;
                        int answerIntVal = 0;
                        try {
                            answerIntVal = Integer.parseInt(answer);
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                        if (this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 2)) {
                            switch (question.getQuestionIdAsInteger()) {
                                case 86: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel0", answer);
                                    break;
                                }
                                case 87: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel1", answer);
                                    break;
                                }
                                case 88: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel2", answer);
                                    break;
                                }
                                case 89: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel3", answer);
                                    break;
                                }
                                case 90: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel4", answer);
                                    break;
                                }
                                case 91: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel5", answer);
                                    break;
                                }
                                case 92: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel6", answer);
                                    break;
                                }
                                case 93: {
                                    if (answer == null) break;
                                    hmDegree.put("fulllevel7", answer);
                                    break;
                                }
                            }
                        }
                        if (!this.isPostDocParentQuestionFromPeriodExists(questionnaireQuestion, budgetPeriod, 3)) continue;
                        switch (question.getQuestionIdAsInteger()) {
                            case 86: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel0", answer);
                                break;
                            }
                            case 87: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel1", answer);
                                break;
                            }
                            case 88: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel2", answer);
                                break;
                            }
                            case 89: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel3", answer);
                                break;
                            }
                            case 90: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel4", answer);
                                break;
                            }
                            case 91: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel5", answer);
                                break;
                            }
                            case 92: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel6", answer);
                                break;
                            }
                            case 93: {
                                if (answer == null) break;
                                hmDegree.put("shortlevel7", answer);
                                break;
                            }
                        }
                    }
                }
            }
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel0(Integer.parseInt(((String)hmDegree.get("fulllevel0")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel0")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel1(Integer.parseInt(((String)hmDegree.get("fulllevel1")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel1")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel2(Integer.parseInt(((String)hmDegree.get("fulllevel2")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel2")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel3(Integer.parseInt(((String)hmDegree.get("fulllevel3")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel3")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel4(Integer.parseInt(((String)hmDegree.get("fulllevel4")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel4")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel5(Integer.parseInt(((String)hmDegree.get("fulllevel5")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel5")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel6(Integer.parseInt(((String)hmDegree.get("fulllevel6")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel6")).toString()));
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeStipendLevel7(Integer.parseInt(((String)hmDegree.get("fulllevel7")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel7")).toString()));
            int postDocNumDegreeFulltime = Integer.parseInt(((String)hmDegree.get("fulllevel0")).toString()) + Integer.parseInt(((String)hmDegree.get("fulllevel1")).toString()) + Integer.parseInt(((String)hmDegree.get("fulllevel2")).toString()) + Integer.parseInt(((String)hmDegree.get("fulllevel3")).toString()) + Integer.parseInt(((String)hmDegree.get("fulllevel4")).toString()) + Integer.parseInt(((String)hmDegree.get("fulllevel5")).toString()) + Integer.parseInt(((String)hmDegree.get("fulllevel6")).toString()) + Integer.parseInt(((String)hmDegree.get("fulllevel7")).toString());
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeFullTime(postDocNumDegreeFulltime);
            int postDocNumDegreeShortTerm = Integer.parseInt(((String)hmDegree.get("shortlevel0")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel1")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel2")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel3")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel4")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel5")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel6")).toString()) + Integer.parseInt(((String)hmDegree.get("shortlevel7")).toString());
            phs398TrainingBudgetYearDataType.setPostdocNumDegreeShortTerm(postDocNumDegreeShortTerm);
            phs398TrainingBudgetYearDataType.setPostdocTotalShortTerm(phs398TrainingBudgetYearDataType.getPostdocNumDegreeShortTerm() + phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeShortTerm());
            phs398TrainingBudgetYearDataType.setPostdocTotalFullTime(phs398TrainingBudgetYearDataType.getPostdocNumDegreeFullTime() + phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeFullTime());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel0(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel0() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel0());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel1(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel1() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel1());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel2(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel2() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel2());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel3(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel3() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel3());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel4(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel4() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel4());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel5(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel5() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel5());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel6(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel6() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel6());
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendLevel7(phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel7() + phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel7());
            numPeople = phs398TrainingBudgetYearDataType.getUndergraduateNumFirstYearSophomoreStipends();
            stipendAmountF = this.getStipendAmount(budgetPeriod, UNDERGRADS, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getUndergraduateNumJuniorSeniorStipends();
            stipendAmountJ = this.getStipendAmount(budgetPeriod, UNDERGRADS, 1, numPeople);
            phs398TrainingBudgetYearDataType.setUndergraduateStipendsRequested(stipendAmountF.add(stipendAmountJ));
            cumUndergradStipends = cumUndergradStipends.add(phs398TrainingBudgetYearDataType.getUndergraduateStipendsRequested());
            numPeople = phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumFullTime();
            stipendAmountPreSingFull = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getPredocDualDegreeNumFullTime();
            stipendAmountPreDualFull = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getPredocSingleDegreeNumShortTerm();
            stipendAmountPreSingShort = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            numPeople = phs398TrainingBudgetYearDataType.getPredocDualDegreeNumShortTerm();
            stipendAmountPreDualShort = this.getStipendAmount(budgetPeriod, PREDOC, 0, numPeople);
            phs398TrainingBudgetYearDataType.setPredocSingleDegreeStipendsRequested(stipendAmountPreSingFull.add(stipendAmountPreSingShort));
            phs398TrainingBudgetYearDataType.setPredocDualDegreeStipendsRequested(stipendAmountPreDualFull.add(stipendAmountPreDualShort));
            phs398TrainingBudgetYearDataType.setPredocTotalStipendsRequested(stipendAmountPreSingFull.add(stipendAmountPreDualFull.add(stipendAmountPreSingShort).add(stipendAmountPreDualShort)));
            cumPreDocSingleStipends = cumPreDocSingleStipends.add(stipendAmountPreSingFull).add(stipendAmountPreSingShort);
            cumPreDocDualStipends = cumPreDocDualStipends.add(stipendAmountPreDualFull).add(stipendAmountPreDualShort);
            cumPreDocTotalStipends = cumPreDocSingleStipends.add(cumPreDocDualStipends);
            cumPreDocTotalTuition = cumPreDocDualTuition.add(cumPreDocSingleTuition);
            int numPostDocLevel0 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel0();
            stipendAmountNonDeg0 = this.getStipendAmount(budgetPeriod, POSTDOC, 0, numPostDocLevel0);
            numPostDocLevel0 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel0();
            stipendAmountDeg0 = this.getStipendAmount(budgetPeriod, POSTDOC, 0, numPostDocLevel0);
            int numPostDocLevel1 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel1();
            stipendAmountNonDeg1 = this.getStipendAmount(budgetPeriod, POSTDOC, 1, numPostDocLevel1);
            numPostDocLevel1 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel1();
            stipendAmountDeg1 = this.getStipendAmount(budgetPeriod, POSTDOC, 1, numPostDocLevel1);
            int numPostDocLevel2 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel2();
            stipendAmountNonDeg2 = this.getStipendAmount(budgetPeriod, POSTDOC, 2, numPostDocLevel2);
            numPostDocLevel2 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel2();
            stipendAmountDeg2 = this.getStipendAmount(budgetPeriod, POSTDOC, 2, numPostDocLevel2);
            int numPostDocLevel3 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel3();
            stipendAmountNonDeg3 = this.getStipendAmount(budgetPeriod, POSTDOC, 3, numPostDocLevel3);
            numPostDocLevel3 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel3();
            stipendAmountDeg3 = this.getStipendAmount(budgetPeriod, POSTDOC, 3, numPostDocLevel3);
            numPostDocLevel4 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel4();
            stipendAmountNonDeg4 = this.getStipendAmount(budgetPeriod, POSTDOC, 4, numPostDocLevel4);
            numPostDocLevel4 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel4();
            stipendAmountDeg4 = this.getStipendAmount(budgetPeriod, POSTDOC, 4, numPostDocLevel4);
            int numPostDocLevel5 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel5();
            stipendAmountNonDeg5 = this.getStipendAmount(budgetPeriod, POSTDOC, 5, numPostDocLevel5);
            numPostDocLevel5 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel5();
            stipendAmountDeg5 = this.getStipendAmount(budgetPeriod, POSTDOC, 5, numPostDocLevel5);
            int numPostDocLevel6 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel6();
            stipendAmountNonDeg6 = this.getStipendAmount(budgetPeriod, POSTDOC, 6, numPostDocLevel6);
            numPostDocLevel6 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel6();
            stipendAmountDeg6 = this.getStipendAmount(budgetPeriod, POSTDOC, 6, numPostDocLevel6);
            numPostDocLevel7 = phs398TrainingBudgetYearDataType.getPostdocNumNonDegreeStipendLevel7();
            stipendAmountNonDeg7 = this.getStipendAmount(budgetPeriod, POSTDOC, 7, numPostDocLevel7);
            numPostDocLevel7 = phs398TrainingBudgetYearDataType.getPostdocNumDegreeStipendLevel7();
            stipendAmountDeg7 = this.getStipendAmount(budgetPeriod, POSTDOC, 7, numPostDocLevel7);
            phs398TrainingBudgetYearDataType.setPostdocDegreeStipendsRequested(stipendAmountDeg0.add(stipendAmountDeg1).add(stipendAmountDeg2).add(stipendAmountDeg3).add(stipendAmountDeg4).add(stipendAmountDeg5).add(stipendAmountDeg6).add(stipendAmountDeg7));
            phs398TrainingBudgetYearDataType.setPostdocNonDegreeStipendsRequested(stipendAmountNonDeg0.add(stipendAmountNonDeg1).add(stipendAmountNonDeg2).add(stipendAmountNonDeg3).add(stipendAmountNonDeg4).add(stipendAmountNonDeg5).add(stipendAmountNonDeg6).add(stipendAmountNonDeg7));
            phs398TrainingBudgetYearDataType.setPostdocTotalStipendsRequested(phs398TrainingBudgetYearDataType.getPostdocNonDegreeStipendsRequested().add(phs398TrainingBudgetYearDataType.getPostdocDegreeStipendsRequested()));
            phs398TrainingBudgetYearDataType.setPostdocTotalTuitionAndFeesRequested(phs398TrainingBudgetYearDataType.getPostdocDegreeTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPostdocNonDegreeTuitionAndFeesRequested()));
            phs398TrainingBudgetYearDataType.setPredocTotalTuitionAndFeesRequested(phs398TrainingBudgetYearDataType.getPredocDualDegreeTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPredocSingleDegreeTuitionAndFeesRequested()));
            phs398TrainingBudgetYearDataType.setTotalTuitionAndFeesRequested(phs398TrainingBudgetYearDataType.getPredocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPostdocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getUndergraduateTuitionAndFeesRequested())).add(phs398TrainingBudgetYearDataType.getOtherTuitionAndFeesRequested()));
            phs398TrainingBudgetYearDataType.setTotalStipendsRequested(phs398TrainingBudgetYearDataType.getPostdocTotalStipendsRequested().add(phs398TrainingBudgetYearDataType.getPredocTotalStipendsRequested().add(phs398TrainingBudgetYearDataType.getUndergraduateStipendsRequested())).add(phs398TrainingBudgetYearDataType.getOtherStipendsRequested()));
            phs398TrainingBudgetYearDataType.setTotalStipendsAndTuitionFeesRequested(phs398TrainingBudgetYearDataType.getTotalStipendsRequested().add(phs398TrainingBudgetYearDataType.getPostdocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getPredocTotalTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getUndergraduateTuitionAndFeesRequested().add(phs398TrainingBudgetYearDataType.getOtherTuitionAndFeesRequested())))));
            researchDirectCosts = ((BudgetDecimal)((BudgetDecimal)((BudgetDecimal)budgetPeriod.getTotalDirectCost().subtract(trainingCost)).subtract(trainingTraveCost)).subtract(consTrainingCost)).bigDecimalValue();
            researchDirectCosts = researchDirectCosts.subtract(phs398TrainingBudgetYearDataType.getTotalStipendsAndTuitionFeesRequested());
            phs398TrainingBudgetYearDataType.setResearchDirectCostsRequested(researchDirectCosts);
            if (phs398TrainingBudgetYearDataType.getResearchDirectCostsRequested() != null && (researchDirectCostValue = Double.valueOf(phs398TrainingBudgetYearDataType.getResearchDirectCostsRequested().doubleValue())) < 0.0) {
                String researchDirectCostValueStipend = researchDirectCostValue.toString();
                String budgetYear = budgetPeriod.getBudgetPeriod().toString();
                AuditError stipendError = new AuditError("noField", "A stipend budget line item is required equal to or greater than the trainee numbers and associated stipend levels indicated in the questionnaire.Currently the stipend value in the budget is in deficit by (amount) for Year period of the budget.", "grantsGov.Opportunity");
                String errorMessage = stipendError.getMessageKey();
                errorMessage = errorMessage.replace(STIPEND_AMOUNT, researchDirectCostValueStipend);
                errorMessage = errorMessage.replace(BUDGET_PERIOD, budgetYear);
                stipendError.setMessageKey(errorMessage);
                this.getAuditErrors().add(stipendError);
            }
            totalOtherDirectCostsRequested = budgetPeriod.getTotalDirectCost().bigDecimalValue();
            totalOtherDirectCostsRequested = totalOtherDirectCostsRequested.subtract(phs398TrainingBudgetYearDataType.getTotalStipendsAndTuitionFeesRequested());
            phs398TrainingBudgetYearDataType.setTotalOtherDirectCostsRequested(totalOtherDirectCostsRequested);
            phs398TrainingBudgetYearDataType.setTotalDirectCostsRequested(phs398TrainingBudgetYearDataType.getTotalOtherDirectCostsRequested().add(phs398TrainingBudgetYearDataType.getTotalStipendsAndTuitionFeesRequested()));
            phs398TrainingBudgetYearDataType.setTotalDirectAndIndirectCostsRequested(phs398TrainingBudgetYearDataType.getTotalDirectCostsRequested().add(phs398TrainingBudgetYearDataType.getTotalIndirectCostsRequested()));
            cumPostDocNonDegStipends = cumPostDocNonDegStipends.add(phs398TrainingBudgetYearDataType.getPostdocNonDegreeStipendsRequested());
            cumPostDocDegStipends = cumPostDocDegStipends.add(phs398TrainingBudgetYearDataType.getPostdocDegreeStipendsRequested());
            cumPostDocTotalStipends = cumPostDocNonDegStipends.add(cumPostDocDegStipends);
            cumResearchTotalDirectCosts = cumResearchTotalDirectCosts.add(phs398TrainingBudgetYearDataType.getResearchDirectCostsRequested());
            cumTotalOtherDirectCosts = cumTotalOtherDirectCosts.add(phs398TrainingBudgetYearDataType.getTotalOtherDirectCostsRequested());
        }
        trainingBudgetType.setCumulativeUndergraduateStipendsRequested(cumUndergradStipends);
        trainingBudgetType.setCumulativeUndergraduateTuitionAndFeesRequested(cumUndergradTuition);
        trainingBudgetType.setCumulativeOtherStipendsRequested(cumOtherStipends);
        trainingBudgetType.setCumulativeOtherTuitionAndFeesRequested(cumOtherTuition);
        trainingBudgetType.setCumulativePostdocDegreeStipendsRequested(cumPostDocDegStipends);
        trainingBudgetType.setCumulativePostdocDegreeTuitionAndFeesRequested(cumPostDocDegTuition);
        trainingBudgetType.setCumulativePostdocNonDegreeStipendsRequested(cumPostDocNonDegStipends);
        trainingBudgetType.setCumulativePostdocNonDegreeTuitionAndFeesRequested(cumPostDocNonDegTuition);
        trainingBudgetType.setCumulativePostdocTotalStipendsRequested(cumPostDocTotalStipends);
        trainingBudgetType.setCumulativePostdocTotalTuitionAndFeesRequested(cumPostDocTotalTuition);
        trainingBudgetType.setCumulativePredocDualDegreeStipendsRequested(cumPreDocDualStipends);
        trainingBudgetType.setCumulativePredocDualDegreeTuitionAndFeesRequested(cumPreDocDualTuition);
        trainingBudgetType.setCumulativePredocSingleDegreeStipendsRequested(cumPreDocSingleStipends);
        trainingBudgetType.setCumulativePredocSingleDegreeTuitionAndFeesRequested(cumPreDocSingleTuition);
        trainingBudgetType.setCumulativePredocTotalStipendsRequested(cumPreDocTotalStipends);
        trainingBudgetType.setCumulativePredocTotalTuitionAndFeesRequested(cumPreDocTotalTuition);
        trainingBudgetType.setCumulativeTotalStipendsRequested(cumPostDocTotalStipends.add(cumPreDocTotalStipends).add(cumOtherStipends).add(cumUndergradStipends));
        trainingBudgetType.setCumulativeTuitionAndFeesRequested(cumPostDocTotalTuition.add(cumPreDocTotalTuition).add(cumOtherTuition).add(cumUndergradTuition));
        trainingBudgetType.setCumulativeTotalStipendsAndTuitionFeesRequested(trainingBudgetType.getCumulativeTotalStipendsRequested().add(trainingBudgetType.getCumulativeTuitionAndFeesRequested()));
        trainingBudgetType.setCumulativeConsortiumTrainingCostsRequested(cumConsCosts);
        trainingBudgetType.setCumulativeResearchDirectCostsRequested(cumResearchTotalDirectCosts);
        trainingBudgetType.setCumulativeTotalDirectCostsRequested(trainingBudgetType.getCumulativeTotalStipendsAndTuitionFeesRequested().add(cumTotalOtherDirectCosts));
        trainingBudgetType.setCumulativeTotalIndirectCostsRequested(cumTotalIndCosts1.add(cumTotalIndCosts2));
        trainingBudgetType.setCumulativeTotalOtherDirectCostsRequested(cumTotalOtherDirectCosts);
        trainingBudgetType.setCumulativeTotalDirectAndIndirectCostsRequested(trainingBudgetType.getCumulativeTotalDirectCostsRequested().add(cumTotalIndCosts1.add(cumTotalIndCosts2)));
        trainingBudgetType.setCumulativeTraineeTravelRequested(cumTravelCosts);
        trainingBudgetType.setCumulativeTrainingRelatedExpensesRequested(cumTrainingCosts);
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : developmentProposal.getNarratives()) {
            if (narrative.getNarrativeTypeCode() != null && Integer.parseInt(narrative.getNarrativeTypeCode()) == 130 && (attachedFileDataType = this.getAttachedFileType(narrative)) != null) break;
        }
        if (attachedFileDataType == null) {
            attachedFileDataType = AttachedFileDataType.Factory.newInstance();
        }
        trainingBudgetType.setBudgetJustification(attachedFileDataType);
        return trainingBudgetType;
    }

    private void setOrganizationData(PHS398TrainingBudgetDocument.PHS398TrainingBudget trainingBudgetType, DevelopmentProposal developmentProposal) {
        Organization organization;
        ProposalSite applicantOrgSite = developmentProposal.getApplicantOrganization();
        if (applicantOrgSite != null && (organization = applicantOrgSite.getOrganization()) != null) {
            String dunsNumber = organization.getDunsNumber();
            if (dunsNumber != null) {
                trainingBudgetType.setDUNSNumber(dunsNumber);
            }
            trainingBudgetType.setOrganizationName(organization.getOrganizationName());
        }
    }

    private BudgetDecimal getBudgetPeriodCost(BudgetPeriod budgetPeriod, String costType) {
        BudgetDecimal totalLineItemCost = BudgetDecimal.ZERO;
        String costElementsStrValue = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, costType);
        String[] costElements = costElementsStrValue.split(",");
        for (int i = 0; i < costElements.length; ++i) {
            String costElement = costElements[i];
            List<BudgetLineItem> budgetLineItems = budgetPeriod.getBudgetLineItems();
            for (BudgetLineItem budgetLineItem : budgetLineItems) {
                if (!budgetLineItem.getCostElement().equals(costElement)) continue;
                totalLineItemCost = (BudgetDecimal)totalLineItemCost.add(budgetLineItem.getLineItemCost());
            }
        }
        return totalLineItemCost;
    }

    private List<AnswerHeader> findQuestionnaireWithAnswers(DevelopmentProposal developmentProposal, Integer budgetPeriod) {
        ProposalDevelopmentS2sQuestionnaireService questionnaireAnswerSerice = this.getProposalDevelopmentS2sQuestionnaireService();
        return questionnaireAnswerSerice.getProposalAnswerHeaderForForm(developmentProposal, "http://apply.grants.gov/forms/PHS398_TrainingBudget-V1.0", "PHS398_TrainingBudget-V1.0");
    }

    private ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        return KraServiceLocator.getService(ProposalDevelopmentS2sQuestionnaireService.class);
    }

    private Answer getAnswer(QuestionnaireQuestion questionnaireQuestion, AnswerHeader answerHeader) {
        List<Answer> answers = answerHeader.getAnswers();
        for (Answer answer : answers) {
            if (!answer.getQuestionnaireQuestionsIdFk().equals(questionnaireQuestion.getQuestionnaireQuestionsId())) continue;
            return answer;
        }
        return null;
    }

    private boolean isPostDocParentQuestionFromPeriodExists(QuestionnaireQuestion questionnaireQuestion, BudgetPeriod budgetPeriod, int termIndex) {
        return this.getPostDocParentQuestionsForPeriod(budgetPeriod, termIndex).equals(questionnaireQuestion.getParentQuestionNumber());
    }

    private Integer getPostDocParentQuestionsForPeriod(BudgetPeriod budgetPeriod, int termIndex) {
        Integer parentId = 0;
        switch (budgetPeriod.getBudgetPeriod()) {
            case 1: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD1[termIndex];
                break;
            }
            case 2: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD2[termIndex];
                break;
            }
            case 3: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD3[termIndex];
                break;
            }
            case 4: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD4[termIndex];
                break;
            }
            case 5: {
                parentId = POSTDOC_PARENT_QUESTION_IDS_PERIOD5[termIndex];
            }
        }
        return parentId;
    }

    private Integer[] getPreDocParentQuestionsForPeriod(BudgetPeriod budgetPeriod) {
        Integer[] parentIds = new Integer[]{};
        switch (budgetPeriod.getBudgetPeriod()) {
            case 1: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD1;
                break;
            }
            case 2: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD2;
                break;
            }
            case 3: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD3;
                break;
            }
            case 4: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD4;
                break;
            }
            case 5: {
                parentIds = PREDOC_PARENT_QUESTION_IDS_PERIOD5;
            }
        }
        return parentIds;
    }

    private Integer getParentQuestionId(Integer parentQuestionNumber) {
        HashMap<String, Integer> qMap = new HashMap<String, Integer>();
        qMap.put("questionNumber", parentQuestionNumber);
        List parentQuestionnaireQuestions = (List)this.businessObjectService.findMatching(QuestionnaireQuestion.class, qMap);
        return parentQuestionnaireQuestions.isEmpty() ? null : ((QuestionnaireQuestion)parentQuestionnaireQuestions.get(0)).getQuestion().getQuestionIdAsInteger();
    }

    private boolean isPreDocParentQuestionFromPeriodExists(QuestionnaireQuestion questionnaireQuestion, BudgetPeriod budgetPeriod) {
        return Arrays.asList(this.getPreDocParentQuestionsForPeriod(budgetPeriod)).contains(questionnaireQuestion.getParentQuestionNumber());
    }

    private BigDecimal getStipendAmount(BudgetPeriod budgetPeriod, String careerLevel, int experienceLevel, int numPeople) {
        BudgetDecimal stipendCost = BudgetDecimal.ZERO;
        List trainingStipendRates = (List)this.businessObjectService.findAll(TrainingStipendRate.class);
        QueryList trainingStipendRatesQueryList = new QueryList(trainingStipendRates);
        Equals eqStartDate = new Equals("effectiveDate", budgetPeriod.getStartDate());
        LesserThan ltStartDate = new LesserThan("effectiveDate", budgetPeriod.getStartDate());
        Or lessThanOrEqualsStartDate = new Or(eqStartDate, ltStartDate);
        QueryList filteredTrainingStipendRates = trainingStipendRatesQueryList.filter(lessThanOrEqualsStartDate);
        Equals eqCareerLevel = new Equals("careerLevel", (Comparable)((Object)careerLevel));
        Equals eqExperienceLevel = new Equals("experienceLevel", Integer.valueOf(experienceLevel));
        And eqCareerLevelAndeqExperienceLevel = new And(eqCareerLevel, eqExperienceLevel);
        if (!(filteredTrainingStipendRates = filteredTrainingStipendRates.filter(eqCareerLevelAndeqExperienceLevel)).isEmpty()) {
            filteredTrainingStipendRates.sort("effectiveDate", false);
            TrainingStipendRate trainingStipendRate = (TrainingStipendRate)((Object)filteredTrainingStipendRates.get(0));
            stipendCost = trainingStipendRate.getStipendRate().multiply(new BudgetDecimal(numPeople));
        }
        return stipendCost.bigDecimalValue();
    }
}

