/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrBudget10V11.BudgetTypeDataType;
import gov.grants.apply.forms.rrBudget10V11.BudgetYearDataType;
import gov.grants.apply.forms.rrBudget10V11.RRBudget10Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.bo.AttachmentData;
import org.kuali.kra.s2s.generator.bo.BudgetPeriodInfo;
import org.kuali.kra.s2s.generator.bo.BudgetSummaryInfo;
import org.kuali.kra.s2s.generator.bo.CompensationInfo;
import org.kuali.kra.s2s.generator.bo.CostInfo;
import org.kuali.kra.s2s.generator.bo.IndirectCostDetails;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.generator.bo.OtherDirectCostInfo;
import org.kuali.kra.s2s.generator.bo.OtherPersonnelInfo;
import org.kuali.kra.s2s.generator.impl.RRBudgetBaseGenerator;

public class RRBudget10V1_1Generator
extends RRBudgetBaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRBudget10V1_1Generator.class);

    private RRBudget10Document getRRBudget10() {
        List<BudgetPeriodInfo> budgetperiodList;
        this.deleteAutoGenNarratives();
        RRBudget10Document rrBudgetDocument = RRBudget10Document.Factory.newInstance();
        RRBudget10Document.RRBudget10 rrBudget = RRBudget10Document.RRBudget10.Factory.newInstance();
        rrBudget.setFormVersion("1.1");
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrBudget.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
            rrBudget.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        }
        rrBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        BudgetSummaryInfo budgetSummary = null;
        try {
            this.validateBudgetForForm(this.pdDoc);
            budgetperiodList = this.s2sBudgetCalculatorService.getBudgetPeriods(this.pdDoc);
            budgetSummary = this.s2sBudgetCalculatorService.getBudgetInfo(this.pdDoc, budgetperiodList);
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return rrBudgetDocument;
        }
        rrBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        for (BudgetPeriodInfo budgetPeriodData : budgetperiodList) {
            this.setBudgetYearDataType(rrBudget, budgetPeriodData);
        }
        AttachedFileDataType attachedFileDataType = AttachedFileDataType.Factory.newInstance();
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() != null && Integer.parseInt(narrative.getNarrativeTypeCode()) == 132 && (attachedFileDataType = this.getAttachedFileType(narrative)) != null) break;
        }
        rrBudget.setBudgetJustificationAttachment(attachedFileDataType);
        rrBudgetDocument.setRRBudget10(rrBudget);
        return rrBudgetDocument;
    }

    private void setBudgetYearDataType(RRBudget10Document.RRBudget10 rrBudget, BudgetPeriodInfo periodInfo) {
        BudgetYearDataType budgetYear = rrBudget.addNewBudgetYear();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            if (periodInfo.getTotalCompensation() != null) {
                budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            BigDecimal directCosts = periodInfo.getDirectCostsTotal().bigDecimalValue();
            budgetYear.setDirectCosts(directCosts);
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            if (indirectCosts != null) {
                budgetYear.setIndirectCosts(indirectCosts);
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue().add(indirectCosts.getTotalIndirectCosts()));
            } else {
                budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
            }
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
        }
    }

    private RRBudget10Document.RRBudget10.BudgetSummary getBudgetSummary(BudgetSummaryInfo budgetSummaryData) {
        RRBudget10Document.RRBudget10.BudgetSummary budgetSummary = RRBudget10Document.RRBudget10.BudgetSummary.Factory.newInstance();
        OtherDirectCostInfo otherDirectCosts = null;
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getOtherDirectCosts() != null && budgetSummaryData.getOtherDirectCosts().size() > 0) {
                otherDirectCosts = budgetSummaryData.getOtherDirectCosts().get(0);
            }
            if (otherDirectCosts != null) {
                budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(BigDecimal.ZERO);
                budgetSummary.setCumulativeTotalFundsRequestedPersonnel(BigDecimal.ZERO);
                if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                    budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
                }
                if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                    budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
                }
                if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
                    budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
                }
                if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                    budgetSummary.setCumulativeTotalFundsRequestedPersonnel(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
                }
                budgetSummary.setCumulativeTotalFundsRequestedEquipment(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedTravel(budgetSummaryData.getCumTravel().bigDecimalValue());
                budgetSummary.setCumulativeDomesticTravelCosts(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
                budgetSummary.setCumulativeForeignTravelCosts(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedTraineeCosts(((BudgetDecimal)budgetSummaryData.getpartOtherCost().add(budgetSummaryData.getpartStipendCost().add(budgetSummaryData.getpartTravelCost().add(budgetSummaryData.getPartTuition().add(budgetSummaryData.getPartSubsistence()))))).bigDecimalValue());
                budgetSummary.setCumulativeTraineeStipends(otherDirectCosts.getPartStipends().bigDecimalValue());
                budgetSummary.setCumulativeTraineeSubsistence(otherDirectCosts.getPartSubsistence().bigDecimalValue());
                budgetSummary.setCumulativeTraineeTravel(otherDirectCosts.getPartTravel().bigDecimalValue());
                budgetSummary.setCumulativeTraineeTuitionFeesHealthInsurance(otherDirectCosts.getPartTuition().bigDecimalValue());
                budgetSummary.setCumulativeOtherTraineeCost(budgetSummaryData.getpartOtherCost().bigDecimalValue());
                budgetSummary.setCumulativeNoofTrainees(budgetSummaryData.getparticipantCount());
                budgetSummary.setCumulativeTotalFundsRequestedOtherDirectCosts(otherDirectCosts.gettotalOtherDirect().bigDecimalValue());
                budgetSummary.setCumulativeMaterialAndSupplies(otherDirectCosts.getmaterials().bigDecimalValue());
                budgetSummary.setCumulativePublicationCosts(otherDirectCosts.getpublications().bigDecimalValue());
                budgetSummary.setCumulativeConsultantServices(otherDirectCosts.getConsultants().bigDecimalValue());
                budgetSummary.setCumulativeADPComputerServices(otherDirectCosts.getcomputer().bigDecimalValue());
                budgetSummary.setCumulativeSubawardConsortiumContractualCosts(otherDirectCosts.getsubAwards().bigDecimalValue());
                budgetSummary.setCumulativeEquipmentFacilityRentalFees(otherDirectCosts.getEquipRental().bigDecimalValue());
                budgetSummary.setCumulativeAlterationsAndRenovations(otherDirectCosts.getAlterations().bigDecimalValue());
                List<Map<String, String>> cvOthers = otherDirectCosts.getOtherCosts();
                for (int j = 0; j < cvOthers.size(); ++j) {
                    Map<String, String> hmCosts = cvOthers.get(j);
                    if (j == 0) {
                        budgetSummary.setCumulativeOther1DirectCost(new BigDecimal(hmCosts.get("Cost").toString()));
                        continue;
                    }
                    if (j == 1) {
                        budgetSummary.setCumulativeOther2DirectCost(new BigDecimal(hmCosts.get("Cost").toString()));
                        continue;
                    }
                    budgetSummary.setCumulativeOther3DirectCost(new BigDecimal(hmCosts.get("Cost").toString()));
                }
                budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
                if (budgetSummaryData.getCumFee() != null) {
                    budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
                }
            }
        }
        return budgetSummary;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            traineeSupportCosts.setTuitionFeeHealthInsurance(periodInfo.getPartTuition().bigDecimalValue());
            traineeSupportCosts.setStipends(periodInfo.getpartStipendCost().bigDecimalValue());
            traineeSupportCosts.setTravel(periodInfo.getpartTravelCost().bigDecimalValue());
            traineeSupportCosts.setSubsistence(periodInfo.getPartSubsistence().bigDecimalValue());
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getparticipantCount());
            traineeSupportCosts.setTotalCost(traineeSupportCosts.getTuitionFeeHealthInsurance().add(traineeSupportCosts.getStipends().add(traineeSupportCosts.getTravel().add(traineeSupportCosts.getSubsistence().add(traineeSupportCosts.getOther().getCost())))));
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other other = BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        other.setDescription("Other");
        BudgetDecimal otherCost = BudgetDecimal.ZERO;
        if (periodInfo != null && periodInfo.getpartOtherCost() != null) {
            otherCost = periodInfo.getpartOtherCost();
        }
        other.setCost(otherCost.bigDecimalValue());
        return other;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts().size() > 0) {
            if (periodInfo.getOtherDirectCosts().get(0).getpublications() != null) {
                otherDirectCosts.setPublicationCosts(periodInfo.getOtherDirectCosts().get(0).getpublications().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getmaterials() != null) {
                otherDirectCosts.setMaterialsSupplies(periodInfo.getOtherDirectCosts().get(0).getmaterials().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getConsultants() != null) {
                otherDirectCosts.setConsultantServices(periodInfo.getOtherDirectCosts().get(0).getConsultants().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getcomputer() != null) {
                otherDirectCosts.setADPComputerServices(periodInfo.getOtherDirectCosts().get(0).getcomputer().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getsubAwards() != null) {
                otherDirectCosts.setSubawardConsortiumContractualCosts(periodInfo.getOtherDirectCosts().get(0).getsubAwards().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getAlterations() != null) {
                otherDirectCosts.setAlterationsRenovations(periodInfo.getOtherDirectCosts().get(0).getAlterations().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getEquipRental() != null) {
                otherDirectCosts.setEquipmentRentalFee(periodInfo.getOtherDirectCosts().get(0).getEquipRental().bigDecimalValue());
            }
            this.setOthersForOtherDirectCosts(otherDirectCosts, periodInfo);
            if (periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect() != null) {
                otherDirectCosts.setTotalOtherDirectCost(periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect().bigDecimalValue());
            }
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null && periodInfo.getIndirectCosts() != null && periodInfo.getIndirectCosts().getIndirectCostDetails() != null) {
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            int IndirectCostCount = 0;
            for (IndirectCostDetails indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                if (indirectCostDetails.getBase() != null) {
                    indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                }
                indirectCost.setCostType(indirectCostDetails.getCostType());
                if (indirectCostDetails.getFunds() != null) {
                    indirectCost.setFundRequested(indirectCostDetails.getFunds().bigDecimalValue());
                }
                if (indirectCostDetails.getRate() != null) {
                    indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                }
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn((Object)"Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = BudgetYearDataType.IndirectCosts.Factory.newInstance();
                BudgetYearDataType.IndirectCosts.IndirectCost[] indirectCostArray = new BudgetYearDataType.IndirectCosts.IndirectCost[]{};
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(indirectCostArray));
                if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                    indirectCosts.setTotalIndirectCosts(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
                }
            }
        }
        return indirectCosts;
    }

    private void setOthersForOtherDirectCosts(BudgetYearDataType.OtherDirectCosts otherDirectCosts, BudgetPeriodInfo periodInfo) {
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null) {
            for (OtherDirectCostInfo otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                BudgetYearDataType.OtherDirectCosts.Other other = otherDirectCosts.addNewOther();
                if (otherDirectCostInfo.getOtherCosts() != null && otherDirectCostInfo.getOtherCosts().size() > 0) {
                    other.setCost(new BigDecimal(otherDirectCostInfo.getOtherCosts().get(0).get("Cost")));
                }
                other.setDescription("Other");
            }
        }
    }

    private BudgetYearDataType.Travel getTravel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Travel travel = BudgetYearDataType.Travel.Factory.newInstance();
        if (periodInfo != null) {
            travel.setDomesticTravelCost(periodInfo.getDomesticTravelCost().bigDecimalValue());
            travel.setForeignTravelCost(periodInfo.getForeignTravelCost().bigDecimalValue());
            travel.setTotalTravelCost(periodInfo.getTotalTravelCost().bigDecimalValue());
        }
        return travel;
    }

    private BudgetYearDataType.Equipment getEquipment(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Equipment equipment = BudgetYearDataType.Equipment.Factory.newInstance();
        Narrative extraEquipmentNarr = null;
        if (periodInfo != null && periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0) {
            ArrayList<BudgetYearDataType.Equipment.EquipmentList> equipmentArrayList = new ArrayList<BudgetYearDataType.Equipment.EquipmentList>();
            BudgetDecimal totalFund = BudgetDecimal.ZERO;
            for (CostInfo costInfo : periodInfo.getEquipment().get(0).getEquipmentList()) {
                BudgetYearDataType.Equipment.EquipmentList equipmentList = BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                equipmentList.setEquipmentItem(costInfo.getDescription());
                if (costInfo.getCost() != null) {
                    equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
                }
                totalFund = (BudgetDecimal)totalFund.add(costInfo.getCost());
                equipmentArrayList.add(equipmentList);
            }
            ArrayList<CostInfo> extraEquipmentArrayList = new ArrayList<CostInfo>();
            BudgetDecimal totalExtraEquipFund = BudgetDecimal.ZERO;
            for (CostInfo costInfo : periodInfo.getEquipment().get(0).getExtraEquipmentList()) {
                extraEquipmentArrayList.add(costInfo);
                totalExtraEquipFund = (BudgetDecimal)totalExtraEquipFund.add(costInfo.getCost());
            }
            BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = new BudgetYearDataType.Equipment.EquipmentList[]{};
            equipmentArray = equipmentArrayList.toArray(equipmentArray);
            equipment.setEquipmentListArray(equipmentArray);
            totalFund = (BudgetDecimal)totalFund.add(totalExtraEquipFund);
            equipment.setTotalFund(totalFund.bigDecimalValue());
            if (equipmentArray.length > 0) {
                equipment.setTotalFundForAttachedEquipment(totalExtraEquipFund.bigDecimalValue());
            }
            extraEquipmentNarr = this.saveAdditionalEquipments(periodInfo, extraEquipmentArrayList);
        }
        if (extraEquipmentNarr != null) {
            AttachedFileDataType equipmentAttachment = AttachedFileDataType.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            equipmentAttachment.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraEquipmentNarr);
            fileLocation.setHref(contentId);
            equipmentAttachment.setFileLocation(fileLocation);
            equipmentAttachment.setFileName(extraEquipmentNarr.getFileName());
            equipmentAttachment.setMimeType("application/octet-stream");
            extraEquipmentNarr.refreshReferenceObject("narrativeAttachmentList");
            if (extraEquipmentNarr.getNarrativeAttachmentList() != null && extraEquipmentNarr.getNarrativeAttachmentList().size() > 0) {
                equipmentAttachment.setHashValue(this.getHashValue(extraEquipmentNarr.getNarrativeAttachmentList().get(0).getContent()));
            }
            AttachmentData attachmentData = new AttachmentData();
            attachmentData.setContent(extraEquipmentNarr.getNarrativeAttachmentList().get(0).getContent());
            attachmentData.setContentId(contentId);
            attachmentData.setContentType("application/octet-stream");
            attachmentData.setFileName(extraEquipmentNarr.getFileName());
            this.addAttachment(attachmentData);
            equipment.setAdditionalEquipmentsAttachment(equipmentAttachment);
        }
        return equipment;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int otherPersonnelCount = 0;
        ArrayList<BudgetYearDataType.OtherPersonnel.Other> otherPersonnelList = new ArrayList<BudgetYearDataType.OtherPersonnel.Other>();
        BudgetYearDataType.OtherPersonnel.Other[] otherPersonnelDataTypeArray = new BudgetYearDataType.OtherPersonnel.Other[1];
        if (periodInfo != null) {
            for (OtherPersonnelInfo otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                    continue;
                }
                if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                    continue;
                }
                if (otherPersonnelCount >= 6) continue;
                CompensationInfo sectBCompType = otherPersonnelInfo.getCompensation();
                BudgetYearDataType.OtherPersonnel.Other otherPersonnelDataType = otherPersonnel.addNewOther();
                otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                otherPersonnelDataType.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
                otherPersonnelDataType.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
                otherPersonnelDataType.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
                otherPersonnelDataType.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
                otherPersonnelDataType.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
                otherPersonnelDataType.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
                otherPersonnelList.add(otherPersonnelDataType);
                ++otherPersonnelCount;
            }
            otherPersonnelDataTypeArray = otherPersonnelList.toArray(otherPersonnelDataTypeArray);
            otherPersonnel.setOtherArray(otherPersonnelDataTypeArray);
            if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
            }
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                otherPersonnel.setTotalOtherPersonnelFund(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDocAssociates = BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDocAssociates.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDocAssociates.setProjectRole(otherPersonnel.getRole());
            CompensationInfo sectBCompType = otherPersonnel.getCompensation();
            postDocAssociates.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            postDocAssociates.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            postDocAssociates.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            postDocAssociates.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            postDocAssociates.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            postDocAssociates.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return postDocAssociates;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            CompensationInfo sectBCompType = otherPersonnel.getCompensation();
            graduate.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            graduate.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            graduate.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            graduate.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            graduate.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            graduate.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            CompensationInfo sectBCompType = otherPersonnel.getCompensation();
            undergraduate.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            undergraduate.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            undergraduate.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            undergraduate.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            undergraduate.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            undergraduate.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarialClerical = BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarialClerical.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarialClerical.setProjectRole(otherPersonnel.getRole());
            CompensationInfo sectBCompType = otherPersonnel.getCompensation();
            secretarialClerical.setRequestedSalary(sectBCompType.getRequestedSalary().bigDecimalValue());
            secretarialClerical.setFringeBenefits(sectBCompType.getFringe().bigDecimalValue());
            secretarialClerical.setAcademicMonths(sectBCompType.getAcademicMonths().bigDecimalValue());
            secretarialClerical.setCalendarMonths(sectBCompType.getCalendarMonths().bigDecimalValue());
            secretarialClerical.setFundsRequested(sectBCompType.getFundsRequested().bigDecimalValue());
            secretarialClerical.setSummerMonths(sectBCompType.getSummerMonths().bigDecimalValue());
        }
        return secretarialClerical;
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.KeyPersons keyPersons = BudgetYearDataType.KeyPersons.Factory.newInstance();
        BudgetDecimal extraFunds = BudgetDecimal.ZERO;
        BudgetService budgetService = KraServiceLocator.getService(BudgetService.class);
        if (periodInfo != null) {
            if (periodInfo.getKeyPersons() != null) {
                ArrayList<BudgetYearDataType.KeyPersons.KeyPerson> keyPersonList = new ArrayList<BudgetYearDataType.KeyPersons.KeyPerson>();
                int keyPersonCount = 0;
                for (KeyPersonInfo keyPerson : periodInfo.getKeyPersons()) {
                    if (!keyPerson.getRole().equals("PD/PI") && !this.hasPersonnelBudget(keyPerson, periodInfo.getBudgetPeriod()).booleanValue()) continue;
                    BudgetYearDataType.KeyPersons.KeyPerson keyPersonDataType = BudgetYearDataType.KeyPersons.KeyPerson.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                    if (this.isSponsorNIH(this.pdDoc) && "CO-PD/PI".equals(keyPerson.getRole())) {
                        DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                        for (ProposalPerson proposalPerson : developmentProposal.getInvestigators()) {
                            if (!this.isProposalPersonEqualsKeyPerson(proposalPerson, keyPerson)) continue;
                            if (proposalPerson.isMultiplePi()) {
                                keyPersonDataType.setProjectRole("PD/PI");
                                continue;
                            }
                            keyPersonDataType.setProjectRole("CO-INVESTIGATOR");
                        }
                    } else if (keyPerson.getKeyPersonRole() != null) {
                        keyPersonDataType.setProjectRole(keyPerson.getKeyPersonRole());
                    } else {
                        keyPersonDataType.setProjectRole(keyPerson.getRole());
                    }
                    if (this.pdDoc.getBudgetDocumentVersions() != null) {
                        BudgetDecimal baseSalaryByPeriod = budgetService.getBaseSalaryByPeriod(this.pdDoc.getBudgetDocumentVersion(0).getBudgetVersionOverview().getBudgetId(), periodInfo.getBudgetPeriod(), keyPerson);
                        if (baseSalaryByPeriod != null) {
                            keyPersonDataType.setBaseSalary(baseSalaryByPeriod.bigDecimalValue());
                        } else if (keyPerson.getBaseSalary() != null) {
                            keyPersonDataType.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
                        }
                    } else if (keyPerson.getBaseSalary() != null) {
                        keyPersonDataType.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
                    }
                    keyPersonDataType.setRequestedSalary(keyPerson.getRequestedSalary().bigDecimalValue());
                    keyPersonDataType.setFringeBenefits(keyPerson.getFringe().bigDecimalValue());
                    keyPersonDataType.setAcademicMonths(keyPerson.getAcademicMonths().bigDecimalValue());
                    keyPersonDataType.setCalendarMonths(keyPerson.getCalendarMonths().bigDecimalValue());
                    keyPersonDataType.setFundsRequested(keyPerson.getFundsRequested().bigDecimalValue());
                    keyPersonDataType.setSummerMonths(keyPerson.getSummerMonths().bigDecimalValue());
                    keyPersonList.add(keyPersonDataType);
                    LOG.info((Object)("keyPersonCount:" + ++keyPersonCount));
                }
                keyPersons.setKeyPersonArray(keyPersonList.toArray(new BudgetYearDataType.KeyPersons.KeyPerson[0]));
            }
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                keyPersons.setTotalFundForKeyPersons(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            for (KeyPersonInfo keyPerson : periodInfo.getExtraKeyPersons()) {
                extraFunds = (BudgetDecimal)extraFunds.add(keyPerson.getFundsRequested());
            }
        }
        keyPersons.setTotalFundForAttachedKeyPersons(extraFunds.bigDecimalValue());
        Narrative extraKeyPersonNarr = this.saveExtraKeyPersons(periodInfo);
        if (extraKeyPersonNarr != null) {
            AttachedFileDataType attachedKeyPersons = AttachedFileDataType.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            attachedKeyPersons.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraKeyPersonNarr);
            fileLocation.setHref(contentId);
            attachedKeyPersons.setFileLocation(fileLocation);
            attachedKeyPersons.setFileName(extraKeyPersonNarr.getFileName());
            attachedKeyPersons.setMimeType("application/octet-stream");
            extraKeyPersonNarr.refreshReferenceObject("narrativeAttachmentList");
            AttachmentData attachmentData = new AttachmentData();
            byte[] narrativeContent = null;
            if (extraKeyPersonNarr.getNarrativeAttachmentList() != null && extraKeyPersonNarr.getNarrativeAttachmentList().size() > 0) {
                narrativeContent = extraKeyPersonNarr.getNarrativeAttachmentList().get(0).getContent();
            }
            if (narrativeContent != null && narrativeContent.length > 0) {
                attachedKeyPersons.setHashValue(this.getHashValue(narrativeContent));
                attachmentData.setContent(narrativeContent);
                attachmentData.setContentId(contentId);
                attachmentData.setContentType("application/octet-stream");
                attachmentData.setFileName(extraKeyPersonNarr.getFileName());
                this.addAttachment(attachmentData);
                keyPersons.setAttachedKeyPersons(attachedKeyPersons);
            }
        }
        return keyPersons;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRBudget10();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRBudget10Document.RRBudget10 rrBudget = (RRBudget10Document.RRBudget10)xmlObject;
        RRBudget10Document rrBudgetDocument = RRBudget10Document.Factory.newInstance();
        rrBudgetDocument.setRRBudget10(rrBudget);
        return rrBudgetDocument;
    }
}

