/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrBudgetV10.BudgetTypeDataType;
import gov.grants.apply.forms.rrBudgetV10.BudgetYear1DataType;
import gov.grants.apply.forms.rrBudgetV10.BudgetYearDataType;
import gov.grants.apply.forms.rrBudgetV10.KeyPersonCompensationDataType;
import gov.grants.apply.forms.rrBudgetV10.KeyPersonDataType;
import gov.grants.apply.forms.rrBudgetV10.OtherPersonnelDataType;
import gov.grants.apply.forms.rrBudgetV10.RRBudgetDocument;
import gov.grants.apply.forms.rrBudgetV10.SectBCompensationDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV10.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.bo.AttachmentData;
import org.kuali.kra.s2s.generator.bo.BudgetPeriodInfo;
import org.kuali.kra.s2s.generator.bo.BudgetSummaryInfo;
import org.kuali.kra.s2s.generator.bo.CompensationInfo;
import org.kuali.kra.s2s.generator.bo.CostInfo;
import org.kuali.kra.s2s.generator.bo.IndirectCostDetails;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.generator.bo.OtherDirectCostInfo;
import org.kuali.kra.s2s.generator.bo.OtherPersonnelInfo;
import org.kuali.kra.s2s.generator.impl.RRBudgetBaseGenerator;

public class RRBudgetV1_0Generator
extends RRBudgetBaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRBudgetV1_0Generator.class);

    private RRBudgetDocument getRRBudget() {
        List<BudgetPeriodInfo> budgetperiodList;
        this.deleteAutoGenNarratives();
        RRBudgetDocument rrBudgetDocument = RRBudgetDocument.Factory.newInstance();
        RRBudgetDocument.RRBudget rrBudget = RRBudgetDocument.RRBudget.Factory.newInstance();
        rrBudget.setFormVersion("1.0");
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrBudget.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
            rrBudget.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        }
        rrBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        rrBudget.setBudgetYear1(BudgetYear1DataType.Factory.newInstance());
        BudgetSummaryInfo budgetSummary = null;
        try {
            budgetperiodList = this.s2sBudgetCalculatorService.getBudgetPeriods(this.pdDoc);
            budgetSummary = this.s2sBudgetCalculatorService.getBudgetInfo(this.pdDoc, budgetperiodList);
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return rrBudgetDocument;
        }
        for (BudgetPeriodInfo budgetPeriodData : budgetperiodList) {
            if (budgetPeriodData.getBudgetPeriod() == 1) {
                rrBudget.setBudgetYear1(this.getBudgetYear1DataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 2) {
                rrBudget.setBudgetYear2(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 3) {
                rrBudget.setBudgetYear3(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() == 4) {
                rrBudget.setBudgetYear4(this.getBudgetYearDataType(budgetPeriodData));
                continue;
            }
            if (budgetPeriodData.getBudgetPeriod() != 5) continue;
            rrBudget.setBudgetYear5(this.getBudgetYearDataType(budgetPeriodData));
        }
        rrBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        rrBudgetDocument.setRRBudget(rrBudget);
        return rrBudgetDocument;
    }

    private BudgetYear1DataType getBudgetYear1DataType(BudgetPeriodInfo periodInfo) {
        BudgetYear1DataType budgetYear = BudgetYear1DataType.Factory.newInstance();
        budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
        budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
        BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt((int)periodInfo.getBudgetPeriod());
        budgetYear.setBudgetPeriod(budgetPeriod);
        budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
        budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
        if (periodInfo.getTotalCompensation() != null) {
            budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
        }
        budgetYear.setEquipment(this.getEquipment(periodInfo));
        budgetYear.setTravel(this.getTravel(periodInfo));
        budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
        budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
        budgetYear.setDirectCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
        BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
        if (indirectCosts != null) {
            budgetYear.setIndirectCosts(indirectCosts);
            budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue().add(indirectCosts.getTotalIndirectCosts()));
        } else {
            budgetYear.setTotalCosts(periodInfo.getDirectCostsTotal().bigDecimalValue());
        }
        budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 7 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            budgetYear.setBudgetJustificationAttachment(attachedFileDataType);
            break;
        }
        return budgetYear;
    }

    private BudgetYearDataType getBudgetYearDataType(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType budgetYear = BudgetYearDataType.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getStartDate() != null) {
                budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
            }
            if (periodInfo.getEndDate() != null) {
                budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
            }
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriod = BudgetYearDataType.BudgetPeriod.Enum.forInt((int)periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriod);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            if (periodInfo.getTotalCompensation() != null) {
                budgetYear.setTotalCompensation(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            BigDecimal directCosts = null;
            if (periodInfo.getDirectCostsTotal() != null) {
                directCosts = periodInfo.getDirectCostsTotal().bigDecimalValue();
                budgetYear.setDirectCosts(directCosts);
            }
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            budgetYear.setIndirectCosts(indirectCosts);
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
            if (indirectCosts != null && directCosts != null) {
                budgetYear.setTotalCosts(directCosts.add(indirectCosts.getTotalIndirectCosts()));
            } else {
                budgetYear.setTotalCosts(periodInfo.getTotalCosts().bigDecimalValue());
            }
        }
        return budgetYear;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary getBudgetSummary(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary budgetSummary = RRBudgetDocument.RRBudget.BudgetSummary.Factory.newInstance();
        budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(BigDecimal.ZERO);
        budgetSummary.setCumulativeTotalFundsRequestedPersonnel(BigDecimal.ZERO);
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(BigDecimal.ZERO);
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
                budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
            }
            if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                budgetSummary.setCumulativeTotalFundsRequestedPersonnel(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
            }
            budgetSummary.setCumulativeEquipments(this.getCumulativeEquipments(budgetSummaryData));
            budgetSummary.setCumulativeTravels(this.getCumulativeTravels(budgetSummaryData));
            budgetSummary.setCumulativeTrainee(this.getCumulativeTrainee(budgetSummaryData));
            budgetSummary.setCumulativeOtherDirect(this.getCumulativeOtherDirect(budgetSummaryData));
            if (budgetSummaryData.getCumTotalDirectCosts() != null) {
                budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalIndirectCosts() != null) {
                budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalCosts() != null) {
                budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
            }
            if (budgetSummaryData.getCumFee() != null) {
                budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
            }
        }
        return budgetSummary;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments getCumulativeEquipments(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments cumulativeEquipments = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeEquipments.Factory.newInstance();
        if (budgetSummaryData.getCumEquipmentFunds() != null) {
            cumulativeEquipments.setCumulativeTotalFundsRequestedEquipment(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
        }
        return cumulativeEquipments;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels getCumulativeTravels(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels cumulativeTravels = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTravels.Factory.newInstance();
        if (budgetSummaryData.getCumDomesticTravel() != null) {
            cumulativeTravels.setCumulativeDomesticTravelCosts(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumForeignTravel() != null) {
            cumulativeTravels.setCumulativeForeignTravelCosts(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
        }
        if (budgetSummaryData.getCumTravel() != null) {
            cumulativeTravels.setCumulativeTotalFundsRequestedTravel(budgetSummaryData.getCumTravel().bigDecimalValue());
        }
        return cumulativeTravels;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee getCumulativeTrainee(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee cumulativeTrainee = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeTrainee.Factory.newInstance();
        cumulativeTrainee.setCumulativeTotalFundsRequestedTraineeCosts(BigDecimal.ZERO);
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getpartOtherCost() != null && budgetSummaryData.getpartStipendCost() != null && budgetSummaryData.getpartTravelCost() != null && budgetSummaryData.getPartTuition() != null) {
                cumulativeTrainee.setCumulativeTotalFundsRequestedTraineeCosts(((BudgetDecimal)budgetSummaryData.getpartOtherCost().add(budgetSummaryData.getpartStipendCost().add(budgetSummaryData.getpartTravelCost().add(budgetSummaryData.getPartTuition().add(budgetSummaryData.getPartSubsistence()))))).bigDecimalValue());
            }
            if (budgetSummaryData.getPartTuition() != null) {
                cumulativeTrainee.setCumulativeTraineeTuitionFeesHealthInsurance(budgetSummaryData.getPartTuition().bigDecimalValue());
            }
            if (budgetSummaryData.getpartStipendCost() != null) {
                cumulativeTrainee.setCumulativeTraineeStipends(budgetSummaryData.getpartStipendCost().bigDecimalValue());
            }
            if (budgetSummaryData.getpartTravelCost() != null) {
                cumulativeTrainee.setCumulativeTraineeTravel(budgetSummaryData.getpartTravelCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartSubsistence() != null) {
                cumulativeTrainee.setCumulativeTraineeSubsistence(budgetSummaryData.getPartSubsistence().bigDecimalValue());
            }
            if (budgetSummaryData.getpartOtherCost() != null) {
                cumulativeTrainee.setCumulativeOtherTraineeCost(budgetSummaryData.getpartOtherCost().bigDecimalValue());
            }
            cumulativeTrainee.setCumulativeNoofTrainees(budgetSummaryData.getparticipantCount());
        }
        return cumulativeTrainee;
    }

    private RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect getCumulativeOtherDirect(BudgetSummaryInfo budgetSummaryData) {
        RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect cumulativeOtherDirect = RRBudgetDocument.RRBudget.BudgetSummary.CumulativeOtherDirect.Factory.newInstance();
        cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(BigDecimal.ZERO);
        if (budgetSummaryData != null) {
            for (OtherDirectCostInfo cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.gettotalOtherDirect() != null) {
                    cumulativeOtherDirect.setCumulativeTotalFundsRequestedOtherDirectCosts(cumOtherDirect.gettotalOtherDirect().bigDecimalValue());
                }
                if (cumOtherDirect.getmaterials() != null) {
                    cumulativeOtherDirect.setCumulativeMaterialAndSupplies(cumOtherDirect.getmaterials().bigDecimalValue());
                }
                if (cumOtherDirect.getpublications() != null) {
                    cumulativeOtherDirect.setCumulativePublicationCosts(cumOtherDirect.getpublications().bigDecimalValue());
                }
                if (cumOtherDirect.getConsultants() != null) {
                    cumulativeOtherDirect.setCumulativeConsultantServices(cumOtherDirect.getConsultants().bigDecimalValue());
                }
                if (cumOtherDirect.getcomputer() != null) {
                    cumulativeOtherDirect.setCumulativeADPComputerServices(cumOtherDirect.getcomputer().bigDecimalValue());
                }
                if (cumOtherDirect.getsubAwards() != null) {
                    cumulativeOtherDirect.setCumulativeSubawardConsortiumContractualCosts(cumOtherDirect.getsubAwards().bigDecimalValue());
                }
                if (cumOtherDirect.getEquipRental() != null) {
                    cumulativeOtherDirect.setCumulativeEquipmentFacilityRentalFees(cumOtherDirect.getEquipRental().bigDecimalValue());
                }
                if (cumOtherDirect.getAlterations() != null) {
                    cumulativeOtherDirect.setCumulativeAlterationsAndRenovations(cumOtherDirect.getAlterations().bigDecimalValue());
                }
                if (cumOtherDirect.getOtherCosts() == null || cumOtherDirect.getOtherCosts().size() <= 0) continue;
                cumulativeOtherDirect.setCumulativeOther1DirectCost(new BigDecimal(cumOtherDirect.getOtherCosts().get(0).get("Cost")));
            }
        }
        return cumulativeOtherDirect;
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.KeyPersons keyPersons = BudgetYearDataType.KeyPersons.Factory.newInstance();
        BudgetDecimal extraFunds = BudgetDecimal.ZERO;
        if (periodInfo != null) {
            KeyPersonDataType[] keyPersonDataTypeArray = null;
            if (periodInfo.getKeyPersons() != null) {
                keyPersonDataTypeArray = new KeyPersonDataType[periodInfo.getKeyPersons().size()];
            }
            if (keyPersonDataTypeArray != null) {
                int keyPersonCount = 0;
                for (KeyPersonInfo keyPerson : periodInfo.getKeyPersons()) {
                    KeyPersonDataType keyPersonDataType = KeyPersonDataType.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV10Generator.getHumanNameDataType(keyPerson));
                    if (this.isSponsorNIH(this.pdDoc) && "CO-PD/PI".equals(keyPerson.getRole())) {
                        keyPersonDataType.setProjectRole("PD/PI");
                    } else {
                        keyPersonDataType.setProjectRole(keyPerson.getRole());
                    }
                    keyPersonDataType.setCompensation(this.getCompensation(keyPerson, periodInfo.getBudgetPeriod()));
                    keyPersonDataTypeArray[keyPersonCount] = keyPersonDataType;
                    LOG.info((Object)("keyPersonCount:" + ++keyPersonCount));
                }
                keyPersons.setKeyPersonArray(keyPersonDataTypeArray);
            }
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                keyPersons.setTotalFundForKeyPersons(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            for (KeyPersonInfo keyPerson : periodInfo.getExtraKeyPersons()) {
                extraFunds = (BudgetDecimal)extraFunds.add(keyPerson.getFundsRequested());
            }
            BudgetYearDataType.KeyPersons.TotalFundForAttachedKeyPersons totalFundForAttachedKeyPersons = BudgetYearDataType.KeyPersons.TotalFundForAttachedKeyPersons.Factory.newInstance();
            totalFundForAttachedKeyPersons.setTotalFundForAttachedKeyPersonsExist(YesNoDataType.YES);
            totalFundForAttachedKeyPersons.setBigDecimalValue(extraFunds.bigDecimalValue());
            keyPersons.setTotalFundForAttachedKeyPersons(totalFundForAttachedKeyPersons);
            Narrative narrative = this.saveExtraKeyPersons(periodInfo);
            if (narrative != null) {
                BudgetYearDataType.KeyPersons.AttachedKeyPersons attachedKeyPersons = BudgetYearDataType.KeyPersons.AttachedKeyPersons.Factory.newInstance();
                AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
                attachedKeyPersons.setFileLocation(fileLocation);
                String contentId = this.createContentId(narrative);
                fileLocation.setHref(contentId);
                attachedKeyPersons.setFileLocation(fileLocation);
                attachedKeyPersons.setFileName(narrative.getFileName());
                attachedKeyPersons.setMimeType("application/octet-stream");
                narrative.refreshReferenceObject("narrativeAttachmentList");
                if (narrative.getNarrativeAttachmentList() != null && narrative.getNarrativeAttachmentList().size() > 0) {
                    attachedKeyPersons.setHashValue(this.getHashValue(narrative.getNarrativeAttachmentList().get(0).getContent()));
                }
                AttachmentData attachmentData = new AttachmentData();
                if (narrative.getNarrativeAttachmentList() != null && narrative.getNarrativeAttachmentList().size() > 0) {
                    attachmentData.setContent(narrative.getNarrativeAttachmentList().get(0).getContent());
                }
                attachmentData.setContentId(contentId);
                attachmentData.setContentType("application/octet-stream");
                attachmentData.setFileName(narrative.getFileName());
                this.addAttachment(attachmentData);
                attachedKeyPersons.setTotalFundForAttachedKeyPersonsExist(YesNoDataType.YES);
                keyPersons.setAttachedKeyPersons(attachedKeyPersons);
            }
        }
        return keyPersons;
    }

    private KeyPersonCompensationDataType getCompensation(KeyPersonInfo keyPerson, int budgetPeriod) {
        KeyPersonCompensationDataType keyPersonCompensation = KeyPersonCompensationDataType.Factory.newInstance();
        BudgetService budgetService = KraServiceLocator.getService(BudgetService.class);
        if (keyPerson != null) {
            if (keyPerson.getAcademicMonths() != null) {
                keyPersonCompensation.setAcademicMonths(keyPerson.getAcademicMonths().bigDecimalValue());
            }
            if (keyPerson.getCalendarMonths() != null) {
                keyPersonCompensation.setCalendarMonths(keyPerson.getCalendarMonths().bigDecimalValue());
            }
            if (keyPerson.getFringe() != null) {
                keyPersonCompensation.setFringeBenefits(keyPerson.getFringe().bigDecimalValue());
            }
            if (keyPerson.getSummerMonths() != null) {
                keyPersonCompensation.setSummerMonths(keyPerson.getSummerMonths().bigDecimalValue());
            }
            if (keyPerson.getRequestedSalary() != null) {
                keyPersonCompensation.setRequestedSalary(keyPerson.getRequestedSalary().bigDecimalValue());
            }
            if (keyPerson.getFundsRequested() != null) {
                keyPersonCompensation.setFundsRequested(keyPerson.getFundsRequested().bigDecimalValue());
            }
            if (this.pdDoc.getBudgetDocumentVersions() != null) {
                BudgetDecimal baseSalaryByPeriod = budgetService.getBaseSalaryByPeriod(this.pdDoc.getBudgetDocumentVersion(0).getBudgetVersionOverview().getBudgetId(), budgetPeriod, keyPerson);
                if (baseSalaryByPeriod != null) {
                    keyPersonCompensation.setBaseSalary(baseSalaryByPeriod.bigDecimalValue());
                } else if (keyPerson.getBaseSalary() != null) {
                    keyPersonCompensation.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
                }
            } else if (keyPerson.getBaseSalary() != null) {
                keyPersonCompensation.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
            }
        }
        return keyPersonCompensation;
    }

    private SectBCompensationDataType getSectBCompensationDataType(CompensationInfo compensation) {
        SectBCompensationDataType sectBCompensation = SectBCompensationDataType.Factory.newInstance();
        if (compensation != null) {
            if (compensation.getAcademicMonths() != null) {
                sectBCompensation.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
            }
            if (compensation.getCalendarMonths() != null) {
                sectBCompensation.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
            }
            if (compensation.getFringe() != null) {
                sectBCompensation.setFringeBenefits(compensation.getFringe().bigDecimalValue());
            }
            if (compensation.getFundsRequested() != null) {
                sectBCompensation.setFundsRequested(compensation.getFundsRequested().bigDecimalValue());
            }
            if (compensation.getSummerMonths() != null) {
                sectBCompensation.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
            }
            if (compensation.getRequestedSalary() != null) {
                sectBCompensation.setRequestedSalary(compensation.getRequestedSalary().bigDecimalValue());
            }
        }
        return sectBCompensation;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int OtherpersonalCount = 0;
        ArrayList<OtherPersonnelDataType> otherPersonnelList = new ArrayList<OtherPersonnelDataType>();
        OtherPersonnelDataType[] otherPersonnelDataTypeArray = new OtherPersonnelDataType[1];
        if (periodInfo != null) {
            for (OtherPersonnelInfo otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                    continue;
                }
                if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                    continue;
                }
                if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                    otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                    continue;
                }
                if (OtherpersonalCount >= 6) continue;
                OtherPersonnelDataType otherPersonnelDataType = OtherPersonnelDataType.Factory.newInstance();
                otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                otherPersonnelDataType.setCompensation(this.getSectBCompensationDataType(otherPersonnelInfo.getCompensation()));
                otherPersonnelList.add(otherPersonnelDataType);
                ++OtherpersonalCount;
            }
            otherPersonnelDataTypeArray = otherPersonnelList.toArray(otherPersonnelDataTypeArray);
            otherPersonnel.setOtherArray(otherPersonnelDataTypeArray);
            if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
            }
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                otherPersonnel.setTotalOtherPersonnelFund(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDocAssociates = BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDocAssociates.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDocAssociates.setProjectRole(otherPersonnel.getRole());
            postDocAssociates.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return postDocAssociates;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            graduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            undergraduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarialClerical = BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarialClerical.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarialClerical.setProjectRole(otherPersonnel.getRole());
            secretarialClerical.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return secretarialClerical;
    }

    private BudgetYearDataType.Equipment getEquipment(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Equipment equipment = BudgetYearDataType.Equipment.Factory.newInstance();
        Narrative extraEquipmentNarr = null;
        if (periodInfo != null && periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0) {
            ArrayList<BudgetYearDataType.Equipment.EquipmentList> equipmentArrayList = new ArrayList<BudgetYearDataType.Equipment.EquipmentList>();
            BudgetDecimal totalFund = BudgetDecimal.ZERO;
            for (CostInfo costInfo : periodInfo.getEquipment().get(0).getEquipmentList()) {
                BudgetYearDataType.Equipment.EquipmentList equipmentList = BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                equipmentList.setEquipmentItem(costInfo.getDescription());
                if (costInfo.getCost() != null) {
                    equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
                }
                totalFund = (BudgetDecimal)totalFund.add(costInfo.getCost());
                equipmentArrayList.add(equipmentList);
            }
            ArrayList<CostInfo> extraEquipmentArrayList = new ArrayList<CostInfo>();
            BudgetDecimal totalExtraEquipFund = BudgetDecimal.ZERO;
            for (CostInfo costInfo : periodInfo.getEquipment().get(0).getExtraEquipmentList()) {
                extraEquipmentArrayList.add(costInfo);
                totalExtraEquipFund = (BudgetDecimal)totalExtraEquipFund.add(costInfo.getCost());
            }
            BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = new BudgetYearDataType.Equipment.EquipmentList[]{};
            equipmentArray = equipmentArrayList.toArray(equipmentArray);
            equipment.setEquipmentListArray(equipmentArray);
            BudgetYearDataType.Equipment.TotalFundForAttachedEquipment totalFundForAttachedEquipment = BudgetYearDataType.Equipment.TotalFundForAttachedEquipment.Factory.newInstance();
            totalFundForAttachedEquipment.setTotalFundForAttachedEquipmentExist(YesNoDataType.YES);
            totalFundForAttachedEquipment.setBigDecimalValue(periodInfo.getEquipment().get(0).getTotalExtraFund().bigDecimalValue());
            totalFund = (BudgetDecimal)totalFund.add(totalExtraEquipFund);
            equipment.setTotalFundForAttachedEquipment(totalFundForAttachedEquipment);
            equipment.setTotalFund(totalFund.bigDecimalValue());
            extraEquipmentNarr = this.saveAdditionalEquipments(periodInfo, extraEquipmentArrayList);
        }
        if (extraEquipmentNarr != null) {
            BudgetYearDataType.Equipment.AdditionalEquipmentsAttachment equipmentAttachment = BudgetYearDataType.Equipment.AdditionalEquipmentsAttachment.Factory.newInstance();
            AttachedFileDataType.FileLocation fileLocation = AttachedFileDataType.FileLocation.Factory.newInstance();
            equipmentAttachment.setFileLocation(fileLocation);
            String contentId = this.createContentId(extraEquipmentNarr);
            fileLocation.setHref(contentId);
            equipmentAttachment.setFileLocation(fileLocation);
            equipmentAttachment.setFileName(extraEquipmentNarr.getFileName());
            equipmentAttachment.setMimeType("application/octet-stream");
            extraEquipmentNarr.refreshReferenceObject("narrativeAttachmentList");
            equipmentAttachment.setHashValue(this.getHashValue(extraEquipmentNarr.getNarrativeAttachmentList().get(0).getContent()));
            AttachmentData attachmentData = new AttachmentData();
            attachmentData.setContent(extraEquipmentNarr.getNarrativeAttachmentList().get(0).getContent());
            attachmentData.setContentId(contentId);
            attachmentData.setContentType("application/octet-stream");
            attachmentData.setFileName(extraEquipmentNarr.getFileName());
            this.addAttachment(attachmentData);
            equipmentAttachment.setTotalFundForAttachedEquipmentExist(YesNoDataType.YES);
            equipment.setAdditionalEquipmentsAttachment(equipmentAttachment);
        }
        return equipment;
    }

    private BudgetYearDataType.Travel getTravel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Travel travel = BudgetYearDataType.Travel.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getDomesticTravelCost() != null) {
                travel.setDomesticTravelCost(periodInfo.getDomesticTravelCost().bigDecimalValue());
            }
            if (periodInfo.getForeignTravelCost() != null) {
                travel.setForeignTravelCost(periodInfo.getForeignTravelCost().bigDecimalValue());
            }
            if (periodInfo.getTotalTravelCost() != null) {
                travel.setTotalTravelCost(periodInfo.getTotalTravelCost().bigDecimalValue());
            }
        }
        return travel;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            traineeSupportCosts.setTuitionFeeHealthInsurance(periodInfo.getPartTuition().bigDecimalValue());
            traineeSupportCosts.setStipends(periodInfo.getpartStipendCost().bigDecimalValue());
            traineeSupportCosts.setTravel(periodInfo.getpartTravelCost().bigDecimalValue());
            traineeSupportCosts.setSubsistence(periodInfo.getPartSubsistence().bigDecimalValue());
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getparticipantCount());
            traineeSupportCosts.setTotalCost(traineeSupportCosts.getTuitionFeeHealthInsurance().add(traineeSupportCosts.getStipends().add(traineeSupportCosts.getTravel().add(traineeSupportCosts.getSubsistence().add(traineeSupportCosts.getOther().getCost())))));
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other other = BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        other.setDescription("Other");
        BudgetDecimal otherCost = BudgetDecimal.ZERO;
        if (periodInfo != null && periodInfo.getpartOtherCost() != null) {
            otherCost = periodInfo.getpartOtherCost();
        }
        other.setCost(otherCost.bigDecimalValue());
        return other;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null && periodInfo.getOtherDirectCosts().size() > 0) {
            if (periodInfo.getOtherDirectCosts().get(0).getpublications() != null) {
                otherDirectCosts.setPublicationCosts(periodInfo.getOtherDirectCosts().get(0).getpublications().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getmaterials() != null) {
                otherDirectCosts.setMaterialsSupplies(periodInfo.getOtherDirectCosts().get(0).getmaterials().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getConsultants() != null) {
                otherDirectCosts.setConsultantServices(periodInfo.getOtherDirectCosts().get(0).getConsultants().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getcomputer() != null) {
                otherDirectCosts.setADPComputerServices(periodInfo.getOtherDirectCosts().get(0).getcomputer().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getsubAwards() != null) {
                otherDirectCosts.setSubawardConsortiumContractualCosts(periodInfo.getOtherDirectCosts().get(0).getsubAwards().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getEquipRental() != null) {
                otherDirectCosts.setEquipmentRentalFee(periodInfo.getOtherDirectCosts().get(0).getEquipRental().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getAlterations() != null) {
                otherDirectCosts.setAlterationsRenovations(periodInfo.getOtherDirectCosts().get(0).getAlterations().bigDecimalValue());
            }
            otherDirectCosts.setOthers(this.getOthersForOtherDirectCosts(periodInfo));
            if (periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect() != null) {
                otherDirectCosts.setTotalOtherDirectCost(periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect().bigDecimalValue());
            }
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts.Others getOthersForOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts.Others others = BudgetYearDataType.OtherDirectCosts.Others.Factory.newInstance();
        if (periodInfo != null) {
            BudgetYearDataType.OtherDirectCosts.Others.Other[] otherArray = new BudgetYearDataType.OtherDirectCosts.Others.Other[periodInfo.getOtherDirectCosts().size()];
            int Otherscount = 0;
            for (OtherDirectCostInfo otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                BudgetYearDataType.OtherDirectCosts.Others.Other other = BudgetYearDataType.OtherDirectCosts.Others.Other.Factory.newInstance();
                if (otherDirectCostInfo.getOtherCosts() != null && otherDirectCostInfo.getOtherCosts().size() > 0) {
                    other.setCost(new BigDecimal(otherDirectCostInfo.getOtherCosts().get(0).get("Cost")));
                }
                other.setDescription("Other");
                otherArray[Otherscount] = other;
                ++Otherscount;
            }
            others.setOtherArray(otherArray);
        }
        return others;
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null) {
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            int IndirectCostCount = 0;
            for (IndirectCostDetails indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                indirectCost.setCostType(indirectCostDetails.getCostType());
                indirectCost.setFundRequested(indirectCostDetails.getFunds().bigDecimalValue());
                indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn((Object)"Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = BudgetYearDataType.IndirectCosts.Factory.newInstance();
                BudgetYearDataType.IndirectCosts.IndirectCost[] indirectCostArray = new BudgetYearDataType.IndirectCosts.IndirectCost[]{};
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(indirectCostArray));
                indirectCosts.setTotalIndirectCosts(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
            }
        }
        return indirectCosts;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRBudget();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRBudgetDocument.RRBudget rrBudget = (RRBudgetDocument.RRBudget)xmlObject;
        RRBudgetDocument rrBudgetDocument = RRBudgetDocument.Factory.newInstance();
        rrBudgetDocument.setRRBudget(rrBudget);
        return rrBudgetDocument;
    }
}

