/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.coeus.additionalEquipment.AdditionalEquipmentListDocument;
import gov.grants.apply.coeus.extraKeyPerson.ExtraKeyPersonListDocument;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.BudgetTypeDataType;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.BudgetYearDataType;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.KeyPersonCompensationDataType;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.KeyPersonDataType;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.OtherPersonnelDataType;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.RRFedNonFedBudget10Document;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.SectBCompensationDataType;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.SummaryDataType;
import gov.grants.apply.forms.rrFedNonFedBudget10V11.TotalDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetService;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.GenericPrintable;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.bo.BudgetPeriodInfo;
import org.kuali.kra.s2s.generator.bo.BudgetSummaryInfo;
import org.kuali.kra.s2s.generator.bo.CompensationInfo;
import org.kuali.kra.s2s.generator.bo.CostInfo;
import org.kuali.kra.s2s.generator.bo.EquipmentInfo;
import org.kuali.kra.s2s.generator.bo.IndirectCostDetails;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.generator.bo.OtherDirectCostInfo;
import org.kuali.kra.s2s.generator.bo.OtherPersonnelInfo;
import org.kuali.kra.s2s.generator.impl.RRFedNonFedBudgetBaseGenerator;
import org.kuali.kra.s2s.generator.impl.RRFedNonFedBudgetV1_0Generator;

public class RRFedNonFedBudget10V1_1Generator
extends RRFedNonFedBudgetBaseGenerator {
    private static final int FED_NONFED_BUDGET_JUSTIFICATION_133 = 133;
    private static final Log LOG = LogFactory.getLog(RRFedNonFedBudgetV1_0Generator.class);
    private static final String EXTRA_KEYPERSON_ATTACHMENT_NON_FED_XSL = "/org/kuali/kra/s2s/stylesheet/ExtraKeyPersonAttachmentNonFed.xsl";
    private static final String EXTRA_KEYPERSONS = "RRFEDNONFED_EXTRA_KEYPERSONS";
    private static final int EXTRA_KEYPERSONS_TYPE = 11;
    private static final String EXTRA_KEYPERSONS_COMMENT = "RRFEDNONFED_EXTRA_KEYPERSONS";
    private static final String ADDITIONAL_EQUIPMENT_NARRATIVE_TYPE_CODE = "12";
    private static final String ADDITIONAL_EQUIPMENT_NARRATIVE_COMMENT = "RRFEDNONFED_ADDITIONAL_EQUIPMENT";
    private Budget budget;

    private RRFedNonFedBudget10Document getRRFedNonFedBudget() {
        List<BudgetPeriodInfo> budgetPeriodList;
        RRFedNonFedBudget10Document rrFedNonFedBudgetDocument = RRFedNonFedBudget10Document.Factory.newInstance();
        RRFedNonFedBudget10Document.RRFedNonFedBudget10 rrFedNonFedBudget = RRFedNonFedBudget10Document.RRFedNonFedBudget10.Factory.newInstance();
        rrFedNonFedBudget.setFormVersion("1.1");
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrFedNonFedBudget.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            rrFedNonFedBudget.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        }
        rrFedNonFedBudget.setBudgetType(BudgetTypeDataType.PROJECT);
        BudgetSummaryInfo budgetSummary = null;
        try {
            this.validateBudgetForForm(this.pdDoc);
            budgetPeriodList = this.s2sBudgetCalculatorService.getBudgetPeriods(this.pdDoc);
            budgetSummary = this.s2sBudgetCalculatorService.getBudgetInfo(this.pdDoc, budgetPeriodList);
            BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
            if (budgetDocument != null) {
                this.budget = budgetDocument.getBudget();
            }
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return rrFedNonFedBudgetDocument;
        }
        for (BudgetPeriodInfo budgetPeriodData : budgetPeriodList) {
            this.setBudgetYearDataType(rrFedNonFedBudget, budgetPeriodData);
        }
        AttachedFileDataType attachedFileDataType = AttachedFileDataType.Factory.newInstance();
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() != null && Integer.parseInt(narrative.getNarrativeTypeCode()) == 133 && (attachedFileDataType = this.getAttachedFileType(narrative)) != null) break;
        }
        rrFedNonFedBudget.setBudgetJustificationAttachment(attachedFileDataType);
        rrFedNonFedBudget.setBudgetSummary(this.getBudgetSummary(budgetSummary));
        rrFedNonFedBudgetDocument.setRRFedNonFedBudget10(rrFedNonFedBudget);
        return rrFedNonFedBudgetDocument;
    }

    private void setBudgetYearDataType(RRFedNonFedBudget10Document.RRFedNonFedBudget10 rrFedNonFedBudget, BudgetPeriodInfo periodInfo) {
        BudgetDecimal totalDirectCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal totalIndirectCostSharing = BudgetDecimal.ZERO;
        BudgetYearDataType budgetYear = rrFedNonFedBudget.addNewBudgetYear();
        if (periodInfo != null) {
            budgetYear.setBudgetPeriodStartDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getStartDate()));
            budgetYear.setBudgetPeriodEndDate(this.s2sUtilService.convertDateToCalendar(periodInfo.getEndDate()));
            BudgetYearDataType.BudgetPeriod.Enum budgetPeriodEnum = BudgetYearDataType.BudgetPeriod.Enum.forInt((int)periodInfo.getBudgetPeriod());
            budgetYear.setBudgetPeriod(budgetPeriodEnum);
            budgetYear.setKeyPersons(this.getKeyPersons(periodInfo));
            budgetYear.setOtherPersonnel(this.getOtherPersonnel(periodInfo));
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCompensation() != null) {
                summary.setFederalSummary(periodInfo.getTotalCompensation().bigDecimalValue());
            }
            if (periodInfo.getTotalCompensationCostSharing() != null) {
                if (this.budget.getSubmitCostSharingFlag().booleanValue()) {
                    summary.setNonFederalSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                    if (periodInfo.getTotalCompensation() != null) {
                        summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalCompensation().add(periodInfo.getTotalCompensationCostSharing())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalCompensationCostSharing().bigDecimalValue());
                    }
                } else {
                    summary.setNonFederalSummary(BigDecimal.ZERO);
                    if (periodInfo.getTotalCompensation() != null) {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalCompensation().bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(BigDecimal.ZERO);
                    }
                }
            }
            budgetYear.setTotalCompensation(summary);
            budgetYear.setEquipment(this.getEquipment(periodInfo));
            budgetYear.setTravel(this.getTravel(periodInfo));
            budgetYear.setParticipantTraineeSupportCosts(this.getParticipantTraineeSupportCosts(periodInfo));
            budgetYear.setOtherDirectCosts(this.getOtherDirectCosts(periodInfo));
            SummaryDataType summaryDirect = SummaryDataType.Factory.newInstance();
            if (periodInfo.getDirectCostsTotal() != null) {
                summaryDirect.setFederalSummary(periodInfo.getDirectCostsTotal().bigDecimalValue());
            }
            if (periodInfo.getTotalDirectCostSharing() != null) {
                totalDirectCostSharing = periodInfo.getTotalDirectCostSharing();
                summaryDirect.setNonFederalSummary(totalDirectCostSharing.bigDecimalValue());
                if (periodInfo.getDirectCostsTotal() != null) {
                    summaryDirect.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getDirectCostsTotal().add(totalDirectCostSharing)).bigDecimalValue());
                } else {
                    summaryDirect.setTotalFedNonFedSummary(totalDirectCostSharing.bigDecimalValue());
                }
            }
            budgetYear.setDirectCosts(summaryDirect);
            BudgetYearDataType.IndirectCosts indirectCosts = this.getIndirectCosts(periodInfo);
            if (indirectCosts != null) {
                budgetYear.setIndirectCosts(indirectCosts);
            }
            budgetYear.setCognizantFederalAgency(periodInfo.getCognizantFedAgency());
            if (periodInfo.getIndirectCosts().getTotalIndirectCostSharing() != null) {
                totalIndirectCostSharing = periodInfo.getIndirectCosts().getTotalIndirectCostSharing();
            }
            SummaryDataType summaryTotal = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalCosts() != null) {
                summaryTotal.setFederalSummary(periodInfo.getTotalCosts().bigDecimalValue());
            }
            summaryTotal.setNonFederalSummary(totalDirectCostSharing.bigDecimalValue().add(totalIndirectCostSharing.bigDecimalValue()));
            if (periodInfo.getCostSharingAmount() != null) {
                if (periodInfo.getTotalCosts() != null) {
                    summaryTotal.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalCosts().add(totalDirectCostSharing)).bigDecimalValue().add(totalIndirectCostSharing.bigDecimalValue()));
                } else {
                    summaryTotal.setTotalFedNonFedSummary(totalDirectCostSharing.bigDecimalValue().add(totalIndirectCostSharing.bigDecimalValue()));
                }
            }
            budgetYear.setTotalCosts(summaryTotal);
        }
    }

    private RRFedNonFedBudget10Document.RRFedNonFedBudget10.BudgetSummary getBudgetSummary(BudgetSummaryInfo budgetSummaryData) {
        BudgetDecimal cumTotalDirectCostSharing = BudgetDecimal.ZERO;
        RRFedNonFedBudget10Document.RRFedNonFedBudget10.BudgetSummary budgetSummary = RRFedNonFedBudget10Document.RRFedNonFedBudget10.BudgetSummary.Factory.newInstance();
        SummaryDataType summarySeniorKey = SummaryDataType.Factory.newInstance();
        SummaryDataType summaryPersonnel = SummaryDataType.Factory.newInstance();
        SummaryDataType directCosts = SummaryDataType.Factory.newInstance();
        SummaryDataType directIndirectCosts = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                summarySeniorKey.setFederalSummary(budgetSummaryData.getCumTotalFundsForSrPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForSrPersonnel() != null) {
                summarySeniorKey.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForSrPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForSrPersonnel() != null) {
                    summarySeniorKey.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalFundsForSrPersonnel().add(budgetSummaryData.getCumTotalNonFundsForSrPersonnel())).bigDecimalValue());
                } else {
                    summarySeniorKey.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForSrPersonnel().bigDecimalValue());
                }
            }
            SummaryDataType summaryOtherPersonnel = SummaryDataType.Factory.newInstance();
            if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                summaryOtherPersonnel.setFederalSummary(budgetSummaryData.getCumTotalFundsForOtherPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForOtherPersonnel() != null) {
                summaryOtherPersonnel.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForOtherPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForOtherPersonnel() != null) {
                    summaryOtherPersonnel.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalFundsForOtherPersonnel().add(budgetSummaryData.getCumTotalNonFundsForOtherPersonnel())).bigDecimalValue());
                } else {
                    summaryOtherPersonnel.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForOtherPersonnel().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTotalFundsRequestedOtherPersonnel(summaryOtherPersonnel);
            if (budgetSummaryData.getCumNumOtherPersonnel() != null) {
                budgetSummary.setCumulativeTotalNoOtherPersonnel(budgetSummaryData.getCumNumOtherPersonnel().intValue());
            }
            if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                summaryPersonnel.setFederalSummary(budgetSummaryData.getCumTotalFundsForPersonnel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTotalNonFundsForPersonnel() != null) {
                summaryPersonnel.setNonFederalSummary(budgetSummaryData.getCumTotalNonFundsForPersonnel().bigDecimalValue());
                if (budgetSummaryData.getCumTotalFundsForPersonnel() != null) {
                    summaryPersonnel.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalFundsForPersonnel().add(budgetSummaryData.getCumTotalNonFundsForPersonnel())).bigDecimalValue());
                } else {
                    summaryPersonnel.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalNonFundsForPersonnel().bigDecimalValue());
                }
            }
            this.setCumulativeEquipments(budgetSummary, budgetSummaryData);
            this.setCumulativeTravels(budgetSummary, budgetSummaryData);
            this.setCumulativeTrainee(budgetSummary, budgetSummaryData);
            this.setCumulativeOtherDirect(budgetSummary, budgetSummaryData);
            if (budgetSummaryData.getCumTotalDirectCosts() != null && budgetSummaryData.getCumTotalDirectCostSharing() != null) {
                if (budgetSummaryData.getCumFee() != null) {
                    budgetSummary.setCumulativeFee(budgetSummaryData.getCumFee().bigDecimalValue());
                }
                cumTotalDirectCostSharing = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)budgetSummaryData.getCumTotalNonFundsForPersonnel().add(budgetSummaryData.getCumEquipmentNonFunds())).add(budgetSummaryData.getCumTravelNonFund())).add(budgetSummaryData.getPartOtherCostSharing().add(budgetSummaryData.getPartStipendCostSharing().add(budgetSummaryData.getPartTravelCostSharing().add(budgetSummaryData.getPartSubsistenceCostSharing().add(budgetSummaryData.getPartTuitionCostSharing())))));
                for (OtherDirectCostInfo cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                    if (cumOtherDirect.getTotalOtherDirectCostSharing() == null) continue;
                    cumTotalDirectCostSharing = (BudgetDecimal)cumTotalDirectCostSharing.add(cumOtherDirect.getTotalOtherDirectCostSharing());
                }
                directCosts.setFederalSummary(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue());
                directCosts.setNonFederalSummary(cumTotalDirectCostSharing.bigDecimalValue());
                directCosts.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalDirectCosts().bigDecimalValue().add(cumTotalDirectCostSharing.bigDecimalValue()));
            }
            if (budgetSummaryData.getCumTotalIndirectCosts() != null && budgetSummaryData.getCumTotalIndirectCostSharing() != null) {
                SummaryDataType summary = SummaryDataType.Factory.newInstance();
                summary.setFederalSummary(budgetSummaryData.getCumTotalIndirectCosts().bigDecimalValue());
                summary.setNonFederalSummary(budgetSummaryData.getCumTotalIndirectCostSharing().bigDecimalValue());
                summary.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTotalIndirectCosts().add(budgetSummaryData.getCumTotalIndirectCostSharing())).bigDecimalValue());
                budgetSummary.setCumulativeTotalFundsRequestedIndirectCost(summary);
            }
            if (budgetSummaryData.getCumTotalCosts() != null && budgetSummaryData.getCumTotalDirectCostSharing() != null) {
                directIndirectCosts.setFederalSummary(budgetSummaryData.getCumTotalCosts().bigDecimalValue());
                directIndirectCosts.setNonFederalSummary(cumTotalDirectCostSharing.bigDecimalValue().add(budgetSummaryData.getCumTotalIndirectCostSharing().bigDecimalValue()));
                directIndirectCosts.setTotalFedNonFedSummary(budgetSummaryData.getCumTotalCosts().bigDecimalValue().add(cumTotalDirectCostSharing.bigDecimalValue()).add(budgetSummaryData.getCumTotalIndirectCostSharing().bigDecimalValue()));
            }
        }
        budgetSummary.setCumulativeTotalFundsRequestedSeniorKeyPerson(summarySeniorKey);
        budgetSummary.setCumulativeTotalFundsRequestedPersonnel(summaryPersonnel);
        budgetSummary.setCumulativeTotalFundsRequestedDirectCosts(directCosts);
        budgetSummary.setCumulativeTotalFundsRequestedDirectIndirectCosts(directIndirectCosts);
        return budgetSummary;
    }

    private void setCumulativeOtherDirect(RRFedNonFedBudget10Document.RRFedNonFedBudget10.BudgetSummary budgetSummary, BudgetSummaryInfo budgetSummaryData) {
        SummaryDataType summary = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null && budgetSummaryData.getOtherDirectCosts() != null) {
            for (OtherDirectCostInfo cumOtherDirect : budgetSummaryData.getOtherDirectCosts()) {
                if (cumOtherDirect.gettotalOtherDirect() != null) {
                    summary.setFederalSummary(cumOtherDirect.gettotalOtherDirect().bigDecimalValue());
                }
                if (cumOtherDirect.getTotalOtherDirectCostSharing() != null) {
                    summary.setNonFederalSummary(cumOtherDirect.getTotalOtherDirectCostSharing().bigDecimalValue());
                    if (cumOtherDirect.gettotalOtherDirect() != null) {
                        summary.setTotalFedNonFedSummary(((BudgetDecimal)cumOtherDirect.gettotalOtherDirect().add(cumOtherDirect.getTotalOtherDirectCostSharing())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(cumOtherDirect.getTotalOtherDirectCostSharing().bigDecimalValue());
                    }
                }
                TotalDataType totalMaterial = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getmaterials() != null) {
                    totalMaterial.setFederal(cumOtherDirect.getmaterials().bigDecimalValue());
                }
                if (cumOtherDirect.getMaterialsCostSharing() != null) {
                    totalMaterial.setNonFederal(cumOtherDirect.getMaterialsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getmaterials() != null) {
                        totalMaterial.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getmaterials().add(cumOtherDirect.getMaterialsCostSharing())).bigDecimalValue());
                    } else {
                        totalMaterial.setTotalFedNonFed(cumOtherDirect.getMaterialsCostSharing().bigDecimalValue());
                    }
                }
                budgetSummary.setCumulativeMaterialAndSupplies(totalMaterial);
                TotalDataType totalPublication = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getpublications() != null) {
                    totalPublication.setFederal(cumOtherDirect.getpublications().bigDecimalValue());
                }
                if (cumOtherDirect.getPublicationsCostSharing() != null) {
                    totalPublication.setNonFederal(cumOtherDirect.getPublicationsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getpublications() != null) {
                        totalPublication.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getpublications().add(cumOtherDirect.getPublicationsCostSharing())).bigDecimalValue());
                    } else {
                        totalPublication.setTotalFedNonFed(cumOtherDirect.getPublicationsCostSharing().bigDecimalValue());
                    }
                }
                budgetSummary.setCumulativePublicationCosts(totalPublication);
                TotalDataType totalConsultant = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getConsultants() != null) {
                    totalConsultant.setFederal(cumOtherDirect.getConsultants().bigDecimalValue());
                }
                if (cumOtherDirect.getConsultantsCostSharing() != null) {
                    totalConsultant.setNonFederal(cumOtherDirect.getConsultantsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getConsultants() != null) {
                        totalConsultant.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getConsultants().add(cumOtherDirect.getConsultantsCostSharing())).bigDecimalValue());
                    } else {
                        totalConsultant.setTotalFedNonFed(cumOtherDirect.getConsultantsCostSharing().bigDecimalValue());
                    }
                }
                budgetSummary.setCumulativeConsultantServices(totalConsultant);
                TotalDataType totalComputer = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getcomputer() != null) {
                    totalComputer.setFederal(cumOtherDirect.getcomputer().bigDecimalValue());
                }
                if (cumOtherDirect.getComputerCostSharing() != null) {
                    totalComputer.setNonFederal(cumOtherDirect.getComputerCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getcomputer() != null) {
                        totalComputer.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getcomputer().add(cumOtherDirect.getComputerCostSharing())).bigDecimalValue());
                    } else {
                        totalComputer.setTotalFedNonFed(cumOtherDirect.getComputerCostSharing().bigDecimalValue());
                    }
                }
                budgetSummary.setCumulativeADPComputerServices(totalComputer);
                TotalDataType totalSubaward = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getsubAwards() != null) {
                    totalSubaward.setFederal(cumOtherDirect.getsubAwards().bigDecimalValue());
                }
                if (cumOtherDirect.getSubAwardsCostSharing() != null) {
                    totalSubaward.setNonFederal(cumOtherDirect.getSubAwardsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getsubAwards() != null) {
                        totalSubaward.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getsubAwards().add(cumOtherDirect.getSubAwardsCostSharing())).bigDecimalValue());
                    } else {
                        totalSubaward.setTotalFedNonFed(cumOtherDirect.getSubAwardsCostSharing().bigDecimalValue());
                    }
                }
                budgetSummary.setCumulativeSubawardConsortiumContractualCosts(totalSubaward);
                TotalDataType totalEquipment = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getEquipRental() != null) {
                    totalEquipment.setFederal(cumOtherDirect.getEquipRental().bigDecimalValue());
                }
                if (cumOtherDirect.getEquipRentalCostSharing() != null) {
                    totalEquipment.setNonFederal(cumOtherDirect.getEquipRentalCostSharing().bigDecimalValue());
                    totalEquipment.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getEquipRental().add(cumOtherDirect.getEquipRentalCostSharing())).bigDecimalValue());
                }
                budgetSummary.setCumulativeEquipmentFacilityRentalFees(totalEquipment);
                budgetSummary.setCumulativeEquipmentFacilityRentalFees(totalEquipment);
                TotalDataType totalAlterations = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getAlterations() != null) {
                    totalAlterations.setFederal(cumOtherDirect.getAlterations().bigDecimalValue());
                }
                if (cumOtherDirect.getAlterationsCostSharing() != null) {
                    totalAlterations.setNonFederal(cumOtherDirect.getAlterationsCostSharing().bigDecimalValue());
                    if (cumOtherDirect.getAlterations() != null) {
                        totalAlterations.setTotalFedNonFed(((BudgetDecimal)cumOtherDirect.getAlterations().add(cumOtherDirect.getAlterationsCostSharing())).bigDecimalValue());
                    } else {
                        totalAlterations.setTotalFedNonFed(cumOtherDirect.getAlterationsCostSharing().bigDecimalValue());
                    }
                }
                budgetSummary.setCumulativeAlterationsAndRenovations(totalAlterations);
                TotalDataType totalOther = TotalDataType.Factory.newInstance();
                if (cumOtherDirect.getOtherCosts() != null && cumOtherDirect.getOtherCosts().size() > 0) {
                    totalOther.setFederal(new BigDecimal(cumOtherDirect.getOtherCosts().get(0).get("Cost")));
                    totalOther.setNonFederal(new BigDecimal(cumOtherDirect.getOtherCosts().get(0).get("CostSharing")));
                }
                if (totalOther.getFederal() != null && totalOther.getNonFederal() != null) {
                    totalOther.setTotalFedNonFed(totalOther.getFederal().add(totalOther.getNonFederal()));
                }
                budgetSummary.setCumulativeOther1DirectCost(totalOther);
            }
        }
        budgetSummary.setCumulativeTotalFundsRequestedOtherDirectCosts(summary);
    }

    private void setCumulativeTrainee(RRFedNonFedBudget10Document.RRFedNonFedBudget10.BudgetSummary budgetSummary, BudgetSummaryInfo budgetSummaryData) {
        SummaryDataType summaryTraineeCosts = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getpartOtherCost() != null && budgetSummaryData.getpartStipendCost() != null && budgetSummaryData.getpartTravelCost() != null && budgetSummaryData.getPartSubsistence() != null && budgetSummaryData.getPartTuition() != null) {
                summaryTraineeCosts.setFederalSummary(((BudgetDecimal)budgetSummaryData.getpartOtherCost().add(budgetSummaryData.getpartStipendCost().add(budgetSummaryData.getpartTravelCost().add(budgetSummaryData.getPartSubsistence().add(budgetSummaryData.getPartTuition()))))).bigDecimalValue());
            }
            if (budgetSummaryData.getPartOtherCostSharing() != null && budgetSummaryData.getPartStipendCostSharing() != null && budgetSummaryData.getPartTravelCostSharing() != null && budgetSummaryData.getPartSubsistenceCostSharing() != null && budgetSummaryData.getPartTuitionCostSharing() != null) {
                summaryTraineeCosts.setNonFederalSummary(((BudgetDecimal)budgetSummaryData.getPartOtherCostSharing().add(budgetSummaryData.getPartStipendCostSharing().add(budgetSummaryData.getPartTravelCostSharing().add(budgetSummaryData.getPartSubsistenceCostSharing().add(budgetSummaryData.getPartTuitionCostSharing()))))).bigDecimalValue());
            }
            if (summaryTraineeCosts.getNonFederalSummary() != null) {
                if (summaryTraineeCosts.getFederalSummary() != null) {
                    summaryTraineeCosts.setTotalFedNonFedSummary(summaryTraineeCosts.getFederalSummary().add(summaryTraineeCosts.getNonFederalSummary()));
                } else {
                    summaryTraineeCosts.setTotalFedNonFedSummary(summaryTraineeCosts.getNonFederalSummary());
                }
            }
            TotalDataType totalTuition = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getPartTuition() != null) {
                totalTuition.setFederal(budgetSummaryData.getPartTuition().bigDecimalValue());
            }
            if (budgetSummaryData.getPartTuitionCostSharing() != null) {
                totalTuition.setNonFederal(budgetSummaryData.getPartTuitionCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartTuition() != null) {
                    totalTuition.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getPartTuition().add(budgetSummaryData.getPartTuitionCostSharing())).bigDecimalValue());
                } else {
                    totalTuition.setTotalFedNonFed(budgetSummaryData.getPartTuitionCostSharing().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTraineeTuitionFeesHealthInsurance(totalTuition);
            TotalDataType totalStipends = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getpartStipendCost() != null) {
                totalStipends.setFederal(budgetSummaryData.getpartStipendCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartStipendCostSharing() != null) {
                totalStipends.setNonFederal(budgetSummaryData.getPartStipendCostSharing().bigDecimalValue());
                if (budgetSummaryData.getpartStipendCost() != null) {
                    totalStipends.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getpartStipendCost().add(budgetSummaryData.getPartStipendCostSharing())).bigDecimalValue());
                } else {
                    totalStipends.setTotalFedNonFed(budgetSummaryData.getPartStipendCostSharing().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTraineeStipends(totalStipends);
            TotalDataType totalTravel = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getpartTravelCost() != null) {
                totalTravel.setFederal(budgetSummaryData.getpartTravelCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartTravelCostSharing() != null) {
                totalTravel.setNonFederal(budgetSummaryData.getPartTravelCostSharing().bigDecimalValue());
                if (budgetSummaryData.getpartTravelCost() != null) {
                    totalTravel.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getpartTravelCost().add(budgetSummaryData.getPartTravelCostSharing())).bigDecimalValue());
                } else {
                    totalTravel.setTotalFedNonFed(budgetSummaryData.getPartTravelCostSharing().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTraineeTravel(totalTravel);
            TotalDataType totalSubsistence = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getPartSubsistence() != null) {
                totalSubsistence.setFederal(budgetSummaryData.getPartSubsistence().bigDecimalValue());
            }
            if (budgetSummaryData.getPartSubsistenceCostSharing() != null) {
                totalSubsistence.setNonFederal(budgetSummaryData.getPartSubsistenceCostSharing().bigDecimalValue());
                if (budgetSummaryData.getPartSubsistence() != null) {
                    totalSubsistence.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getPartSubsistence().add(budgetSummaryData.getPartSubsistenceCostSharing())).bigDecimalValue());
                } else {
                    totalSubsistence.setTotalFedNonFed(budgetSummaryData.getPartSubsistenceCostSharing().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTraineeSubsistence(totalSubsistence);
            TotalDataType totalOtherTrainee = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getpartOtherCost() != null) {
                totalOtherTrainee.setFederal(budgetSummaryData.getpartOtherCost().bigDecimalValue());
            }
            if (budgetSummaryData.getPartOtherCostSharing() != null) {
                totalOtherTrainee.setNonFederal(budgetSummaryData.getPartOtherCostSharing().bigDecimalValue());
                if (budgetSummaryData.getpartOtherCost() != null) {
                    totalOtherTrainee.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getpartOtherCost().add(budgetSummaryData.getPartOtherCostSharing())).bigDecimalValue());
                } else {
                    totalOtherTrainee.setTotalFedNonFed(budgetSummaryData.getPartOtherCostSharing().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeOtherTraineeCost(totalOtherTrainee);
            budgetSummary.setCumulativeNoofTrainees(budgetSummaryData.getparticipantCount());
        }
        budgetSummary.setCumulativeTotalFundsRequestedTraineeCosts(summaryTraineeCosts);
    }

    private void setCumulativeEquipments(RRFedNonFedBudget10Document.RRFedNonFedBudget10.BudgetSummary budgetSummary, BudgetSummaryInfo budgetSummaryData) {
        if (budgetSummaryData != null) {
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (budgetSummaryData.getCumEquipmentFunds() != null) {
                summary.setFederalSummary(budgetSummaryData.getCumEquipmentFunds().bigDecimalValue());
            }
            if (budgetSummaryData.getCumEquipmentNonFunds() != null) {
                summary.setNonFederalSummary(budgetSummaryData.getCumEquipmentNonFunds().bigDecimalValue());
                if (budgetSummaryData.getCumEquipmentFunds() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumEquipmentFunds().add(budgetSummaryData.getCumEquipmentNonFunds())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(budgetSummaryData.getCumEquipmentNonFunds().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeTotalFundsRequestedEquipment(summary);
        }
    }

    private void setCumulativeTravels(RRFedNonFedBudget10Document.RRFedNonFedBudget10.BudgetSummary budgetSummary, BudgetSummaryInfo budgetSummaryData) {
        SummaryDataType summary = SummaryDataType.Factory.newInstance();
        if (budgetSummaryData != null) {
            if (budgetSummaryData.getCumTravel() != null) {
                summary.setFederalSummary(budgetSummaryData.getCumTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumTravelNonFund() != null) {
                summary.setNonFederalSummary(budgetSummaryData.getCumTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumTravel() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)budgetSummaryData.getCumTravel().add(budgetSummaryData.getCumTravelNonFund())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(budgetSummaryData.getCumTravelNonFund().bigDecimalValue());
                }
            }
            TotalDataType totalDomestic = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getCumDomesticTravel() != null) {
                totalDomestic.setFederal(budgetSummaryData.getCumDomesticTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumDomesticTravelNonFund() != null) {
                totalDomestic.setNonFederal(budgetSummaryData.getCumDomesticTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumDomesticTravel() != null) {
                    totalDomestic.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getCumDomesticTravel().add(budgetSummaryData.getCumDomesticTravelNonFund())).bigDecimalValue());
                } else {
                    totalDomestic.setTotalFedNonFed(budgetSummaryData.getCumDomesticTravelNonFund().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeDomesticTravelCosts(totalDomestic);
            TotalDataType totalForeign = TotalDataType.Factory.newInstance();
            if (budgetSummaryData.getCumForeignTravel() != null) {
                totalForeign.setFederal(budgetSummaryData.getCumForeignTravel().bigDecimalValue());
            }
            if (budgetSummaryData.getCumForeignTravelNonFund() != null) {
                totalForeign.setNonFederal(budgetSummaryData.getCumForeignTravelNonFund().bigDecimalValue());
                if (budgetSummaryData.getCumForeignTravel() != null) {
                    totalForeign.setTotalFedNonFed(((BudgetDecimal)budgetSummaryData.getCumForeignTravel().add(budgetSummaryData.getCumForeignTravelNonFund())).bigDecimalValue());
                } else {
                    totalForeign.setTotalFedNonFed(budgetSummaryData.getCumForeignTravelNonFund().bigDecimalValue());
                }
            }
            budgetSummary.setCumulativeForeignTravelCosts(totalForeign);
        }
        budgetSummary.setCumulativeTotalFundsRequestedTravel(summary);
    }

    private BudgetYearDataType.IndirectCosts getIndirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.IndirectCosts indirectCosts = null;
        if (periodInfo != null && periodInfo.getIndirectCosts() != null && periodInfo.getIndirectCosts().getIndirectCostDetails() != null) {
            int IndirectCostCount = 0;
            ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost> indirectCostList = new ArrayList<BudgetYearDataType.IndirectCosts.IndirectCost>();
            for (IndirectCostDetails indirectCostDetails : periodInfo.getIndirectCosts().getIndirectCostDetails()) {
                BudgetYearDataType.IndirectCosts.IndirectCost indirectCost = BudgetYearDataType.IndirectCosts.IndirectCost.Factory.newInstance();
                indirectCost.setCostType(indirectCostDetails.getCostType());
                if (indirectCostDetails.getBase() != null) {
                    indirectCost.setBase(indirectCostDetails.getBase().bigDecimalValue());
                }
                if (indirectCostDetails.getRate() != null) {
                    indirectCost.setRate(indirectCostDetails.getRate().bigDecimalValue());
                }
                TotalDataType total = TotalDataType.Factory.newInstance();
                if (indirectCostDetails.getFunds() != null) {
                    total.setFederal(indirectCostDetails.getFunds().bigDecimalValue());
                } else {
                    total.setFederal(new BigDecimal(0.0));
                }
                if (indirectCostDetails.getCostSharing() != null) {
                    total.setNonFederal(indirectCostDetails.getCostSharing().bigDecimalValue());
                    if (indirectCostDetails.getFunds() != null) {
                        total.setTotalFedNonFed(((BudgetDecimal)indirectCostDetails.getFunds().add(indirectCostDetails.getCostSharing())).bigDecimalValue());
                    } else {
                        total.setTotalFedNonFed(indirectCostDetails.getCostSharing().bigDecimalValue());
                    }
                } else if (indirectCostDetails.getFunds() != null) {
                    total.setTotalFedNonFed(indirectCostDetails.getFunds().bigDecimalValue());
                    total.setNonFederal(new BigDecimal(0.0));
                } else {
                    total.setNonFederal(new BigDecimal(0.0));
                    total.setTotalFedNonFed(new BigDecimal(0.0));
                }
                indirectCost.setFundRequested(total);
                indirectCostList.add(indirectCost);
                if (++IndirectCostCount != 4) continue;
                LOG.warn((Object)"Stopping iteration over indirect cost details because array limit in schema is only 4");
                break;
            }
            if (IndirectCostCount > 0) {
                indirectCosts = BudgetYearDataType.IndirectCosts.Factory.newInstance();
                BudgetYearDataType.IndirectCosts.IndirectCost[] indirectCostArray = new BudgetYearDataType.IndirectCosts.IndirectCost[]{};
                indirectCosts.setIndirectCostArray(indirectCostList.toArray(indirectCostArray));
                SummaryDataType summary = SummaryDataType.Factory.newInstance();
                if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                    summary.setFederalSummary(periodInfo.getIndirectCosts().getTotalIndirectCosts().bigDecimalValue());
                }
                if (periodInfo.getIndirectCosts().getTotalIndirectCostSharing() != null) {
                    summary.setNonFederalSummary(periodInfo.getIndirectCosts().getTotalIndirectCostSharing().bigDecimalValue());
                    if (periodInfo.getIndirectCosts().getTotalIndirectCosts() != null) {
                        summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getIndirectCosts().getTotalIndirectCosts().add(periodInfo.getIndirectCosts().getTotalIndirectCostSharing())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(periodInfo.getIndirectCosts().getTotalIndirectCostSharing().bigDecimalValue());
                    }
                }
                indirectCosts.setTotalIndirectCosts(summary);
            }
        }
        return indirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts getOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts otherDirectCosts = BudgetYearDataType.OtherDirectCosts.Factory.newInstance();
        TotalDataType totalMaterials = TotalDataType.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null && periodInfo.getOtherDirectCosts().size() > 0) {
            if (periodInfo.getOtherDirectCosts().get(0).getmaterials() != null) {
                totalMaterials.setFederal(periodInfo.getOtherDirectCosts().get(0).getmaterials().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getMaterialsCostSharing() != null) {
                totalMaterials.setNonFederal(periodInfo.getOtherDirectCosts().get(0).getMaterialsCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).getmaterials() != null) {
                    totalMaterials.setTotalFedNonFed(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).getmaterials().add(periodInfo.getOtherDirectCosts().get(0).getMaterialsCostSharing())).bigDecimalValue());
                } else {
                    totalMaterials.setTotalFedNonFed(periodInfo.getOtherDirectCosts().get(0).getMaterialsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setMaterialsSupplies(totalMaterials);
            TotalDataType totalPublication = TotalDataType.Factory.newInstance();
            if (periodInfo.getOtherDirectCosts().get(0).getpublications() != null) {
                totalPublication.setFederal(periodInfo.getOtherDirectCosts().get(0).getpublications().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getPublicationsCostSharing() != null) {
                totalPublication.setNonFederal(periodInfo.getOtherDirectCosts().get(0).getPublicationsCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).getpublications() != null) {
                    totalPublication.setTotalFedNonFed(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).getpublications().add(periodInfo.getOtherDirectCosts().get(0).getPublicationsCostSharing())).bigDecimalValue());
                } else {
                    totalPublication.setTotalFedNonFed(periodInfo.getOtherDirectCosts().get(0).getPublicationsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setPublicationCosts(totalPublication);
            TotalDataType totalConsultant = TotalDataType.Factory.newInstance();
            if (periodInfo.getOtherDirectCosts().get(0).getConsultants() != null) {
                totalConsultant.setFederal(periodInfo.getOtherDirectCosts().get(0).getConsultants().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getConsultantsCostSharing() != null) {
                totalConsultant.setNonFederal(periodInfo.getOtherDirectCosts().get(0).getConsultantsCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).getConsultants() != null) {
                    totalConsultant.setTotalFedNonFed(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).getConsultants().add(periodInfo.getOtherDirectCosts().get(0).getConsultantsCostSharing())).bigDecimalValue());
                } else {
                    totalConsultant.setTotalFedNonFed(periodInfo.getOtherDirectCosts().get(0).getConsultantsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setConsultantServices(totalConsultant);
            TotalDataType totalADP = TotalDataType.Factory.newInstance();
            if (periodInfo.getOtherDirectCosts().get(0).getcomputer() != null) {
                totalADP.setFederal(periodInfo.getOtherDirectCosts().get(0).getcomputer().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getComputerCostSharing() != null) {
                totalADP.setNonFederal(periodInfo.getOtherDirectCosts().get(0).getComputerCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).getcomputer() != null) {
                    totalADP.setTotalFedNonFed(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).getcomputer().add(periodInfo.getOtherDirectCosts().get(0).getComputerCostSharing())).bigDecimalValue());
                } else {
                    totalADP.setTotalFedNonFed(periodInfo.getOtherDirectCosts().get(0).getComputerCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setADPComputerServices(totalADP);
            TotalDataType totalSubaward = TotalDataType.Factory.newInstance();
            if (periodInfo.getOtherDirectCosts().get(0).getsubAwards() != null) {
                totalSubaward.setFederal(periodInfo.getOtherDirectCosts().get(0).getsubAwards().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getSubAwardsCostSharing() != null) {
                totalSubaward.setNonFederal(periodInfo.getOtherDirectCosts().get(0).getSubAwardsCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).getsubAwards() != null) {
                    totalSubaward.setTotalFedNonFed(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).getsubAwards().add(periodInfo.getOtherDirectCosts().get(0).getSubAwardsCostSharing())).bigDecimalValue());
                } else {
                    totalSubaward.setTotalFedNonFed(periodInfo.getOtherDirectCosts().get(0).getSubAwardsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setSubawardConsortiumContractualCosts(totalSubaward);
            TotalDataType totalEquipment = TotalDataType.Factory.newInstance();
            if (periodInfo.getOtherDirectCosts().get(0).getEquipRental() != null) {
                totalEquipment.setFederal(periodInfo.getOtherDirectCosts().get(0).getEquipRental().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getEquipRentalCostSharing() != null) {
                totalEquipment.setNonFederal(periodInfo.getOtherDirectCosts().get(0).getEquipRentalCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).getEquipRental() != null) {
                    totalEquipment.setTotalFedNonFed(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).getEquipRental().add(periodInfo.getOtherDirectCosts().get(0).getEquipRentalCostSharing())).bigDecimalValue());
                } else {
                    totalEquipment.setTotalFedNonFed(periodInfo.getOtherDirectCosts().get(0).getEquipRentalCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setEquipmentRentalFee(totalEquipment);
            TotalDataType totalAlterations = TotalDataType.Factory.newInstance();
            if (periodInfo.getOtherDirectCosts().get(0).getAlterations() != null) {
                totalAlterations.setFederal(periodInfo.getOtherDirectCosts().get(0).getAlterations().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getAlterationsCostSharing() != null) {
                totalAlterations.setNonFederal(periodInfo.getOtherDirectCosts().get(0).getAlterationsCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).getAlterations() != null) {
                    totalAlterations.setTotalFedNonFed(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).getAlterations().add(periodInfo.getOtherDirectCosts().get(0).getAlterationsCostSharing())).bigDecimalValue());
                } else {
                    totalAlterations.setTotalFedNonFed(periodInfo.getOtherDirectCosts().get(0).getAlterationsCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setAlterationsRenovations(totalAlterations);
            otherDirectCosts.setOthers(this.getOthersForOtherDirectCosts(periodInfo));
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect() != null) {
                summary.setFederalSummary(periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect().bigDecimalValue());
            }
            if (periodInfo.getOtherDirectCosts().get(0).getTotalOtherDirectCostSharing() != null) {
                summary.setNonFederalSummary(periodInfo.getOtherDirectCosts().get(0).getTotalOtherDirectCostSharing().bigDecimalValue());
                if (periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getOtherDirectCosts().get(0).gettotalOtherDirect().add(periodInfo.getOtherDirectCosts().get(0).getTotalOtherDirectCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getOtherDirectCosts().get(0).getTotalOtherDirectCostSharing().bigDecimalValue());
                }
            }
            otherDirectCosts.setTotalOtherDirectCost(summary);
        }
        return otherDirectCosts;
    }

    private BudgetYearDataType.OtherDirectCosts.Others getOthersForOtherDirectCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherDirectCosts.Others othersDirect = BudgetYearDataType.OtherDirectCosts.Others.Factory.newInstance();
        if (periodInfo != null && periodInfo.getOtherDirectCosts() != null) {
            BudgetYearDataType.OtherDirectCosts.Others.Other[] otherArray = new BudgetYearDataType.OtherDirectCosts.Others.Other[periodInfo.getOtherDirectCosts().size()];
            int Otherscount = 0;
            BudgetYearDataType.OtherDirectCosts.Others.Other other = BudgetYearDataType.OtherDirectCosts.Others.Other.Factory.newInstance();
            for (OtherDirectCostInfo otherDirectCostInfo : periodInfo.getOtherDirectCosts()) {
                TotalDataType total = TotalDataType.Factory.newInstance();
                if (otherDirectCostInfo.getOtherCosts() != null && otherDirectCostInfo.getOtherCosts().size() > 0) {
                    total.setFederal(new BigDecimal(otherDirectCostInfo.getOtherCosts().get(0).get("Cost")));
                    total.setNonFederal(new BigDecimal(otherDirectCostInfo.getOtherCosts().get(0).get("CostSharing")));
                    if (otherDirectCostInfo.getOtherCosts().get(0).get("Cost") != null) {
                        total.setTotalFedNonFed(new BigDecimal(otherDirectCostInfo.getOtherCosts().get(0).get("Cost")).add(new BigDecimal(otherDirectCostInfo.getOtherCosts().get(0).get("CostSharing"))));
                    } else {
                        total.setTotalFedNonFed(new BigDecimal(otherDirectCostInfo.getOtherCosts().get(0).get("CostSharing")));
                    }
                }
                other.setCost(total);
                other.setDescription("Other");
                otherArray[Otherscount] = other;
                ++Otherscount;
            }
            othersDirect.setOtherArray(otherArray);
        }
        return othersDirect;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts getParticipantTraineeSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts traineeSupportCosts = BudgetYearDataType.ParticipantTraineeSupportCosts.Factory.newInstance();
        if (periodInfo != null) {
            TotalDataType totalTution = TotalDataType.Factory.newInstance();
            if (periodInfo.getPartTuition() != null) {
                totalTution.setFederal(periodInfo.getPartTuition().bigDecimalValue());
            }
            if (periodInfo.getPartTuitionCostSharing() != null) {
                totalTution.setNonFederal(periodInfo.getPartTuitionCostSharing().bigDecimalValue());
                if (periodInfo.getPartTuition() != null) {
                    totalTution.setTotalFedNonFed(((BudgetDecimal)periodInfo.getPartTuition().add(periodInfo.getPartTuitionCostSharing())).bigDecimalValue());
                } else {
                    totalTution.setTotalFedNonFed(periodInfo.getPartTuitionCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setTuitionFeeHealthInsurance(totalTution);
            TotalDataType totalStipends = TotalDataType.Factory.newInstance();
            if (periodInfo.getpartStipendCost() != null) {
                totalStipends.setFederal(periodInfo.getpartStipendCost().bigDecimalValue());
            }
            if (periodInfo.getPartStipendCostSharing() != null) {
                totalStipends.setNonFederal(periodInfo.getPartStipendCostSharing().bigDecimalValue());
                if (periodInfo.getpartStipendCost() != null) {
                    totalStipends.setTotalFedNonFed(((BudgetDecimal)periodInfo.getpartStipendCost().add(periodInfo.getPartStipendCostSharing())).bigDecimalValue());
                } else {
                    totalStipends.setTotalFedNonFed(periodInfo.getPartStipendCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setStipends(totalStipends);
            TotalDataType totalTravel = TotalDataType.Factory.newInstance();
            if (periodInfo.getpartTravelCost() != null) {
                totalTravel.setFederal(periodInfo.getpartTravelCost().bigDecimalValue());
            }
            if (periodInfo.getPartTravelCostSharing() != null) {
                totalTravel.setNonFederal(periodInfo.getPartTravelCostSharing().bigDecimalValue());
                if (periodInfo.getpartTravelCost() != null) {
                    totalTravel.setTotalFedNonFed(((BudgetDecimal)periodInfo.getpartTravelCost().add(periodInfo.getPartTravelCostSharing())).bigDecimalValue());
                } else {
                    totalTravel.setTotalFedNonFed(periodInfo.getPartTravelCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setParticipantTravel(totalTravel);
            TotalDataType totalSubsistence = TotalDataType.Factory.newInstance();
            if (periodInfo.getPartSubsistence() != null) {
                totalSubsistence.setFederal(periodInfo.getPartSubsistence().bigDecimalValue());
            }
            if (periodInfo.getPartSubsistenceCostSharing() != null) {
                totalSubsistence.setNonFederal(periodInfo.getPartSubsistenceCostSharing().bigDecimalValue());
                if (periodInfo.getPartSubsistence() != null) {
                    totalSubsistence.setTotalFedNonFed(((BudgetDecimal)periodInfo.getPartSubsistence().add(periodInfo.getPartSubsistenceCostSharing())).bigDecimalValue());
                } else {
                    totalSubsistence.setTotalFedNonFed(periodInfo.getPartSubsistenceCostSharing().bigDecimalValue());
                }
            }
            traineeSupportCosts.setSubsistence(totalSubsistence);
            traineeSupportCosts.setOther(this.getOtherPTSupportCosts(periodInfo));
            traineeSupportCosts.setParticipantTraineeNumber(periodInfo.getparticipantCount());
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            summary.setFederalSummary(((BudgetDecimal)periodInfo.getpartOtherCost().add(periodInfo.getpartStipendCost().add(periodInfo.getpartTravelCost().add(periodInfo.getPartSubsistence().add(periodInfo.getPartTuition()))))).bigDecimalValue());
            summary.setNonFederalSummary(((BudgetDecimal)periodInfo.getPartOtherCostSharing().add(periodInfo.getPartStipendCostSharing().add(periodInfo.getPartTravelCostSharing().add(periodInfo.getPartSubsistenceCostSharing().add(periodInfo.getPartTuitionCostSharing()))))).bigDecimalValue());
            if (summary.getNonFederalSummary() != null) {
                if (summary.getFederalSummary() != null) {
                    summary.setTotalFedNonFedSummary(summary.getFederalSummary().add(summary.getNonFederalSummary()));
                } else {
                    summary.setTotalFedNonFedSummary(summary.getNonFederalSummary());
                }
            }
            traineeSupportCosts.setTotalCost(summary);
        }
        return traineeSupportCosts;
    }

    private BudgetYearDataType.ParticipantTraineeSupportCosts.Other getOtherPTSupportCosts(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.ParticipantTraineeSupportCosts.Other other = BudgetYearDataType.ParticipantTraineeSupportCosts.Other.Factory.newInstance();
        other.setDescription("Other");
        TotalDataType total = TotalDataType.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getpartOtherCost() != null) {
                total.setFederal(periodInfo.getpartOtherCost().bigDecimalValue());
            }
            if (periodInfo.getPartOtherCostSharing() != null) {
                total.setNonFederal(periodInfo.getPartOtherCostSharing().bigDecimalValue());
                if (periodInfo.getpartOtherCost() != null) {
                    total.setTotalFedNonFed(((BudgetDecimal)periodInfo.getpartOtherCost().add(periodInfo.getPartOtherCostSharing())).bigDecimalValue());
                } else {
                    total.setTotalFedNonFed(periodInfo.getPartOtherCostSharing().bigDecimalValue());
                }
            }
        }
        other.setCost(total);
        return other;
    }

    private BudgetYearDataType.Equipment getEquipment(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Equipment equipment = BudgetYearDataType.Equipment.Factory.newInstance();
        BudgetYearDataType.Equipment.EquipmentList[] equipmentArray = new BudgetYearDataType.Equipment.EquipmentList[]{};
        ArrayList<BudgetYearDataType.Equipment.EquipmentList> equipmentArrayList = new ArrayList<BudgetYearDataType.Equipment.EquipmentList>();
        if (periodInfo.getEquipment() != null && periodInfo.getEquipment() != null && periodInfo.getEquipment().size() > 0 && periodInfo.getEquipment() != null) {
            SummaryDataType totalFund = SummaryDataType.Factory.newInstance();
            totalFund.setFederalSummary(BigDecimal.ZERO);
            totalFund.setNonFederalSummary(BigDecimal.ZERO);
            totalFund.setTotalFedNonFedSummary(BigDecimal.ZERO);
            for (CostInfo costInfo : periodInfo.getEquipment().get(0).getEquipmentList()) {
                BudgetYearDataType.Equipment.EquipmentList equipmentList = BudgetYearDataType.Equipment.EquipmentList.Factory.newInstance();
                equipmentList.setEquipmentItem(costInfo.getDescription());
                TotalDataType fundsRequested = TotalDataType.Factory.newInstance();
                fundsRequested.setFederal(costInfo.getCost().bigDecimalValue());
                fundsRequested.setNonFederal(costInfo.getCostSharing().bigDecimalValue());
                fundsRequested.setTotalFedNonFed(((BudgetDecimal)costInfo.getCost().add(costInfo.getCostSharing())).bigDecimalValue());
                totalFund.setFederalSummary(totalFund.getFederalSummary().add(costInfo.getCost().bigDecimalValue()));
                totalFund.setNonFederalSummary(totalFund.getNonFederalSummary().add(costInfo.getCostSharing().bigDecimalValue()));
                equipmentList.setFundsRequested(fundsRequested);
                equipmentArrayList.add(equipmentList);
            }
            totalFund.setTotalFedNonFedSummary(totalFund.getFederalSummary().add(totalFund.getNonFederalSummary()));
            equipmentArray = equipmentArrayList.toArray(equipmentArray);
            equipment.setEquipmentListArray(equipmentArray);
            equipment.setTotalFund(totalFund);
            EquipmentInfo equipmentInfo = periodInfo.getEquipment().get(0);
            TotalDataType totalFundForExtraEquipment = TotalDataType.Factory.newInstance();
            totalFundForExtraEquipment.setFederal(equipmentInfo.getTotalExtraFund().bigDecimalValue());
            totalFundForExtraEquipment.setNonFederal(equipmentInfo.getTotalExtraNonFund().bigDecimalValue());
            if (equipmentInfo.getTotalExtraFund() != null) {
                totalFundForExtraEquipment.setTotalFedNonFed(((BudgetDecimal)equipmentInfo.getTotalExtraFund().add(equipmentInfo.getTotalExtraNonFund())).bigDecimalValue());
            } else {
                totalFundForExtraEquipment.setTotalFedNonFed(equipmentInfo.getTotalExtraNonFund().bigDecimalValue());
            }
            equipment.setTotalFundForAttachedEquipment(totalFundForExtraEquipment);
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (equipmentInfo.getTotalFund() != null) {
                summary.setFederalSummary(equipmentInfo.getTotalFund().bigDecimalValue());
            }
            if (equipmentInfo.getTotalNonFund() != null) {
                summary.setNonFederalSummary(equipmentInfo.getTotalNonFund().bigDecimalValue());
                if (equipmentInfo.getTotalFund() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)equipmentInfo.getTotalFund().add(equipmentInfo.getTotalNonFund())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(equipmentInfo.getTotalNonFund().bigDecimalValue());
                }
            }
            equipment.setTotalFund(summary);
        }
        Narrative narrative = this.saveExtraEquipment(periodInfo);
        AttachedFileDataType attachedFileDataType = null;
        if (narrative != null && (attachedFileDataType = this.getAttachedFileType(narrative)) != null) {
            equipment.setAdditionalEquipmentsAttachment(attachedFileDataType);
        }
        return equipment;
    }

    private Narrative saveExtraEquipment(BudgetPeriodInfo periodInfo) {
        Narrative narrative = null;
        List<CostInfo> extraEquipmentList = periodInfo.getEquipment().get(0).getExtraEquipmentList();
        if (extraEquipmentList.size() > 0) {
            AdditionalEquipmentListDocument.AdditionalEquipmentList additionalEquipmentList = AdditionalEquipmentListDocument.AdditionalEquipmentList.Factory.newInstance();
            additionalEquipmentList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            additionalEquipmentList.setBudgetPeriod(new BigInteger(Integer.toString(periodInfo.getBudgetPeriod())));
            additionalEquipmentList.setEquipmentListArray(this.getEquipmentListArray(extraEquipmentList));
            AdditionalEquipmentListDocument additionalEquipmentDoc = AdditionalEquipmentListDocument.Factory.newInstance();
            additionalEquipmentDoc.setAdditionalEquipmentList(additionalEquipmentList);
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream("/org/kuali/kra/s2s/stylesheet/AdditionalEquipmentAttachmentNonFed.xsl"));
            HashMap<String, Source> xSLTemplateWithBookmarks = new HashMap<String, Source>();
            xSLTemplateWithBookmarks.put("", xsltSource);
            String xmlData = additionalEquipmentDoc.xmlText();
            HashMap<String, byte[]> streamMap = new HashMap<String, byte[]>();
            streamMap.put("", xmlData.getBytes());
            GenericPrintable printable = new GenericPrintable();
            printable.setXSLTemplateWithBookmarks(xSLTemplateWithBookmarks);
            printable.setStreamMap(streamMap);
            PrintingService printingService = KraServiceLocator.getService(PrintingService.class);
            try {
                AttachmentDataSource printData = printingService.print(printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_ADDITIONAL_EQUIPMENT.pdf";
                narrative = this.saveNarrative(printData.getContent(), ADDITIONAL_EQUIPMENT_NARRATIVE_TYPE_CODE, fileName, ADDITIONAL_EQUIPMENT_NARRATIVE_COMMENT);
            }
            catch (PrintingException e) {
                e.printStackTrace();
            }
        }
        return narrative;
    }

    private AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[] getEquipmentListArray(List<CostInfo> extraEquipmentArrayList) {
        ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList> additionalEquipmentListList = new ArrayList<AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList>();
        AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList equipmentList = null;
        for (CostInfo costInfo : extraEquipmentArrayList) {
            equipmentList = AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList.Factory.newInstance();
            equipmentList.setFundsRequested(costInfo.getCost().bigDecimalValue());
            equipmentList.setNonFederal(costInfo.getCostSharing().bigDecimalValue());
            equipmentList.setTotalFedNonFed(((BudgetDecimal)costInfo.getCost().add(costInfo.getCostSharing())).bigDecimalValue());
            equipmentList.setEquipmentItem(costInfo.getDescription() != null ? costInfo.getDescription() : costInfo.getCategory());
            additionalEquipmentListList.add(equipmentList);
        }
        return additionalEquipmentListList.toArray(new AdditionalEquipmentListDocument.AdditionalEquipmentList.EquipmentList[0]);
    }

    private Narrative saveExtraKeyPersons(BudgetPeriodInfo periodInfo) {
        Narrative extraKPNarrative = null;
        if (periodInfo.getExtraKeyPersons() != null && !periodInfo.getExtraKeyPersons().isEmpty()) {
            ExtraKeyPersonListDocument extraKeyPersonListDocument = ExtraKeyPersonListDocument.Factory.newInstance();
            ExtraKeyPersonListDocument.ExtraKeyPersonList extraKeyPersonList = ExtraKeyPersonListDocument.ExtraKeyPersonList.Factory.newInstance();
            extraKeyPersonList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            extraKeyPersonList.setBudgetPeriod(new BigInteger("" + periodInfo.getBudgetPeriod()));
            extraKeyPersonList.setKeyPersonsArray(this.getExtraKeyPersons(periodInfo.getExtraKeyPersons()));
            extraKeyPersonListDocument.setExtraKeyPersonList(extraKeyPersonList);
            String xmlData = extraKeyPersonListDocument.xmlText();
            HashMap<String, byte[]> streamMap = new HashMap<String, byte[]>();
            streamMap.put("", xmlData.getBytes());
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream(EXTRA_KEYPERSON_ATTACHMENT_NON_FED_XSL));
            HashMap<String, Source> xSLTemplateWithBookmarks = new HashMap<String, Source>();
            xSLTemplateWithBookmarks.put("", xsltSource);
            GenericPrintable printable = new GenericPrintable();
            printable.setXSLTemplateWithBookmarks(xSLTemplateWithBookmarks);
            printable.setStreamMap(streamMap);
            PrintingService printingService = KraServiceLocator.getService(PrintingService.class);
            try {
                AttachmentDataSource printData = printingService.print(printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_" + periodInfo.getBudgetPeriod() + "_" + "RRFEDNONFED_EXTRA_KEYPERSONS" + ".pdf";
                extraKPNarrative = this.saveNarrative(printData.getContent(), "11", fileName, "RRFEDNONFED_EXTRA_KEYPERSONS");
            }
            catch (PrintingException e) {
                e.printStackTrace();
            }
        }
        return extraKPNarrative;
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[] getExtraKeyPersons(List<KeyPersonInfo> keyPersonList) {
        ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons> keypersonslist = new ArrayList<ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons>();
        for (KeyPersonInfo keyPersonInfo : keyPersonList) {
            ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons keyPerson = ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Factory.newInstance();
            keyPerson.setFirstName(keyPersonInfo.getFirstName());
            keyPerson.setMiddleName(keyPersonInfo.getMiddleName());
            keyPerson.setLastName(keyPersonInfo.getLastName());
            keyPerson.setProjectRole(keyPersonInfo.getRole());
            keyPerson.setCompensation(this.getExtraKeyPersonCompensation(keyPersonInfo));
            keypersonslist.add(keyPerson);
        }
        return keypersonslist.toArray(new ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons[0]);
    }

    private ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation getExtraKeyPersonCompensation(KeyPersonInfo keyPersonInfo) {
        ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation compensation = ExtraKeyPersonListDocument.ExtraKeyPersonList.KeyPersons.Compensation.Factory.newInstance();
        compensation.setAcademicMonths(keyPersonInfo.getAcademicMonths().bigDecimalValue());
        compensation.setCalendarMonths(keyPersonInfo.getCalendarMonths().bigDecimalValue());
        compensation.setSummerMonths(keyPersonInfo.getSummerMonths().bigDecimalValue());
        compensation.setBaseSalary(keyPersonInfo.getBaseSalary().bigDecimalValue());
        compensation.setFringeBenefits(((BudgetDecimal)keyPersonInfo.getFringe().add(keyPersonInfo.getFringeCostSharing())).bigDecimalValue());
        compensation.setFundsRequested(keyPersonInfo.getFundsRequested().bigDecimalValue());
        compensation.setRequestedSalary(((BudgetDecimal)keyPersonInfo.getRequestedSalary().add(keyPersonInfo.getCostSharingAmount())).bigDecimalValue());
        compensation.setNonFederal(keyPersonInfo.getNonFundsRequested().bigDecimalValue());
        if (keyPersonInfo.getFundsRequested() != null) {
            compensation.setTotalFedNonFed(((BudgetDecimal)keyPersonInfo.getFundsRequested().add(keyPersonInfo.getNonFundsRequested())).bigDecimalValue());
        } else {
            compensation.setTotalFedNonFed(keyPersonInfo.getNonFundsRequested().bigDecimalValue());
        }
        return compensation;
    }

    private BudgetYearDataType.Travel getTravel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.Travel travel = BudgetYearDataType.Travel.Factory.newInstance();
        if (periodInfo != null) {
            TotalDataType total = TotalDataType.Factory.newInstance();
            if (periodInfo.getDomesticTravelCost() != null) {
                total.setFederal(periodInfo.getDomesticTravelCost().bigDecimalValue());
            }
            if (periodInfo.getDomesticTravelCostSharing() != null) {
                total.setNonFederal(periodInfo.getDomesticTravelCostSharing().bigDecimalValue());
                if (periodInfo.getDomesticTravelCost() != null) {
                    total.setTotalFedNonFed(((BudgetDecimal)periodInfo.getDomesticTravelCost().add(periodInfo.getDomesticTravelCostSharing())).bigDecimalValue());
                } else {
                    total.setTotalFedNonFed(periodInfo.getDomesticTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setDomesticTravelCost(total);
            TotalDataType totalForeign = TotalDataType.Factory.newInstance();
            if (periodInfo.getForeignTravelCost() != null) {
                totalForeign.setFederal(periodInfo.getForeignTravelCost().bigDecimalValue());
            }
            if (periodInfo.getForeignTravelCostSharing() != null) {
                totalForeign.setNonFederal(periodInfo.getForeignTravelCostSharing().bigDecimalValue());
                if (periodInfo.getForeignTravelCost() != null) {
                    totalForeign.setTotalFedNonFed(((BudgetDecimal)periodInfo.getForeignTravelCost().add(periodInfo.getForeignTravelCostSharing())).bigDecimalValue());
                } else {
                    totalForeign.setTotalFedNonFed(periodInfo.getForeignTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setForeignTravelCost(totalForeign);
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalTravelCost() != null) {
                summary.setFederalSummary(periodInfo.getTotalTravelCost().bigDecimalValue());
            }
            if (periodInfo.getTotalTravelCostSharing() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalTravelCostSharing().bigDecimalValue());
                if (periodInfo.getTotalTravelCost() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalTravelCost().add(periodInfo.getTotalTravelCostSharing())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalTravelCostSharing().bigDecimalValue());
                }
            }
            travel.setTotalTravelCost(summary);
        }
        return travel;
    }

    private BudgetYearDataType.OtherPersonnel getOtherPersonnel(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.OtherPersonnel otherPersonnel = BudgetYearDataType.OtherPersonnel.Factory.newInstance();
        int OtherpersonalCount = 0;
        ArrayList<OtherPersonnelDataType> otherPersonnelList = new ArrayList<OtherPersonnelDataType>();
        OtherPersonnelDataType[] otherPersonnelDataTypeArray = new OtherPersonnelDataType[1];
        if (periodInfo != null) {
            if (periodInfo.getOtherPersonnel() != null) {
                for (OtherPersonnelInfo otherPersonnelInfo : periodInfo.getOtherPersonnel()) {
                    if ("PostDoc".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setPostDocAssociates(this.getPostDocAssociates(otherPersonnelInfo));
                        continue;
                    }
                    if ("Grad".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setGraduateStudents(this.getGraduateStudents(otherPersonnelInfo));
                        continue;
                    }
                    if ("UnderGrad".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setUndergraduateStudents(this.getUndergraduateStudents(otherPersonnelInfo));
                        continue;
                    }
                    if ("Sec".equals(otherPersonnelInfo.getPersonnelType())) {
                        otherPersonnel.setSecretarialClerical(this.getSecretarialClerical(otherPersonnelInfo));
                        continue;
                    }
                    if (OtherpersonalCount >= 6) continue;
                    OtherPersonnelDataType otherPersonnelDataType = OtherPersonnelDataType.Factory.newInstance();
                    otherPersonnelDataType.setNumberOfPersonnel(otherPersonnelInfo.getNumberPersonnel());
                    otherPersonnelDataType.setProjectRole(otherPersonnelInfo.getRole());
                    this.setSectBCompensationDataType(otherPersonnelDataType, otherPersonnelInfo.getCompensation());
                    otherPersonnelList.add(otherPersonnelDataType);
                    ++OtherpersonalCount;
                }
                otherPersonnelDataTypeArray = otherPersonnelList.toArray(otherPersonnelDataTypeArray);
                otherPersonnel.setOtherArray(otherPersonnelDataTypeArray);
                if (periodInfo.getOtherPersonnelTotalNumber() != null) {
                    otherPersonnel.setOtherPersonnelTotalNumber(periodInfo.getOtherPersonnelTotalNumber().intValue());
                }
            }
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                summary.setFederalSummary(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
            }
            if (periodInfo.getTotalOtherPersonnelNonFunds() != null) {
                if (this.budget.getSubmitCostSharingFlag().booleanValue()) {
                    summary.setNonFederalSummary(periodInfo.getTotalOtherPersonnelNonFunds().bigDecimalValue());
                    if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                        summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalOtherPersonnelFunds().add(periodInfo.getTotalOtherPersonnelNonFunds())).bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalOtherPersonnelNonFunds().bigDecimalValue());
                    }
                } else {
                    summary.setNonFederalSummary(BigDecimal.ZERO);
                    if (periodInfo.getTotalOtherPersonnelFunds() != null) {
                        summary.setTotalFedNonFedSummary(periodInfo.getTotalOtherPersonnelFunds().bigDecimalValue());
                    } else {
                        summary.setTotalFedNonFedSummary(BigDecimal.ZERO);
                    }
                }
            }
            otherPersonnel.setTotalOtherPersonnelFund(summary);
        }
        return otherPersonnel;
    }

    private BudgetYearDataType.OtherPersonnel.PostDocAssociates getPostDocAssociates(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.PostDocAssociates postDoc = BudgetYearDataType.OtherPersonnel.PostDocAssociates.Factory.newInstance();
        if (otherPersonnel != null) {
            postDoc.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            postDoc.setProjectRole(otherPersonnel.getRole());
            postDoc.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return postDoc;
    }

    private SectBCompensationDataType getSectBCompensationDataType(CompensationInfo compensation) {
        SectBCompensationDataType sectBCompensation = SectBCompensationDataType.Factory.newInstance();
        if (compensation != null) {
            if (compensation.getAcademicMonths() != null) {
                sectBCompensation.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
            }
            if (compensation.getCalendarMonths() != null) {
                sectBCompensation.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
            }
            if (compensation.getSummerMonths() != null) {
                sectBCompensation.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
            }
            if (compensation.getFringe() != null) {
                sectBCompensation.setFringeBenefits(compensation.getFringe().bigDecimalValue());
            }
            if (compensation.getRequestedSalary() != null) {
                sectBCompensation.setRequestedSalary(compensation.getRequestedSalary().bigDecimalValue());
            }
            TotalDataType totalDataType = TotalDataType.Factory.newInstance();
            if (compensation.getFundsRequested() != null) {
                totalDataType.setFederal(compensation.getFundsRequested().bigDecimalValue());
            }
            if (compensation.getNonFundsRequested() != null) {
                if (this.budget.getSubmitCostSharingFlag().booleanValue()) {
                    totalDataType.setNonFederal(compensation.getNonFundsRequested().bigDecimalValue());
                    if (compensation.getFundsRequested() != null && compensation.getNonFundsRequested() != null) {
                        totalDataType.setTotalFedNonFed(((BudgetDecimal)compensation.getFundsRequested().add(compensation.getNonFundsRequested())).bigDecimalValue());
                    }
                } else {
                    totalDataType.setNonFederal(BigDecimal.ZERO);
                    if (compensation.getFundsRequested() != null && compensation.getNonFundsRequested() != null) {
                        totalDataType.setTotalFedNonFed(compensation.getFundsRequested().bigDecimalValue());
                    }
                }
            }
            sectBCompensation.setOtherTotal(totalDataType);
        }
        return sectBCompensation;
    }

    private BudgetYearDataType.OtherPersonnel.GraduateStudents getGraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.GraduateStudents graduate = BudgetYearDataType.OtherPersonnel.GraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            graduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            graduate.setProjectRole(otherPersonnel.getRole());
            graduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return graduate;
    }

    private BudgetYearDataType.OtherPersonnel.UndergraduateStudents getUndergraduateStudents(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.UndergraduateStudents undergraduate = BudgetYearDataType.OtherPersonnel.UndergraduateStudents.Factory.newInstance();
        if (otherPersonnel != null) {
            undergraduate.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            undergraduate.setProjectRole(otherPersonnel.getRole());
            undergraduate.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return undergraduate;
    }

    private BudgetYearDataType.OtherPersonnel.SecretarialClerical getSecretarialClerical(OtherPersonnelInfo otherPersonnel) {
        BudgetYearDataType.OtherPersonnel.SecretarialClerical secretarial = BudgetYearDataType.OtherPersonnel.SecretarialClerical.Factory.newInstance();
        if (otherPersonnel != null) {
            secretarial.setNumberOfPersonnel(otherPersonnel.getNumberPersonnel());
            secretarial.setProjectRole(otherPersonnel.getRole());
            secretarial.setCompensation(this.getSectBCompensationDataType(otherPersonnel.getCompensation()));
        }
        return secretarial;
    }

    private void setSectBCompensationDataType(OtherPersonnelDataType otherPersonnelDataType, CompensationInfo compensation) {
        if (compensation != null) {
            if (compensation.getAcademicMonths() != null) {
                otherPersonnelDataType.setAcademicMonths(compensation.getAcademicMonths().bigDecimalValue());
            }
            if (compensation.getCalendarMonths() != null) {
                otherPersonnelDataType.setCalendarMonths(compensation.getCalendarMonths().bigDecimalValue());
            }
            if (compensation.getSummerMonths() != null) {
                otherPersonnelDataType.setSummerMonths(compensation.getSummerMonths().bigDecimalValue());
            }
            if (compensation.getFringe() != null) {
                otherPersonnelDataType.setFringeBenefits(compensation.getFringe().bigDecimalValue());
            }
            if (compensation.getRequestedSalary() != null) {
                otherPersonnelDataType.setRequestedSalary(compensation.getRequestedSalary().bigDecimalValue());
            }
            TotalDataType totalDataType = TotalDataType.Factory.newInstance();
            if (compensation.getFundsRequested() != null) {
                totalDataType.setFederal(compensation.getFundsRequested().bigDecimalValue());
            }
            if (compensation.getNonFundsRequested() != null) {
                if (this.budget.getSubmitCostSharingFlag().booleanValue()) {
                    totalDataType.setNonFederal(compensation.getNonFundsRequested().bigDecimalValue());
                    if (compensation.getFundsRequested() != null && compensation.getNonFundsRequested() != null) {
                        totalDataType.setTotalFedNonFed(((BudgetDecimal)compensation.getFundsRequested().add(compensation.getNonFundsRequested())).bigDecimalValue());
                    }
                } else {
                    totalDataType.setNonFederal(BigDecimal.ZERO);
                    if (compensation.getFundsRequested() != null && compensation.getNonFundsRequested() != null) {
                        totalDataType.setTotalFedNonFed(compensation.getFundsRequested().bigDecimalValue());
                    }
                }
            }
            otherPersonnelDataType.setOtherTotal(totalDataType);
        }
    }

    private BudgetYearDataType.KeyPersons getKeyPersons(BudgetPeriodInfo periodInfo) {
        BudgetYearDataType.KeyPersons keyPersons = BudgetYearDataType.KeyPersons.Factory.newInstance();
        if (periodInfo != null) {
            if (periodInfo.getKeyPersons() != null) {
                ArrayList<KeyPersonDataType> keyPersonList = new ArrayList<KeyPersonDataType>();
                int keyPersonCount = 0;
                for (KeyPersonInfo keyPerson : periodInfo.getKeyPersons()) {
                    if (!keyPerson.getRole().equals("PD/PI") && !this.hasPersonnelBudget(keyPerson, periodInfo.getBudgetPeriod()).booleanValue()) continue;
                    KeyPersonDataType keyPersonDataType = KeyPersonDataType.Factory.newInstance();
                    keyPersonDataType.setName(this.globLibV20Generator.getHumanNameDataType(keyPerson));
                    if (keyPerson.getKeyPersonRole() != null) {
                        keyPersonDataType.setProjectRole(keyPerson.getKeyPersonRole());
                    } else {
                        keyPersonDataType.setProjectRole(keyPerson.getRole());
                    }
                    keyPersonDataType.setCompensation(this.getCompensation(keyPerson, periodInfo.getBudgetPeriod()));
                    keyPersonList.add(keyPersonDataType);
                    LOG.info((Object)("keyPersonCount:" + ++keyPersonCount));
                }
                keyPersons.setKeyPersonArray(keyPersonList.toArray(new KeyPersonDataType[0]));
            }
            SummaryDataType summary = SummaryDataType.Factory.newInstance();
            if (periodInfo.getTotalFundsKeyPersons() != null) {
                summary.setFederalSummary(periodInfo.getTotalFundsKeyPersons().bigDecimalValue());
            }
            if (periodInfo.getTotalNonFundsKeyPersons() != null) {
                summary.setNonFederalSummary(periodInfo.getTotalNonFundsKeyPersons().bigDecimalValue());
                if (periodInfo.getTotalFundsKeyPersons() != null) {
                    summary.setTotalFedNonFedSummary(((BudgetDecimal)periodInfo.getTotalFundsKeyPersons().add(periodInfo.getTotalNonFundsKeyPersons())).bigDecimalValue());
                } else {
                    summary.setTotalFedNonFedSummary(periodInfo.getTotalNonFundsKeyPersons().bigDecimalValue());
                }
            }
            keyPersons.setTotalFundForKeyPersons(summary);
            SummaryDataType summaryAttachedKey = SummaryDataType.Factory.newInstance();
            BigDecimal totalFederalSummary = BigDecimal.ZERO;
            BigDecimal totalNonFederalSummary = BigDecimal.ZERO;
            for (KeyPersonInfo keyPersonInfo : periodInfo.getExtraKeyPersons()) {
                totalFederalSummary = totalFederalSummary.add(keyPersonInfo.getFundsRequested().bigDecimalValue());
                totalNonFederalSummary = totalNonFederalSummary.add(keyPersonInfo.getNonFundsRequested().bigDecimalValue());
            }
            summaryAttachedKey.setFederalSummary(totalFederalSummary);
            summaryAttachedKey.setNonFederalSummary(totalNonFederalSummary);
            summaryAttachedKey.setTotalFedNonFedSummary(totalFederalSummary.add(totalNonFederalSummary));
            keyPersons.setTotalFundForAttachedKeyPersons(summaryAttachedKey);
        }
        Narrative extraKeyPersonNarr = this.saveExtraKeyPersons(periodInfo);
        AttachedFileDataType attachedFileDataType = null;
        if (extraKeyPersonNarr != null && (attachedFileDataType = this.getAttachedFileType(extraKeyPersonNarr)) != null) {
            keyPersons.setAttachedKeyPersons(attachedFileDataType);
        }
        return keyPersons;
    }

    private KeyPersonCompensationDataType getCompensation(KeyPersonInfo keyPerson, int budgetPeriod) {
        KeyPersonCompensationDataType keyPersonCompensation = KeyPersonCompensationDataType.Factory.newInstance();
        BudgetService budgetService = KraServiceLocator.getService(BudgetService.class);
        if (keyPerson != null) {
            if (keyPerson.getAcademicMonths() != null) {
                keyPersonCompensation.setAcademicMonths(keyPerson.getAcademicMonths().bigDecimalValue());
            }
            if (keyPerson.getCalendarMonths() != null) {
                keyPersonCompensation.setCalendarMonths(keyPerson.getCalendarMonths().bigDecimalValue());
            }
            if (keyPerson.getSummerMonths() != null) {
                keyPersonCompensation.setSummerMonths(keyPerson.getSummerMonths().bigDecimalValue());
            }
            if (keyPerson.getFringe() != null) {
                keyPersonCompensation.setFringeBenefits(keyPerson.getFringe().bigDecimalValue());
            }
            if (keyPerson.getRequestedSalary() != null) {
                keyPersonCompensation.setRequestedSalary(keyPerson.getRequestedSalary().bigDecimalValue());
            }
            TotalDataType totalDataType = TotalDataType.Factory.newInstance();
            if (keyPerson.getFundsRequested() != null) {
                totalDataType.setFederal(keyPerson.getFundsRequested().bigDecimalValue());
            }
            if (keyPerson.getNonFundsRequested() != null) {
                totalDataType.setNonFederal(keyPerson.getNonFundsRequested().bigDecimalValue());
            }
            if (keyPerson.getFundsRequested() != null && keyPerson.getNonFundsRequested() != null) {
                totalDataType.setTotalFedNonFed(((BudgetDecimal)keyPerson.getFundsRequested().add(keyPerson.getNonFundsRequested())).bigDecimalValue());
            }
            keyPersonCompensation.setTotal(totalDataType);
            if (this.pdDoc.getBudgetDocumentVersions() != null) {
                BudgetDecimal baseSalaryByPeriod = budgetService.getBaseSalaryByPeriod(this.pdDoc.getBudgetDocumentVersion(0).getBudgetVersionOverview().getBudgetId(), budgetPeriod, keyPerson);
                if (baseSalaryByPeriod != null) {
                    keyPersonCompensation.setBaseSalary(baseSalaryByPeriod.bigDecimalValue());
                } else if (keyPerson.getBaseSalary() != null) {
                    keyPersonCompensation.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
                }
            } else if (keyPerson.getBaseSalary() != null) {
                keyPersonCompensation.setBaseSalary(keyPerson.getBaseSalary().bigDecimalValue());
            }
        }
        return keyPersonCompensation;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getRRFedNonFedBudget();
    }
}

