/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import gov.grants.apply.coeus.personProfile.PersonProfileListDocument;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.GenericPrintable;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonBiography;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.rice.core.api.datetime.DateTimeService;

public abstract class RRKeyPersonBase
extends S2SBaseFormGenerator {
    private static final Log LOG = LogFactory.getLog(RRKeyPersonBase.class);
    protected List<ProposalPerson> extraPersons = null;
    protected static final int BIOSKETCH_DOC_TYPE = 16;
    protected static final int CURRENTPENDING_DOC_TYPE = 17;
    protected static final String BIOSKETCH_TYPE = "1";
    protected static final String CURRENT_PENDING_TYPE = "2";
    private int WHITESPACE_LENGTH_76 = 76;
    private int WHITESPACE_LENGTH_60 = 60;
    private static final String COMMENT = "Auto generated document for ";
    private static final String BIOSKETCH_COMMENT = "BIOSKETCH";
    private static final String CURRENT_PENDING_COMMENT = "CURRENTPENDING";
    protected static final String PROFILE_COMMENT = "PROFILE";
    protected static final int PROFILE_TYPE = 18;
    protected static final String ADDITIONALKEYPERSONPROFILES_XSL = "/org/kuali/kra/s2s/stylesheet/additionalkeypersonprofiles.xsl";
    protected static final String NIH_CO_INVESTIGATOR = "Co-Investigator";

    protected void saveKeyPersonAttachmentsToProposal() {
        if (this.extraPersons != null && !this.extraPersons.isEmpty()) {
            this.saveKeyPersonAttachments();
            this.saveKeypersonProfileObject();
        }
    }

    private Narrative[] saveKeyPersonAttachments() {
        ArrayList<String> bioSketchBookMarks = new ArrayList<String>();
        ArrayList<String> curPendBookMarks = new ArrayList<String>();
        ArrayList<byte[]> bioSketchDataList = new ArrayList<byte[]>();
        ArrayList<byte[]> curPendDataList = new ArrayList<byte[]>();
        Narrative[] extraKeyPersonAttachments = new Narrative[2];
        for (ProposalPerson proposalPerson : this.extraPersons) {
            this.setBookMarkAndData(bioSketchBookMarks, bioSketchDataList, proposalPerson, BIOSKETCH_TYPE);
            this.setBookMarkAndData(curPendBookMarks, curPendDataList, proposalPerson, CURRENT_PENDING_TYPE);
        }
        byte[] bioSketchData = null;
        byte[] curPendData = null;
        try {
            bioSketchData = this.mergePdfBytes(bioSketchDataList, bioSketchBookMarks);
            curPendData = this.mergePdfBytes(curPendDataList, curPendBookMarks);
            String fileName = null;
            if (bioSketchData != null && bioSketchData.length > 0) {
                fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_" + BIOSKETCH_COMMENT + ".pdf";
                extraKeyPersonAttachments[0] = this.saveNarrative(bioSketchData, "16", fileName, "Auto generated document for BIOSKETCH");
            }
            if (curPendData != null && curPendData.length > 0) {
                fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_" + CURRENT_PENDING_COMMENT + ".pdf";
                extraKeyPersonAttachments[1] = this.saveNarrative(curPendData, "17", fileName, "Auto generated document for CURRENTPENDING");
            }
        }
        catch (PrintingException e) {
            LOG.error((Object)"Auto generation of Biosketch/Currend Pending report for extra Keypersons is failed", (Throwable)e);
        }
        return extraKeyPersonAttachments;
    }

    private void setBookMarkAndData(List<String> bookMarksList, List<byte[]> dataList, ProposalPerson proposalPerson, String docType) {
        String personId = null;
        personId = proposalPerson.getPersonId() != null && proposalPerson.getPersonId().length() > 0 ? proposalPerson.getPersonId() : "" + proposalPerson.getRolodexId();
        for (ProposalPersonBiography personBiography : this.getPernonnelAttachments(this.pdDoc, proposalPerson, docType)) {
            personBiography.refreshReferenceObject("personnelAttachmentList");
            byte[] content = personBiography.getPersonnelAttachmentList().get(0).getContent();
            if (content == null || content.length <= 0) continue;
            dataList.add(content);
            bookMarksList.add(personId);
        }
    }

    private byte[] mergePdfBytes(List<byte[]> pdfBytesList, List<String> bookmarksList) throws PrintingException {
        Document document = null;
        PdfWriter writer = null;
        ByteArrayOutputStream mergedPdfReport = new ByteArrayOutputStream();
        int totalNumOfPages = 0;
        PdfReader[] pdfReaderArr = new PdfReader[pdfBytesList.size()];
        int pdfReaderCount = 0;
        for (byte[] fileBytes : pdfBytesList) {
            LOG.debug((Object)("File Size " + fileBytes.length + " For " + bookmarksList.get(pdfReaderCount)));
            PdfReader reader = null;
            try {
                pdfReaderArr[pdfReaderCount] = reader = new PdfReader(fileBytes);
                ++pdfReaderCount;
                totalNumOfPages += reader.getNumberOfPages();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new PrintingException(e.getMessage(), e);
            }
        }
        DateTimeService dateTimeService = KraServiceLocator.getService(DateTimeService.class);
        Calendar calendar = dateTimeService.getCurrentCalendar();
        SimpleDateFormat dateFormat = new SimpleDateFormat("M/d/yy h:mm a");
        String dateString = dateFormat.format(calendar.getTime());
        StringBuilder footerPhStr = new StringBuilder();
        footerPhStr.append(" of ");
        footerPhStr.append(totalNumOfPages);
        footerPhStr.append(this.getWhitespaceString(this.WHITESPACE_LENGTH_76));
        footerPhStr.append(this.getWhitespaceString(this.WHITESPACE_LENGTH_76));
        footerPhStr.append(this.getWhitespaceString(this.WHITESPACE_LENGTH_60));
        footerPhStr.append(dateString);
        Font font = FontFactory.getFont((String)"Times", (float)8.0f, (int)0, (Color)Color.BLACK);
        Phrase beforePhrase = new Phrase("Page ", font);
        Phrase afterPhrase = new Phrase(footerPhStr.toString(), font);
        HeaderFooter footer = new HeaderFooter(beforePhrase, afterPhrase);
        footer.setAlignment(7);
        footer.setBorderWidth(0.0f);
        for (int count = 0; count < pdfReaderArr.length; ++count) {
            PdfReader reader = pdfReaderArr[count];
            if (reader == null) {
                LOG.debug((Object)("Empty PDF byetes found for " + bookmarksList.get(count)));
                continue;
            }
            int nop = reader.getNumberOfPages();
            if (count == 0) {
                document = nop > 0 ? new Document(reader.getPageSizeWithRotation(1)) : new Document();
                try {
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)mergedPdfReport);
                }
                catch (DocumentException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                    throw new PrintingException(e.getMessage(), e);
                }
                document.setFooter(footer);
                document.open();
            }
            PdfContentByte cb = writer.getDirectContent();
            int pageCount = 0;
            while (pageCount < nop) {
                document.setPageSize(reader.getPageSize(++pageCount));
                document.newPage();
                document.setFooter(footer);
                PdfImportedPage page = writer.getImportedPage(reader, pageCount);
                cb.addTemplate((PdfTemplate)page, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                PdfOutline root = cb.getRootOutline();
                if (pageCount != 1) continue;
                String pageName = bookmarksList.get(count);
                cb.addOutline(new PdfOutline(root, new PdfDestination(2), pageName), pageName);
            }
        }
        if (document != null) {
            try {
                document.close();
                return mergedPdfReport.toByteArray();
            }
            catch (Exception e) {
                LOG.error((Object)"Exception occured because the generated PDF document has no pages", (Throwable)e);
            }
        }
        return null;
    }

    private List<ProposalPersonBiography> getPernonnelAttachments(ProposalDevelopmentDocument pdDoc, ProposalPerson proposalPerson, String documentType) {
        ArrayList<ProposalPersonBiography> result = new ArrayList<ProposalPersonBiography>();
        for (ProposalPersonBiography proposalPersonBiography : pdDoc.getDevelopmentProposal().getPropPersonBios()) {
            String personId = proposalPerson.getPersonId();
            Integer rolodexId = proposalPerson.getRolodexId();
            if (personId != null && proposalPersonBiography.getPersonId() != null && proposalPersonBiography.getPersonId().equals(personId) && documentType.equals(proposalPersonBiography.getDocumentTypeCode())) {
                result.add(proposalPersonBiography);
                continue;
            }
            if (rolodexId == null || proposalPersonBiography.getRolodexId() == null || !proposalPersonBiography.getRolodexId().toString().equals(rolodexId.toString()) || !documentType.equals(proposalPersonBiography.getDocumentTypeCode())) continue;
            result.add(proposalPersonBiography);
        }
        return result;
    }

    private String getWhitespaceString(int length) {
        StringBuffer sb = new StringBuffer();
        char[] whiteSpace = new char[length];
        Arrays.fill(whiteSpace, ' ');
        sb.append(whiteSpace);
        return sb.toString();
    }

    protected PersonProfileListDocument.PersonProfileList.ExtraKeyPerson[] getExtraKeyPersons() {
        ArrayList<PersonProfileListDocument.PersonProfileList.ExtraKeyPerson> extraPersonList = new ArrayList<PersonProfileListDocument.PersonProfileList.ExtraKeyPerson>();
        for (ProposalPerson proposalPerson : this.extraPersons) {
            AttachedFileDataType curPendingAttachment;
            AttachedFileDataType bioSketchAttachment;
            PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson = PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Factory.newInstance();
            extraPerson.setName(this.getExtraPersonName(proposalPerson));
            extraPerson.setAddress(this.getExtraPersonAddress(proposalPerson));
            if (proposalPerson.getPrimaryTitle() != null && proposalPerson.getPrimaryTitle().length() > 45) {
                extraPerson.setTitle(proposalPerson.getPrimaryTitle().substring(0, 45));
            } else {
                extraPerson.setTitle(proposalPerson.getPrimaryTitle());
            }
            if (proposalPerson.getRole() != null) {
                if ("PI".equals(proposalPerson.getProjectRole())) {
                    extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.PD_PI);
                } else if ("COI".equals(proposalPerson.getRole())) {
                    if (this.isSponsorNIH(this.pdDoc)) {
                        extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.OTHER_SPECIFY);
                        extraPerson.setOtherProjectRoleCategory(NIH_CO_INVESTIGATOR);
                    } else {
                        extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.CO_PD_PI);
                    }
                } else {
                    String otherRole = "";
                    otherRole = proposalPerson.getProjectRole() != null && proposalPerson.getProjectRole().length() > 40 ? proposalPerson.getProjectRole().substring(0, 40) : proposalPerson.getProjectRole();
                    extraPerson.setOtherProjectRoleCategory(otherRole);
                    extraPerson.setProjectRole(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.ProjectRole.OTHER_SPECIFY);
                }
            }
            if (proposalPerson.getEraCommonsUserName() != null) {
                extraPerson.setCredential(proposalPerson.getEraCommonsUserName());
            }
            this.setDepartmentName(extraPerson, proposalPerson);
            this.setDivisionName(extraPerson, proposalPerson);
            if (proposalPerson.getEmailAddress() != null) {
                extraPerson.setEmail(proposalPerson.getEmailAddress());
            }
            if (proposalPerson.getFaxNumber() != null) {
                extraPerson.setFax(proposalPerson.getFaxNumber());
            }
            if (proposalPerson.getUnit() != null && proposalPerson.getOrganization() != null) {
                extraPerson.setOrganizationName(proposalPerson.getOrganization());
            }
            if (proposalPerson.getPhoneNumber() != null) {
                extraPerson.setPhone(proposalPerson.getPhoneNumber());
            }
            if (proposalPerson.getDegree() != null) {
                extraPerson.setDegreeType(proposalPerson.getDegree());
            }
            if (proposalPerson.getYearGraduated() != null) {
                extraPerson.setDegreeYear(proposalPerson.getYearGraduated());
            }
            if ((bioSketchAttachment = this.getPernonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), "16")) != null) {
                extraPerson.setBioSketchAttached(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.BioSketchAttached.YES);
            }
            if ((curPendingAttachment = this.getPernonnelAttachments(this.pdDoc, proposalPerson.getPersonId(), proposalPerson.getRolodexId(), "16")) != null) {
                extraPerson.setSupportsAttached(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.SupportsAttached.YES);
            }
            extraPersonList.add(extraPerson);
        }
        return extraPersonList.toArray(new PersonProfileListDocument.PersonProfileList.ExtraKeyPerson[0]);
    }

    private PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address getExtraPersonAddress(ProposalPerson proposalPerson) {
        PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address address = PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Factory.newInstance();
        if (proposalPerson.getAddressLine1() != null) {
            if (proposalPerson.getAddressLine1().length() > 55) {
                address.setStreet1(proposalPerson.getAddressLine1().substring(0, 55));
            } else {
                address.setStreet1(proposalPerson.getAddressLine1());
            }
        }
        if (proposalPerson.getAddressLine2() != null) {
            if (proposalPerson.getAddressLine2().length() > 55) {
                address.setStreet2(proposalPerson.getAddressLine2().substring(0, 55));
            } else {
                address.setStreet2(proposalPerson.getAddressLine2());
            }
        }
        if (proposalPerson.getCity() != null) {
            address.setCity(proposalPerson.getCity());
        }
        if (proposalPerson.getCounty() != null) {
            address.setCounty(proposalPerson.getCounty());
        }
        if (proposalPerson.getPostalCode() != null) {
            address.setZipCode(proposalPerson.getPostalCode());
        }
        if (proposalPerson.getCountryCode() != null) {
            PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Country.Enum county = PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Address.Country.Enum.forString((String)proposalPerson.getCountryCode());
            address.setCountry(county);
        }
        if (proposalPerson.getState() != null) {
            address.setState(proposalPerson.getState());
        }
        return address;
    }

    private PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name getExtraPersonName(ProposalPerson proposalPerson) {
        PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name name = PersonProfileListDocument.PersonProfileList.ExtraKeyPerson.Name.Factory.newInstance();
        if (proposalPerson.getFirstName() != null) {
            name.setFirstName(proposalPerson.getFirstName());
        }
        if (proposalPerson.getMiddleName() != null) {
            name.setMiddleName(proposalPerson.getMiddleName());
        }
        if (proposalPerson.getLastName() != null) {
            name.setLastName(proposalPerson.getLastName());
        }
        return name;
    }

    private void setDivisionName(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson, ProposalPerson proposalPerson) {
        String divisionName = "";
        if (divisionName != null && divisionName.length() > 29) {
            divisionName = divisionName.substring(0, 29);
        }
        extraPerson.setDivisionName(divisionName);
    }

    private void setDepartmentName(PersonProfileListDocument.PersonProfileList.ExtraKeyPerson extraPerson, ProposalPerson proposalPerson) {
        String departmentName = "";
        if (departmentName != null && departmentName.length() > 30) {
            departmentName = departmentName.substring(0, 29);
        }
        if (departmentName != null) {
            extraPerson.setDepartmentName(departmentName);
        }
    }

    private Narrative saveKeypersonProfileObject() {
        Narrative narrative = null;
        if (this.extraPersons != null && !this.extraPersons.isEmpty()) {
            PersonProfileListDocument.PersonProfileList extraPersonProfileList = PersonProfileListDocument.PersonProfileList.Factory.newInstance();
            extraPersonProfileList.setProposalNumber(this.pdDoc.getDevelopmentProposal().getProposalNumber());
            extraPersonProfileList.setExtraKeyPersonArray(this.getExtraKeyPersons());
            PersonProfileListDocument extraPersonDoc = PersonProfileListDocument.Factory.newInstance();
            extraPersonDoc.setPersonProfileList(extraPersonProfileList);
            String xmlData = extraPersonDoc.xmlText();
            HashMap<String, byte[]> streamMap = new HashMap<String, byte[]>();
            streamMap.put("", xmlData.getBytes());
            StreamSource xsltSource = new StreamSource(this.getClass().getResourceAsStream(ADDITIONALKEYPERSONPROFILES_XSL));
            HashMap<String, Source> xSLTemplateWithBookmarks = new HashMap<String, Source>();
            xSLTemplateWithBookmarks.put("", xsltSource);
            GenericPrintable printable = new GenericPrintable();
            printable.setXSLTemplateWithBookmarks(xSLTemplateWithBookmarks);
            printable.setStreamMap(streamMap);
            PrintingService printingService = KraServiceLocator.getService(PrintingService.class);
            try {
                AttachmentDataSource printData = printingService.print(printable);
                String fileName = this.pdDoc.getDevelopmentProposal().getProposalNumber() + "_" + PROFILE_COMMENT + ".pdf";
                narrative = this.saveNarrative(printData.getContent(), "18", fileName, "Auto generated document for PROFILE");
            }
            catch (PrintingException e) {
                LOG.error((Object)"Auto generation of Profile attachment for extra Keypersons failed", (Throwable)e);
            }
        }
        return narrative;
    }
}

