/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrsf424SF424BV11.AssuranceType;
import gov.grants.apply.forms.rrsf424SF424BV11.AssurancesDocument;
import gov.grants.apply.forms.rrsf424SF424BV11.AuthorizedRepresentativeDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.S2SBaseFormGenerator;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.rice.core.api.datetime.DateTimeService;

public class RRSF424BV1_1Generator
extends S2SBaseFormGenerator {
    private static final String NON_CONSTRUCTION = "Non-Construction";

    public AssurancesDocument getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) throws S2SException {
        AssurancesDocument assurcesDocument = AssurancesDocument.Factory.newInstance();
        DevelopmentProposal propDevFormBean = proposalDevelopmentDocument.getDevelopmentProposal();
        AssuranceType rrSF424B = assurcesDocument.addNewAssurances();
        rrSF424B.setFormVersionIdentifier("1.1");
        rrSF424B.setProgramType(NON_CONSTRUCTION);
        rrSF424B.setFormVersion("1.1");
        ProposalSite applicantOrganization = propDevFormBean.getApplicantOrganization();
        rrSF424B.setApplicantOrganizationName(applicantOrganization.getOrganization().getOrganizationName());
        rrSF424B.setAuthorizedRepresentative(this.getAuthorizedRepresentative(proposalDevelopmentDocument));
        rrSF424B.setSubmittedDate(this.getDateTimeService().getCurrentCalendar());
        return assurcesDocument;
    }

    private DateTimeService getDateTimeService() {
        return KraServiceLocator.getService(DateTimeService.class);
    }

    private AuthorizedRepresentativeDocument.AuthorizedRepresentative getAuthorizedRepresentative(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        AuthorizedRepresentativeDocument.AuthorizedRepresentative authorizedRepresentative = AuthorizedRepresentativeDocument.AuthorizedRepresentative.Factory.newInstance();
        DepartmentalPerson aorInfo = this.getS2sUtilService().getDepartmentalPerson(proposalDevelopmentDocument);
        if (aorInfo.getPrimaryTitle() != null) {
            authorizedRepresentative.setRepresentativeTitle(aorInfo.getPrimaryTitle());
        }
        return authorizedRepresentative;
    }

    private S2SUtilService getS2sUtilService() {
        return KraServiceLocator.getService(S2SUtilService.class);
    }
}

