/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrSF424V11.AORInfoType;
import gov.grants.apply.forms.rrSF424V11.ApplicationTypeCodeDataType;
import gov.grants.apply.forms.rrSF424V11.OrganizationContactPersonDataType;
import gov.grants.apply.forms.rrSF424V11.RRSF424Document;
import gov.grants.apply.forms.rrSF424V11.RevisionTypeCodeDataType;
import gov.grants.apply.forms.rrSF424V11.StateReviewCodeTypeDataType;
import gov.grants.apply.forms.rrSF424V11.SubmissionTypeDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.AddressDataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.OrganizationDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.ArgValueLookup;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.RRSF424BaseGenerator;
import org.kuali.kra.s2s.generator.impl.RRSF424V1_0Generator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class RRSF424V1_1Generator
extends RRSF424BaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRSF424V1_0Generator.class);
    private DepartmentalPerson departmentalPerson;

    private RRSF424Document getRRSF424() {
        Sponsor sponsor;
        String federalId;
        DevelopmentProposal devProp = this.pdDoc.getDevelopmentProposal();
        RRSF424Document rrSF424Document = RRSF424Document.Factory.newInstance();
        RRSF424Document.RRSF424 rrsf424 = RRSF424Document.RRSF424.Factory.newInstance();
        rrsf424.setFormVersion("1.1");
        S2sOpportunity s2sOpportunity = devProp.getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionTypeCode() != null) {
            s2sOpportunity.refreshNonUpdateableReferences();
            rrsf424.setSubmissionTypeCode(SubmissionTypeDataType.Enum.forString((String)devProp.getS2sOpportunity().getS2sSubmissionType().getDescription()));
        }
        rrsf424.setSubmittedDate(this.s2sUtilService.getCurrentCalendar());
        Organization applicantOrganization = devProp.getApplicantOrganization().getOrganization();
        if (applicantOrganization != null && applicantOrganization.getRolodex() != null) {
            String state = applicantOrganization.getRolodex().getState();
            rrsf424.setStateID(state);
        }
        if ((federalId = this.s2sUtilService.getFederalId(this.pdDoc)) != null) {
            if (federalId.length() > 30) {
                rrsf424.setFederalID(federalId.substring(0, 30));
            } else {
                rrsf424.setFederalID(federalId);
            }
        }
        rrsf424.setApplicantInfo(this.getApplicationInfo());
        rrsf424.setApplicantType(this.getApplicantType());
        rrsf424.setApplicationType(this.getApplicationType());
        if (applicantOrganization != null) {
            rrsf424.setEmployerID(applicantOrganization.getFedralEmployerId());
        }
        if ((sponsor = devProp.getSponsor()) != null) {
            rrsf424.setFederalAgencyName(sponsor.getSponsorName());
        }
        if (devProp.getCfdaNumber() != null) {
            rrsf424.setCFDANumber(devProp.getCfdaNumber());
        }
        if (devProp.getProgramAnnouncementTitle() != null) {
            String announcementTitle = devProp.getProgramAnnouncementTitle().length() > 120 ? devProp.getProgramAnnouncementTitle().substring(0, 120) : devProp.getProgramAnnouncementTitle();
            rrsf424.setActivityTitle(announcementTitle);
        }
        rrsf424.setProjectTitle(devProp.getTitle());
        if (devProp.getProposalAbstracts() != null) {
            List<ProposalAbstract> proposalAbstractList = devProp.getProposalAbstracts();
            String state = "";
            for (ProposalAbstract proposalAbstract : proposalAbstractList) {
                if (!proposalAbstract.getAbstractTypeCode().equals("16")) continue;
                state = proposalAbstract.getAbstractDetails();
            }
            rrsf424.setLocation(state);
        }
        rrsf424.setProposedProjectPeriod(this.getProjectPeriod());
        rrsf424.setCongressionalDistrict(this.getCongDistrict());
        rrsf424.setPDPIContactInfo(this.getPDPI());
        try {
            rrsf424.setEstimatedProjectFunding(this.getProjectFunding());
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return rrSF424Document;
        }
        rrsf424.setStateReview(this.getStateReview());
        rrsf424.setTrustAgree(YesNoDataType.Y_YES);
        rrsf424.setAORInfo(this.getAORInfoType());
        for (Narrative narrative : devProp.getNarratives()) {
            AttachedFileDataType attachedFileDataType = null;
            switch (Integer.parseInt(narrative.getNarrativeTypeCode())) {
                case 6: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    rrsf424.setPreApplicationAttachment(attachedFileDataType);
                    break;
                }
                case 59: {
                    attachedFileDataType = this.getAttachedFileType(narrative);
                    if (attachedFileDataType == null) break;
                    rrsf424.setAdditionalCongressionalDistricts(attachedFileDataType);
                }
            }
        }
        if (this.departmentalPerson != null) {
            rrsf424.setAORSignature(this.departmentalPerson.getFullName());
        } else {
            rrsf424.setAORSignature("");
        }
        rrsf424.setAORSignedDate(this.s2sUtilService.getCurrentCalendar());
        rrSF424Document.setRRSF424(rrsf424);
        return rrSF424Document;
    }

    private RRSF424Document.RRSF424.EstimatedProjectFunding getProjectFunding() throws S2SException {
        BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
        Budget budget = budgetDocument == null ? null : budgetDocument.getBudget();
        RRSF424Document.RRSF424.EstimatedProjectFunding funding = RRSF424Document.RRSF424.EstimatedProjectFunding.Factory.newInstance();
        funding.setTotalEstimatedAmount(BigDecimal.ZERO);
        funding.setTotalfedNonfedrequested(BigDecimal.ZERO);
        funding.setEstimatedProgramIncome(BigDecimal.ZERO);
        boolean hasBudgetLineItem = false;
        if (budget != null) {
            if (budget.getModularBudgetFlag().booleanValue()) {
                BudgetDecimal fundsRequested = BudgetDecimal.ZERO;
                BudgetDecimal totalDirectCost = BudgetDecimal.ZERO;
                BudgetDecimal totalCost = BudgetDecimal.ZERO;
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    totalDirectCost = (BudgetDecimal)totalDirectCost.add(budgetPeriod.getBudgetModular().getTotalDirectCost());
                    for (BudgetModularIdc budgetModularIdc : budgetPeriod.getBudgetModular().getBudgetModularIdcs()) {
                        fundsRequested = (BudgetDecimal)fundsRequested.add(budgetModularIdc.getFundsRequested());
                    }
                }
                totalCost = (BudgetDecimal)totalCost.add(totalDirectCost);
                totalCost = (BudgetDecimal)totalCost.add(fundsRequested);
                budget.setTotalIndirectCost(fundsRequested);
                budget.setTotalCost(totalCost);
            }
            BudgetDecimal fedNonFedCost = budget.getTotalCost();
            BigDecimal totalProjectIncome = BigDecimal.ZERO;
            BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (BudgetDecimal)costSharingAmount.add(lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (BudgetDecimal)costSharingAmount.add(budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            fedNonFedCost = (BudgetDecimal)fedNonFedCost.add(costSharingAmount);
            for (BudgetProjectIncome budgetProjectIncome : budget.getBudgetProjectIncomes()) {
                totalProjectIncome = totalProjectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            }
            funding = RRSF424Document.RRSF424.EstimatedProjectFunding.Factory.newInstance();
            funding.setTotalEstimatedAmount(budget.getTotalCost().bigDecimalValue());
            funding.setTotalfedNonfedrequested(fedNonFedCost.bigDecimalValue());
            funding.setEstimatedProgramIncome(totalProjectIncome);
        }
        return funding;
    }

    private RRSF424Document.RRSF424.ApplicantInfo getApplicationInfo() {
        RRSF424Document.RRSF424.ApplicantInfo appInfo = RRSF424Document.RRSF424.ApplicantInfo.Factory.newInstance();
        String contactType = this.getContactType();
        if (contactType.equals("I")) {
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                appInfo.setContactPersonInfo(this.getContactInfo(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex()));
            }
        } else {
            DepartmentalPerson depPerson = this.getContactPerson(this.pdDoc);
            RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo contactInfo = RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
            if (depPerson != null) {
                contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(depPerson));
                contactInfo.setPhone(depPerson.getOfficePhone());
                if (depPerson.getFaxNumber() != null) {
                    contactInfo.setFax(depPerson.getFaxNumber());
                }
                if (depPerson.getEmailAddress() != null) {
                    contactInfo.setEmail(depPerson.getEmailAddress());
                }
            }
            appInfo.setContactPersonInfo(contactInfo);
        }
        OrganizationDataType orgType = OrganizationDataType.Factory.newInstance();
        Rolodex rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getRolodex();
        orgType.setAddress(this.globLibV20Generator.getAddressDataType(rolodex));
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            orgType.setOrganizationName(organization.getOrganizationName());
            orgType.setDUNSID(organization.getDunsNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getOwnedByUnit() != null) {
            String departmentName = this.pdDoc.getDevelopmentProposal().getOwnedByUnit().getUnitName();
            if (departmentName != null && departmentName.length() > 30) {
                departmentName = departmentName.substring(0, 29);
            }
            orgType.setDepartmentName(departmentName);
            String divisionName = this.s2sUtilService.getDivisionName(this.pdDoc);
            if (divisionName != null) {
                orgType.setDivisionName(divisionName);
            }
        }
        appInfo.setOrganizationInfo(orgType);
        return appInfo;
    }

    private RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo getContactInfo(Rolodex rolodex) {
        RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo contactInfo = RRSF424Document.RRSF424.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(rolodex));
        contactInfo.setPhone("");
        if (rolodex != null) {
            contactInfo.setPhone(rolodex.getPhoneNumber());
            if (rolodex.getFaxNumber() != null) {
                contactInfo.setFax(rolodex.getFaxNumber());
            }
            if (rolodex.getEmailAddress() != null) {
                contactInfo.setEmail(rolodex.getEmailAddress());
            }
        }
        return contactInfo;
    }

    private RRSF424Document.RRSF424.StateReview getStateReview() {
        Map<String, String> eoStateReview = this.s2sUtilService.getEOStateReview(this.pdDoc);
        StateReviewCodeTypeDataType.Enum stateReviewCodeType = null;
        String strReview = eoStateReview.get("answer");
        String stateReviewData = null;
        String stateReviewDate = null;
        if ("Y".equals(strReview)) {
            stateReviewCodeType = StateReviewCodeTypeDataType.Y_YES;
            stateReviewDate = eoStateReview.get("reviewDate");
        } else if ("N".equals(strReview)) {
            stateReviewData = eoStateReview.get("stateReviewData");
            if (stateReviewData != null && "Not Covered".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
            } else if (stateReviewData != null && "Not Selected".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_HAS_NOT_BEEN_SELECTED_BY_STATE_FOR_REVIEW;
            }
        }
        RRSF424Document.RRSF424.StateReview stateReview = RRSF424Document.RRSF424.StateReview.Factory.newInstance();
        stateReview.setStateReviewCodeType(stateReviewCodeType);
        if (stateReviewDate != null) {
            stateReview.setStateReviewDate(this.s2sUtilService.convertDateStringToCalendar(stateReviewDate));
        }
        return stateReview;
    }

    private RRSF424Document.RRSF424.ApplicationType getApplicationType() {
        Collection argDescription;
        String answerExplanation;
        RRSF424Document.RRSF424.ApplicationType applicationType = RRSF424Document.RRSF424.ApplicationType.Factory.newInstance();
        Map<String, String> submissionInfo = this.s2sUtilService.getSubmissionType(this.pdDoc);
        if (this.pdDoc.getDevelopmentProposal().getProposalTypeCode() != null && Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) < 6) {
            ApplicationTypeCodeDataType.Enum applicationTypeCodeDataType = ApplicationTypeCodeDataType.Enum.forInt((int)Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()));
            applicationType.setApplicationTypeCode(applicationTypeCodeDataType);
            if (Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) == 5) {
                String revisionCode = null;
                if (submissionInfo.get("revisionCode") != null) {
                    revisionCode = submissionInfo.get("revisionCode");
                    RevisionTypeCodeDataType.Enum revisionCodeApplication = RevisionTypeCodeDataType.Enum.forString((String)revisionCode);
                    applicationType.setRevisionCode(revisionCodeApplication);
                }
                String revisionCodeOtherDesc = null;
                if (submissionInfo.get("revisionOtherDescription") != null) {
                    revisionCodeOtherDesc = submissionInfo.get("revisionOtherDescription");
                    applicationType.setRevisionCodeOtherExplanation(revisionCodeOtherDesc);
                }
            }
        }
        Object answer = null;
        String answerdetails = this.getAnswer("128");
        if (answerdetails != null && !answerdetails.equals("No")) {
            answer = answerdetails.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            applicationType.setIsOtherAgencySubmission((YesNoDataType.Enum)answer);
        } else {
            applicationType.setIsOtherAgencySubmission(null);
        }
        if (answer != null && answer.equals(YesNoDataType.Y_YES) && (answerExplanation = this.getAnswer("111")) != null && (argDescription = KraServiceLocator.getService(BusinessObjectService.class).findAll(ArgValueLookup.class)) != null) {
            for (ArgValueLookup argValue : argDescription) {
                System.out.println(argValue.getValue());
                if (!argValue.getValue().equals(answerExplanation)) continue;
                String description = argValue.getDescription();
                String submissionExplanation = description.substring(5);
                if (submissionExplanation.length() > 20) {
                    applicationType.setOtherAgencySubmissionExplanation(submissionExplanation.substring(0, 20));
                    continue;
                }
                applicationType.setOtherAgencySubmissionExplanation(submissionExplanation);
            }
        }
        return applicationType;
    }

    private RRSF424Document.RRSF424.ProposedProjectPeriod getProjectPeriod() {
        RRSF424Document.RRSF424.ProposedProjectPeriod proposedProjectPeriod = RRSF424Document.RRSF424.ProposedProjectPeriod.Factory.newInstance();
        proposedProjectPeriod.setProposedStartDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        proposedProjectPeriod.setProposedEndDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        return proposedProjectPeriod;
    }

    private RRSF424Document.RRSF424.CongressionalDistrict getCongDistrict() {
        ProposalSite applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        ProposalSite performOrganization = this.pdDoc.getDevelopmentProposal().getPerformingOrganization();
        RRSF424Document.RRSF424.CongressionalDistrict congressionalDistrict = RRSF424Document.RRSF424.CongressionalDistrict.Factory.newInstance();
        if (applicantOrganization != null) {
            congressionalDistrict.setApplicantCongressionalDistrict(applicantOrganization.getFirstCongressionalDistrictName());
        } else {
            congressionalDistrict.setApplicantCongressionalDistrict("");
        }
        if (performOrganization != null) {
            congressionalDistrict.setProjectCongressionalDistrict(performOrganization.getFirstCongressionalDistrictName());
        } else {
            congressionalDistrict.setProjectCongressionalDistrict("");
        }
        return congressionalDistrict;
    }

    private OrganizationContactPersonDataType getPDPI() {
        OrganizationContactPersonDataType PDPI2 = OrganizationContactPersonDataType.Factory.newInstance();
        ProposalPerson PI = null;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!"PI".equals(proposalPerson.getProposalPersonRoleId())) continue;
            PI = proposalPerson;
            ProposalSite applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
            PDPI2.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            PDPI2.setPhone(PI.getOfficePhone());
            PDPI2.setEmail(PI.getEmailAddress());
            if (PI.getFaxNumber() != null) {
                PDPI2.setFax(PI.getFaxNumber());
            }
            PDPI2.setAddress(this.globLibV20Generator.getAddressDataType(PI));
            if (PI.getDirectoryTitle() != null) {
                if (PI.getDirectoryTitle().length() > 45) {
                    PDPI2.setTitle(PI.getDirectoryTitle().substring(0, 45));
                } else {
                    PDPI2.setTitle(PI.getDirectoryTitle());
                }
            }
            if (PI.getHomeUnit() != null) {
                KcPersonService kcPersonService = KraServiceLocator.getService(KcPersonService.class);
                KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(PI.getPersonId());
                String departmentName = kcPersons.getOrganizationIdentifier();
                PDPI2.setDepartmentName(departmentName);
            } else {
                DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
                PDPI2.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
            }
            String divisionName = proposalPerson.getDivision();
            if (divisionName != null) {
                PDPI2.setDivisionName(divisionName);
            }
            if (applicantOrganization == null) continue;
            PDPI2.setOrganizationName(applicantOrganization.getLocationName());
        }
        return PDPI2;
    }

    private AORInfoType getAORInfoType() {
        ProposalSite applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        AORInfoType aorInfoType = AORInfoType.Factory.newInstance();
        if (this.departmentalPerson != null) {
            aorInfoType.setName(this.globLibV20Generator.getHumanNameDataType(this.departmentalPerson));
            if (this.departmentalPerson.getPrimaryTitle() != null) {
                if (this.departmentalPerson.getPrimaryTitle().length() > 45) {
                    aorInfoType.setTitle(this.departmentalPerson.getPrimaryTitle().substring(0, 45));
                } else {
                    aorInfoType.setTitle(this.departmentalPerson.getPrimaryTitle());
                }
            } else {
                aorInfoType.setTitle("");
            }
            AddressDataType address = AddressDataType.Factory.newInstance();
            address.setStreet1(this.departmentalPerson.getAddress1());
            address.setStreet2(this.departmentalPerson.getAddress2());
            address.setCity(this.departmentalPerson.getCity());
            if (this.departmentalPerson.getState() != null) {
                address.setState(this.globLibV20Generator.getStateCodeDataType(this.departmentalPerson.getCountryCode(), this.departmentalPerson.getState()));
            }
            address.setZipPostalCode(this.departmentalPerson.getPostalCode());
            if (this.departmentalPerson.getCountryCode() != null) {
                address.setCountry(this.globLibV20Generator.getCountryCodeDataType(this.departmentalPerson.getCountryCode()));
            }
            aorInfoType.setAddress(address);
            aorInfoType.setPhone(this.departmentalPerson.getOfficePhone());
            aorInfoType.setFax(this.departmentalPerson.getFaxNumber());
            aorInfoType.setDepartmentName(this.departmentalPerson.getDirDept());
            aorInfoType.setEmail(this.departmentalPerson.getEmailAddress());
            if (this.departmentalPerson.getHomeUnit() != null) {
                aorInfoType.setDivisionName(this.departmentalPerson.getHomeUnit());
            }
        }
        if (applicantOrganization != null) {
            aorInfoType.setOrganizationName(applicantOrganization.getLocationName());
        }
        return aorInfoType;
    }

    private RRSF424Document.RRSF424.ApplicantType getApplicantType() {
        RRSF424Document.RRSF424.ApplicantType applicantType = RRSF424Document.RRSF424.ApplicantType.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType smallOrganizationType = RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged isSociallyEconomicallyDisadvantaged = RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged.Factory.newInstance();
        RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned isWomenOwned = RRSF424Document.RRSF424.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned.Factory.newInstance();
        boolean smallBusflag = false;
        int orgTypeCode = 0;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().size() > 0) {
            orgTypeCode = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().get(0).getOrganizationTypeCode();
        }
        ApplicantTypeCodeDataType.Enum applicantTypeCode = null;
        switch (orgTypeCode) {
            case 1: {
                applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                break;
            }
            case 2: {
                applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                break;
            }
            case 3: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 4: {
                applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 5: {
                applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 6: {
                applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                break;
            }
            case 7: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 8: {
                applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                break;
            }
            case 9: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                break;
            }
            case 10: {
                applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 11: {
                applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                break;
            }
            case 14: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isSociallyEconomicallyDisadvantaged.setStringValue("Yes");
                smallOrganizationType.setIsSociallyEconomicallyDisadvantaged(isSociallyEconomicallyDisadvantaged);
                smallBusflag = true;
                break;
            }
            case 15: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isWomenOwned.setStringValue("Yes");
                smallOrganizationType.setIsWomenOwned(isWomenOwned);
                smallBusflag = true;
                break;
            }
            case 21: {
                applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 22: {
                applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                break;
            }
            case 23: {
                applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                break;
            }
            case 24: {
                applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                break;
            }
            case 25: {
                applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                break;
            }
            case 26: {
                applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                break;
            }
            default: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            }
        }
        if (smallBusflag) {
            applicantType.setSmallBusinessOrganizationType(smallOrganizationType);
        }
        if (orgTypeCode == 3) {
            applicantType.setApplicantTypeCodeOtherExplanation("Federal Government");
        }
        applicantType.setApplicantTypeCode(applicantTypeCode);
        return applicantType;
    }

    private ProposalYnq getAnswer(String questionId, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalYnq ynq = null;
        for (ProposalYnq proposalYnq : proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs()) {
            String question = proposalYnq.getQuestionId();
            if (question == null || !question.equals(questionId)) continue;
            ynq = proposalYnq;
            break;
        }
        return ynq;
    }

    private String getAnswer(String questionId) {
        List<Object> answerHeaders = new ArrayList();
        answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        String answer = null;
        if (answerHeaders != null && !answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : answerHeaders) {
                List<QuestionnaireQuestion> questionnaireQuestions = answerHeader.getQuestionnaire().getQuestionnaireQuestions();
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (answers.getAnswer() == null || !questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                    return answer;
                }
            }
        }
        return answer;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.departmentalPerson = this.s2sUtilService.getDepartmentalPerson(proposalDevelopmentDocument);
        return this.getRRSF424();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRSF424Document.RRSF424 rrsf424 = (RRSF424Document.RRSF424)xmlObject;
        RRSF424Document rrSF424Document = RRSF424Document.Factory.newInstance();
        rrSF424Document.setRRSF424(rrsf424);
        return rrSF424Document;
    }
}

