/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrSF42412V12.AORInfoType;
import gov.grants.apply.forms.rrSF42412V12.ApplicationTypeCodeDataType;
import gov.grants.apply.forms.rrSF42412V12.OrganizationContactPersonDataType;
import gov.grants.apply.forms.rrSF42412V12.RRSF42412Document;
import gov.grants.apply.forms.rrSF42412V12.RevisionTypeCodeDataType;
import gov.grants.apply.forms.rrSF42412V12.StateReviewCodeTypeDataType;
import gov.grants.apply.forms.rrSF42412V12.SubmissionTypeDataType;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.globalLibraryV20.AddressDataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.OrganizationDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import gov.grants.apply.system.universalCodesV20.CountryCodeDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.ArgValueLookup;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.RRSF424BaseGenerator;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class RRSF424V1_2Generator
extends RRSF424BaseGenerator {
    private static final Log LOG = LogFactory.getLog(RRSF424V1_2Generator.class);
    private DepartmentalPerson departmentalPerson;

    private RRSF42412Document getRRSF424() {
        RRSF42412Document rrSF424Document = RRSF42412Document.Factory.newInstance();
        RRSF42412Document.RRSF42412 rrsf42412 = RRSF42412Document.RRSF42412.Factory.newInstance();
        rrsf42412.setFormVersion("1.2");
        rrsf42412.setSubmittedDate(this.s2sUtilService.getCurrentCalendar());
        if (this.getSubmissionTypeCode() != null) {
            rrsf42412.setSubmissionTypeCode(SubmissionTypeDataType.Enum.forInt((int)Integer.parseInt(this.getSubmissionTypeCode())));
        }
        rrsf42412.setStateID(this.getRolodexState());
        rrsf42412.setApplicantInfo(this.getApplicationInfo());
        rrsf42412.setEmployerID(this.getEmployerId());
        rrsf42412.setApplicantType(this.getApplicantType());
        if (this.getAgencyRoutingNumber() != null) {
            rrsf42412.setAgencyRoutingNumber(this.getAgencyRoutingNumber());
        }
        rrsf42412.setApplicationType(this.getApplicationType());
        rrsf42412.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        rrsf42412.setFederalAgencyName(this.getFederalAgencyName());
        rrsf42412.setProjectTitle(this.getProjectTitle());
        rrsf42412.setProposedProjectPeriod(this.getProjectPeriod());
        rrsf42412.setCongressionalDistrict(this.getCongDistrict());
        if (this.pdDoc.getDevelopmentProposal().getCfdaNumber() != null) {
            rrsf42412.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber());
        }
        rrsf42412.setActivityTitle(this.getActivityTitle());
        this.setFederalId(rrsf42412);
        rrsf42412.setPDPIContactInfo(this.getPDPI());
        rrsf42412.setEstimatedProjectFunding(this.getProjectFunding());
        rrsf42412.setTrustAgree(YesNoDataType.Y_YES);
        rrsf42412.setStateReview(this.getStateReview());
        rrsf42412.setAORInfo(this.getAORInfoType());
        rrsf42412.setAORSignature(this.getAORSignature());
        rrsf42412.setAORSignedDate(this.s2sUtilService.getCurrentCalendar());
        this.setPreApplicationAttachment(rrsf42412);
        this.setSFLLLAttachment(rrsf42412);
        rrSF424Document.setRRSF42412(rrsf42412);
        return rrSF424Document;
    }

    private RRSF42412Document.RRSF42412.EstimatedProjectFunding getProjectFunding() {
        BudgetDocument budgetDoc = null;
        Budget budget = null;
        RRSF42412Document.RRSF42412.EstimatedProjectFunding funding = RRSF42412Document.RRSF42412.EstimatedProjectFunding.Factory.newInstance();
        funding.setTotalEstimatedAmount(BigDecimal.ZERO);
        funding.setTotalNonfedrequested(BigDecimal.ZERO);
        funding.setTotalfedNonfedrequested(BigDecimal.ZERO);
        funding.setEstimatedProgramIncome(BigDecimal.ZERO);
        boolean hasBudgetLineItem = false;
        try {
            budgetDoc = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while fetching Budget document", (Throwable)e);
            return funding;
        }
        if (budgetDoc != null) {
            budget = budgetDoc.getBudget();
        }
        if (budget != null) {
            if (budget.getModularBudgetFlag().booleanValue()) {
                BudgetDecimal fundsRequested = BudgetDecimal.ZERO;
                BudgetDecimal totalDirectCost = BudgetDecimal.ZERO;
                BudgetDecimal totalCost = BudgetDecimal.ZERO;
                for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                    totalDirectCost = (BudgetDecimal)totalDirectCost.add(budgetPeriod.getBudgetModular().getTotalDirectCost());
                    for (BudgetModularIdc budgetModularIdc : budgetPeriod.getBudgetModular().getBudgetModularIdcs()) {
                        fundsRequested = (BudgetDecimal)fundsRequested.add(budgetModularIdc.getFundsRequested());
                    }
                }
                totalCost = (BudgetDecimal)totalCost.add(totalDirectCost);
                totalCost = (BudgetDecimal)totalCost.add(fundsRequested);
                budget.setTotalIndirectCost(fundsRequested);
                budget.setTotalCost(totalCost);
            }
            BudgetDecimal fedNonFedCost = budget.getTotalCost();
            BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (BudgetDecimal)costSharingAmount.add(lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (BudgetDecimal)costSharingAmount.add(budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            fedNonFedCost = (BudgetDecimal)fedNonFedCost.add(costSharingAmount);
            funding = RRSF42412Document.RRSF42412.EstimatedProjectFunding.Factory.newInstance();
            funding.setTotalEstimatedAmount(budget.getTotalCost().bigDecimalValue());
            funding.setTotalNonfedrequested(costSharingAmount.bigDecimalValue());
            funding.setTotalfedNonfedrequested(fedNonFedCost.bigDecimalValue());
            funding.setEstimatedProgramIncome(this.getTotalProjectIncome(budget));
        }
        return funding;
    }

    private BigDecimal getTotalProjectIncome(Budget budget) {
        BigDecimal totalProjectIncome = BigDecimal.ZERO;
        for (BudgetProjectIncome budgetProjectIncome : budget.getBudgetProjectIncomes()) {
            totalProjectIncome = totalProjectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
        }
        return totalProjectIncome;
    }

    private RRSF42412Document.RRSF42412.ApplicantInfo getApplicationInfo() {
        RRSF42412Document.RRSF42412.ApplicantInfo appInfo = RRSF42412Document.RRSF42412.ApplicantInfo.Factory.newInstance();
        appInfo.setContactPersonInfo(this.getContactPersonInfo());
        appInfo.setOrganizationInfo(this.getOrganizationDataType());
        return appInfo;
    }

    private RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo getContactPersonInfo() {
        String contactType = this.getContactType();
        RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo contactInfo = RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        if (contactType.equals("I")) {
            if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
                contactInfo = this.getContactInfo(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex());
            }
        } else {
            DepartmentalPerson depPerson = this.getContactPerson(this.pdDoc);
            if (depPerson != null) {
                contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(depPerson));
                contactInfo.setPhone(depPerson.getOfficePhone());
                if (depPerson.getFaxNumber() != null) {
                    contactInfo.setFax(depPerson.getFaxNumber());
                }
                if (depPerson.getEmailAddress() != null) {
                    contactInfo.setEmail(depPerson.getEmailAddress());
                }
            }
        }
        return contactInfo;
    }

    private OrganizationDataType getOrganizationDataType() {
        OrganizationDataType orgType = OrganizationDataType.Factory.newInstance();
        Rolodex rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getRolodex();
        orgType.setAddress(this.globLibV20Generator.getAddressDataType(rolodex));
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            orgType.setOrganizationName(organization.getOrganizationName());
            orgType.setDUNSID(organization.getDunsNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getOwnedByUnit() != null) {
            String departmentName = this.pdDoc.getDevelopmentProposal().getOwnedByUnit().getUnitName();
            if (departmentName != null && departmentName.length() > 30) {
                departmentName = departmentName.substring(0, 29);
            }
            orgType.setDepartmentName(departmentName);
            String divisionName = this.s2sUtilService.getDivisionName(this.pdDoc);
            if (divisionName != null) {
                orgType.setDivisionName(divisionName);
            }
        }
        return orgType;
    }

    private RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo getContactInfo(Rolodex rolodex) {
        RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo contactInfo = RRSF42412Document.RRSF42412.ApplicantInfo.ContactPersonInfo.Factory.newInstance();
        contactInfo.setName(this.globLibV20Generator.getHumanNameDataType(rolodex));
        contactInfo.setPhone("");
        if (rolodex != null) {
            contactInfo.setPhone(rolodex.getPhoneNumber());
            if (rolodex.getFaxNumber() != null) {
                contactInfo.setFax(rolodex.getFaxNumber());
            }
            if (rolodex.getEmailAddress() != null) {
                contactInfo.setEmail(rolodex.getEmailAddress());
            }
        }
        return contactInfo;
    }

    private RRSF42412Document.RRSF42412.StateReview getStateReview() {
        RRSF42412Document.RRSF42412.StateReview stateReview = RRSF42412Document.RRSF42412.StateReview.Factory.newInstance();
        Map<String, String> eoStateReview = this.s2sUtilService.getEOStateReview(this.pdDoc);
        StateReviewCodeTypeDataType.Enum stateReviewCodeType = null;
        String strReview = eoStateReview.get("answer");
        String stateReviewData = null;
        String stateReviewDate = null;
        Calendar reviewDate = null;
        if ("Y".equals(strReview)) {
            stateReviewCodeType = StateReviewCodeTypeDataType.Y_YES;
            stateReviewDate = eoStateReview.get("reviewDate");
            reviewDate = this.s2sUtilService.convertDateStringToCalendar(stateReviewDate);
            stateReview.setStateReviewDate(reviewDate);
        } else if ("N".equals(strReview)) {
            stateReviewData = eoStateReview.get("stateReviewData");
            if (stateReviewData != null && "Not Covered".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
            } else if (stateReviewData != null && "Not Selected".equals(stateReviewData)) {
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_HAS_NOT_BEEN_SELECTED_BY_STATE_FOR_REVIEW;
            }
        }
        stateReview.setStateReviewCodeType(stateReviewCodeType);
        return stateReview;
    }

    private RRSF42412Document.RRSF42412.ApplicationType getApplicationType() {
        RRSF42412Document.RRSF42412.ApplicationType applicationType = RRSF42412Document.RRSF42412.ApplicationType.Factory.newInstance();
        Map<String, String> submissionInfo = this.s2sUtilService.getSubmissionType(this.pdDoc);
        if (this.pdDoc.getDevelopmentProposal().getProposalTypeCode() != null && Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) < 6) {
            applicationType.setApplicationTypeCode(this.getApplicationTypeCodeDataType());
            if (Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()) == 5) {
                String revisionCode = null;
                if (submissionInfo.get("revisionCode") != null) {
                    revisionCode = submissionInfo.get("revisionCode");
                    RevisionTypeCodeDataType.Enum revisionCodeApplication = RevisionTypeCodeDataType.Enum.forString((String)revisionCode);
                    applicationType.setRevisionCode(revisionCodeApplication);
                }
                String revisionCodeOtherDesc = null;
                if (submissionInfo.get("revisionOtherDescription") != null) {
                    revisionCodeOtherDesc = submissionInfo.get("revisionOtherDescription");
                    applicationType.setRevisionCodeOtherExplanation(revisionCodeOtherDesc);
                }
            }
        }
        this.setOtherAgencySubmissionDetails(applicationType);
        return applicationType;
    }

    private void setOtherAgencySubmissionDetails(RRSF42412Document.RRSF42412.ApplicationType applicationType) {
        Collection argDescription;
        String answerExplanation;
        Object answer = null;
        String answerdetails = this.getAnswer("128");
        if (answerdetails != null && !answerdetails.equals("No")) {
            answer = answerdetails.equals("Y") ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
            applicationType.setIsOtherAgencySubmission((YesNoDataType.Enum)answer);
        } else {
            applicationType.setIsOtherAgencySubmission(null);
        }
        if (answer != null && answer.equals(YesNoDataType.Y_YES) && (answerExplanation = this.getAnswer("111")) != null && (argDescription = KraServiceLocator.getService(BusinessObjectService.class).findAll(ArgValueLookup.class)) != null) {
            for (ArgValueLookup argValue : argDescription) {
                if (!argValue.getValue().equals(answerExplanation)) continue;
                String description = argValue.getDescription();
                String submissionExplanation = description.substring(5);
                if (submissionExplanation.length() > 20) {
                    applicationType.setOtherAgencySubmissionExplanation(submissionExplanation.substring(0, 20));
                    continue;
                }
                applicationType.setOtherAgencySubmissionExplanation(submissionExplanation);
            }
        }
    }

    private String getAnswer(String questionId) {
        List<Object> answerHeaders = new ArrayList();
        answerHeaders = this.getQuestionnaireAnswers(this.pdDoc.getDevelopmentProposal(), true);
        String answer = null;
        if (answerHeaders != null && !answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : answerHeaders) {
                List<QuestionnaireQuestion> questionnaireQuestions = answerHeader.getQuestionnaire().getQuestionnaireQuestions();
                List<Answer> answerDetails = answerHeader.getAnswers();
                for (Answer answers : answerDetails) {
                    if (answers.getAnswer() == null || !questionId.equals(answers.getQuestion().getQuestionId())) continue;
                    answer = answers.getAnswer();
                    return answer;
                }
            }
        }
        return answer;
    }

    private ApplicationTypeCodeDataType.Enum getApplicationTypeCodeDataType() {
        return ApplicationTypeCodeDataType.Enum.forInt((int)Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode()));
    }

    private RRSF42412Document.RRSF42412.ProposedProjectPeriod getProjectPeriod() {
        RRSF42412Document.RRSF42412.ProposedProjectPeriod proposedProjectPeriod = RRSF42412Document.RRSF42412.ProposedProjectPeriod.Factory.newInstance();
        proposedProjectPeriod.setProposedStartDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        proposedProjectPeriod.setProposedEndDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        return proposedProjectPeriod;
    }

    private RRSF42412Document.RRSF42412.CongressionalDistrict getCongDistrict() {
        ProposalSite applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        RRSF42412Document.RRSF42412.CongressionalDistrict congressionalDistrict = RRSF42412Document.RRSF42412.CongressionalDistrict.Factory.newInstance();
        if (applicantOrganization != null) {
            congressionalDistrict.setApplicantCongressionalDistrict(applicantOrganization.getFirstCongressionalDistrictName());
        } else {
            congressionalDistrict.setApplicantCongressionalDistrict("");
        }
        return congressionalDistrict;
    }

    private OrganizationContactPersonDataType getPDPI() {
        OrganizationContactPersonDataType PDPI2 = OrganizationContactPersonDataType.Factory.newInstance();
        ProposalPerson PI = null;
        for (ProposalPerson proposalPerson : this.pdDoc.getDevelopmentProposal().getProposalPersons()) {
            if (!"PI".equals(proposalPerson.getProposalPersonRoleId())) continue;
            PI = proposalPerson;
            ProposalSite applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
            PDPI2.setName(this.globLibV20Generator.getHumanNameDataType(PI));
            PDPI2.setPhone(PI.getOfficePhone());
            PDPI2.setEmail(PI.getEmailAddress());
            if (PI.getFaxNumber() != null) {
                PDPI2.setFax(PI.getFaxNumber());
            }
            PDPI2.setAddress(this.globLibV20Generator.getAddressDataType(PI));
            this.setDirectoryTitle(PDPI2, PI);
            this.setDepartmentName(PDPI2, PI);
            this.setDivisionName(PDPI2, PI);
            if (applicantOrganization == null) continue;
            PDPI2.setOrganizationName(applicantOrganization.getLocationName());
        }
        return PDPI2;
    }

    private void setDivisionName(OrganizationContactPersonDataType PDPI2, ProposalPerson PI) {
        String divisionName = PI.getDivision();
        if (divisionName != null) {
            PDPI2.setDivisionName(divisionName);
        }
    }

    private void setDepartmentName(OrganizationContactPersonDataType PDPI2, ProposalPerson PI) {
        if (PI.getHomeUnit() != null) {
            KcPersonService kcPersonService = KraServiceLocator.getService(KcPersonService.class);
            KcPerson kcPersons = kcPersonService.getKcPersonByPersonId(PI.getPersonId());
            String departmentName = kcPersons.getOrganizationIdentifier();
            PDPI2.setDepartmentName(departmentName);
        } else {
            DevelopmentProposal developmentProposal = this.pdDoc.getDevelopmentProposal();
            PDPI2.setDepartmentName(developmentProposal.getOwnedByUnit().getUnitName());
        }
    }

    private void setDirectoryTitle(OrganizationContactPersonDataType PDPI2, ProposalPerson PI) {
        if (PI.getDirectoryTitle() != null) {
            if (PI.getDirectoryTitle().length() > 45) {
                PDPI2.setTitle(PI.getDirectoryTitle().substring(0, 45));
            } else {
                PDPI2.setTitle(PI.getDirectoryTitle());
            }
        }
    }

    private AORInfoType getAORInfoType() {
        ProposalSite applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        AORInfoType aorInfoType = AORInfoType.Factory.newInstance();
        if (this.departmentalPerson != null) {
            aorInfoType.setName(this.globLibV20Generator.getHumanNameDataType(this.departmentalPerson));
            this.setTitle(aorInfoType);
            this.setAddress(aorInfoType);
            this.setDivisionName(aorInfoType);
        }
        if (applicantOrganization != null) {
            aorInfoType.setOrganizationName(applicantOrganization.getLocationName());
        }
        return aorInfoType;
    }

    private void setTitle(AORInfoType aorInfoType) {
        if (this.departmentalPerson.getPrimaryTitle() != null) {
            if (this.departmentalPerson.getPrimaryTitle().length() > 45) {
                aorInfoType.setTitle(this.departmentalPerson.getPrimaryTitle().substring(0, 45));
            } else {
                aorInfoType.setTitle(this.departmentalPerson.getPrimaryTitle());
            }
        } else {
            aorInfoType.setTitle("");
        }
    }

    private void setAddress(AORInfoType aorInfoType) {
        AddressDataType address = AddressDataType.Factory.newInstance();
        if (this.departmentalPerson.getAddress1() != null) {
            if (this.departmentalPerson.getAddress1().length() > 55) {
                address.setStreet1(this.departmentalPerson.getAddress1().substring(0, 55));
            } else {
                address.setStreet1(this.departmentalPerson.getAddress1());
            }
        }
        if (this.departmentalPerson.getAddress2() != null && this.departmentalPerson.getAddress2().length() != 0) {
            if (this.departmentalPerson.getAddress2().length() > 55) {
                address.setStreet2(this.departmentalPerson.getAddress2().substring(0, 55));
            } else {
                address.setStreet2(this.departmentalPerson.getAddress2());
            }
        }
        if (this.departmentalPerson.getCounty() != null) {
            address.setCounty(this.departmentalPerson.getCounty());
        }
        address.setCity(this.departmentalPerson.getCity());
        address.setZipPostalCode(this.departmentalPerson.getPostalCode());
        CountryCodeDataType.Enum countryCodeDataType = this.globLibV20Generator.getCountryCodeDataType(this.departmentalPerson.getCountryCode());
        address.setCountry(countryCodeDataType);
        String state = this.departmentalPerson.getState();
        if (state != null && !state.equals("") && countryCodeDataType != null) {
            if (countryCodeDataType.equals(CountryCodeDataType.USA_UNITED_STATES)) {
                address.setState(this.globLibV20Generator.getStateCodeDataType(this.departmentalPerson.getCountryCode(), this.departmentalPerson.getState()));
            } else {
                address.setProvince(state);
            }
        }
        aorInfoType.setAddress(address);
        aorInfoType.setPhone(this.departmentalPerson.getOfficePhone());
        aorInfoType.setFax(this.departmentalPerson.getFaxNumber());
        String departmentName = this.departmentalPerson.getDirDept();
        if (departmentName != null && departmentName.length() > 30) {
            departmentName = departmentName.substring(0, 29);
        }
        aorInfoType.setDepartmentName(departmentName);
        aorInfoType.setEmail(this.departmentalPerson.getEmailAddress());
    }

    private void setDivisionName(AORInfoType aorInfoType) {
        if (this.departmentalPerson.getHomeUnit() != null) {
            aorInfoType.setDivisionName(this.departmentalPerson.getHomeUnit());
        }
    }

    private RRSF42412Document.RRSF42412.ApplicantType getApplicantType() {
        RRSF42412Document.RRSF42412.ApplicantType applicantType = RRSF42412Document.RRSF42412.ApplicantType.Factory.newInstance();
        RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType smallOrganizationType = RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.Factory.newInstance();
        RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged isSociallyEconomicallyDisadvantaged = RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsSociallyEconomicallyDisadvantaged.Factory.newInstance();
        RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned isWomenOwned = RRSF42412Document.RRSF42412.ApplicantType.SmallBusinessOrganizationType.IsWomenOwned.Factory.newInstance();
        boolean smallBusflag = false;
        int orgTypeCode = 0;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().size() > 0) {
            orgTypeCode = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().get(0).getOrganizationTypeCode();
        }
        ApplicantTypeCodeDataType.Enum applicantTypeCode = null;
        switch (orgTypeCode) {
            case 1: {
                applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                break;
            }
            case 2: {
                applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                break;
            }
            case 3: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 4: {
                applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 5: {
                applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 6: {
                applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                break;
            }
            case 7: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                break;
            }
            case 8: {
                applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                break;
            }
            case 9: {
                applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                break;
            }
            case 10: {
                applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 11: {
                applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                break;
            }
            case 14: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isSociallyEconomicallyDisadvantaged.setStringValue("Yes");
                smallOrganizationType.setIsSociallyEconomicallyDisadvantaged(isSociallyEconomicallyDisadvantaged);
                smallBusflag = true;
                break;
            }
            case 15: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                isWomenOwned.setStringValue("Yes");
                smallOrganizationType.setIsWomenOwned(isWomenOwned);
                smallBusflag = true;
                break;
            }
            case 21: {
                applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 22: {
                applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                break;
            }
            case 23: {
                applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                break;
            }
            case 24: {
                applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                break;
            }
            case 25: {
                applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                break;
            }
            case 26: {
                applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                break;
            }
            default: {
                applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            }
        }
        if (smallBusflag) {
            applicantType.setSmallBusinessOrganizationType(smallOrganizationType);
        }
        if (orgTypeCode == 3) {
            applicantType.setApplicantTypeCodeOtherExplanation("Federal Government");
        }
        applicantType.setApplicantTypeCode(applicantTypeCode);
        return applicantType;
    }

    private ProposalYnq getAnswer(String questionId, ProposalDevelopmentDocument proposalDevelopmentDocument) {
        ProposalYnq ynq = null;
        for (ProposalYnq proposalYnq : proposalDevelopmentDocument.getDevelopmentProposal().getProposalYnqs()) {
            String question = proposalYnq.getQuestionId();
            if (question == null || !question.equals(questionId)) continue;
            ynq = proposalYnq;
            break;
        }
        return ynq;
    }

    private String getSubmissionTypeCode() {
        String submissionTypeCode = null;
        S2sOpportunity s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionTypeCode() != null) {
            s2sOpportunity.refreshNonUpdateableReferences();
            submissionTypeCode = s2sOpportunity.getS2sSubmissionTypeCode();
        }
        return submissionTypeCode;
    }

    private String getRolodexState() {
        String state = "";
        Rolodex rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getRolodex();
        if (rolodex != null) {
            state = rolodex.getState();
        }
        return state;
    }

    private String getEmployerId() {
        String employerId = "";
        ProposalSite applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization();
        if (applicantOrganization != null) {
            employerId = applicantOrganization.getOrganization().getFedralEmployerId();
        }
        return employerId;
    }

    private String getFederalAgencyName() {
        String agencyName = "";
        Sponsor sponsor = this.pdDoc.getDevelopmentProposal().getSponsor();
        if (sponsor != null) {
            agencyName = sponsor.getSponsorName();
        }
        return agencyName;
    }

    private void setPreApplicationAttachment(RRSF42412Document.RRSF42412 rrsf42412) {
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 6 || (preAttachment = this.getAttachedFileType(narrative)) == null) continue;
            rrsf42412.setPreApplicationAttachment(preAttachment);
            break;
        }
    }

    private void setSFLLLAttachment(RRSF42412Document.RRSF42412 rrsf42412) {
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType preAttachment;
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 86 || (preAttachment = this.getAttachedFileType(narrative)) == null) continue;
            rrsf42412.setSFLLLAttachment(preAttachment);
            break;
        }
    }

    private String getAORSignature() {
        String AORSignature = "";
        if (this.departmentalPerson != null) {
            AORSignature = this.departmentalPerson.getFullName();
        }
        return AORSignature;
    }

    private void setFederalId(RRSF42412Document.RRSF42412 rrsf42412) {
        String federalId = this.s2sUtilService.getFederalId(this.pdDoc);
        if (federalId != null) {
            if (federalId.length() > 30) {
                rrsf42412.setFederalID(federalId.substring(0, 30));
            } else {
                rrsf42412.setFederalID(federalId);
            }
        }
    }

    private String getActivityTitle() {
        String announcementTitle = "";
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
        }
        return announcementTitle;
    }

    private String getProjectTitle() {
        String title = this.pdDoc.getDevelopmentProposal().getTitle();
        if (title != null && title.length() > 200) {
            title = title.substring(0, 200);
        }
        return title;
    }

    private String getAgencyRoutingNumber() {
        String sponserProgramCode = this.pdDoc.getDevelopmentProposal().getAgencyProgramCode();
        return sponserProgramCode;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.departmentalPerson = this.s2sUtilService.getDepartmentalPerson(proposalDevelopmentDocument);
        return this.getRRSF424();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        RRSF42412Document.RRSF42412 rrsf42412 = (RRSF42412Document.RRSF42412)xmlObject;
        RRSF42412Document rrSF424Document = RRSF42412Document.Factory.newInstance();
        rrSF424Document.setRRSF42412(rrsf42412);
        return rrSF424Document;
    }
}

