/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.sf424BV11.AssuranceType;
import gov.grants.apply.forms.sf424BV11.AssurancesDocument;
import gov.grants.apply.forms.sf424BV11.AuthorizedRepresentativeDocument;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.SF424BaseGenerator;

public class SF424BV1_1Generator
extends SF424BaseGenerator {
    private AssurancesDocument getAssurance() {
        AssurancesDocument assuranceDocument = AssurancesDocument.Factory.newInstance();
        assuranceDocument.setAssurances(this.getAssuranceType());
        return assuranceDocument;
    }

    private AssuranceType getAssuranceType() {
        AssuranceType assuranceType = AssuranceType.Factory.newInstance();
        assuranceType.setFormVersionIdentifier("1.1");
        assuranceType.setProgramType("Non-Construction");
        assuranceType.setCoreSchemaVersion("1.1");
        assuranceType.setAuthorizedRepresentative(this.getAuthorizedRepresentative());
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        assuranceType.setApplicantOrganizationName(organization.getOrganizationName());
        return assuranceType;
    }

    private AuthorizedRepresentativeDocument.AuthorizedRepresentative getAuthorizedRepresentative() {
        AuthorizedRepresentativeDocument.AuthorizedRepresentative authorizedRepresentative = AuthorizedRepresentativeDocument.AuthorizedRepresentative.Factory.newInstance();
        DepartmentalPerson aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        if (aorInfo.getPrimaryTitle() != null) {
            authorizedRepresentative.setRepresentativeTitle(aorInfo.getPrimaryTitle());
        }
        return authorizedRepresentative;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getAssurance();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        AssuranceType assuranceType = (AssuranceType)xmlObject;
        AssurancesDocument assurancesDocument = AssurancesDocument.Factory.newInstance();
        assurancesDocument.setAssurances(assuranceType);
        return assurancesDocument;
    }
}

