/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.sf424ShortV10.SF424ShortDocument;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.util.HashMap;
import java.util.List;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationType;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.SF424BaseGenerator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SF424ShortV1_0Generator
extends SF424BaseGenerator {
    private String applicantTypeOtherSpecify = null;
    private static final String SPONSOR_CODE = "sponsorCode";
    private static final String DESCRIPTION = "description";
    private static final String ABSTRACT_TYPE_PROJECT_DESCRIPTION = "1";
    private static final int SPONSOR_NAME_MAX_LENGTH = 60;
    private static final int CFDA_NUMBER_MAX_LENGTH = 15;
    private static final int PROGRAM_ANNOUNCEMENT_TITLE_MAX_LENGTH = 120;
    private static final int OPPORTUNITY_ID_MAX_LENGTH = 40;
    private static final int ABSTRACT_TYPE_CODE_MAX_LENGTH = 1000;
    private static final int OFFICE_PHONE_MAX_LENGTH = 25;
    private static final int EMAIL_ADDRESS_MAX_LENGTH = 60;
    private static final int FAX_NUMBER_MAX_LENGTH = 25;
    private static final String VALUE_YES = "Yes";
    private BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);

    private SF424ShortDocument getsf424ShortDocument() {
        String congressionalDistrict;
        ApplicantTypeCodeDataType.Enum applicantTypeCode3;
        ApplicantTypeCodeDataType.Enum applicantTypeCode2;
        List<OrganizationType> organizationTypes;
        ApplicantTypeCodeDataType.Enum applicantTypeCode;
        Rolodex rolodex;
        Organization organization;
        SF424ShortDocument sf424ShortDocument = SF424ShortDocument.Factory.newInstance();
        SF424ShortDocument.SF424Short sf424Short = SF424ShortDocument.SF424Short.Factory.newInstance();
        sf424Short.setFormVersion("1.0");
        sf424Short.setAgencyName("");
        sf424Short.setFundingOpportunityNumber("");
        sf424Short.setFundingOpportunityTitle("");
        sf424Short.setOrganizationName("");
        sf424Short.setEmployerTaxpayerIdentificationNumber("");
        sf424Short.setProjectDescription("");
        sf424Short.setAuthorizedRepresentativeTitle("");
        sf424Short.setAuthorizedRepresentativePhoneNumber("");
        sf424Short.setAuthorizedRepresentativeEmail("");
        HashMap<String, String> sponsorMap = new HashMap<String, String>();
        sponsorMap.put(SPONSOR_CODE, this.pdDoc.getDevelopmentProposal().getPrimeSponsorCode());
        Sponsor sponsor = (Sponsor)this.businessObjectService.findByPrimaryKey(Sponsor.class, sponsorMap);
        if (this.pdDoc.getDevelopmentProposal().getSponsor() != null && this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName() != null) {
            if (this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName().length() > 60) {
                sf424Short.setAgencyName(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName().substring(0, 60));
            } else {
                sf424Short.setAgencyName(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName());
            }
        } else if (sponsor.getSponsorName() != null) {
            if (sponsor.getSponsorName().length() > 60) {
                sf424Short.setAgencyName(sponsor.getSponsorName().substring(0, 60));
            } else {
                sf424Short.setAgencyName(sponsor.getSponsorName());
            }
        }
        if (this.pdDoc.getDevelopmentProposal().getCfdaNumber() != null) {
            if (this.pdDoc.getDevelopmentProposal().getCfdaNumber().length() > 15) {
                sf424Short.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber().substring(0, 15));
            } else {
                sf424Short.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber());
            }
        }
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120) {
                sf424Short.setCFDAProgramTitle(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120));
            } else {
                sf424Short.setCFDAProgramTitle(this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle());
            }
        }
        sf424Short.setDateReceived(this.s2sUtilService.getCurrentCalendar());
        S2sOpportunity s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null) {
            s2sOpportunity.refreshNonUpdateableReferences();
            if (s2sOpportunity.getOpportunityId().length() > 40) {
                sf424Short.setFundingOpportunityNumber(s2sOpportunity.getOpportunityId().substring(0, 40));
            } else {
                sf424Short.setFundingOpportunityNumber(s2sOpportunity.getOpportunityId());
            }
            if (s2sOpportunity.getOpportunityTitle() != null) {
                sf424Short.setFundingOpportunityTitle(s2sOpportunity.getOpportunityTitle());
            }
        }
        if ((organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization()).getOrganizationName() != null) {
            sf424Short.setOrganizationName(organization.getOrganizationName());
        }
        if ((rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex()) != null) {
            sf424Short.setAddress(this.globLibV20Generator.getAddressDataType(rolodex));
        }
        if ((applicantTypeCode = this.getApplicantType(organizationTypes = organization.getOrganizationTypes(), 0)) != null) {
            sf424Short.setApplicantTypeCode1(applicantTypeCode);
        }
        if ((applicantTypeCode2 = this.getApplicantType(organizationTypes, 1)) != null) {
            sf424Short.setApplicantTypeCode2(applicantTypeCode2);
        }
        if ((applicantTypeCode3 = this.getApplicantType(organizationTypes, 2)) != null) {
            sf424Short.setApplicantTypeCode3(applicantTypeCode3);
        }
        if (this.applicantTypeOtherSpecify != null && !this.applicantTypeOtherSpecify.equals("")) {
            sf424Short.setApplicantTypeOtherSpecify(this.applicantTypeOtherSpecify);
        }
        sf424Short.setEmployerTaxpayerIdentificationNumber(organization.getFedralEmployerId());
        sf424Short.setDUNSNumber(organization.getDunsNumber());
        String string = congressionalDistrict = organization.getCongressionalDistrict() == null ? "Unknown" : organization.getCongressionalDistrict();
        if (congressionalDistrict.length() > 6) {
            sf424Short.setCongressionalDistrictApplicant(congressionalDistrict.substring(0, 6));
        } else {
            sf424Short.setCongressionalDistrictApplicant(congressionalDistrict);
        }
        sf424Short.setProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        for (ProposalAbstract proposalAbstract : this.pdDoc.getDevelopmentProposal().getProposalAbstracts()) {
            if (proposalAbstract.getAbstractTypeCode() == null || !proposalAbstract.getAbstractTypeCode().equals(ABSTRACT_TYPE_PROJECT_DESCRIPTION)) continue;
            if (proposalAbstract.getAbstractDetails().length() > 1000) {
                sf424Short.setProjectDescription(proposalAbstract.getAbstractDetails().substring(0, 1000));
                break;
            }
            sf424Short.setProjectDescription(proposalAbstract.getAbstractDetails());
            break;
        }
        sf424Short.setProjectStartDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        sf424Short.setProjectEndDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        ProposalPerson pi = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        sf424Short.setProjectDirectorGroup(this.globLibV20Generator.getContactPersonDataType(pi));
        sf424Short.setContactPersonGroup(this.globLibV20Generator.getContactPersonDataType(this.pdDoc));
        sf424Short.setApplicationCertification(YesNoDataType.Y_YES);
        DepartmentalPerson aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        sf424Short.setAuthorizedRepresentative(this.globLibV20Generator.getHumanNameDataType(aorInfo));
        if (aorInfo.getPrimaryTitle() != null) {
            if (aorInfo.getPrimaryTitle().length() > 45) {
                sf424Short.setAuthorizedRepresentativeTitle(aorInfo.getPrimaryTitle().substring(0, 45));
            } else {
                sf424Short.setAuthorizedRepresentativeTitle(aorInfo.getPrimaryTitle());
            }
        }
        if (aorInfo.getOfficePhone() != null) {
            if (aorInfo.getOfficePhone().length() > 25) {
                sf424Short.setAuthorizedRepresentativePhoneNumber(aorInfo.getOfficePhone().substring(0, 25));
            } else {
                sf424Short.setAuthorizedRepresentativePhoneNumber(aorInfo.getOfficePhone());
            }
        }
        if (aorInfo.getEmailAddress() != null) {
            if (aorInfo.getEmailAddress().length() > 60) {
                sf424Short.setAuthorizedRepresentativeEmail(aorInfo.getEmailAddress().substring(0, 60));
            } else {
                sf424Short.setAuthorizedRepresentativeEmail(aorInfo.getEmailAddress());
            }
        }
        if (aorInfo.getFaxNumber() != null) {
            if (aorInfo.getFaxNumber().length() > 25) {
                sf424Short.setAuthorizedRepresentativeFaxNumber(aorInfo.getFaxNumber().substring(0, 25));
            } else {
                sf424Short.setAuthorizedRepresentativeFaxNumber(aorInfo.getFaxNumber());
            }
        }
        sf424Short.setAuthorizedRepresentativeSignature(aorInfo.getFullName());
        sf424Short.setAuthorizedRepresentativeDateSigned(this.s2sUtilService.getCurrentCalendar());
        sf424ShortDocument.setSF424Short(sf424Short);
        return sf424ShortDocument;
    }

    private ApplicantTypeCodeDataType.Enum getApplicantType(List<OrganizationType> organizationTypes, int index) {
        if (index < organizationTypes.size()) {
            OrganizationType orgType = organizationTypes.get(index);
            int orgTypeCode = orgType.getOrganizationTypeCode();
            ApplicantTypeCodeDataType.Enum applicantTypeCode = null;
            switch (orgTypeCode) {
                case 1: {
                    applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                    break;
                }
                case 2: {
                    applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                    break;
                }
                case 3: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    break;
                }
                case 4: {
                    applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 5: {
                    applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 6: {
                    applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                    break;
                }
                case 7: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    break;
                }
                case 8: {
                    applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                    break;
                }
                case 9: {
                    applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                    break;
                }
                case 10: {
                    applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 11: {
                    applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                    break;
                }
                case 14: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    break;
                }
                case 15: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    break;
                }
                case 21: {
                    applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 22: {
                    applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                    break;
                }
                case 23: {
                    applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                    break;
                }
                case 24: {
                    applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                    break;
                }
                case 25: {
                    applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                    break;
                }
                case 26: {
                    applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                    break;
                }
                default: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                }
            }
            return applicantTypeCode;
        }
        return null;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        return this.getsf424ShortDocument();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        SF424ShortDocument sf424ShortDocument = SF424ShortDocument.Factory.newInstance();
        SF424ShortDocument.SF424Short sf424Short = (SF424ShortDocument.SF424Short)xmlObject;
        sf424ShortDocument.setSF424Short(sf424Short);
        return sf424ShortDocument;
    }
}

