/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.rrSF424V10.RRSF424Document;
import gov.grants.apply.forms.rrSF424V10.StateReviewCodeTypeDataType;
import gov.grants.apply.forms.sf424V10.AddressDocument;
import gov.grants.apply.forms.sf424V10.ApplicantTypeCodeType;
import gov.grants.apply.forms.sf424V10.ApplicationTypeCodeType;
import gov.grants.apply.forms.sf424V10.AuthorizedRepresentativeDocument;
import gov.grants.apply.forms.sf424V10.BudgetDocument;
import gov.grants.apply.forms.sf424V10.ContactDocument;
import gov.grants.apply.forms.sf424V10.GrantApplicationDocument;
import gov.grants.apply.forms.sf424V10.GrantApplicationType;
import gov.grants.apply.forms.sf424V10.IndividualDocument;
import gov.grants.apply.forms.sf424V10.OrganizationDocument;
import gov.grants.apply.forms.sf424V10.OrganizationIdentifyingInformationDocument;
import gov.grants.apply.forms.sf424V10.ProjectDocument;
import gov.grants.apply.forms.sf424V10.RevisionCodeType;
import gov.grants.apply.forms.sf424V10.RevisionDocument;
import gov.grants.apply.forms.sf424V10.StateReviewCodeType;
import gov.grants.apply.forms.sf424V10.SubmissionTypeCodeType;
import gov.grants.apply.forms.sf424V10.SubmittingOrganizationDocument;
import gov.grants.apply.system.globalV10.YesNoType;
import gov.grants.apply.system.universalCodesV10.CountryCodeType;
import gov.grants.apply.system.universalCodesV10.CurrencyCodeType;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.proposaldevelopment.ProposalDevelopmentUtils;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.SF424BaseGenerator;

public class SF424V1_0Generator
extends SF424BaseGenerator {
    private static final Log LOG = LogFactory.getLog(SF424V1_0Generator.class);
    private DepartmentalPerson aorInfo;
    private String stateReviewDate = null;

    private GrantApplicationDocument getGrantApplication() {
        GrantApplicationDocument grantApplicationDocument = GrantApplicationDocument.Factory.newInstance();
        grantApplicationDocument.setGrantApplication(this.getGrantApplicationType());
        return grantApplicationDocument;
    }

    private GrantApplicationType getGrantApplicationType() {
        String federalId;
        Rolodex rolodex;
        int proposalTypeCode;
        GrantApplicationType grantApplicationType = GrantApplicationType.Factory.newInstance();
        grantApplicationType.setFormVersionIdentifier("1.0");
        grantApplicationType.setAgencyName("");
        String submissionTypeCode = this.getSF424SubmissionType(this.pdDoc);
        if (submissionTypeCode != null) {
            SubmissionTypeCodeType.Enum submissionType = SubmissionTypeCodeType.Enum.forString((String)submissionTypeCode);
            grantApplicationType.setSubmissionTypeCode(submissionType);
        }
        grantApplicationType.setSubmittedDate(this.s2sUtilService.getCurrentCalendar());
        ApplicationTypeCodeType.Enum applicationTypeCodeDataType = null;
        if (this.pdDoc.getDevelopmentProposal().getProposalTypeCode() != null && (proposalTypeCode = Integer.parseInt(this.pdDoc.getDevelopmentProposal().getProposalTypeCode())) < Integer.parseInt(ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_RESUBMISSION"))) {
            applicationTypeCodeDataType = ApplicationTypeCodeType.Enum.forInt((int)proposalTypeCode);
        }
        grantApplicationType.setApplicationTypeCode(applicationTypeCodeDataType);
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() != null) {
            this.pdDoc.getDevelopmentProposal().getS2sOpportunity().refreshNonUpdateableReferences();
            String revisionCode = this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getRevisionCode();
            if (revisionCode != null) {
                RevisionDocument.Revision revision = RevisionDocument.Revision.Factory.newInstance();
                String revision1 = null;
                String revision2 = null;
                revision1 = revisionCode.substring(0, 1);
                if (revisionCode.length() > 1) {
                    revision2 = revisionCode.substring(1, 2);
                }
                if (revision1 != null && !revision1.equals("E")) {
                    RevisionCodeType.Enum rev1Enum = RevisionCodeType.Enum.forString((String)revision1);
                    revision.setRevisionCode1(rev1Enum);
                }
                if (revision2 != null) {
                    RevisionCodeType.Enum rev2Enum = RevisionCodeType.Enum.forString((String)revision2);
                    revision.setRevisionCode2(rev2Enum);
                }
                grantApplicationType.setRevision(revision);
            }
        }
        if (this.pdDoc.getDevelopmentProposal().getSponsor() != null) {
            grantApplicationType.setAgencyName(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName());
        }
        if ((rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex()) != null) {
            grantApplicationType.setStateID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex().getState());
        }
        if ((federalId = this.s2sUtilService.getFederalId(this.pdDoc)) != null) {
            grantApplicationType.setFederalID(federalId);
        }
        if (this.pdDoc.getDevelopmentProposal().getCfdaNumber() != null) {
            grantApplicationType.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            grantApplicationType.setActivityTitle(announcementTitle);
        }
        grantApplicationType.setSubmittingOrganization(this.getSubmittingOrganization());
        grantApplicationType.setProject(this.getProject());
        try {
            grantApplicationType.setBudget(this.getBudget());
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return grantApplicationType;
        }
        IndividualDocument.Individual individual = IndividualDocument.Individual.Factory.newInstance();
        individual.setAuthorizedRepresentative(this.getAuthorizedRepresentative());
        individual.setContact(this.getContact());
        grantApplicationType.setIndividual(individual);
        grantApplicationType.setStateReviewCode(this.getStateReviewCode());
        if (this.stateReviewDate != null) {
            grantApplicationType.setStateReviewDate(this.s2sUtilService.convertDateStringToCalendar(this.stateReviewDate));
        }
        grantApplicationType.setAuthorizedRepresentativeSignature(this.aorInfo.getFullName());
        grantApplicationType.setSignedDate(this.s2sUtilService.getCurrentCalendar());
        grantApplicationType.setCoreSchemaVersion("1.0");
        return grantApplicationType;
    }

    private StateReviewCodeType.Enum getStateReviewCode() {
        Map<String, String> eoStateReview = this.s2sUtilService.getEOStateReview(this.pdDoc);
        StateReviewCodeType.Enum stateType = null;
        StateReviewCodeTypeDataType.Enum stateReviewCodeType = null;
        String strReview = eoStateReview.get("answer");
        String stateReviewData = null;
        if ("Y".equals(strReview)) {
            stateType = StateReviewCodeType.YES;
        } else {
            stateReviewData = eoStateReview.get("stateReviewData");
            if (stateReviewData != null && StateReviewCodeType.NOT_COVERED.toString().equals(stateReviewData)) {
                stateType = StateReviewCodeType.NOT_COVERED;
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
            } else if (stateReviewData != null && "Not Selected".equals(stateReviewData)) {
                stateType = StateReviewCodeType.NOT_REVIEWED;
                stateReviewCodeType = StateReviewCodeTypeDataType.PROGRAM_HAS_NOT_BEEN_SELECTED_BY_STATE_FOR_REVIEW;
            }
        }
        if (eoStateReview.get("reviewDate") != null) {
            this.stateReviewDate = eoStateReview.get("reviewDate");
        }
        RRSF424Document.RRSF424.StateReview stateReview = RRSF424Document.RRSF424.StateReview.Factory.newInstance();
        stateReview.setStateReviewCodeType(stateReviewCodeType);
        return stateType;
    }

    private AuthorizedRepresentativeDocument.AuthorizedRepresentative getAuthorizedRepresentative() {
        AuthorizedRepresentativeDocument.AuthorizedRepresentative authorizedRep = AuthorizedRepresentativeDocument.AuthorizedRepresentative.Factory.newInstance();
        if (this.aorInfo.getFirstName() != null) {
            authorizedRep.setGivenName1(this.aorInfo.getFirstName());
        }
        if (this.aorInfo.getMiddleName() != null) {
            authorizedRep.setGivenName2(this.aorInfo.getMiddleName());
        }
        if (this.aorInfo.getLastName() != null) {
            authorizedRep.setFamilyName(this.aorInfo.getLastName());
        }
        if (this.aorInfo.getEmailAddress() != null) {
            authorizedRep.setElectronicMailAddress(this.aorInfo.getEmailAddress());
        }
        if (this.aorInfo.getOfficePhone() != null) {
            authorizedRep.setTelephoneNumber(this.aorInfo.getOfficePhone());
        }
        if (this.aorInfo.getFaxNumber() != null) {
            authorizedRep.setFaxNumber(this.aorInfo.getFaxNumber());
        }
        if (this.aorInfo.getPrimaryTitle() != null) {
            if (this.aorInfo.getPrimaryTitle().length() > 45) {
                authorizedRep.setRepresentativeTitle(this.aorInfo.getPrimaryTitle().substring(0, 45));
            } else {
                authorizedRep.setRepresentativeTitle(this.aorInfo.getPrimaryTitle());
            }
        }
        return authorizedRep;
    }

    private BudgetDocument.Budget getBudget() throws S2SException {
        BudgetDocument.Budget budget = BudgetDocument.Budget.Factory.newInstance();
        CurrencyCodeType.Enum currencyEnum = CurrencyCodeType.USD;
        budget.setCurrencyCode(currencyEnum);
        budget.setFederalEstimatedAmount(BigDecimal.ZERO);
        budget.setTotalEstimatedAmount(BigDecimal.ZERO);
        Budget budgetDoc = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc).getBudget();
        if (budgetDoc != null) {
            budget.setFederalEstimatedAmount(budgetDoc.getTotalCost().bigDecimalValue());
            budget.setApplicantEstimatedAmount(budgetDoc.getCostSharingAmount().bigDecimalValue());
            budget.setStateEstimatedAmount(BigDecimal.ZERO);
            budget.setLocalEstimatedAmount(BigDecimal.ZERO);
            budget.setOtherEstimatedAmount(BigDecimal.ZERO);
            BigDecimal projectIncome = BigDecimal.ZERO;
            for (BudgetProjectIncome budgetProjectIncome : budgetDoc.getBudgetProjectIncomes()) {
                if (budgetProjectIncome.getProjectIncome() == null) continue;
                projectIncome = projectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            }
            budget.setProgramIncomeEstimatedAmount(projectIncome);
            BudgetDecimal totalEstimatedAmount = BudgetDecimal.ZERO;
            if (budgetDoc.getTotalCost() != null) {
                totalEstimatedAmount = (BudgetDecimal)totalEstimatedAmount.add(budgetDoc.getTotalCost());
            }
            if (budgetDoc.getCostSharingAmount() != null) {
                totalEstimatedAmount = (BudgetDecimal)totalEstimatedAmount.add(budgetDoc.getCostSharingAmount());
            }
            budget.setTotalEstimatedAmount(totalEstimatedAmount.bigDecimalValue().add(projectIncome));
        }
        return budget;
    }

    private ContactDocument.Contact getContact() {
        ContactDocument.Contact contact = ContactDocument.Contact.Factory.newInstance();
        ProposalPerson PI = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc);
        if (PI != null) {
            if (PI.getFirstName() != null) {
                contact.setGivenName1(PI.getFirstName());
            }
            if (PI.getMiddleName() != null) {
                contact.setGivenName2(PI.getMiddleName());
            }
            if (PI.getLastName() != null) {
                contact.setFamilyName(PI.getLastName());
            }
            if (PI.getEmailAddress() != null) {
                contact.setElectronicMailAddress(PI.getEmailAddress());
            }
            if (PI.getOfficePhone() != null) {
                contact.setTelephoneNumber(PI.getOfficePhone());
            }
            if (PI.getFaxNumber() != null) {
                contact.setFaxNumber(PI.getFaxNumber());
            }
        }
        return contact;
    }

    private ProjectDocument.Project getProject() {
        ProjectDocument.Project project = ProjectDocument.Project.Factory.newInstance();
        project.setProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        Rolodex rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex();
        if (rolodex != null) {
            project.setLocation(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex().getState());
        }
        project.setProposedStartDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        project.setProposedEndDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        if (this.pdDoc.getDevelopmentProposal().getPerformingOrganization() != null) {
            project.setCongressionalDistrict(this.pdDoc.getDevelopmentProposal().getPerformingOrganization().getFirstCongressionalDistrictName());
        } else {
            project.setCongressionalDistrict("");
        }
        return project;
    }

    private SubmittingOrganizationDocument.SubmittingOrganization getSubmittingOrganization() {
        SubmittingOrganizationDocument.SubmittingOrganization submittingOrganization = SubmittingOrganizationDocument.SubmittingOrganization.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            submittingOrganization.setCongressionalDistrict(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getFirstCongressionalDistrictName());
        }
        YesNoType.Enum yesNo = YesNoType.N;
        for (OrganizationYnq orgYnq : this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationYnqs()) {
            if (!"I7".equals(orgYnq.getQuestionId()) || orgYnq.getAnswer() == null) continue;
            yesNo = YesNoType.Enum.forString((String)orgYnq.getAnswer());
        }
        submittingOrganization.setDelinquentFederalDebtIndicator(yesNo);
        OrganizationDocument.Organization organization = OrganizationDocument.Organization.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            organization.setOrganizationName(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationName());
        }
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            organization.setDUNSID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getDunsNumber());
        }
        String departmentName = "";
        if (this.pdDoc.getDevelopmentProposal().getOwnedByUnit() != null) {
            departmentName = this.pdDoc.getDevelopmentProposal().getOwnedByUnit().getUnitName();
        }
        if (departmentName != null && departmentName.length() > 30) {
            organization.setDepartmentName(departmentName.substring(0, 30));
        } else {
            organization.setDepartmentName(departmentName);
        }
        String divisionName = this.s2sUtilService.getDivisionName(this.pdDoc);
        if (divisionName != null) {
            organization.setDivisionName(divisionName);
        }
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null) {
            organization.setEmployerID(this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getFedralEmployerId());
        }
        OrganizationIdentifyingInformationDocument.OrganizationIdentifyingInformation orgIdentifyingInformation = OrganizationIdentifyingInformationDocument.OrganizationIdentifyingInformation.Factory.newInstance();
        orgIdentifyingInformation.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        orgIdentifyingInformation.setApplicantTypeCode(this.getApplicantType());
        orgIdentifyingInformation.setOrganization(organization);
        submittingOrganization.setOrganizationIdentifyingInformation(orgIdentifyingInformation);
        AddressDocument.Address address = AddressDocument.Address.Factory.newInstance();
        address.setStreet1("");
        address.setCity("");
        Rolodex rolodex = null;
        if (this.pdDoc.getDevelopmentProposal().getPerformingOrganization() != null && (rolodex = this.pdDoc.getDevelopmentProposal().getPerformingOrganization().getRolodex()) != null) {
            address.setStreet1(rolodex.getAddressLine1() == null ? "" : rolodex.getAddressLine1());
            address.setStreet2(rolodex.getAddressLine2());
            address.setCity(rolodex.getCity() == null ? "" : rolodex.getCity());
            address.setCounty(rolodex.getCounty());
            address.setStateCode(rolodex.getState());
            address.setZipCode(rolodex.getPostalCode());
            if (rolodex.getCountryCode() != null) {
                CountryCodeType.Enum countryEnum = CountryCodeType.Enum.forString((String)rolodex.getCountryCode());
                address.setCountry(countryEnum);
            }
            submittingOrganization.setAddress(address);
        }
        submittingOrganization.setAddress(address);
        return submittingOrganization;
    }

    private ApplicantTypeCodeType.Enum getApplicantType() {
        ApplicantTypeCodeType.Enum applicantTypeCode = null;
        int orgTypeCode = 0;
        if (this.pdDoc.getDevelopmentProposal().getApplicantOrganization() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes() != null && this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationTypes().size() > 0) {
            orgTypeCode = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization().getOrganizationType(0).getOrganizationTypeCode();
        }
        switch (orgTypeCode) {
            case 1: {
                applicantTypeCode = ApplicantTypeCodeType.CITY_OR_TOWNSHIP_GOVERNMENT;
                break;
            }
            case 2: {
                applicantTypeCode = ApplicantTypeCodeType.STATE_GOVERNMENT;
                break;
            }
            case 3: {
                applicantTypeCode = ApplicantTypeCodeType.OTHER;
                break;
            }
            case 4: {
                applicantTypeCode = ApplicantTypeCodeType.NONPROFIT_ORGANIZATION_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION_OTHER_SPECIFY;
                break;
            }
            case 5: {
                applicantTypeCode = ApplicantTypeCodeType.NONPROFIT_ORGANIZATION_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION_OTHER_SPECIFY;
                break;
            }
            case 6: {
                applicantTypeCode = ApplicantTypeCodeType.FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                break;
            }
            case 7: {
                applicantTypeCode = ApplicantTypeCodeType.OTHER;
                break;
            }
            case 8: {
                applicantTypeCode = ApplicantTypeCodeType.NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                break;
            }
            case 9: {
                applicantTypeCode = ApplicantTypeCodeType.INDIVIDUAL;
                break;
            }
            case 10: {
                applicantTypeCode = ApplicantTypeCodeType.PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 11: {
                applicantTypeCode = ApplicantTypeCodeType.SMALL_BUSINESS;
                break;
            }
            case 21: {
                applicantTypeCode = ApplicantTypeCodeType.PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                break;
            }
            case 22: {
                applicantTypeCode = ApplicantTypeCodeType.COUNTY_GOVERNMENT;
                break;
            }
            case 23: {
                applicantTypeCode = ApplicantTypeCodeType.SPECIAL_DISTRICT;
                break;
            }
            case 24: {
                applicantTypeCode = ApplicantTypeCodeType.INDEPENDENT_SCHOOL_DISTRICT;
                break;
            }
            case 25: {
                applicantTypeCode = ApplicantTypeCodeType.PUBLIC_INDIAN_HOUSING_AUTHORITY;
                break;
            }
            case 26: {
                applicantTypeCode = ApplicantTypeCodeType.NATIVE_AMERICAN_TRIBAL_ORGANIZATION_OTHER_THAN_FEDERALLY_RECOGNIZED;
                break;
            }
            default: {
                applicantTypeCode = ApplicantTypeCodeType.OTHER;
            }
        }
        return applicantTypeCode;
    }

    private String getSF424SubmissionType(ProposalDevelopmentDocument pdDoc) {
        String submissionType = null;
        String suffix = ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("ACTIVITY_TYPE_CODE_CONSTRUCTION").equals(pdDoc.getDevelopmentProposal().getActivityTypeCode()) ? "C" : "N";
        if (pdDoc.getDevelopmentProposal().getS2sOpportunity() != null && pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionTypeCode() != null) {
            pdDoc.getDevelopmentProposal().getS2sOpportunity().refreshNonUpdateableReferences();
            submissionType = ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("S2S_SUBMISSION_TYPE_CODE_PREAPPLICATION").equals(pdDoc.getDevelopmentProposal().getS2sOpportunity().getS2sSubmissionType().getS2sSubmissionTypeCode()) ? "P" + suffix : "A" + suffix;
        }
        return submissionType;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        return this.getGrantApplication();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        GrantApplicationType grantApplicationType = (GrantApplicationType)xmlObject;
        GrantApplicationDocument grantDocument = GrantApplicationDocument.Factory.newInstance();
        grantDocument.setGrantApplication(grantApplicationType);
        return grantDocument;
    }
}

