/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.sf424V20.SF424Document;
import gov.grants.apply.system.attachmentsV10.AttachedFileDataType;
import gov.grants.apply.system.attachmentsV10.AttachmentGroupMin0Max100DataType;
import gov.grants.apply.system.globalLibraryV20.ApplicantTypeCodeDataType;
import gov.grants.apply.system.globalLibraryV20.YesNoDataType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.OrganizationType;
import org.kuali.kra.bo.OrganizationYnq;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.distributionincome.BudgetProjectIncome;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.proposaldevelopment.ProposalDevelopmentUtils;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalAbstract;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.bo.S2sSubmissionType;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.SF424BaseGenerator;

public class SF424V2_0Generator
extends SF424BaseGenerator {
    private static final Log LOG = LogFactory.getLog(SF424V2_0Generator.class);
    private DepartmentalPerson aorInfo = null;
    private String applicantTypeOtherSpecify = null;
    private String federalDebtExp;
    private String stateReviewDate = null;
    private String strReview = null;
    private static final String ORGANIZATION_YNQ_ANSWER_YES = "Y";

    private SF424Document getSF424Doc() {
        SF424Document sf424Document = SF424Document.Factory.newInstance();
        sf424Document.setSF424(this.getSF424());
        return sf424Document;
    }

    private SF424Document.SF424 getSF424() {
        String congressionalDistrict;
        ProposalPerson personInfo;
        String divisionName;
        SF424Document.SF424 sf424V2 = SF424Document.SF424.Factory.newInstance();
        sf424V2.setFormVersion("2.0");
        boolean hasBudgetLineItem = false;
        S2sOpportunity s2sOpportunity = this.pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (s2sOpportunity != null && s2sOpportunity.getS2sSubmissionTypeCode() != null) {
            s2sOpportunity.refreshNonUpdateableReferences();
            S2sSubmissionType submissionType = s2sOpportunity.getS2sSubmissionType();
            SF424Document.SF424.SubmissionType.Enum subEnum = SF424Document.SF424.SubmissionType.Enum.forInt((int)Integer.parseInt(submissionType.getS2sSubmissionTypeCode()));
            sf424V2.setSubmissionType(subEnum);
            SF424Document.SF424.ApplicationType.Enum applicationTypeEnum = null;
            if (this.pdDoc.getDevelopmentProposal().getProposalTypeCode() != null) {
                String proposalTypeCode = this.pdDoc.getDevelopmentProposal().getProposalTypeCode();
                if (ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_NEW").equals(proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.NEW;
                } else if (ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_RESUBMISSION").equals(proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.REVISION;
                } else if (ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_RENEWAL").equals(proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.CONTINUATION;
                } else if (ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_CONTINUATION").equals(proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.CONTINUATION;
                } else if (ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter("PROPOSAL_TYPE_CODE_REVISION").equals(proposalTypeCode)) {
                    applicationTypeEnum = SF424Document.SF424.ApplicationType.REVISION;
                }
            }
            sf424V2.setApplicationType(applicationTypeEnum);
            String revisionType = s2sOpportunity.getRevisionCode();
            if (revisionType != null) {
                SF424Document.SF424.RevisionType.Enum revType = null;
                if (revisionType.equals("A")) {
                    revType = SF424Document.SF424.RevisionType.A_INCREASE_AWARD;
                } else if (revisionType.equals("B")) {
                    revType = SF424Document.SF424.RevisionType.B_DECREASE_AWARD;
                } else if (revisionType.equals("C")) {
                    revType = SF424Document.SF424.RevisionType.C_INCREASE_DURATION;
                } else if (revisionType.equals("D")) {
                    revType = SF424Document.SF424.RevisionType.D_DECREASE_DURATION;
                } else if (revisionType.equals("AD")) {
                    revType = SF424Document.SF424.RevisionType.AD_INCREASE_AWARD_DECREASE_DURATION;
                } else if (revisionType.equals("AC")) {
                    revType = SF424Document.SF424.RevisionType.AC_INCREASE_AWARD_INCREASE_DURATION;
                } else if (revisionType.equals("BD")) {
                    revType = SF424Document.SF424.RevisionType.BD_DECREASE_AWARD_DECREASE_DURATION;
                } else if (revisionType.equals("BC")) {
                    revType = SF424Document.SF424.RevisionType.BC_DECREASE_AWARD_INCREASE_DURATION;
                } else if (revisionType.equals("E")) {
                    revType = SF424Document.SF424.RevisionType.E_OTHER_SPECIFY;
                }
                if (revType != null) {
                    sf424V2.setRevisionType(revType);
                }
                if (revisionType.startsWith("E")) {
                    sf424V2.setRevisionOtherSpecify(s2sOpportunity.getRevisionOtherDescription());
                }
            }
        }
        sf424V2.setDateReceived(this.s2sUtilService.getCurrentCalendar());
        sf424V2.setApplicantID(this.pdDoc.getDevelopmentProposal().getProposalNumber());
        String federalId = this.s2sUtilService.getFederalId(this.pdDoc);
        if (federalId != null) {
            sf424V2.setFederalEntityIdentifier(federalId);
        }
        Organization organization = null;
        organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            sf424V2.setOrganizationName(organization.getOrganizationName());
            sf424V2.setEmployerTaxpayerIdentificationNumber(organization.getFedralEmployerId());
            sf424V2.setDUNSNumber(organization.getDunsNumber());
            sf424V2.setOrganizationAffiliation(organization.getOrganizationName());
        } else {
            sf424V2.setOrganizationName(null);
            sf424V2.setEmployerTaxpayerIdentificationNumber(null);
            sf424V2.setDUNSNumber(null);
        }
        Rolodex rolodex = null;
        rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex();
        sf424V2.setApplicant(this.globLibV20Generator.getAddressDataType(rolodex));
        String departmentName = null;
        if (this.pdDoc.getDevelopmentProposal().getOwnedByUnit() != null) {
            departmentName = this.pdDoc.getDevelopmentProposal().getOwnedByUnit().getUnitName();
        }
        if (departmentName != null) {
            if (departmentName.length() > 30) {
                sf424V2.setDepartmentName(departmentName.substring(0, 30));
            } else {
                sf424V2.setDepartmentName(departmentName);
            }
        }
        if ((divisionName = this.s2sUtilService.getDivisionName(this.pdDoc)) != null) {
            sf424V2.setDivisionName(divisionName);
        }
        if ((personInfo = this.s2sUtilService.getPrincipalInvestigator(this.pdDoc)) != null) {
            sf424V2.setContactPerson(this.globLibV20Generator.getHumanNameDataType(personInfo));
            if (personInfo.getDirectoryTitle() != null) {
                sf424V2.setTitle(personInfo.getDirectoryTitle());
            }
            sf424V2.setPhoneNumber(personInfo.getOfficePhone());
            if (personInfo.getFaxNumber() != null) {
                sf424V2.setFax(personInfo.getFaxNumber());
            }
            sf424V2.setEmail(personInfo.getEmailAddress());
        } else {
            sf424V2.setPhoneNumber(null);
            sf424V2.setEmail(null);
        }
        this.setApplicatTypeCodes(sf424V2);
        if (this.pdDoc.getDevelopmentProposal().getSponsor() != null) {
            sf424V2.setAgencyName(this.pdDoc.getDevelopmentProposal().getSponsor().getSponsorName());
        }
        if (this.pdDoc.getDevelopmentProposal().getCfdaNumber() != null) {
            sf424V2.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber());
        }
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            sf424V2.setCFDAProgramTitle(announcementTitle);
        }
        if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity() != null) {
            sf424V2.setFundingOpportunityNumber(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityId());
            if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle() != null) {
                sf424V2.setFundingOpportunityTitle(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityTitle());
            }
            if (this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getCompetetionId() != null) {
                sf424V2.setCompetitionIdentificationNumber(this.pdDoc.getDevelopmentProposal().getS2sOpportunity().getCompetetionId());
            }
        } else {
            sf424V2.setFundingOpportunityTitle(null);
        }
        String areasAffected = null;
        for (ProposalAbstract proposalAbstract : this.pdDoc.getDevelopmentProposal().getProposalAbstracts()) {
            if (proposalAbstract.getAbstractTypeCode() == null || Integer.parseInt(proposalAbstract.getAbstractTypeCode()) != 16) continue;
            areasAffected = proposalAbstract.getAbstractDetails();
            if (areasAffected != null && areasAffected.length() > 250) {
                sf424V2.setAffectedAreas(areasAffected.substring(0, 250));
                continue;
            }
            sf424V2.setAffectedAreas(areasAffected);
        }
        sf424V2.setProjectTitle(this.pdDoc.getDevelopmentProposal().getTitle());
        AttachmentGroupMin0Max100DataType attachedFileMin0Max100 = AttachmentGroupMin0Max100DataType.Factory.newInstance();
        attachedFileMin0Max100.setAttachedFileArray(this.getAttachedFileDataTypes());
        sf424V2.setAdditionalProjectTitle(attachedFileMin0Max100);
        String string = congressionalDistrict = organization.getCongressionalDistrict() == null ? "Unknown" : organization.getCongressionalDistrict();
        if (congressionalDistrict.length() > 6) {
            sf424V2.setCongressionalDistrictApplicant(congressionalDistrict.substring(0, 6));
        } else {
            sf424V2.setCongressionalDistrictApplicant(congressionalDistrict);
        }
        ProposalSite perfOrganization = this.pdDoc.getDevelopmentProposal().getPerformingOrganization();
        if (perfOrganization != null) {
            String congDistrictProject;
            String string2 = congDistrictProject = perfOrganization.getFirstCongressionalDistrictName() == null ? "Unknown" : perfOrganization.getFirstCongressionalDistrictName();
            if (congDistrictProject.length() > 6) {
                sf424V2.setCongressionalDistrictProgramProject(congDistrictProject.substring(0, 6));
            } else {
                sf424V2.setCongressionalDistrictProgramProject(congDistrictProject);
            }
        }
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            AttachedFileDataType attachedFileDataType;
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 42 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            sf424V2.setAdditionalCongressionalDistricts(attachedFileDataType);
            break;
        }
        if (this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial() != null) {
            sf424V2.setProjectStartDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedStartDateInitial()));
        } else {
            sf424V2.setProjectStartDate(null);
        }
        if (this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial() != null) {
            sf424V2.setProjectEndDate(this.s2sUtilService.convertDateToCalendar(this.pdDoc.getDevelopmentProposal().getRequestedEndDateInitial()));
        } else {
            sf424V2.setProjectEndDate(null);
        }
        Budget budget = null;
        try {
            BudgetDocument budgetDocument = this.s2sBudgetCalculatorService.getFinalBudgetVersion(this.pdDoc);
            budget = budgetDocument == null ? null : budgetDocument.getBudget();
        }
        catch (S2SException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return sf424V2;
        }
        if (budget != null) {
            if (budget.getTotalCost() != null) {
                sf424V2.setFederalEstimatedFunding(budget.getTotalCost().bigDecimalValue());
            }
            BudgetDecimal fedNonFedCost = budget.getTotalCost();
            BudgetDecimal costSharingAmount = BudgetDecimal.ZERO;
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    hasBudgetLineItem = true;
                    if (!budget.getSubmitCostSharingFlag().booleanValue() || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    costSharingAmount = (BudgetDecimal)costSharingAmount.add(lineItem.getCostSharingAmount());
                    List calculatedAmounts = lineItem.getBudgetCalculatedAmounts();
                    for (BudgetLineItemCalculatedAmount budgetLineItemCalculatedAmount : calculatedAmounts) {
                        costSharingAmount = (BudgetDecimal)costSharingAmount.add(budgetLineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
            if (!hasBudgetLineItem && budget.getSubmitCostSharingFlag().booleanValue()) {
                costSharingAmount = budget.getCostSharingAmount();
            }
            fedNonFedCost = (BudgetDecimal)fedNonFedCost.add(costSharingAmount);
            sf424V2.setApplicantEstimatedFunding(costSharingAmount.bigDecimalValue());
            BigDecimal projectIncome = BigDecimal.ZERO;
            for (BudgetProjectIncome budgetProjectIncome : budget.getBudgetProjectIncomes()) {
                projectIncome = projectIncome.add(budgetProjectIncome.getProjectIncome().bigDecimalValue());
            }
            sf424V2.setProgramIncomeEstimatedFunding(projectIncome);
            BudgetDecimal totalEstimatedAmount = BudgetDecimal.ZERO;
            if (budget.getTotalCost() != null) {
                totalEstimatedAmount = (BudgetDecimal)totalEstimatedAmount.add(budget.getTotalCost());
            }
            totalEstimatedAmount = (BudgetDecimal)totalEstimatedAmount.add(costSharingAmount);
            totalEstimatedAmount = (BudgetDecimal)totalEstimatedAmount.add(new BudgetDecimal(projectIncome));
            sf424V2.setTotalEstimatedFunding(totalEstimatedAmount.bigDecimalValue());
        } else {
            sf424V2.setFederalEstimatedFunding(BigDecimal.ZERO);
            sf424V2.setApplicantEstimatedFunding(BigDecimal.ZERO);
            sf424V2.setProgramIncomeEstimatedFunding(BigDecimal.ZERO);
            sf424V2.setTotalEstimatedFunding(BigDecimal.ZERO);
        }
        sf424V2.setStateEstimatedFunding(BigDecimal.ZERO);
        sf424V2.setLocalEstimatedFunding(BigDecimal.ZERO);
        sf424V2.setOtherEstimatedFunding(BigDecimal.ZERO);
        sf424V2.setStateReview(this.getStateReviewCode());
        if (this.strReview != null && this.strReview.equals(ORGANIZATION_YNQ_ANSWER_YES)) {
            Calendar reviewDate = null;
            reviewDate = this.s2sUtilService.convertDateStringToCalendar(this.stateReviewDate);
            sf424V2.setStateReviewAvailableDate(reviewDate);
        }
        YesNoDataType.Enum yesNo = YesNoDataType.N_NO;
        Organization applicantOrganization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (applicantOrganization != null) {
            for (OrganizationYnq orgYnq : applicantOrganization.getOrganizationYnqs()) {
                if (orgYnq.getQuestionId() == null || !orgYnq.getQuestionId().equals("I7")) continue;
                String orgYnqanswer = orgYnq.getAnswer();
                if (orgYnqanswer != null) {
                    yesNo = orgYnqanswer.equalsIgnoreCase(ORGANIZATION_YNQ_ANSWER_YES) ? YesNoDataType.Y_YES : YesNoDataType.N_NO;
                }
                this.federalDebtExp = orgYnq.getExplanation();
            }
        }
        sf424V2.setDelinquentFederalDebt(yesNo);
        if (sf424V2.getDelinquentFederalDebt() != null && sf424V2.getDelinquentFederalDebt().equals(YesNoDataType.Y_YES)) {
            sf424V2.setDelinquentFederalDebtExplanation(this.federalDebtExp);
        }
        sf424V2.setCertificationAgree(YesNoDataType.Y_YES);
        sf424V2.setAuthorizedRepresentative(this.globLibV20Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            if (this.aorInfo.getPrimaryTitle().length() > 45) {
                sf424V2.setAuthorizedRepresentativeTitle(this.aorInfo.getPrimaryTitle().substring(0, 45));
            } else {
                sf424V2.setAuthorizedRepresentativeTitle(this.aorInfo.getPrimaryTitle());
            }
        } else {
            sf424V2.setAuthorizedRepresentativeTitle(null);
        }
        sf424V2.setAuthorizedRepresentativePhoneNumber(this.aorInfo.getOfficePhone());
        sf424V2.setAuthorizedRepresentativeEmail(this.aorInfo.getEmailAddress());
        sf424V2.setAuthorizedRepresentativeFax(this.aorInfo.getFaxNumber());
        sf424V2.setAORSignature(this.aorInfo.getFullName());
        sf424V2.setDateSigned(this.s2sUtilService.getCurrentCalendar());
        return sf424V2;
    }

    private void setApplicatTypeCodes(SF424Document.SF424 sf424V2) {
        List<OrganizationType> organizationTypes;
        Organization organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization.getOrganizationTypes() == null) {
            organization.refreshReferenceObject("organizationTypes");
        }
        if ((organizationTypes = organization.getOrganizationTypes()).isEmpty()) {
            sf424V2.setApplicantTypeCode1(null);
            return;
        }
        for (int i = 0; i < organizationTypes.size() && i < 3; ++i) {
            OrganizationType orgType = organizationTypes.get(i);
            ApplicantTypeCodeDataType.Enum applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
            switch (orgType.getOrganizationTypeCode()) {
                case 1: {
                    applicantTypeCode = ApplicantTypeCodeDataType.C_CITY_OR_TOWNSHIP_GOVERNMENT;
                    break;
                }
                case 2: {
                    applicantTypeCode = ApplicantTypeCodeDataType.A_STATE_GOVERNMENT;
                    break;
                }
                case 3: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Federal Government";
                    break;
                }
                case 4: {
                    applicantTypeCode = ApplicantTypeCodeDataType.M_NONPROFIT_WITH_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 5: {
                    applicantTypeCode = ApplicantTypeCodeDataType.N_NONPROFIT_WITHOUT_501_C_3_IRS_STATUS_OTHER_THAN_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 6: {
                    applicantTypeCode = ApplicantTypeCodeDataType.Q_FOR_PROFIT_ORGANIZATION_OTHER_THAN_SMALL_BUSINESS;
                    break;
                }
                case 7: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    break;
                }
                case 8: {
                    applicantTypeCode = ApplicantTypeCodeDataType.I_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_FEDERALLY_RECOGNIZED;
                    break;
                }
                case 9: {
                    applicantTypeCode = ApplicantTypeCodeDataType.P_INDIVIDUAL;
                    break;
                }
                case 10: {
                    applicantTypeCode = ApplicantTypeCodeDataType.O_PRIVATE_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 11: {
                    applicantTypeCode = ApplicantTypeCodeDataType.R_SMALL_BUSINESS;
                    break;
                }
                case 14: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Socially and Economically Disadvantaged";
                    break;
                }
                case 15: {
                    applicantTypeCode = ApplicantTypeCodeDataType.X_OTHER_SPECIFY;
                    this.applicantTypeOtherSpecify = "Women owned";
                    break;
                }
                case 21: {
                    applicantTypeCode = ApplicantTypeCodeDataType.H_PUBLIC_STATE_CONTROLLED_INSTITUTION_OF_HIGHER_EDUCATION;
                    break;
                }
                case 22: {
                    applicantTypeCode = ApplicantTypeCodeDataType.B_COUNTY_GOVERNMENT;
                    break;
                }
                case 23: {
                    applicantTypeCode = ApplicantTypeCodeDataType.D_SPECIAL_DISTRICT_GOVERNMENT;
                    break;
                }
                case 24: {
                    applicantTypeCode = ApplicantTypeCodeDataType.G_INDEPENDENT_SCHOOL_DISTRICT;
                    break;
                }
                case 25: {
                    applicantTypeCode = ApplicantTypeCodeDataType.L_PUBLIC_INDIAN_HOUSING_AUTHORITY;
                    break;
                }
                case 26: {
                    applicantTypeCode = ApplicantTypeCodeDataType.J_INDIAN_NATIVE_AMERICAN_TRIBAL_GOVERNMENT_OTHER_THAN_FEDERALLY_RECOGNIZED;
                }
            }
            switch (i) {
                case 0: {
                    sf424V2.setApplicantTypeCode1(applicantTypeCode);
                    break;
                }
                case 1: {
                    sf424V2.setApplicantTypeCode2(applicantTypeCode);
                    break;
                }
                case 2: {
                    sf424V2.setApplicantTypeCode3(applicantTypeCode);
                }
            }
            if (this.applicantTypeOtherSpecify == null) continue;
            sf424V2.setApplicantTypeOtherSpecify(this.applicantTypeOtherSpecify);
        }
    }

    private SF424Document.SF424.StateReview.Enum getStateReviewCode() {
        Map<String, String> eoStateReview = this.s2sUtilService.getEOStateReview(this.pdDoc);
        SF424Document.SF424.StateReview.Enum stateType = null;
        String stateReviewData = null;
        this.strReview = eoStateReview.get("answer");
        if (this.strReview != null) {
            if (this.strReview.equals(ORGANIZATION_YNQ_ANSWER_YES)) {
                stateType = SF424Document.SF424.StateReview.A_THIS_APPLICATION_WAS_MADE_AVAILABLE_TO_THE_STATE_UNDER_THE_EXECUTIVE_ORDER_12372_PROCESS_FOR_REVIEW_ON;
            } else if (this.strReview.equals("N")) {
                stateReviewData = eoStateReview.get("stateReviewData");
                if (stateReviewData != null && "Not Covered".equals(stateReviewData)) {
                    stateType = SF424Document.SF424.StateReview.C_PROGRAM_IS_NOT_COVERED_BY_E_O_12372;
                } else if (stateReviewData != null && "Not Selected".equals(stateReviewData)) {
                    stateType = SF424Document.SF424.StateReview.B_PROGRAM_IS_SUBJECT_TO_E_O_12372_BUT_HAS_NOT_BEEN_SELECTED_BY_THE_STATE_FOR_REVIEW;
                }
            }
        }
        if (eoStateReview.get("reviewDate") != null) {
            this.stateReviewDate = eoStateReview.get("reviewDate");
        }
        return stateType;
    }

    private AttachedFileDataType[] getAttachedFileDataTypes() {
        ArrayList<AttachedFileDataType> attachedFileDataTypeList = new ArrayList<AttachedFileDataType>();
        AttachedFileDataType attachedFileDataType = null;
        for (Narrative narrative : this.pdDoc.getDevelopmentProposal().getNarratives()) {
            if (narrative.getNarrativeTypeCode() == null || Integer.parseInt(narrative.getNarrativeTypeCode()) != 41 || (attachedFileDataType = this.getAttachedFileType(narrative)) == null) continue;
            attachedFileDataTypeList.add(attachedFileDataType);
        }
        return attachedFileDataTypeList.toArray(new AttachedFileDataType[0]);
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        return this.getSF424Doc();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        SF424Document.SF424 sf424 = (SF424Document.SF424)xmlObject;
        SF424Document sfDocument = SF424Document.Factory.newInstance();
        sfDocument.setSF424(sf424);
        return sfDocument;
    }
}

