/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.generator.impl;

import gov.grants.apply.forms.sflllV10.LobbyingActivitiesDisclosureDocument;
import gov.grants.apply.forms.sflllV10.ReportDataType;
import gov.grants.apply.forms.sflllV10.ReportEntityDataType;
import gov.grants.apply.system.globalLibraryV10.HumanNameDataType;
import gov.grants.apply.system.globalLibraryV10.YesNoDataType;
import java.util.HashMap;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.impl.SFLLLBaseGenerator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class SFLLLV1_0Generator
extends SFLLLBaseGenerator {
    private DepartmentalPerson aorInfo;

    private LobbyingActivitiesDisclosureDocument getLobbyingActivitiesDisclosure() {
        LobbyingActivitiesDisclosureDocument lobbyingADDocument = LobbyingActivitiesDisclosureDocument.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure lobbyingDisclosure = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.Factory.newInstance();
        lobbyingDisclosure.setFormVersion("1.0");
        lobbyingDisclosure.setFederalActionType(LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalActionType.GRANT);
        lobbyingDisclosure.setFederalActionStatus(LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalActionStatus.BID_OFFER);
        lobbyingDisclosure.setReportType(ReportDataType.INITIAL_FILING);
        lobbyingDisclosure.setReportEntity(this.getReportEntity());
        lobbyingDisclosure.setFederalAgencyDepartment("");
        Sponsor sponsor = this.pdDoc.getDevelopmentProposal().getSponsor();
        if (sponsor != null) {
            if (sponsor.getSponsorName() != null) {
                if (sponsor.getSponsorName().length() > 40) {
                    lobbyingDisclosure.setFederalAgencyDepartment(sponsor.getSponsorName().substring(0, 40));
                } else {
                    lobbyingDisclosure.setFederalAgencyDepartment(sponsor.getSponsorName());
                }
            }
        } else {
            String primeSponsorCode = this.pdDoc.getDevelopmentProposal().getPrimeSponsorCode();
            if (primeSponsorCode != null) {
                BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
                HashMap<String, String> sponsorMap = new HashMap<String, String>();
                sponsorMap.put("sponsorCode", primeSponsorCode);
                Sponsor primeSponsor = (Sponsor)businessObjectService.findByPrimaryKey(Sponsor.class, sponsorMap);
                if (primeSponsor.getSponsorName() != null) {
                    if (primeSponsor.getSponsorName().length() > 40) {
                        lobbyingDisclosure.setFederalAgencyDepartment(primeSponsor.getSponsorName().substring(0, 40));
                    } else {
                        lobbyingDisclosure.setFederalAgencyDepartment(primeSponsor.getSponsorName());
                    }
                }
            }
        }
        lobbyingDisclosure.setFederalProgramName(this.getFedProgramName());
        lobbyingDisclosure.setLobbyingRegistrant(this.getLobbyingRegistrant());
        lobbyingDisclosure.setIndividualsPerformingServices(this.getIndividualsPerformingServices());
        lobbyingDisclosure.setSignatureBlock(this.getSignatureBlock());
        lobbyingADDocument.setLobbyingActivitiesDisclosure(lobbyingDisclosure);
        return lobbyingADDocument;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant getLobbyingRegistrant() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant lobbyingRegistrant = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.LobbyingRegistrant.Factory.newInstance();
        lobbyingRegistrant.setOrganizationName("N/A");
        return lobbyingRegistrant;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices getIndividualsPerformingServices() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices individualServices = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual individual = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual.Factory.newInstance();
        HumanNameDataType humanName = HumanNameDataType.Factory.newInstance();
        humanName.setFirstName("N/A");
        humanName.setLastName("N/A");
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual[] individualArray = new LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.IndividualsPerformingServices.Individual[1];
        individual.setName(humanName);
        individualArray[0] = individual;
        individualServices.setIndividualArray(individualArray);
        return individualServices;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName getFedProgramName() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName fedProgramName = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.FederalProgramName.Factory.newInstance();
        if (this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle() != null) {
            String announcementTitle = this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().length() > 120 ? this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle().substring(0, 120) : this.pdDoc.getDevelopmentProposal().getProgramAnnouncementTitle();
            fedProgramName.setFederalProgramDescription(announcementTitle);
        }
        fedProgramName.setCFDANumber(this.pdDoc.getDevelopmentProposal().getCfdaNumber());
        return fedProgramName;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity getReportEntity() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity reportEntity = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Factory.newInstance();
        reportEntity.setReportEntityType(ReportEntityDataType.PRIME);
        reportEntity.setReportEntityIsPrime(YesNoDataType.YES);
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Prime prime = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.ReportEntity.Prime.Factory.newInstance();
        Organization organization = null;
        organization = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
        if (organization != null) {
            if (organization.getOrganizationName() != null) {
                if (organization.getOrganizationName().length() > 60) {
                    prime.setOrganizationName(organization.getOrganizationName().substring(0, 60));
                } else {
                    prime.setOrganizationName(organization.getOrganizationName());
                }
            }
            if (organization.getCongressionalDistrict() != null) {
                if (organization.getCongressionalDistrict().length() > 6) {
                    prime.setCongressionalDistrict(organization.getCongressionalDistrict().substring(0, 6));
                } else {
                    prime.setCongressionalDistrict(organization.getCongressionalDistrict());
                }
            }
        }
        prime.setReportEntityType(ReportEntityDataType.PRIME);
        Rolodex rolodex = null;
        rolodex = this.pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex();
        prime.setAddress(this.globLibV10Generator.getAddressDataType(rolodex));
        reportEntity.setPrime(prime);
        return reportEntity;
    }

    private LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock getSignatureBlock() {
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock signatureBlock = LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure.SignatureBlock.Factory.newInstance();
        signatureBlock.setName(this.globLibV10Generator.getHumanNameDataType(this.aorInfo));
        if (this.aorInfo.getPrimaryTitle() != null) {
            if (this.aorInfo.getPrimaryTitle().length() > 45) {
                signatureBlock.setTitle(this.aorInfo.getPrimaryTitle().substring(0, 45));
            } else {
                signatureBlock.setTitle(this.aorInfo.getPrimaryTitle());
            }
        }
        signatureBlock.setSignature(this.aorInfo.getFullName());
        signatureBlock.setSignedDate(this.s2sUtilService.getCurrentCalendar());
        return signatureBlock;
    }

    @Override
    public XmlObject getFormObject(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        this.pdDoc = proposalDevelopmentDocument;
        this.aorInfo = this.s2sUtilService.getDepartmentalPerson(this.pdDoc);
        return this.getLobbyingActivitiesDisclosure();
    }

    public XmlObject getFormObject(XmlObject xmlObject) {
        LobbyingActivitiesDisclosureDocument lobbyingDisclosureDocument = LobbyingActivitiesDisclosureDocument.Factory.newInstance();
        LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure lobbyingActivitiesDisclosure = (LobbyingActivitiesDisclosureDocument.LobbyingActivitiesDisclosure)xmlObject;
        lobbyingDisclosureDocument.setLobbyingActivitiesDisclosure(lobbyingActivitiesDisclosure);
        return lobbyingDisclosureDocument;
    }
}

