/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.polling;

import gov.grants.apply.webservices.applicantintegrationservices_v1.ApplicationInformationType;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetApplicationListResponse;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sAppSubmission;
import org.kuali.kra.s2s.polling.MailInfo;
import org.kuali.kra.s2s.polling.SubmissionData;
import org.kuali.kra.s2s.service.S2SService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.mail.MailMessage;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.exception.InvalidAddressException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.MailService;

public class S2SPollingTask {
    private static final Log LOG = LogFactory.getLog(S2SPollingTask.class);
    private final List<String> lstStatus = new ArrayList<String>();
    private final Map<String, String> sortMsgKeyMap = new Hashtable<String, String>();
    private DateTimeService dateTimeService = null;
    private BusinessObjectService businessObjectService = null;
    private S2SService s2SService = null;
    private String stopPollInterval;
    private String mailInterval;
    private Map<String, String> statusMap = new HashMap<String, String>();
    private List<MailInfo> mailInfoList = new ArrayList<MailInfo>();
    private static final String KEY_PROPOSAL_NUMBER = "proposalNumber";
    private static final String KEY_STATUS = "status";
    private static final String DATE_FORMAT = "dd-MMM-yyyy hh:mm a";
    private static final String SORT_ID_A = "A";
    private static final String SORT_ID_B = "B";
    private static final String SORT_ID_C = "C";
    private static final String SORT_ID_D = "D";
    private static final String SORT_ID_E = "E";
    private static final String SORT_ID_F = "F";
    private static final String SORT_ID_Z = "Z";

    public S2SPollingTask() {
        this.lstStatus.add("Submitted to S2S".toUpperCase());
        this.lstStatus.add("Receiving".toUpperCase());
        this.lstStatus.add("Received".toUpperCase());
        this.lstStatus.add("Processing".toUpperCase());
        this.lstStatus.add("Validated".toUpperCase());
        this.lstStatus.add("Received by Agency".toUpperCase());
        this.lstStatus.add("Agency Tracking Number Assigned".toUpperCase());
        this.lstStatus.add("REJECTED_WITH_ERRORS".toUpperCase());
        this.lstStatus.add("S2S Submission Error".toUpperCase());
        this.sortMsgKeyMap.put(SORT_ID_A, "Following proposals DID NOT validate at Grants.Gov");
        this.sortMsgKeyMap.put(SORT_ID_B, "Following proposals are at an Unknown status at Grants.Gov");
        this.sortMsgKeyMap.put(SORT_ID_C, "Following proposals will be dropped from the notification emails in next 24 hours");
        this.sortMsgKeyMap.put(SORT_ID_D, "Following submissions status has not changed");
        this.sortMsgKeyMap.put(SORT_ID_E, "Following submissions status has changed");
        this.sortMsgKeyMap.put(SORT_ID_F, "Error occured while retrieving submissions");
        this.sortMsgKeyMap.put(SORT_ID_Z, "");
    }

    private boolean getSubmissionDateValidity(S2sAppSubmission appSubmission) {
        Calendar lastModifiedDate = this.dateTimeService.getCurrentCalendar();
        long stopPollingIntervalMillis = (long)(Integer.parseInt(this.getStopPollInterval()) * 60 * 60) * 1000L;
        if (appSubmission.getLastModifiedDate() != null) {
            lastModifiedDate.setTimeInMillis(appSubmission.getLastModifiedDate().getTime());
        } else {
            lastModifiedDate.setTimeInMillis(appSubmission.getReceivedDate().getTime());
        }
        return this.dateTimeService.getCurrentDate().getTime() - lastModifiedDate.getTimeInMillis() < stopPollingIntervalMillis;
    }

    private Map<String, SubmissionData> populatePollingList() {
        HashMap<String, String> submissionMap = new HashMap<String, String>();
        Collection submissionList = new ArrayList();
        for (String status : this.statusMap.values()) {
            submissionMap.clear();
            submissionMap.put(KEY_STATUS, status);
            if (submissionList == null) {
                submissionList = this.businessObjectService.findMatching(S2sAppSubmission.class, submissionMap);
                continue;
            }
            submissionList.addAll(this.businessObjectService.findMatching(S2sAppSubmission.class, submissionMap));
        }
        HashMap<String, SubmissionData> pollingList = new HashMap<String, SubmissionData>();
        for (S2sAppSubmission appSubmission : submissionList) {
            SubmissionData submissionData;
            if (pollingList.get(appSubmission.getProposalNumber()) != null) {
                if (appSubmission.getSubmissionNumber() <= ((SubmissionData)pollingList.get(appSubmission.getProposalNumber())).getS2sAppSubmission().getSubmissionNumber() || !this.getSubmissionDateValidity(appSubmission)) continue;
                submissionData = new SubmissionData();
                submissionData.setS2sAppSubmission(appSubmission);
                pollingList.put(appSubmission.getProposalNumber(), submissionData);
                continue;
            }
            if (!this.getSubmissionDateValidity(appSubmission)) continue;
            submissionData = new SubmissionData();
            submissionData.setS2sAppSubmission(appSubmission);
            pollingList.put(appSubmission.getProposalNumber(), submissionData);
        }
        return pollingList;
    }

    public void execute() {
        SubmissionData localSubInfo;
        LOG.info((Object)("Executing polling schedule for status -" + this.statusMap.values() + ":" + this.stopPollInterval));
        Map<String, SubmissionData> pollingList = this.populatePollingList();
        int appListSize = pollingList.size();
        Iterator<SubmissionData> submissions = pollingList.values().iterator();
        LinkedHashMap<String, Vector<SubmissionData>> htMails = new LinkedHashMap<String, Vector<SubmissionData>>();
        Vector<SubmissionData> submList = new Vector<SubmissionData>();
        Timestamp[] lastNotiDateArr = new Timestamp[appListSize];
        while (submissions.hasNext()) {
            SubmissionData localSubInfo2 = submissions.next();
            S2sAppSubmission appSubmission = localSubInfo2.getS2sAppSubmission();
            Timestamp oldLastNotiDate = appSubmission.getLastNotifiedDate();
            Timestamp today = this.dateTimeService.getCurrentTimestamp();
            boolean updateFlag = false;
            boolean sendEmailFlag = false;
            boolean statusChanged = false;
            GetApplicationListResponse applicationListResponse = null;
            try {
                ProposalDevelopmentDocument pdDoc = this.getProposalDevelopmentDocument(appSubmission.getProposalNumber());
                if (pdDoc != null) {
                    applicationListResponse = this.s2SService.fetchApplicationListResponse(pdDoc);
                }
                if (applicationListResponse.getApplicationInformation() == null || applicationListResponse.getApplicationInformation().size() == 0) {
                    statusChanged = this.s2SService.checkForSubmissionStatusChange(pdDoc, appSubmission);
                    if (!statusChanged && appSubmission.getComments().equals("No response from S2S Server")) {
                        localSubInfo2.setSortId(SORT_ID_F);
                        sendEmailFlag = true;
                    }
                } else {
                    ApplicationInformationType ggApplication = applicationListResponse.getApplicationInformation().get(0);
                    if (ggApplication != null) {
                        localSubInfo2.setAcType('U');
                        statusChanged = !appSubmission.getStatus().equalsIgnoreCase(ggApplication.getGrantsGovApplicationStatus().value());
                        this.s2SService.populateAppSubmission(pdDoc, appSubmission, ggApplication);
                    }
                }
            }
            catch (S2SException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                appSubmission.setComments(e.getMessage());
                localSubInfo2.setSortId(SORT_ID_F);
                sendEmailFlag = true;
            }
            String sortId = SORT_ID_Z;
            Timestamp lastNotifiedDate = appSubmission.getLastNotifiedDate();
            Timestamp statusChangedDate = appSubmission.getLastModifiedDate();
            Calendar lastNotifiedDateCal = this.dateTimeService.getCurrentCalendar();
            if (lastNotifiedDate != null) {
                lastNotifiedDateCal.setTimeInMillis(lastNotifiedDate.getTime());
            }
            Calendar statusChangedDateCal = this.dateTimeService.getCurrentCalendar();
            if (statusChangedDate != null) {
                statusChangedDateCal.setTimeInMillis(statusChangedDate.getTime());
            }
            Calendar recDateCal = this.dateTimeService.getCurrentCalendar();
            recDateCal.setTimeInMillis(appSubmission.getReceivedDate().getTime());
            if (statusChanged) {
                if (appSubmission.getStatus().indexOf("S2S Submission Error") != -1) {
                    updateFlag = true;
                    sendEmailFlag = true;
                    sortId = SORT_ID_A;
                } else if (!this.lstStatus.contains(appSubmission.getStatus().trim().toUpperCase())) {
                    updateFlag = false;
                    sendEmailFlag = true;
                    sortId = SORT_ID_B;
                } else {
                    updateFlag = true;
                    sendEmailFlag = true;
                    sortId = SORT_ID_E;
                }
            } else {
                long lastModifiedTime = statusChangedDate == null ? appSubmission.getReceivedDate().getTime() : statusChangedDate.getTime();
                long lastNotifiedTime = lastNotifiedDate == null ? lastModifiedTime : lastNotifiedDate.getTime();
                long mailDelta = today.getTime() - lastNotifiedTime;
                long delta = today.getTime() - lastModifiedTime;
                long stopPollDiff = (Integer.parseInt(this.getStopPollInterval()) == 0 ? 4320L : (long)Integer.parseInt(this.getStopPollInterval())) - delta / 3600000L;
                if (mailDelta / 60000L >= (long)Integer.parseInt(this.getMailInterval())) {
                    if (localSubInfo2.getSortId() == null) {
                        if (stopPollDiff <= 24L) {
                            sortId = SORT_ID_C;
                        } else {
                            sortId = SORT_ID_D;
                            this.sortMsgKeyMap.put(SORT_ID_D, "Following submissions status has not been changed in " + this.getMailInterval() + " minutes");
                        }
                    }
                    updateFlag = true;
                    sendEmailFlag = true;
                }
            }
            if (sendEmailFlag) {
                HashMap<String, String> proposalMap = new HashMap<String, String>();
                proposalMap.put(KEY_PROPOSAL_NUMBER, appSubmission.getProposalNumber());
                DevelopmentProposal developmentProposal = (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, proposalMap);
                String dunsNum = developmentProposal.getApplicantOrganization().getOrganization().getDunsNumber() != null ? developmentProposal.getApplicantOrganization().getOrganization().getDunsNumber() : developmentProposal.getApplicantOrganization().getOrganizationId();
                Vector<SubmissionData> mailGrpForDunNum = new Vector<SubmissionData>();
                mailGrpForDunNum.add(localSubInfo2);
                htMails.put(dunsNum, mailGrpForDunNum);
                appSubmission.setLastNotifiedDate(today);
            }
            if (localSubInfo2.getSortId() == null) {
                localSubInfo2.setSortId(sortId);
            }
            if (!updateFlag) continue;
            submList.addElement(localSubInfo2);
            lastNotiDateArr[submList.size() - 1] = oldLastNotiDate;
        }
        try {
            this.sendMail(htMails);
        }
        catch (InvalidAddressException ex) {
            LOG.error((Object)"Mail sending failed");
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
            int size = submList.size();
            for (int i = 0; i < size; ++i) {
                localSubInfo = submList.elementAt(i);
                localSubInfo.getS2sAppSubmission().setLastNotifiedDate(lastNotiDateArr[i]);
            }
        }
        catch (MessagingException me) {
            LOG.error((Object)"Mail sending failed");
            LOG.error((Object)me.getMessage(), (Throwable)me);
            int size = submList.size();
            for (int i = 0; i < size; ++i) {
                localSubInfo = submList.elementAt(i);
                localSubInfo.getS2sAppSubmission().setLastNotifiedDate(lastNotiDateArr[i]);
            }
        }
        this.saveSubmissionDetails(submList);
    }

    private ProposalDevelopmentDocument getProposalDevelopmentDocument(String proposalNumber) {
        ProposalDevelopmentDocument pdDoc = null;
        HashMap<String, String> proposalMap = new HashMap<String, String>();
        proposalMap.put(KEY_PROPOSAL_NUMBER, proposalNumber);
        DevelopmentProposal developmentProposal = (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, proposalMap);
        if (developmentProposal != null) {
            pdDoc = developmentProposal.getProposalDocument();
        }
        return pdDoc;
    }

    private void saveSubmissionDetails(Vector<SubmissionData> submList) {
        if (submList != null) {
            for (SubmissionData submissionData : submList) {
                S2sAppSubmission s2sAppSubmission = submissionData.getS2sAppSubmission();
                s2sAppSubmission.setUpdateUserSet(true);
                if (s2sAppSubmission.getStatus().equalsIgnoreCase("PURGED")) continue;
                this.businessObjectService.save((PersistableBusinessObject)s2sAppSubmission);
            }
        }
    }

    private void sendMail(HashMap<String, Vector<SubmissionData>> htMails) throws InvalidAddressException, MessagingException {
        MailService mailService = KraServiceLocator.getService(MailService.class);
        if (htMails.isEmpty()) {
            return;
        }
        List<MailInfo> mailList = this.getMailInfoList();
        for (MailInfo mailInfo : mailList) {
            String dunsNum = mailInfo.getDunsNumber();
            Vector<SubmissionData> propList = htMails.get(dunsNum);
            if (propList == null) continue;
            htMails.remove(dunsNum);
            MailMessage mailMessage = this.parseNGetMailAttr(propList, mailInfo);
            if (mailMessage == null) continue;
            mailService.sendMessage(mailMessage);
        }
        if (mailList.size() > 0 && !htMails.isEmpty()) {
            Iterator<String> it = htMails.keySet().iterator();
            while (it.hasNext()) {
                MailInfo mailInfo;
                Vector<SubmissionData> nonDunsPropList = htMails.get(it.next());
                MailMessage mailMessage = this.parseNGetMailAttr(nonDunsPropList, mailInfo = mailList.get(0));
                if (mailMessage == null) continue;
                mailService.sendMessage(mailMessage);
                LOG.debug((Object)("Sent mail with default duns to " + mailMessage.getToAddresses() + " Subject as " + mailMessage.getSubject() + " Message as " + mailMessage.getMessage()));
            }
        }
    }

    private MailMessage parseNGetMailAttr(Vector<SubmissionData> propList, MailInfo mailInfo) {
        if (propList == null || propList.isEmpty()) {
            return null;
        }
        MailMessage mailMessage = mailInfo.getMailMessage();
        StringBuffer message = new StringBuffer(mailMessage.getMessage());
        for (SubmissionData submissionData : propList) {
            S2sAppSubmission appSubmission = submissionData.getS2sAppSubmission();
            Timestamp lastNotifiedDate = appSubmission.getLastNotifiedDate();
            Timestamp statusChangedDate = appSubmission.getLastModifiedDate();
            Calendar lastNotifiedDateCal = this.dateTimeService.getCurrentCalendar();
            if (lastNotifiedDate != null) {
                lastNotifiedDateCal.setTimeInMillis(lastNotifiedDate.getTime());
            }
            Calendar statusChangedDateCal = this.dateTimeService.getCurrentCalendar();
            if (statusChangedDate != null) {
                statusChangedDateCal.setTimeInMillis(statusChangedDate.getTime());
            }
            Calendar recDateCal = this.dateTimeService.getCurrentCalendar();
            recDateCal.setTimeInMillis(appSubmission.getReceivedDate().getTime());
            long lastModifiedTime = statusChangedDate == null ? appSubmission.getReceivedDate().getTime() : statusChangedDate.getTime();
            Timestamp today = this.dateTimeService.getCurrentTimestamp();
            long delta = today.getTime() - lastModifiedTime;
            double deltaHrs = (double)Math.round((double)delta / 3600000.0 * Math.pow(10.0, 2.0)) / 100.0;
            int days = 0;
            int hrs = 0;
            if (deltaHrs > 0.0) {
                days = (int)deltaHrs / 24;
                hrs = (int)((double)Math.round(deltaHrs % 24.0 * Math.pow(10.0, 2.0)) / 100.0);
            }
            if (propList.size() > 0) {
                SubmissionData prevSubmissionData = propList.elementAt(propList.size() - 1);
                if (!prevSubmissionData.getSortId().equals(submissionData.getSortId())) {
                    message.append("\n\n");
                    message.append(this.sortMsgKeyMap.get(submissionData.getSortId()));
                    message.append("\n____________________________________________________");
                }
            } else {
                message.append("\n\n");
                message.append(this.sortMsgKeyMap.get(submissionData.getSortId()));
                message.append("\n____________________________________________________");
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            message.append('\n');
            message.append("Proposal Number : " + appSubmission.getProposalNumber() + "\n");
            message.append("Received Date : ");
            message.append(dateFormat.format(appSubmission.getReceivedDate()));
            message.append('\n');
            message.append("Grants.Gov Tracking Id : ");
            message.append(appSubmission.getGgTrackingId());
            message.append('\n');
            String agTrackId = appSubmission.getAgencyTrackingId() == null ? "Not updated yet" : appSubmission.getAgencyTrackingId();
            message.append("Agency Tracking Id : ");
            message.append(agTrackId);
            message.append('\n');
            message.append("Current Status : ");
            message.append(appSubmission.getStatus());
            message.append('\n');
            String stChnageDate = appSubmission.getLastModifiedDate() == null ? "Not updated yet" : dateFormat.format(appSubmission.getLastModifiedDate());
            message.append("Last Status Change : " + stChnageDate + "\t *** " + days + " day(s) and " + hrs + " hour(s) ***\n");
            message.append('\n');
        }
        message.append('\n');
        message.append(mailInfo.getFooter());
        mailMessage.setMessage(message.toString());
        return mailMessage;
    }

    public String getStopPollInterval() {
        return this.stopPollInterval;
    }

    public void setStopPollInterval(String stopPollInterval) {
        this.stopPollInterval = stopPollInterval;
    }

    public Map<String, String> getStatusMap() {
        return this.statusMap;
    }

    public void setStatusMap(Map<String, String> statusMap) {
        this.statusMap = statusMap;
    }

    public List<MailInfo> getMailInfoList() {
        return this.mailInfoList;
    }

    public void setMailInfoList(List<MailInfo> mailInfoList) {
        this.mailInfoList = mailInfoList;
    }

    public String getMailInterval() {
        return this.mailInterval;
    }

    public void setMailInterval(String mailInterval) {
        this.mailInterval = mailInterval;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void sets2SService(S2SService s2SService) {
        this.s2SService = s2SService;
    }
}

