/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.QueryList;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.BudgetCategoryMap;
import org.kuali.kra.budget.core.BudgetCategoryMapping;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItemCalculatedAmount;
import org.kuali.kra.budget.nonpersonnel.BudgetRateAndBase;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPerson;
import org.kuali.kra.budget.personnel.BudgetPersonnelCalculatedAmount;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.personnel.TbnPerson;
import org.kuali.kra.budget.rates.RateClass;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.budget.modular.BudgetModularIdc;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.generator.bo.BudgetPeriodInfo;
import org.kuali.kra.s2s.generator.bo.BudgetSummaryInfo;
import org.kuali.kra.s2s.generator.bo.CompensationInfo;
import org.kuali.kra.s2s.generator.bo.CostInfo;
import org.kuali.kra.s2s.generator.bo.EquipmentInfo;
import org.kuali.kra.s2s.generator.bo.IndirectCostDetails;
import org.kuali.kra.s2s.generator.bo.IndirectCostInfo;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.generator.bo.OtherDirectCostInfo;
import org.kuali.kra.s2s.generator.bo.OtherPersonnelInfo;
import org.kuali.kra.s2s.service.S2SBudgetCalculatorService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.RolodexService;
import org.kuali.kra.service.SponsorService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;

public class S2SBudgetCalculatorServiceImpl
implements S2SBudgetCalculatorService {
    public static final String KEY_MAPPING_NAME = "mappingName";
    public static final String KEY_TARGET_CATEGORY_CODE = "targetCategoryCode";
    private static final int MAX_KEY_PERSON_COUNT = 8;
    private static final String CATEGORY_TYPE_OTHER_DIRECT_COST = "O";
    private static final String LASALARIES = "LASALARIES";
    private static final String PERSONNEL_TYPE_GRAD = "Grad";
    private static final String PERSONNEL_TYPE_POSTDOC = "PostDoc";
    private static final String PERSONNEL_TYPE_UNDERGRAD = "UnderGrad";
    private static final String PERSONNEL_TYPE_SEC = "Sec";
    private static final String PERSONNEL_TYPE_OTHER = "Other";
    private static final String PERSONNEL_TYPE_OTHER_PROFESSIONALS = "Other Professionals";
    private static final String PERSONNEL_TYPE_ALLOCATED_ADMIN_SUPPORT = "Allocated Admin Support";
    private static final String ROLE_GRADUATE_STUDENTS = "Graduate Students";
    private static final String ROLE_POST_DOCTORAL_ASSOCIATES = "Post Doctoral Associates";
    private static final String ROLE_GRADUATE_UNDERGRADUATE_STUDENTS = "Undergraduate Students";
    private static final String ROLE_GRADUATE_SECRETARIAL_OR_CLERICAL = "Secretarial / Clerical";
    private static final String ROLE_GRADUATE_OTHER = "Other";
    private static final String ROLE_GRADUATE_OTHER_PROFESSIONALS = "Other Professionals";
    private static final String ROLE_GRADUATE_ALLOCATED_ADMIN_SUPPORT = "Allocated Admin Support";
    private static final String TARGET_CATEGORY_CODE_01 = "01";
    private static final String OTHER_DIRECT_COSTS = "Other Direct Costs";
    private static final String ALL_OTHER_COSTS = "All Other Costs";
    private static final String DESCRIPTION = "Description";
    private static final String DESCRIPTION_LA = "LA ";
    private static final String KEYPERSON_CO_PD_PI = "CO-PD/PI";
    private static final String NID_PD_PI = "PD/PI";
    private static final String NID_CO_PD_PI = "CO-INVESTIGATOR";
    private static final String KEYPERSON_OTHER = "Other (Specify)";
    private static final Log LOG = LogFactory.getLog(S2SBudgetCalculatorServiceImpl.class);
    private static final String PRINCIPAL_INVESTIGATOR_ROLE = "PD/PI";
    private static final Object ONE_STRING = "1";
    private BusinessObjectService businessObjectService;
    private KcPersonService kcPersonService;
    private S2SUtilService s2SUtilService;
    private RolodexService rolodexService;
    private ParameterService parameterService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public boolean isBudgetSummaryCostShareParameterValueEnabled(Budget budget) {
        return budget.getSubmitCostSharingFlag();
    }

    @Override
    public BudgetSummaryInfo getBudgetInfo(ProposalDevelopmentDocument pdDoc, List<BudgetPeriodInfo> budgetPeriodInfos) throws S2SException {
        BudgetDocument budgetDocument = this.getFinalBudgetVersion(pdDoc);
        Budget budget = budgetDocument == null ? null : budgetDocument.getBudget();
        BudgetSummaryInfo budgetSummaryInfo = new BudgetSummaryInfo();
        if (budget == null) {
            return budgetSummaryInfo;
        }
        budgetSummaryInfo.setBudgetPeriods(budgetPeriodInfos);
        budgetSummaryInfo.setCumTotalCosts(budget.getTotalCost());
        budgetSummaryInfo.setCumTotalIndirectCosts(budget.getTotalIndirectCost());
        budgetSummaryInfo.setCumTotalDirectCosts(budget.getTotalDirectCost());
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            budgetSummaryInfo.setCumTotalCostSharing(budget.getCostSharingAmount());
        }
        BudgetDecimal totalDirectCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal totalIndirectCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal lineItemCost = BudgetDecimal.ZERO;
        BudgetDecimal lineItemCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal fringeCost = BudgetDecimal.ZERO;
        BudgetDecimal fringeCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal budgetDetailsCost = BudgetDecimal.ZERO;
        BudgetDecimal budgetDetailsCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal budgetDetailsFringeCost = BudgetDecimal.ZERO;
        BudgetDecimal budgetDetailsFringeCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal totPersFunds = BudgetDecimal.ZERO;
        BudgetDecimal totPersNonFunds = BudgetDecimal.ZERO;
        String budgetCategoryTypePersonnel = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetBudgetCategoryTypePersonnel");
        String rateTypeSupportStaffSalaries = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateTypeSupportStaffSalaries");
        String rateTypeAdministrativeSalaries = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateTypeAdministrativeSalaries");
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                totalDirectCostSharing = (BudgetDecimal)totalDirectCostSharing.add(lineItem.getCostSharingAmount());
                if (lineItem.getBudgetCategory().getBudgetCategoryType().getBudgetCategoryTypeCode().equals(budgetCategoryTypePersonnel)) {
                    lineItemCost = (BudgetDecimal)lineItemCost.add(lineItem.getLineItemCost());
                    if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                        lineItemCostSharingAmount = (BudgetDecimal)lineItemCostSharingAmount.add(lineItem.getCostSharingAmount());
                    }
                }
                for (BudgetLineItemCalculatedAmount lineItemCalAmt : lineItem.getBudgetLineItemCalculatedAmounts()) {
                    lineItemCalAmt.refreshReferenceObject("rateClass");
                    if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                        if (lineItemCalAmt.getRateClass().getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) {
                            totalIndirectCostSharing = (BudgetDecimal)totalIndirectCostSharing.add(lineItemCalAmt.getCalculatedCostSharing());
                        } else {
                            totalDirectCostSharing = (BudgetDecimal)totalDirectCostSharing.add(lineItemCalAmt.getCalculatedCostSharing());
                        }
                    }
                    if ((lineItemCalAmt.getRateClassCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassCodeEmployeeBenefits")) && !lineItemCalAmt.getRateTypeCode().equals(rateTypeSupportStaffSalaries) || lineItemCalAmt.getRateClassCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassCodeVacation")) && !lineItemCalAmt.getRateTypeCode().equals(rateTypeAdministrativeSalaries)) && lineItem.getBudgetCategory().getBudgetCategoryType().getBudgetCategoryTypeCode().equals(budgetCategoryTypePersonnel)) {
                        fringeCost = (BudgetDecimal)fringeCost.add(lineItemCalAmt.getCalculatedCost());
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            fringeCostSharingAmount = (BudgetDecimal)fringeCostSharingAmount.add(lineItemCalAmt.getCalculatedCostSharing());
                        }
                    }
                    if (lineItemCalAmt.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeLabAllocationSalaries"))) {
                        budgetDetailsCost = (BudgetDecimal)budgetDetailsCost.add(lineItemCalAmt.getCalculatedCost());
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            budgetDetailsCostSharingAmount = (BudgetDecimal)budgetDetailsCostSharingAmount.add(lineItemCalAmt.getCalculatedCostSharing());
                        }
                    }
                    if ((!lineItemCalAmt.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeEmployeeBenefits")) || !lineItemCalAmt.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!lineItemCalAmt.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeVacation")) || !lineItemCalAmt.getRateTypeCode().equals(rateTypeAdministrativeSalaries))) continue;
                    budgetDetailsFringeCost = (BudgetDecimal)budgetDetailsFringeCost.add(lineItemCalAmt.getCalculatedCost());
                    if (!this.canBudgetLineItemCostSharingInclude(budget, lineItem)) continue;
                    budgetDetailsFringeCostSharingAmount = (BudgetDecimal)budgetDetailsFringeCostSharingAmount.add(lineItemCalAmt.getCalculatedCostSharing());
                }
            }
        }
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            budgetSummaryInfo.setCumTotalDirectCostSharing(totalDirectCostSharing);
            budgetSummaryInfo.setCumTotalIndirectCostSharing(totalIndirectCostSharing);
        }
        totPersFunds = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)((BudgetDecimal)totPersFunds.add(lineItemCost)).add(fringeCost)).add(budgetDetailsCost)).add(budgetDetailsFringeCost);
        totPersNonFunds = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)((BudgetDecimal)totPersNonFunds.add(lineItemCostSharingAmount)).add(fringeCostSharingAmount)).add(budgetDetailsCostSharingAmount)).add(budgetDetailsFringeCostSharingAmount);
        budgetSummaryInfo.setCumTotalNonFundsForPersonnel(totPersNonFunds);
        budgetSummaryInfo.setCumTotalFundsForPersonnel(totPersFunds);
        OtherDirectCostInfo otherDirectCostInfo = new OtherDirectCostInfo();
        List<Object> cvOtherDirectCost = new ArrayList();
        List<Object> cvOtherCosts = new ArrayList();
        BudgetDecimal cumAlterations = BudgetDecimal.ZERO;
        BudgetDecimal cumConsultants = BudgetDecimal.ZERO;
        BudgetDecimal cumMaterials = BudgetDecimal.ZERO;
        BudgetDecimal cumPubs = BudgetDecimal.ZERO;
        BudgetDecimal cumSubAward = BudgetDecimal.ZERO;
        BudgetDecimal cumComputer = BudgetDecimal.ZERO;
        BudgetDecimal cumEquipRental = BudgetDecimal.ZERO;
        BudgetDecimal cumAll = BudgetDecimal.ZERO;
        BudgetDecimal cumOtherType1 = BudgetDecimal.ZERO;
        BudgetDecimal cumPartStipends = BudgetDecimal.ZERO;
        BudgetDecimal cumPartSubsistence = BudgetDecimal.ZERO;
        BudgetDecimal cumPartTuition = BudgetDecimal.ZERO;
        BudgetDecimal cumPartOther = BudgetDecimal.ZERO;
        BudgetDecimal cumPartTravel = BudgetDecimal.ZERO;
        int cumParticipantCount = 0;
        BudgetDecimal cumAlterationsCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumConsultantsCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumMaterialsCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumPubsCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumSubAwardCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumComputerCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumEquipRentalCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumAllCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumOtherType1CostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumPartStipendsCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumPartSubsistenceCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumPartTuitionCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumPartOtherCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal cumPartTravelCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal participantTotalCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal totalDomesticTravel = BudgetDecimal.ZERO;
        BudgetDecimal totalForeignTravel = BudgetDecimal.ZERO;
        BudgetDecimal totalDomesticTravelNonFund = BudgetDecimal.ZERO;
        BudgetDecimal totalForeignTravelNonFund = BudgetDecimal.ZERO;
        BudgetDecimal cumTotalEquipFund = BudgetDecimal.ZERO;
        BudgetDecimal cumTotalEquipNonFund = BudgetDecimal.ZERO;
        BudgetDecimal totCountOtherPersonnel = BudgetDecimal.ZERO;
        if (budgetPeriodInfos != null) {
            for (BudgetPeriodInfo budgetPeriodInfo : budgetPeriodInfos) {
                cvOtherDirectCost = budgetPeriodInfo.getOtherDirectCosts();
                otherDirectCostInfo = (OtherDirectCostInfo)cvOtherDirectCost.get(0);
                cumAlterations = (BudgetDecimal)cumAlterations.add(otherDirectCostInfo.getAlterations());
                cumConsultants = (BudgetDecimal)cumConsultants.add(otherDirectCostInfo.getConsultants());
                cumMaterials = (BudgetDecimal)cumMaterials.add(otherDirectCostInfo.getmaterials());
                cumPubs = (BudgetDecimal)cumPubs.add(otherDirectCostInfo.getpublications());
                cumSubAward = (BudgetDecimal)cumSubAward.add(otherDirectCostInfo.getsubAwards());
                cumComputer = (BudgetDecimal)cumComputer.add(otherDirectCostInfo.getcomputer());
                cumEquipRental = (BudgetDecimal)cumEquipRental.add(otherDirectCostInfo.getEquipRental());
                cumAll = (BudgetDecimal)cumAll.add(otherDirectCostInfo.gettotalOtherDirect());
                cumPartStipends = (BudgetDecimal)cumPartStipends.add(otherDirectCostInfo.getPartStipends() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartStipends());
                cumPartTravel = (BudgetDecimal)cumPartTravel.add(otherDirectCostInfo.getPartTravel() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartTravel());
                cumPartSubsistence = (BudgetDecimal)cumPartSubsistence.add(otherDirectCostInfo.getPartSubsistence() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartSubsistence());
                cumPartTuition = (BudgetDecimal)cumPartTuition.add(otherDirectCostInfo.getPartTuition() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartTuition());
                cumPartOther = (BudgetDecimal)cumPartOther.add(otherDirectCostInfo.getPartOther() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartOther());
                cumParticipantCount += otherDirectCostInfo.getParticpantTotalCount() == 0 ? 0 : otherDirectCostInfo.getParticpantTotalCount();
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    cumAlterationsCostSharing = (BudgetDecimal)cumAlterationsCostSharing.add(otherDirectCostInfo.getAlterationsCostSharing());
                    cumConsultantsCostSharing = (BudgetDecimal)cumConsultantsCostSharing.add(otherDirectCostInfo.getConsultantsCostSharing());
                    cumMaterialsCostSharing = (BudgetDecimal)cumMaterialsCostSharing.add(otherDirectCostInfo.getMaterialsCostSharing());
                    cumPubsCostSharing = (BudgetDecimal)cumPubsCostSharing.add(otherDirectCostInfo.getPublicationsCostSharing());
                    cumSubAwardCostSharing = (BudgetDecimal)cumSubAwardCostSharing.add(otherDirectCostInfo.getSubAwardsCostSharing());
                    cumComputerCostSharing = (BudgetDecimal)cumComputerCostSharing.add(otherDirectCostInfo.getComputerCostSharing());
                    cumEquipRentalCostSharing = (BudgetDecimal)cumEquipRentalCostSharing.add(otherDirectCostInfo.getEquipRentalCostSharing());
                    cumAllCostSharing = (BudgetDecimal)cumAllCostSharing.add(otherDirectCostInfo.getTotalOtherDirectCostSharing());
                    cumPartStipendsCostSharing = (BudgetDecimal)cumPartStipendsCostSharing.add(otherDirectCostInfo.getPartStipendsCostSharing() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartStipendsCostSharing());
                    cumPartTravelCostSharing = (BudgetDecimal)cumPartTravelCostSharing.add(otherDirectCostInfo.getPartTravelCostSharing() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartTravelCostSharing());
                    cumPartSubsistenceCostSharing = (BudgetDecimal)cumPartSubsistenceCostSharing.add(otherDirectCostInfo.getPartSubsistenceCostSharing() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartSubsistenceCostSharing());
                    cumPartTuitionCostSharing = (BudgetDecimal)cumPartTuitionCostSharing.add(otherDirectCostInfo.getPartTuitionCostSharing() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartTuitionCostSharing());
                    cumPartOtherCostSharing = (BudgetDecimal)cumPartOtherCostSharing.add(otherDirectCostInfo.getPartOtherCostSharing() == null ? BudgetDecimal.ZERO : otherDirectCostInfo.getPartOtherCostSharing());
                } else {
                    cumAlterationsCostSharing = (BudgetDecimal)cumAlterationsCostSharing.add(BudgetDecimal.ZERO);
                    cumConsultantsCostSharing = (BudgetDecimal)cumConsultantsCostSharing.add(BudgetDecimal.ZERO);
                    cumMaterialsCostSharing = (BudgetDecimal)cumMaterialsCostSharing.add(BudgetDecimal.ZERO);
                    cumPubsCostSharing = (BudgetDecimal)cumPubsCostSharing.add(BudgetDecimal.ZERO);
                    cumSubAwardCostSharing = (BudgetDecimal)cumSubAwardCostSharing.add(BudgetDecimal.ZERO);
                    cumComputerCostSharing = (BudgetDecimal)cumComputerCostSharing.add(BudgetDecimal.ZERO);
                    cumEquipRentalCostSharing = (BudgetDecimal)cumEquipRentalCostSharing.add(BudgetDecimal.ZERO);
                    cumAllCostSharing = (BudgetDecimal)cumAllCostSharing.add(BudgetDecimal.ZERO);
                    cumPartStipendsCostSharing = (BudgetDecimal)cumPartStipendsCostSharing.add(BudgetDecimal.ZERO);
                    cumPartTravelCostSharing = (BudgetDecimal)cumPartTravelCostSharing.add(BudgetDecimal.ZERO);
                    cumPartSubsistenceCostSharing = (BudgetDecimal)cumPartSubsistenceCostSharing.add(BudgetDecimal.ZERO);
                    cumPartTuitionCostSharing = (BudgetDecimal)cumPartTuitionCostSharing.add(BudgetDecimal.ZERO);
                    cumPartOtherCostSharing = (BudgetDecimal)cumPartOtherCostSharing.add(BudgetDecimal.ZERO);
                }
                totalDomesticTravel = (BudgetDecimal)totalDomesticTravel.add(budgetPeriodInfo.getDomesticTravelCost());
                totalForeignTravel = (BudgetDecimal)totalForeignTravel.add(budgetPeriodInfo.getForeignTravelCost());
                totalDomesticTravelNonFund = (BudgetDecimal)totalDomesticTravelNonFund.add(budgetPeriodInfo.getDomesticTravelCostSharing());
                totalForeignTravelNonFund = (BudgetDecimal)totalForeignTravelNonFund.add(budgetPeriodInfo.getForeignTravelCostSharing());
                totCountOtherPersonnel = (BudgetDecimal)totCountOtherPersonnel.add(budgetPeriodInfo.getOtherPersonnelTotalNumber());
                for (EquipmentInfo equipmentInfo : budgetPeriodInfo.getEquipment()) {
                    cumTotalEquipFund = (BudgetDecimal)cumTotalEquipFund.add(equipmentInfo.getTotalFund());
                    cumTotalEquipNonFund = (BudgetDecimal)cumTotalEquipNonFund.add(equipmentInfo.getTotalNonFund());
                }
                Map hmOthers = new HashMap();
                cvOtherCosts = otherDirectCostInfo.getOtherCosts();
                for (int l = 0; l < cvOtherCosts.size(); ++l) {
                    hmOthers = (Map)cvOtherCosts.get(l);
                    cumOtherType1 = (BudgetDecimal)cumOtherType1.add(new BudgetDecimal((String)hmOthers.get("Cost")));
                    cumOtherType1CostSharing = (BudgetDecimal)cumOtherType1CostSharing.add(new BudgetDecimal((String)hmOthers.get("CostSharing")));
                }
            }
        }
        budgetSummaryInfo.setCumDomesticTravelNonFund(totalDomesticTravelNonFund);
        budgetSummaryInfo.setCumForeignTravelNonFund(totalForeignTravelNonFund);
        budgetSummaryInfo.setCumTravelNonFund((BudgetDecimal)totalDomesticTravelNonFund.add(totalForeignTravelNonFund));
        budgetSummaryInfo.setCumDomesticTravel(totalDomesticTravel);
        budgetSummaryInfo.setCumForeignTravel(totalForeignTravel);
        budgetSummaryInfo.setCumTravel((BudgetDecimal)totalDomesticTravel.add(totalForeignTravel));
        budgetSummaryInfo.setpartOtherCost(cumPartOther);
        budgetSummaryInfo.setpartStipendCost(cumPartStipends);
        budgetSummaryInfo.setpartTravelCost(cumPartTravel);
        budgetSummaryInfo.setPartSubsistence(cumPartSubsistence);
        budgetSummaryInfo.setPartTuition(cumPartTuition);
        budgetSummaryInfo.setparticipantCount(cumParticipantCount);
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            budgetSummaryInfo.setPartOtherCostSharing(cumPartOtherCostSharing);
            budgetSummaryInfo.setPartStipendCostSharing(cumPartStipendsCostSharing);
            budgetSummaryInfo.setPartTravelCostSharing(cumPartTravelCostSharing);
            budgetSummaryInfo.setPartSubsistenceCostSharing(cumPartSubsistenceCostSharing);
            budgetSummaryInfo.setPartTuitionCostSharing(cumPartTuitionCostSharing);
        }
        OtherDirectCostInfo summaryOtherDirectCostInfo = new OtherDirectCostInfo();
        summaryOtherDirectCostInfo.setAlterations(cumAlterations);
        summaryOtherDirectCostInfo.setcomputer(cumComputer);
        summaryOtherDirectCostInfo.setConsultants(cumConsultants);
        summaryOtherDirectCostInfo.setmaterials(cumMaterials);
        summaryOtherDirectCostInfo.setpublications(cumPubs);
        summaryOtherDirectCostInfo.setsubAwards(cumSubAward);
        summaryOtherDirectCostInfo.setEquipRental(cumEquipRental);
        summaryOtherDirectCostInfo.settotalOtherDirect(cumAll);
        summaryOtherDirectCostInfo.setPartStipends(cumPartStipends);
        summaryOtherDirectCostInfo.setPartTravel(cumPartTravel);
        summaryOtherDirectCostInfo.setPartSubsistence(cumPartSubsistence);
        summaryOtherDirectCostInfo.setPartTuition(cumPartTuition);
        summaryOtherDirectCostInfo.setPartOther(cumPartOther);
        summaryOtherDirectCostInfo.setParticipantTotal((BudgetDecimal)cumPartStipends.add(cumPartTravel.add(cumPartOther.add(cumPartSubsistence.add(cumPartTravel)))));
        summaryOtherDirectCostInfo.setParticipantTotalCount(cumParticipantCount);
        summaryOtherDirectCostInfo.setAlterationsCostSharing(cumAlterationsCostSharing);
        summaryOtherDirectCostInfo.setComputerCostSharing(cumComputerCostSharing);
        summaryOtherDirectCostInfo.setConsultantsCostSharing(cumConsultantsCostSharing);
        summaryOtherDirectCostInfo.setMaterialsCostSharing(cumMaterialsCostSharing);
        summaryOtherDirectCostInfo.setPublicationsCostSharing(cumPubsCostSharing);
        summaryOtherDirectCostInfo.setSubAwardsCostSharing(cumSubAwardCostSharing);
        summaryOtherDirectCostInfo.setEquipRentalCostSharing(cumEquipRentalCostSharing);
        summaryOtherDirectCostInfo.setTotalOtherDirectCostSharing(cumAllCostSharing);
        summaryOtherDirectCostInfo.setPartStipendsCostSharing(cumPartStipendsCostSharing);
        summaryOtherDirectCostInfo.setPartTravelCostSharing(cumPartTravelCostSharing);
        summaryOtherDirectCostInfo.setPartTuitionCostSharing(cumPartTuitionCostSharing);
        summaryOtherDirectCostInfo.setPartSubsistenceCostSharing(cumPartSubsistenceCostSharing);
        summaryOtherDirectCostInfo.setPartOtherCostSharing(cumPartOtherCostSharing);
        participantTotalCostSharing = (BudgetDecimal)participantTotalCostSharing.add(cumPartStipendsCostSharing);
        participantTotalCostSharing = (BudgetDecimal)participantTotalCostSharing.add(cumPartTravelCostSharing);
        participantTotalCostSharing = (BudgetDecimal)participantTotalCostSharing.add(cumPartOtherCostSharing);
        participantTotalCostSharing = (BudgetDecimal)participantTotalCostSharing.add(cumPartTuitionCostSharing);
        participantTotalCostSharing = (BudgetDecimal)participantTotalCostSharing.add(cumPartSubsistenceCostSharing);
        summaryOtherDirectCostInfo.setParticipantTotalCostSharing(participantTotalCostSharing);
        ArrayList<Map<String, String>> cvAllOthers = new ArrayList<Map<String, String>>();
        HashMap<String, String> hmAllOthers = new HashMap<String, String>();
        hmAllOthers.put("Cost", cumOtherType1.toString());
        hmAllOthers.put("CostSharing", cumOtherType1CostSharing.toString());
        cvAllOthers.add(hmAllOthers);
        summaryOtherDirectCostInfo.setOtherCosts(cvAllOthers);
        ArrayList<OtherDirectCostInfo> cvCumOtherDirectCost = new ArrayList<OtherDirectCostInfo>();
        cvCumOtherDirectCost.add(summaryOtherDirectCostInfo);
        budgetSummaryInfo.setOtherDirectCosts(cvCumOtherDirectCost);
        budgetSummaryInfo.setCumEquipmentFunds(cumTotalEquipFund);
        budgetSummaryInfo.setCumEquipmentNonFunds(cumTotalEquipNonFund);
        budgetSummaryInfo.setCumFee(BudgetDecimal.ZERO);
        BudgetDecimal totSrFunds = BudgetDecimal.ZERO;
        BudgetDecimal totSrNonFunds = BudgetDecimal.ZERO;
        if (budgetPeriodInfos != null) {
            for (BudgetPeriodInfo budgetPeriodInfo : budgetPeriodInfos) {
                totSrFunds = (BudgetDecimal)totSrFunds.add(budgetPeriodInfo.getTotalFundsKeyPersons());
                totSrNonFunds = (BudgetDecimal)totSrNonFunds.add(budgetPeriodInfo.getTotalNonFundsKeyPersons());
            }
        }
        budgetSummaryInfo.setCumTotalFundsForSrPersonnel(totSrFunds);
        budgetSummaryInfo.setCumTotalNonFundsForSrPersonnel(totSrNonFunds);
        budgetSummaryInfo.setCumTotalFundsForOtherPersonnel((BudgetDecimal)totPersFunds.subtract(totSrFunds));
        budgetSummaryInfo.setCumTotalNonFundsForOtherPersonnel((BudgetDecimal)totPersNonFunds.subtract(totSrNonFunds));
        budgetSummaryInfo.setCumNumOtherPersonnel(totCountOtherPersonnel);
        return budgetSummaryInfo;
    }

    @Override
    public List<BudgetPeriodInfo> getBudgetPeriods(ProposalDevelopmentDocument pdDoc) throws S2SException {
        Budget budget;
        ArrayList<BudgetPeriodInfo> budgetPeriods = new ArrayList<BudgetPeriodInfo>();
        BudgetDocument budgetDocument = this.getFinalBudgetVersion(pdDoc);
        Budget budget2 = budget = budgetDocument == null ? null : budgetDocument.getBudget();
        if (budget == null) {
            return budgetPeriods;
        }
        for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
            BudgetPeriodInfo bpData = new BudgetPeriodInfo();
            BudgetDecimal totalCostSharing = BudgetDecimal.ZERO;
            BudgetDecimal totalDirectCostSharing = BudgetDecimal.ZERO;
            BudgetDecimal totalIndirectCostSharing = BudgetDecimal.ZERO;
            bpData.setLineItemCount(budgetPeriod.getBudgetLineItems().size());
            if (budget.getSubmitCostSharingFlag().booleanValue()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                        totalCostSharing = (BudgetDecimal)totalCostSharing.add(lineItem.getCostSharingAmount());
                    }
                    for (BudgetLineItemCalculatedAmount lineItemCalculatedAmt : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        lineItemCalculatedAmt.refreshReferenceObject("rateClass");
                        if (!lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                        if (lineItemCalculatedAmt.getRateClass().getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) {
                            totalIndirectCostSharing = (BudgetDecimal)totalIndirectCostSharing.add(lineItemCalculatedAmt.getCalculatedCostSharing());
                            continue;
                        }
                        totalDirectCostSharing = (BudgetDecimal)totalDirectCostSharing.add(lineItemCalculatedAmt.getCalculatedCostSharing());
                    }
                }
                totalDirectCostSharing = (BudgetDecimal)totalDirectCostSharing.add(totalCostSharing);
            }
            bpData.setFinalVersionFlag(budget.getFinalVersionFlag().toString());
            bpData.setProposalNumber(pdDoc.getDevelopmentProposal().getProposalNumber());
            bpData.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
            bpData.setVersion(budgetPeriod.getBudget().getBudgetVersionNumber());
            bpData.setStartDate(budgetPeriod.getStartDate());
            bpData.setEndDate(budgetPeriod.getEndDate());
            bpData.setTotalCosts(budgetPeriod.getTotalCost());
            bpData.setDirectCostsTotal(budgetPeriod.getTotalDirectCost());
            bpData.setTotalIndirectCost(budgetPeriod.getTotalIndirectCost());
            bpData.setCostSharingAmount(budgetPeriod.getCostSharingAmount());
            if (budget.getSubmitCostSharingFlag().booleanValue()) {
                bpData.setTotalDirectCostSharing(totalDirectCostSharing);
                bpData.setTotalIndirectCostSharing(totalIndirectCostSharing);
            }
            bpData.setCognizantFedAgency(this.s2SUtilService.getCognizantFedAgency(pdDoc.getDevelopmentProposal()));
            bpData.setIndirectCosts(this.getIndirectCosts(budget, budgetPeriod));
            bpData.setEquipment(this.getEquipment(budgetPeriod));
            bpData.setOtherDirectCosts(this.getOtherDirectCosts(budgetPeriod, "S2S"));
            if (bpData.getOtherDirectCosts().size() > 0) {
                OtherDirectCostInfo otherCostInfo = bpData.getOtherDirectCosts().get(0);
                bpData.setDomesticTravelCost(otherCostInfo.getDomTravel());
                bpData.setForeignTravelCost(otherCostInfo.getForeignTravel());
                bpData.setTotalTravelCost(otherCostInfo.getTotTravel());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    bpData.setDomesticTravelCostSharing(otherCostInfo.getDomTravelCostSharing());
                    bpData.setForeignTravelCostSharing(otherCostInfo.getForeignTravelCostSharing());
                    bpData.setTotalTravelCostSharing(otherCostInfo.getTotTravelCostSharing());
                }
                bpData.setpartOtherCost(otherCostInfo.getPartOther());
                bpData.setpartStipendCost(otherCostInfo.getPartStipends());
                bpData.setpartTravelCost(otherCostInfo.getPartTravel());
                bpData.setPartSubsistence(otherCostInfo.getPartSubsistence());
                bpData.setPartTuition(otherCostInfo.getPartTuition());
                bpData.setparticipantCount(otherCostInfo.getParticpantTotalCount());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    bpData.setPartOtherCostSharing(otherCostInfo.getPartOtherCostSharing());
                    bpData.setPartStipendCostSharing(otherCostInfo.getPartStipendsCostSharing());
                    bpData.setPartTravelCostSharing(otherCostInfo.getPartTravelCostSharing());
                    bpData.setPartTuitionCostSharing(otherCostInfo.getPartTuitionCostSharing());
                    bpData.setPartSubsistenceCostSharing(otherCostInfo.getPartSubsistenceCostSharing());
                }
            }
            List<List<KeyPersonInfo>> keyPersonList = this.getKeyPersons(budgetPeriod, pdDoc, 8);
            ArrayList<KeyPersonInfo> keyPersons = new ArrayList();
            ArrayList<KeyPersonInfo> extraPersons = new ArrayList();
            if (keyPersonList.size() > 0) {
                keyPersons = keyPersonList.get(0);
            }
            if (keyPersonList.size() > 1) {
                extraPersons = keyPersonList.get(1);
            }
            bpData.setKeyPersons(keyPersons);
            bpData.setExtraKeyPersons(extraPersons);
            BudgetDecimal totalKeyPersonSum = BudgetDecimal.ZERO;
            BudgetDecimal totalKeyPersonSumCostSharing = BudgetDecimal.ZERO;
            BudgetDecimal totalAttKeyPersonSum = BudgetDecimal.ZERO;
            BudgetDecimal totalAttKeyPersonSumCostSharing = BudgetDecimal.ZERO;
            if (keyPersons != null) {
                for (KeyPersonInfo keyPerson : keyPersons) {
                    totalKeyPersonSum = (BudgetDecimal)totalKeyPersonSum.add(keyPerson.getFundsRequested());
                    if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                    totalKeyPersonSumCostSharing = (BudgetDecimal)totalKeyPersonSumCostSharing.add(keyPerson.getNonFundsRequested());
                }
            }
            if (extraPersons != null) {
                for (KeyPersonInfo keyPerson : extraPersons) {
                    totalAttKeyPersonSum = (BudgetDecimal)totalAttKeyPersonSum.add(keyPerson.getFundsRequested());
                    if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                    totalAttKeyPersonSumCostSharing = (BudgetDecimal)totalAttKeyPersonSumCostSharing.add(keyPerson.getNonFundsRequested());
                }
            }
            bpData.setTotalFundsKeyPersons((BudgetDecimal)totalKeyPersonSum.add(totalAttKeyPersonSum));
            bpData.setTotalFundsAttachedKeyPersons(totalAttKeyPersonSum);
            bpData.setTotalNonFundsKeyPersons((BudgetDecimal)totalKeyPersonSumCostSharing.add(totalAttKeyPersonSumCostSharing));
            bpData.setTotalNonFundsAttachedKeyPersons(totalAttKeyPersonSumCostSharing);
            List<OtherPersonnelInfo> otherPersonnel = this.getOtherPersonnel(budgetPeriod, pdDoc);
            bpData.setOtherPersonnel(otherPersonnel);
            BudgetDecimal otherPersonnelCount = BudgetDecimal.ZERO;
            BudgetDecimal otherPersonnelTotalFunds = BudgetDecimal.ZERO;
            BudgetDecimal otherPersonnelTotalNonFunds = BudgetDecimal.ZERO;
            for (OtherPersonnelInfo otherPersonnelInfo : otherPersonnel) {
                otherPersonnelCount = (BudgetDecimal)otherPersonnelCount.add(new BudgetDecimal(otherPersonnelInfo.getNumberPersonnel()));
                otherPersonnelTotalFunds = (BudgetDecimal)otherPersonnelTotalFunds.add(otherPersonnelInfo.getCompensation().getFundsRequested());
                otherPersonnelTotalNonFunds = (BudgetDecimal)otherPersonnelTotalNonFunds.add(otherPersonnelInfo.getCompensation().getNonFundsRequested());
            }
            bpData.setTotalOtherPersonnelFunds(otherPersonnelTotalFunds);
            bpData.setOtherPersonnelTotalNumber(otherPersonnelCount);
            bpData.setTotalCompensation((BudgetDecimal)((BudgetDecimal)otherPersonnelTotalFunds.add(totalKeyPersonSum)).add(totalAttKeyPersonSum));
            bpData.setTotalOtherPersonnelNonFunds(otherPersonnelTotalNonFunds);
            bpData.setTotalCompensationCostSharing((BudgetDecimal)((BudgetDecimal)otherPersonnelTotalNonFunds.add(totalKeyPersonSumCostSharing)).add(totalAttKeyPersonSumCostSharing));
            budgetPeriods.add(bpData);
        }
        return budgetPeriods;
    }

    protected List<OtherPersonnelInfo> getOtherPersonnel(BudgetPeriod budgetPeriod, ProposalDevelopmentDocument pdDoc) {
        ArrayList<OtherPersonnelInfo> cvOtherPersonnel = new ArrayList<OtherPersonnelInfo>();
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, pdDoc, this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetCategory01Graduates"), PERSONNEL_TYPE_GRAD, ROLE_GRADUATE_STUDENTS));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, pdDoc, this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetCategory01Postdocs"), PERSONNEL_TYPE_POSTDOC, ROLE_POST_DOCTORAL_ASSOCIATES));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, pdDoc, this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetCategory01Undergrads"), PERSONNEL_TYPE_UNDERGRAD, ROLE_GRADUATE_UNDERGRADUATE_STUDENTS));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, pdDoc, this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetCategory01Secretarial"), PERSONNEL_TYPE_SEC, ROLE_GRADUATE_SECRETARIAL_OR_CLERICAL));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, pdDoc, this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetCategory01Other"), "Other", "Other"));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, pdDoc, this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetCategory01OtherProfs"), "Other Professionals", "Other Professionals"));
        cvOtherPersonnel.add(this.getOtherPersonnelDetails(budgetPeriod, pdDoc, LASALARIES, "Allocated Admin Support", "Allocated Admin Support"));
        return cvOtherPersonnel;
    }

    protected OtherPersonnelInfo getOtherPersonnelDetails(BudgetPeriod budgetPeriod, ProposalDevelopmentDocument pdDoc, String category, String personnelType, String role) {
        OtherPersonnelInfo otherPersonnelInfo = new OtherPersonnelInfo();
        int count = 0;
        BudgetDecimal salaryRequested = BudgetDecimal.ZERO;
        BudgetDecimal salaryCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal lineItemCost = BudgetDecimal.ZERO;
        BudgetDecimal lineItemCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal mrLaCost = BudgetDecimal.ZERO;
        BudgetDecimal mrLaCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal fringeCost = BudgetDecimal.ZERO;
        BudgetDecimal fringeCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal mrLaFringeCost = BudgetDecimal.ZERO;
        BudgetDecimal mrLaFringeCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal budgetLineItemFringeCost = BudgetDecimal.ZERO;
        BudgetDecimal budgetLineItemFringeCostSharingAmount = BudgetDecimal.ZERO;
        BudgetDecimal bdSalary = BudgetDecimal.ZERO;
        BudgetDecimal bdFringe = BudgetDecimal.ZERO;
        BudgetDecimal bdFunds = BudgetDecimal.ZERO;
        BudgetDecimal bdSalaryCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal bdFringeCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal bdNonFunds = BudgetDecimal.ZERO;
        BudgetDecimal academicMonths = BudgetDecimal.ZERO;
        BudgetDecimal summerMonths = BudgetDecimal.ZERO;
        BudgetDecimal calendarMonths = BudgetDecimal.ZERO;
        BudgetDecimal cycleMonths = BudgetDecimal.ZERO;
        BudgetDecimal numberOfMonths = BudgetDecimal.ZERO;
        String rateTypeSupportStaffSalaries = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateTypeSupportStaffSalaries");
        String rateClassCodeEmployeeBenefits = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassCodeEmployeeBenefits");
        String rateClassCodeVacation = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassCodeVacation");
        String rateTypeAdministrativeSalaries = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateTypeAdministrativeSalaries");
        HashMap<String, String> personJobCodes = new HashMap<String, String>();
        boolean personExistsAsProposalPerson = false;
        if (category.equalsIgnoreCase(LASALARIES)) {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                    if (lineItemCalculatedAmount.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeLabAllocationSalaries"))) {
                        mrLaCost = (BudgetDecimal)mrLaCost.add(lineItemCalculatedAmount.getCalculatedCost());
                        if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                            mrLaCostSharingAmount = (BudgetDecimal)mrLaCostSharingAmount.add(lineItemCalculatedAmount.getCalculatedCostSharing());
                        }
                    }
                    if ((!lineItemCalculatedAmount.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeEmployeeBenefits")) || !lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!lineItemCalculatedAmount.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeVacation")) || !lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeAdministrativeSalaries))) continue;
                    mrLaFringeCost = (BudgetDecimal)mrLaFringeCost.add(lineItemCalculatedAmount.getCalculatedCost());
                    if (!lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                    mrLaFringeCostSharingAmount = (BudgetDecimal)mrLaFringeCostSharingAmount.add(lineItemCalculatedAmount.getCalculatedCostSharing());
                }
            }
        } else {
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                HashMap<String, String> categoryMap = new HashMap<String, String>();
                categoryMap.put(KEY_TARGET_CATEGORY_CODE, category);
                categoryMap.put(KEY_MAPPING_NAME, "S2S");
                List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
                for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                    boolean personExist;
                    if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                    List<BudgetPersonnelDetails> lineItemPersonDetails = lineItem.getBudgetPersonnelDetailsList();
                    boolean bl = personExist = !lineItemPersonDetails.isEmpty();
                    if (personExist) {
                        for (BudgetPersonnelDetails personDetails : lineItemPersonDetails) {
                            if (!categoryMapping.getBudgetCategoryCode().equals(lineItem.getBudgetCategoryCode())) continue;
                            String budgetPersonId = personDetails.getPersonId();
                            personExistsAsProposalPerson = false;
                            for (ProposalPerson proposalPerson : pdDoc.getDevelopmentProposal().getProposalPersons()) {
                                if (!budgetPersonId.equals(proposalPerson.getPersonId()) && (proposalPerson.getRolodexId() == null || !budgetPersonId.equals(proposalPerson.getRolodexId().toString()))) continue;
                                personExistsAsProposalPerson = true;
                                break;
                            }
                            if (personExistsAsProposalPerson) continue;
                            salaryRequested = (BudgetDecimal)salaryRequested.add(personDetails.getSalaryRequested());
                            if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                                salaryCostSharing = (BudgetDecimal)salaryCostSharing.add(personDetails.getCostSharingAmount());
                            }
                            numberOfMonths = this.s2SUtilService.getNumberOfMonths(personDetails.getStartDate(), personDetails.getEndDate());
                            if (personDetails.getPeriodTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetPeriodTypeAcademicMonths"))) {
                                academicMonths = lineItem.getSubmitCostSharingFlag().booleanValue() ? (BudgetDecimal)academicMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01))) : (BudgetDecimal)academicMonths.add(personDetails.getPercentCharged().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                            } else if (personDetails.getPeriodTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetPeriodTypeSummerMonths"))) {
                                summerMonths = lineItem.getSubmitCostSharingFlag().booleanValue() ? (BudgetDecimal)summerMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01))) : (BudgetDecimal)summerMonths.add(personDetails.getPercentCharged().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                            } else if (personDetails.getPeriodTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetPeriodTypeCalendarMonths"))) {
                                calendarMonths = lineItem.getSubmitCostSharingFlag().booleanValue() ? (BudgetDecimal)calendarMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01))) : (BudgetDecimal)calendarMonths.add(personDetails.getPercentCharged().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                            } else if (personDetails.getPeriodTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetPeriodTypeCycleMonths"))) {
                                cycleMonths = (BudgetDecimal)cycleMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                            }
                            personJobCodes.put(personDetails.getPersonId() + personDetails.getJobCode(), "");
                            for (BudgetPersonnelCalculatedAmount personCalculatedAmount : personDetails.getBudgetCalculatedAmounts()) {
                                if ((!personCalculatedAmount.getRateClassCode().equals(rateClassCodeEmployeeBenefits) || personCalculatedAmount.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!personCalculatedAmount.getRateClassCode().equals(rateClassCodeVacation) || personCalculatedAmount.getRateTypeCode().equals(rateTypeAdministrativeSalaries))) continue;
                                fringeCost = (BudgetDecimal)fringeCost.add(personCalculatedAmount.getCalculatedCost());
                                if (!lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                                fringeCostSharingAmount = (BudgetDecimal)fringeCostSharingAmount.add(personCalculatedAmount.getCalculatedCostSharing());
                            }
                        }
                        continue;
                    }
                    lineItemCost = (BudgetDecimal)lineItemCost.add(lineItem.getLineItemCost());
                    if (lineItem.getSubmitCostSharingFlag().booleanValue()) {
                        lineItemCostSharingAmount = (BudgetDecimal)lineItemCostSharingAmount.add(lineItem.getCostSharingAmount());
                    }
                    count = lineItem.getQuantity();
                    for (BudgetLineItemCalculatedAmount lineItemCalculatedAmount : lineItem.getBudgetLineItemCalculatedAmounts()) {
                        lineItemCalculatedAmount.refreshReferenceObject("rateClass");
                        if (lineItemCalculatedAmount.getRateClass().getRateClassType().equalsIgnoreCase("E")) {
                            fringeCost = (BudgetDecimal)fringeCost.add(lineItemCalculatedAmount.getCalculatedCost());
                        }
                        if ((!lineItemCalculatedAmount.getRateClassCode().equals(rateClassCodeEmployeeBenefits) || lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeSupportStaffSalaries)) && (!lineItemCalculatedAmount.getRateClassCode().equals(rateClassCodeVacation) || lineItemCalculatedAmount.getRateTypeCode().equals(rateTypeAdministrativeSalaries)) || !lineItem.getSubmitCostSharingFlag().booleanValue()) continue;
                        fringeCostSharingAmount = (BudgetDecimal)fringeCostSharingAmount.add(lineItemCalculatedAmount.getCalculatedCostSharing());
                    }
                }
            }
        }
        bdSalary = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)bdSalary.add(salaryRequested)).add(lineItemCost)).add(mrLaCost);
        bdSalaryCostSharing = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)bdSalaryCostSharing.add(salaryCostSharing)).add(lineItemCostSharingAmount)).add(mrLaCostSharingAmount);
        bdFringe = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)bdFringe.add(fringeCost)).add(budgetLineItemFringeCost)).add(mrLaFringeCost);
        bdFringeCostSharing = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)bdFringeCostSharing.add(fringeCostSharingAmount)).add(budgetLineItemFringeCostSharingAmount)).add(mrLaFringeCostSharingAmount);
        bdNonFunds = (BudgetDecimal)bdSalaryCostSharing.add(bdFringeCostSharing);
        bdFunds = (BudgetDecimal)bdSalary.add(bdFringe);
        count = personJobCodes.isEmpty() ? count : personJobCodes.size();
        otherPersonnelInfo.setNumberPersonnel(count);
        otherPersonnelInfo.setPersonnelType(personnelType);
        otherPersonnelInfo.setRole(role);
        CompensationInfo compensationInfo = new CompensationInfo();
        compensationInfo.setBaseSalary(BudgetDecimal.ZERO);
        compensationInfo.setFringe(bdFringe);
        compensationInfo.setFundsRequested(bdFunds);
        compensationInfo.setRequestedSalary(bdSalary);
        compensationInfo.setSummerMonths(summerMonths.setScale());
        compensationInfo.setAcademicMonths(academicMonths.setScale());
        compensationInfo.setCalendarMonths(calendarMonths.setScale());
        compensationInfo.setFringeCostSharing(bdFringeCostSharing);
        compensationInfo.setNonFundsRequested(bdNonFunds);
        compensationInfo.setCostSharingAmount(bdSalaryCostSharing);
        otherPersonnelInfo.setCompensation(compensationInfo);
        return otherPersonnelInfo;
    }

    @Override
    public IndirectCostInfo getIndirectCosts(Budget budget, BudgetPeriod budgetPeriod) {
        ArrayList<IndirectCostDetails> indirectCostDetailList = new ArrayList<IndirectCostDetails>();
        BudgetDecimal baseCost = BudgetDecimal.ZERO;
        BudgetDecimal baseCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal calculatedCost = BudgetDecimal.ZERO;
        BudgetDecimal calculatedCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal appliedRate = BudgetDecimal.ZERO;
        BudgetDecimal totalIndirectCosts = BudgetDecimal.ZERO;
        BudgetDecimal totalIndirectCostSharing = BudgetDecimal.ZERO;
        String description = "";
        boolean firstLoop = true;
        if (budget.getModularBudgetFlag().booleanValue()) {
            for (BudgetModularIdc budgetModularIdc : budgetPeriod.getBudgetModular().getBudgetModularIdcs()) {
                if (firstLoop) {
                    appliedRate = (BudgetDecimal)appliedRate.add(budgetModularIdc.getIdcRate());
                    description = budgetModularIdc.getDescription();
                    firstLoop = false;
                }
                baseCost = (BudgetDecimal)baseCost.add(budgetModularIdc.getIdcBase());
                calculatedCost = (BudgetDecimal)calculatedCost.add(budgetModularIdc.getFundsRequested());
            }
            IndirectCostDetails indirectCostDetails = new IndirectCostDetails();
            indirectCostDetails.setBase(baseCost);
            indirectCostDetails.setBaseCostSharing(baseCostSharing);
            indirectCostDetails.setCostSharing(calculatedCostSharing);
            indirectCostDetails.setCostType(description);
            indirectCostDetails.setFunds(calculatedCost);
            indirectCostDetails.setRate(appliedRate);
            indirectCostDetailList.add(indirectCostDetails);
            totalIndirectCosts = (BudgetDecimal)totalIndirectCosts.add(calculatedCost);
            totalIndirectCostSharing = (BudgetDecimal)totalIndirectCostSharing.add(calculatedCostSharing);
        } else {
            HashMap<String, IndirectCostDetails> costDetailsMap = new HashMap<String, IndirectCostDetails>();
            for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                for (BudgetRateAndBase rateBase : lineItem.getBudgetRateAndBaseList()) {
                    IndirectCostDetails indirectCostDetails;
                    RateClass rateClass = rateBase.getRateClass();
                    if (!rateClass.getRateClassType().equals(RateClassType.OVERHEAD.getRateClassType())) continue;
                    String rateClassCode = rateClass.getRateClassCode();
                    String rateTypeCode = rateBase.getRateTypeCode();
                    appliedRate = rateBase.getAppliedRate();
                    StringBuilder keyBuilder = new StringBuilder();
                    keyBuilder.append(rateClassCode);
                    keyBuilder.append("-");
                    keyBuilder.append(rateTypeCode);
                    keyBuilder.append("-");
                    keyBuilder.append((Object)appliedRate);
                    String key = keyBuilder.toString();
                    if (costDetailsMap.get(key) == null) {
                        indirectCostDetails = new IndirectCostDetails();
                        indirectCostDetails.setBase(rateBase.getBaseCost() == null ? BudgetDecimal.ZERO : rateBase.getBaseCost());
                        indirectCostDetails.setBaseCostSharing(rateBase.getBaseCostSharing() == null ? BudgetDecimal.ZERO : rateBase.getBaseCostSharing());
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            indirectCostDetails.setCostSharing(rateBase.getCalculatedCostSharing() == null ? BudgetDecimal.ZERO : rateBase.getCalculatedCostSharing());
                        }
                        indirectCostDetails.setCostType(rateClass.getDescription());
                        indirectCostDetails.setFunds(rateBase.getCalculatedCost() == null ? BudgetDecimal.ZERO : rateBase.getCalculatedCost());
                        indirectCostDetails.setRate(appliedRate);
                    } else {
                        indirectCostDetails = (IndirectCostDetails)costDetailsMap.get(key);
                        baseCost = (BudgetDecimal)indirectCostDetails.getBase().add(rateBase.getBaseCost() == null ? BudgetDecimal.ZERO : rateBase.getBaseCost());
                        baseCostSharing = (BudgetDecimal)indirectCostDetails.getBaseCostSharing().add(rateBase.getBaseCostSharing() == null ? BudgetDecimal.ZERO : rateBase.getBaseCostSharing());
                        calculatedCost = (BudgetDecimal)indirectCostDetails.getFunds().add(rateBase.getCalculatedCost() == null ? BudgetDecimal.ZERO : rateBase.getCalculatedCost());
                        if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                            calculatedCostSharing = (BudgetDecimal)indirectCostDetails.getCostSharing().add(rateBase.getCalculatedCostSharing() == null ? BudgetDecimal.ZERO : rateBase.getCalculatedCostSharing());
                        } else if (!lineItem.getSubmitCostSharingFlag().booleanValue() && budget.getSubmitCostSharingFlag().booleanValue()) {
                            calculatedCostSharing = indirectCostDetails.getCostSharing();
                        }
                        indirectCostDetails.setBase(baseCost);
                        indirectCostDetails.setBaseCostSharing(baseCostSharing);
                        indirectCostDetails.setCostSharing(calculatedCostSharing);
                        indirectCostDetails.setFunds(calculatedCost);
                    }
                    costDetailsMap.put(key, indirectCostDetails);
                    indirectCostDetailList = new ArrayList(costDetailsMap.values());
                    totalIndirectCosts = (BudgetDecimal)totalIndirectCosts.add(rateBase.getCalculatedCost() == null ? BudgetDecimal.ZERO : rateBase.getCalculatedCost());
                    if (!this.canBudgetLineItemCostSharingInclude(budget, lineItem)) continue;
                    totalIndirectCostSharing = (BudgetDecimal)totalIndirectCostSharing.add(rateBase.getCalculatedCostSharing() == null ? BudgetDecimal.ZERO : rateBase.getCalculatedCostSharing());
                }
            }
        }
        IndirectCostInfo indirectCostInfo = new IndirectCostInfo();
        indirectCostInfo.setIndirectCostDetails(indirectCostDetailList);
        indirectCostInfo.setTotalIndirectCosts(totalIndirectCosts);
        indirectCostInfo.setTotalIndirectCostSharing(totalIndirectCostSharing);
        return indirectCostInfo;
    }

    protected List<OtherDirectCostInfo> getOtherDirectCosts(BudgetPeriod budgetPeriod, String sponsor) {
        Budget budget = budgetPeriod.getBudget();
        OtherDirectCostInfo otherDirectCostInfo = new OtherDirectCostInfo();
        ArrayList<CostInfo> costInfoList = new ArrayList<CostInfo>();
        ArrayList<String> filterTargetCategoryCodes = new ArrayList<String>();
        filterTargetCategoryCodes.add(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetTargetCategoryCodeEquipmentCost"));
        ArrayList<String> filterCategoryTypes = new ArrayList<String>();
        filterCategoryTypes.add(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetFilterCategoryTypePersonnel"));
        List<BudgetCategoryMap> budgetCategoryMapList = this.getBudgetCategoryMapList(filterTargetCategoryCodes, filterCategoryTypes);
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetCategoryMap budgetCategoryMap : budgetCategoryMapList) {
                boolean recordAdded = false;
                for (BudgetCategoryMapping budgetCategoryMapping : budgetCategoryMap.getBudgetCategoryMappings()) {
                    if (!lineItem.getBudgetCategoryCode().equals(budgetCategoryMapping.getBudgetCategoryCode())) continue;
                    CostInfo costInfo = new CostInfo();
                    costInfo.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                    costInfo.setCost(lineItem.getLineItemCost());
                    if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                        costInfo.setCostSharing(lineItem.getCostSharingAmount());
                    }
                    costInfo.setCategory(budgetCategoryMap.getDescription());
                    costInfo.setCategoryType(budgetCategoryMap.getCategoryType());
                    if (lineItem.getQuantity() != null) {
                        costInfo.setQuantity(lineItem.getQuantity());
                    }
                    costInfoList.add(costInfo);
                    recordAdded = true;
                    break;
                }
                if (!recordAdded) continue;
                break;
            }
            CostInfo lineItemcostInfo = new CostInfo();
            lineItemcostInfo.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
            lineItemcostInfo.setCategory(OTHER_DIRECT_COSTS);
            lineItemcostInfo.setCategoryType(CATEGORY_TYPE_OTHER_DIRECT_COST);
            lineItemcostInfo.setQuantity(1);
            BudgetDecimal totalCost = BudgetDecimal.ZERO;
            BudgetDecimal totalCostSharing = BudgetDecimal.ZERO;
            for (BudgetLineItemCalculatedAmount lineItemCalculatedAmt : lineItem.getBudgetLineItemCalculatedAmounts()) {
                lineItemCalculatedAmt.refreshReferenceObject("rateClass");
                if (!lineItemCalculatedAmt.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeSalariesMs"))) continue;
                totalCost = (BudgetDecimal)totalCost.add(lineItemCalculatedAmt.getCalculatedCost());
                if (!this.canBudgetLineItemCostSharingInclude(budget, lineItem)) continue;
                totalCostSharing = (BudgetDecimal)totalCostSharing.add(lineItemCalculatedAmt.getCalculatedCostSharing());
            }
            lineItemcostInfo.setCost(totalCost);
            if (this.canBudgetLineItemCostSharingInclude(budget, lineItem)) {
                lineItemcostInfo.setCostSharing(totalCostSharing);
            }
            StringBuilder description = new StringBuilder();
            description.append(DESCRIPTION_LA);
            description.append((Object)totalCost);
            description.append(";");
            lineItemcostInfo.setDescription(description.toString());
            costInfoList.add(lineItemcostInfo);
        }
        BudgetDecimal totalOtherDirect = BudgetDecimal.ZERO;
        BudgetDecimal totalTravelCost = BudgetDecimal.ZERO;
        BudgetDecimal totalParticipantCost = BudgetDecimal.ZERO;
        BudgetDecimal totalOtherDirectCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal totalTravelCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal totalParticipantCostSharing = BudgetDecimal.ZERO;
        int totalParticipantCount = 0;
        BudgetDecimal materialCost = BudgetDecimal.ZERO;
        BudgetDecimal materialCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal consultantCost = BudgetDecimal.ZERO;
        BudgetDecimal consultantCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal publicationCost = BudgetDecimal.ZERO;
        BudgetDecimal publicationCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal computerCost = BudgetDecimal.ZERO;
        BudgetDecimal computerCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal alterationsCost = BudgetDecimal.ZERO;
        BudgetDecimal alterationsCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal subContractCost = BudgetDecimal.ZERO;
        BudgetDecimal subContractCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal equipmentRentalCost = BudgetDecimal.ZERO;
        BudgetDecimal equipmentRentalCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal domesticTravelCost = BudgetDecimal.ZERO;
        BudgetDecimal domesticTravelCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal foreignTravelCost = BudgetDecimal.ZERO;
        BudgetDecimal foreignTravelCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal partStipendsCost = BudgetDecimal.ZERO;
        BudgetDecimal partStipendsCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal partTravelCost = BudgetDecimal.ZERO;
        BudgetDecimal partTravelCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal partTuitionCost = BudgetDecimal.ZERO;
        BudgetDecimal partTuitionCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal partSubsistenceCost = BudgetDecimal.ZERO;
        BudgetDecimal partSubsistenceCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal partOtherCost = BudgetDecimal.ZERO;
        BudgetDecimal partOtherCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal otherDirectCost = BudgetDecimal.ZERO;
        BudgetDecimal otherDirectCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal otherCost = BudgetDecimal.ZERO;
        BudgetDecimal otherCostSharing = BudgetDecimal.ZERO;
        for (CostInfo costInfo : costInfoList) {
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetMaterialsAndSuppliesCategory"))) {
                materialCost = (BudgetDecimal)materialCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                materialCostSharing = (BudgetDecimal)materialCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetConsultantCostsCategory"))) {
                consultantCost = (BudgetDecimal)consultantCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                consultantCostSharing = (BudgetDecimal)consultantCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetPublicationCostsCategory"))) {
                publicationCost = (BudgetDecimal)publicationCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                publicationCostSharing = (BudgetDecimal)publicationCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetComputerServicesCategory"))) {
                computerCost = (BudgetDecimal)computerCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                computerCostSharing = (BudgetDecimal)computerCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetAlterationsCategory"))) {
                alterationsCost = (BudgetDecimal)alterationsCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                alterationsCostSharing = (BudgetDecimal)alterationsCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetSubcontractCategory"))) {
                subContractCost = (BudgetDecimal)subContractCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                subContractCostSharing = (BudgetDecimal)subContractCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetEquipmentRentalCategory"))) {
                equipmentRentalCost = (BudgetDecimal)equipmentRentalCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                equipmentRentalCostSharing = (BudgetDecimal)equipmentRentalCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetDomesticTravelCategory"))) {
                domesticTravelCost = (BudgetDecimal)domesticTravelCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                domesticTravelCostSharing = (BudgetDecimal)domesticTravelCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetForeignTravelCategory"))) {
                foreignTravelCost = (BudgetDecimal)foreignTravelCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                foreignTravelCostSharing = (BudgetDecimal)foreignTravelCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetParticipantStipendsCategory"))) {
                partStipendsCost = (BudgetDecimal)partStipendsCost.add(costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partStipendsCostSharing = (BudgetDecimal)partStipendsCostSharing.add(costInfo.getCostSharing());
                    totalParticipantCostSharing = (BudgetDecimal)totalParticipantCostSharing.add(costInfo.getCostSharing());
                }
                totalParticipantCost = (BudgetDecimal)totalParticipantCost.add(costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetParticipantTravelCategory"))) {
                partTravelCost = (BudgetDecimal)partTravelCost.add(costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partTravelCostSharing = (BudgetDecimal)partTravelCostSharing.add(costInfo.getCostSharing());
                    totalParticipantCostSharing = (BudgetDecimal)totalParticipantCostSharing.add(costInfo.getCostSharing());
                }
                totalParticipantCost = (BudgetDecimal)totalParticipantCost.add(costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetParticipantTutionCategory"))) {
                partTuitionCost = (BudgetDecimal)partTuitionCost.add(costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partTuitionCostSharing = (BudgetDecimal)partTuitionCostSharing.add(costInfo.getCostSharing());
                    totalParticipantCostSharing = (BudgetDecimal)totalParticipantCostSharing.add(costInfo.getCostSharing());
                }
                totalParticipantCost = (BudgetDecimal)totalParticipantCost.add(costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetParticipantSubsistenceCategory"))) {
                partSubsistenceCost = (BudgetDecimal)partSubsistenceCost.add(costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partSubsistenceCostSharing = (BudgetDecimal)partSubsistenceCostSharing.add(costInfo.getCostSharing());
                    totalParticipantCostSharing = (BudgetDecimal)totalParticipantCostSharing.add(costInfo.getCostSharing());
                }
                totalParticipantCost = (BudgetDecimal)totalParticipantCost.add(costInfo.getCost());
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetParticipantOtherCategory"))) {
                partOtherCost = (BudgetDecimal)partOtherCost.add(costInfo.getCost());
                if (budget.getSubmitCostSharingFlag().booleanValue()) {
                    partOtherCostSharing = (BudgetDecimal)partOtherCostSharing.add(costInfo.getCostSharing());
                    totalParticipantCostSharing = (BudgetDecimal)totalParticipantCostSharing.add(costInfo.getCostSharing());
                }
                totalParticipantCost = (BudgetDecimal)totalParticipantCost.add(costInfo.getCost());
                totalParticipantCount += costInfo.getQuantity();
                continue;
            }
            if (costInfo.getCategory().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetOtherDirectCostsCategory"))) {
                otherDirectCost = (BudgetDecimal)otherDirectCost.add(costInfo.getCost());
                if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
                otherDirectCostSharing = (BudgetDecimal)otherDirectCostSharing.add(costInfo.getCostSharing());
                continue;
            }
            otherCost = (BudgetDecimal)otherCost.add(costInfo.getCost());
            if (!budget.getSubmitCostSharingFlag().booleanValue()) continue;
            otherCostSharing = (BudgetDecimal)otherCostSharing.add(costInfo.getCostSharing());
        }
        otherDirectCostInfo.setmaterials(materialCost);
        otherDirectCostInfo.setMaterialsCostSharing(materialCostSharing);
        otherDirectCostInfo.setConsultants(consultantCost);
        otherDirectCostInfo.setConsultantsCostSharing(consultantCostSharing);
        otherDirectCostInfo.setpublications(publicationCost);
        otherDirectCostInfo.setPublicationsCostSharing(publicationCostSharing);
        otherDirectCostInfo.setcomputer(computerCost);
        otherDirectCostInfo.setComputerCostSharing(computerCostSharing);
        otherDirectCostInfo.setAlterations(alterationsCost);
        otherDirectCostInfo.setAlterationsCostSharing(alterationsCostSharing);
        otherDirectCostInfo.setsubAwards(subContractCost);
        otherDirectCostInfo.setSubAwardsCostSharing(subContractCostSharing);
        otherDirectCostInfo.setEquipRental(equipmentRentalCost);
        otherDirectCostInfo.setEquipRentalCostSharing(equipmentRentalCostSharing);
        otherDirectCostInfo.setDomTravel(domesticTravelCost);
        otherDirectCostInfo.setDomTravelCostSharing(domesticTravelCostSharing);
        otherDirectCostInfo.setForeignTravel(foreignTravelCost);
        otherDirectCostInfo.setForeignTravelCostSharing(foreignTravelCostSharing);
        otherDirectCostInfo.setPartStipends(partStipendsCost);
        otherDirectCostInfo.setPartStipendsCostSharing(partStipendsCostSharing);
        otherDirectCostInfo.setPartTravel(partTravelCost);
        otherDirectCostInfo.setPartTravelCostSharing(partTravelCostSharing);
        otherDirectCostInfo.setPartTuition(partTuitionCost);
        otherDirectCostInfo.setPartTuitionCostSharing(partTuitionCostSharing);
        otherDirectCostInfo.setPartSubsistence(partSubsistenceCost);
        otherDirectCostInfo.setPartSubsistenceCostSharing(partSubsistenceCostSharing);
        otherDirectCostInfo.setPartOther(partOtherCost);
        otherDirectCostInfo.setPartOtherCostSharing(partOtherCostSharing);
        otherDirectCostInfo.setParticipantTotal(totalParticipantCost);
        otherDirectCostInfo.setParticipantTotalCostSharing(totalParticipantCostSharing);
        otherDirectCostInfo.setParticipantTotalCount(budgetPeriod.getNumberOfParticipants() == null ? 0 : budgetPeriod.getNumberOfParticipants());
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(materialCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(consultantCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(publicationCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(computerCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(alterationsCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(subContractCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(equipmentRentalCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(otherDirectCost);
        totalOtherDirect = (BudgetDecimal)totalOtherDirect.add(otherCost);
        totalTravelCost = (BudgetDecimal)totalTravelCost.add(domesticTravelCost);
        totalTravelCost = (BudgetDecimal)totalTravelCost.add(foreignTravelCost);
        if (budget.getSubmitCostSharingFlag().booleanValue()) {
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(materialCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(consultantCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(publicationCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(computerCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(alterationsCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(subContractCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(equipmentRentalCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(otherDirectCostSharing);
            totalOtherDirectCostSharing = (BudgetDecimal)totalOtherDirectCostSharing.add(otherCostSharing);
            totalTravelCostSharing = (BudgetDecimal)totalTravelCostSharing.add(domesticTravelCostSharing);
            totalTravelCostSharing = (BudgetDecimal)totalTravelCostSharing.add(foreignTravelCostSharing);
        }
        otherDirectCostInfo.settotalOtherDirect(totalOtherDirect);
        otherDirectCostInfo.setTotalOtherDirectCostSharing(totalOtherDirectCostSharing);
        otherDirectCostInfo.setTotTravel(totalTravelCost);
        otherDirectCostInfo.setTotTravelCostSharing(totalTravelCostSharing);
        ArrayList<Map<String, String>> otherCostDetails = new ArrayList<Map<String, String>>();
        HashMap<String, String> hmOtherDirectCostDetails = new HashMap<String, String>();
        hmOtherDirectCostDetails.put("Cost", otherDirectCost.toString());
        hmOtherDirectCostDetails.put(DESCRIPTION, OTHER_DIRECT_COSTS);
        hmOtherDirectCostDetails.put("CostSharing", otherDirectCostSharing.toString());
        otherCostDetails.add(hmOtherDirectCostDetails);
        HashMap<String, String> hmOtherCostDetails = new HashMap<String, String>();
        hmOtherCostDetails.put("Cost", otherCost.toString());
        hmOtherCostDetails.put(DESCRIPTION, ALL_OTHER_COSTS);
        hmOtherCostDetails.put("CostSharing", otherCostSharing.toString());
        otherCostDetails.add(hmOtherCostDetails);
        otherDirectCostInfo.setOtherCosts(otherCostDetails);
        ArrayList<OtherDirectCostInfo> otherDirectCosts = new ArrayList<OtherDirectCostInfo>();
        otherDirectCosts.add(otherDirectCostInfo);
        return otherDirectCosts;
    }

    private boolean canBudgetLineItemCostSharingInclude(Budget budget, BudgetLineItem lineItem) {
        return budget.getSubmitCostSharingFlag() != false && lineItem.getSubmitCostSharingFlag() != false;
    }

    @Override
    public List<BudgetCategoryMap> getBudgetCategoryMapList(List<String> filterTargetCategoryCodes, List<String> filterCategoryTypes) {
        ArrayList<BudgetCategoryMap> budgetCategoryMapList = new ArrayList<BudgetCategoryMap>();
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put(KEY_MAPPING_NAME, "S2S");
        List<BudgetCategoryMapping> budgetCategoryMappingList = this.getBudgetCategoryMappings(categoryMap);
        for (BudgetCategoryMapping categoryMapping : budgetCategoryMappingList) {
            boolean targetMatched = true;
            if (filterTargetCategoryCodes.size() > 0) {
                for (String targetCategoryCode : filterTargetCategoryCodes) {
                    if (!categoryMapping.getTargetCategoryCode().equals(targetCategoryCode)) continue;
                    targetMatched = false;
                    break;
                }
            }
            if (!targetMatched) continue;
            HashMap<String, String> conditionMap = new HashMap<String, String>();
            conditionMap.put(KEY_MAPPING_NAME, categoryMapping.getMappingName());
            conditionMap.put(KEY_TARGET_CATEGORY_CODE, categoryMapping.getTargetCategoryCode());
            for (BudgetCategoryMap filterMap : this.businessObjectService.findMatching(BudgetCategoryMap.class, conditionMap)) {
                filterMap.setCategoryType(filterMap.getCategoryType().trim());
                targetMatched = true;
                if (filterCategoryTypes.size() > 0) {
                    for (String categoryType : filterCategoryTypes) {
                        if (!filterMap.getCategoryType().equals(categoryType)) continue;
                        targetMatched = false;
                        break;
                    }
                }
                if (!targetMatched) continue;
                boolean duplicateExists = false;
                for (BudgetCategoryMap map : budgetCategoryMapList) {
                    if (!filterMap.getTargetCategoryCode().equals(map.getTargetCategoryCode())) continue;
                    duplicateExists = true;
                    break;
                }
                if (duplicateExists) continue;
                budgetCategoryMapList.add(filterMap);
            }
        }
        return budgetCategoryMapList;
    }

    protected List<EquipmentInfo> getEquipment(BudgetPeriod budgetPeriod) {
        ArrayList<CostInfo> cvExtraEquipment = new ArrayList<CostInfo>();
        List<BudgetCategoryMap> budgetCategoryMapList = this.getBudgetCategoryMapList(new ArrayList<String>(), new ArrayList<String>());
        BudgetDecimal totalEquipFund = BudgetDecimal.ZERO;
        BudgetDecimal totalExtraEquipFund = BudgetDecimal.ZERO;
        BudgetDecimal totalEquipNonFund = BudgetDecimal.ZERO;
        BudgetDecimal totalExtraEquipNonFund = BudgetDecimal.ZERO;
        HashMap<String, CostInfo> costInfoMap = new HashMap<String, CostInfo>();
        ArrayList<CostInfo> costInfos = new ArrayList<CostInfo>();
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetCategoryMap budgetCategoryMap : budgetCategoryMapList) {
                CostInfo equipCostInfo = new CostInfo();
                for (BudgetCategoryMapping budgetCategoryMapping : budgetCategoryMap.getBudgetCategoryMappings()) {
                    if (!lineItem.getBudgetCategoryCode().equals(budgetCategoryMapping.getBudgetCategoryCode()) || !budgetCategoryMapping.getTargetCategoryCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetTargetCategoryCodeEquipmentCost")) || !budgetCategoryMapping.getMappingName().equals("S2S")) continue;
                    equipCostInfo.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                    equipCostInfo.setCategory(budgetCategoryMap.getDescription());
                    equipCostInfo.setCategoryType(budgetCategoryMap.getCategoryType());
                    if (lineItem.getLineItemDescription() != null) {
                        equipCostInfo.setDescription(lineItem.getLineItemDescription());
                    } else {
                        equipCostInfo.setDescription(lineItem.getCostElementBO().getDescription());
                    }
                    totalEquipFund = (BudgetDecimal)totalEquipFund.add(lineItem.getLineItemCost());
                    if (this.canBudgetLineItemCostSharingInclude(budgetPeriod.getBudget(), lineItem)) {
                        totalEquipNonFund = (BudgetDecimal)totalEquipNonFund.add(lineItem.getCostSharingAmount());
                    }
                    StringBuilder keyBuilder = new StringBuilder();
                    keyBuilder.append(budgetCategoryMap.getCategoryType());
                    keyBuilder.append("-");
                    keyBuilder.append(lineItem.getLineItemDescription());
                    String key = keyBuilder.toString();
                    if (costInfoMap.get(key) == null) {
                        equipCostInfo = new CostInfo();
                        equipCostInfo.setBudgetPeriod(budgetPeriod.getBudgetPeriod());
                        equipCostInfo.setCategory(budgetCategoryMap.getDescription());
                        equipCostInfo.setCategoryType(budgetCategoryMap.getCategoryType());
                        if (lineItem.getLineItemDescription() != null) {
                            equipCostInfo.setDescription(lineItem.getLineItemDescription());
                        } else {
                            equipCostInfo.setDescription(lineItem.getCostElementBO().getDescription());
                        }
                        equipCostInfo.setCost(lineItem.getLineItemCost());
                        if (this.canBudgetLineItemCostSharingInclude(budgetPeriod.getBudget(), lineItem)) {
                            equipCostInfo.setCostSharing(lineItem.getCostSharingAmount());
                        }
                    } else {
                        equipCostInfo = (CostInfo)costInfoMap.get(key);
                        equipCostInfo.setCost((BudgetDecimal)equipCostInfo.getCost().add(lineItem.getLineItemCost()));
                        if (this.canBudgetLineItemCostSharingInclude(budgetPeriod.getBudget(), lineItem)) {
                            equipCostInfo.setCostSharing((BudgetDecimal)equipCostInfo.getCostSharing().add(lineItem.getCostSharingAmount()));
                        }
                    }
                    costInfoMap.put(key, equipCostInfo);
                    costInfos.add(equipCostInfo);
                }
            }
        }
        EquipmentInfo equipmentInfo = new EquipmentInfo();
        if (costInfos.size() > 10) {
            for (int j = costInfos.size() - 1; j > 9; --j) {
                cvExtraEquipment.add((CostInfo)costInfos.get(j));
                CostInfo extraCostInfo = (CostInfo)costInfos.get(j);
                totalExtraEquipFund = (BudgetDecimal)totalExtraEquipFund.add(extraCostInfo.getCost());
                totalExtraEquipNonFund = (BudgetDecimal)totalExtraEquipNonFund.add(extraCostInfo.getCostSharing());
                costInfos.remove(j);
            }
            Collections.reverse(cvExtraEquipment);
            equipmentInfo.setExtraEquipmentList(cvExtraEquipment);
            equipmentInfo.setTotalExtraNonFund(totalExtraEquipNonFund);
        }
        equipmentInfo.setTotalExtraFund(totalExtraEquipFund);
        equipmentInfo.setEquipmentList(costInfos);
        equipmentInfo.setTotalFund(totalEquipFund);
        equipmentInfo.setTotalNonFund(totalEquipNonFund);
        ArrayList<EquipmentInfo> equipmentInfos = new ArrayList<EquipmentInfo>();
        equipmentInfos.add(equipmentInfo);
        return equipmentInfos;
    }

    protected List<List<KeyPersonInfo>> getKeyPersons(BudgetPeriod budgetPeriod, ProposalDevelopmentDocument pdDoc, int numKeyPersons) {
        CompensationInfo compensationInfo;
        KeyPersonInfo keyPersonInfo;
        ArrayList<KeyPersonInfo> keyPersons = new ArrayList<KeyPersonInfo>();
        KeyPersonInfo keyPerson = new KeyPersonInfo();
        ProposalPerson principalInvestigator = this.s2SUtilService.getPrincipalInvestigator(pdDoc);
        ArrayList<ProposalPerson> propPersons = new ArrayList<ProposalPerson>();
        if (principalInvestigator != null) {
            propPersons.add(principalInvestigator);
            keyPerson.setPersonId(principalInvestigator.getPersonId());
            keyPerson.setRolodexId(principalInvestigator.getRolodexId());
            keyPerson.setFirstName(principalInvestigator.getFirstName() == null ? "Unknown" : principalInvestigator.getFirstName());
            keyPerson.setLastName(principalInvestigator.getLastName() == null ? "Unknown" : principalInvestigator.getLastName());
            keyPerson.setMiddleName(principalInvestigator.getMiddleName());
            keyPerson.setRole("PD/PI");
            keyPerson.setNonMITPersonFlag(this.isPersonNonMITPerson(principalInvestigator));
            keyPersons.add(keyPerson);
        }
        for (ProposalPerson coInvestigator : this.s2SUtilService.getCoInvestigators(pdDoc)) {
            propPersons.add(coInvestigator);
            keyPerson = new KeyPersonInfo();
            keyPerson.setPersonId(coInvestigator.getPersonId());
            keyPerson.setRolodexId(coInvestigator.getRolodexId());
            keyPerson.setFirstName(coInvestigator.getFirstName() == null ? "Unknown" : coInvestigator.getFirstName());
            keyPerson.setLastName(coInvestigator.getLastName() == null ? "Unknown" : coInvestigator.getLastName());
            keyPerson.setMiddleName(coInvestigator.getMiddleName());
            keyPerson.setNonMITPersonFlag(this.isPersonNonMITPerson(coInvestigator));
            SponsorService sponsorService = KraServiceLocator.getService(SponsorService.class);
            if (sponsorService.isSponsorNihMultiplePi(pdDoc.getDevelopmentProposal())) {
                if (coInvestigator.isMultiplePi()) {
                    keyPerson.setRole("PD/PI");
                } else {
                    keyPerson.setRole(NID_CO_PD_PI);
                }
            } else {
                keyPerson.setRole(KEYPERSON_CO_PD_PI);
            }
            keyPersons.add(keyPerson);
        }
        for (ProposalPerson propPerson : this.s2SUtilService.getKeyPersons(pdDoc)) {
            propPersons.add(propPerson);
            keyPerson = new KeyPersonInfo();
            keyPerson.setPersonId(propPerson.getPersonId());
            keyPerson.setRolodexId(propPerson.getRolodexId());
            keyPerson.setFirstName(propPerson.getFirstName() == null ? "Unknown" : propPerson.getFirstName());
            keyPerson.setLastName(propPerson.getLastName() == null ? "Unknown" : propPerson.getLastName());
            keyPerson.setMiddleName(propPerson.getMiddleName());
            keyPerson.setNonMITPersonFlag(this.isPersonNonMITPerson(propPerson));
            keyPerson.setRole(this.getBudgetPersonRoleOther());
            keyPerson.setKeyPersonRole(propPerson.getProjectRole());
            keyPersons.add(keyPerson);
        }
        boolean personAlreadyAdded = false;
        HashMap<String, String> categoryMap = new HashMap<String, String>();
        categoryMap.put(KEY_TARGET_CATEGORY_CODE, TARGET_CATEGORY_CODE_01);
        categoryMap.put(KEY_MAPPING_NAME, "S2S");
        List<BudgetCategoryMapping> budgetCategoryList = this.getBudgetCategoryMappings(categoryMap);
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                personAlreadyAdded = false;
                for (ProposalPerson coInvestigator : pdDoc.getDevelopmentProposal().getInvestigators()) {
                    if (!this.s2SUtilService.proposalPersonEqualsBudgetPerson(coInvestigator, budgetPersonnelDetails)) continue;
                    personAlreadyAdded = true;
                    break;
                }
                budgetPersonnelDetails.refreshReferenceObject("budgetPerson");
                if (personAlreadyAdded) continue;
                if (budgetPersonnelDetails.getNonEmployeeFlag().booleanValue()) {
                    if (budgetPersonnelDetails.getBudgetPerson().getRolodexId() != null) {
                        budgetPersonnelDetails.getBudgetPerson().refreshReferenceObject("rolodex");
                        Rolodex rolodexPerson = budgetPersonnelDetails.getBudgetPerson().getRolodex();
                        keyPerson = new KeyPersonInfo();
                        keyPerson.setRolodexId(rolodexPerson.getRolodexId());
                        keyPerson.setFirstName(rolodexPerson.getFirstName() == null ? "Unknown" : rolodexPerson.getFirstName());
                        keyPerson.setLastName(rolodexPerson.getLastName() == null ? "Unknown" : rolodexPerson.getLastName());
                        keyPerson.setMiddleName(rolodexPerson.getMiddleName());
                        keyPerson.setRole(StringUtils.isNotBlank((String)rolodexPerson.getTitle()) ? rolodexPerson.getTitle() : this.getBudgetPersonRoleOther());
                        keyPerson.setNonMITPersonFlag(true);
                        if (!this.isSeniorLineItem(budgetCategoryList, lineItem.getBudgetCategoryCode())) continue;
                        keyPersons.add(keyPerson);
                        continue;
                    }
                    if (!StringUtils.isNotBlank((String)budgetPersonnelDetails.getBudgetPerson().getTbnId())) continue;
                    HashMap<String, String> searchMap = new HashMap<String, String>();
                    searchMap.put("tbnId", budgetPersonnelDetails.getBudgetPerson().getTbnId());
                    TbnPerson tbnPerson = (TbnPerson)this.businessObjectService.findByPrimaryKey(TbnPerson.class, searchMap);
                    if (tbnPerson == null) continue;
                    keyPerson = new KeyPersonInfo();
                    keyPerson.setPersonId(tbnPerson.getJobCode());
                    String[] tbnNames = tbnPerson.getPersonName().split(" ");
                    int nameIndex = 0;
                    keyPerson.setPersonId(tbnPerson.getTbnId());
                    keyPerson.setFirstName(tbnNames.length >= 1 ? tbnNames[nameIndex++] : "Unknown");
                    keyPerson.setMiddleName(tbnNames.length >= 3 ? tbnNames[nameIndex++] : " ");
                    keyPerson.setLastName(tbnNames.length >= 2 ? tbnNames[nameIndex++] : "Unknown");
                    keyPerson.setRole(tbnPerson.getPersonName());
                    keyPerson.setNonMITPersonFlag(false);
                    if (!this.isSeniorLineItem(budgetCategoryList, lineItem.getBudgetCategoryCode())) continue;
                    keyPersons.add(keyPerson);
                    continue;
                }
                KcPerson kcPerson = null;
                try {
                    kcPerson = this.kcPersonService.getKcPersonByPersonId(budgetPersonnelDetails.getPersonId());
                }
                catch (Exception e) {
                    LOG.error((Object)("Person not found " + e));
                }
                if (kcPerson == null) continue;
                keyPerson = new KeyPersonInfo();
                keyPerson.setPersonId(kcPerson.getPersonId());
                keyPerson.setFirstName(kcPerson.getFirstName() == null ? "Unknown" : kcPerson.getFirstName());
                keyPerson.setLastName(kcPerson.getLastName() == null ? "Unknown" : kcPerson.getLastName());
                keyPerson.setMiddleName(kcPerson.getMiddleName());
                keyPerson.setNonMITPersonFlag(false);
                keyPerson.setRole(this.getBudgetPersonRoleOther());
                if (!this.isSeniorLineItem(budgetCategoryList, lineItem.getBudgetCategoryCode())) continue;
                keyPersons.add(keyPerson);
            }
        }
        ArrayList<KeyPersonInfo> allPersons = new ArrayList<KeyPersonInfo>();
        allPersons.addAll(keyPersons);
        List<KeyPersonInfo> nKeyPersons = this.getNKeyPersons(keyPersons, true, numKeyPersons);
        List<KeyPersonInfo> extraPersons = this.getNKeyPersons(allPersons, false, numKeyPersons);
        Iterator<Object> i$ = nKeyPersons.iterator();
        while (i$.hasNext()) {
            keyPerson = keyPersonInfo = (KeyPersonInfo)i$.next();
            compensationInfo = this.getCompensation(keyPerson, budgetPeriod, pdDoc.getDevelopmentProposal().getProposalNumber());
            keyPerson.setAcademicMonths(compensationInfo.getAcademicMonths());
            keyPerson.setCalendarMonths(compensationInfo.getCalendarMonths());
            keyPerson.setSummerMonths(compensationInfo.getSummerMonths());
            keyPerson.setBaseSalary(compensationInfo.getBaseSalary());
            keyPerson.setRequestedSalary(compensationInfo.getRequestedSalary());
            keyPerson.setFundsRequested(compensationInfo.getFundsRequested());
            keyPerson.setFringe(compensationInfo.getFringe());
            keyPerson.setCostSharingAmount(compensationInfo.getCostSharingAmount());
            keyPerson.setNonFundsRequested(compensationInfo.getNonFundsRequested());
            keyPerson.setFringeCostSharing(compensationInfo.getFringeCostSharing());
        }
        if (extraPersons != null) {
            i$ = extraPersons.iterator();
            while (i$.hasNext()) {
                keyPerson = keyPersonInfo = (KeyPersonInfo)i$.next();
                compensationInfo = this.getCompensation(keyPerson, budgetPeriod, pdDoc.getDevelopmentProposal().getProposalNumber());
                keyPerson.setAcademicMonths(compensationInfo.getAcademicMonths());
                keyPerson.setCalendarMonths(compensationInfo.getCalendarMonths());
                keyPerson.setSummerMonths(compensationInfo.getSummerMonths());
                keyPerson.setBaseSalary(compensationInfo.getBaseSalary());
                keyPerson.setRequestedSalary(compensationInfo.getRequestedSalary());
                keyPerson.setFundsRequested(compensationInfo.getFundsRequested());
                keyPerson.setFringe(compensationInfo.getFringe());
                keyPerson.setCostSharingAmount(compensationInfo.getCostSharingAmount());
                keyPerson.setNonFundsRequested(compensationInfo.getNonFundsRequested());
                keyPerson.setFringeCostSharing(compensationInfo.getFringeCostSharing());
            }
        }
        ArrayList<List<KeyPersonInfo>> listKeyPersons = new ArrayList<List<KeyPersonInfo>>();
        listKeyPersons.add(nKeyPersons);
        listKeyPersons.add(extraPersons);
        return listKeyPersons;
    }

    private String getBudgetPersonRoleOther() {
        return KEYPERSON_OTHER;
    }

    private boolean isSeniorLineItem(String keyPersonRole, List<BudgetCategoryMapping> budgetCategoryList, String budgetCategoryCode) {
        boolean isSeniorLineItem = false;
        if (keyPersonRole.equalsIgnoreCase(this.getBudgetPersonRoleOther())) {
            for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
                if (!categoryMapping.getBudgetCategoryCode().equals(budgetCategoryCode)) continue;
                isSeniorLineItem = true;
            }
        } else {
            isSeniorLineItem = true;
        }
        return isSeniorLineItem;
    }

    private boolean isSeniorLineItem(List<BudgetCategoryMapping> budgetCategoryList, String budgetCategoryCode) {
        boolean isSeniorLineItem = false;
        for (BudgetCategoryMapping categoryMapping : budgetCategoryList) {
            if (!categoryMapping.getBudgetCategoryCode().equals(budgetCategoryCode)) continue;
            isSeniorLineItem = true;
        }
        return isSeniorLineItem;
    }

    protected boolean budgetPersonExistInProposalPersons(BudgetPerson budgetPerson, List<ProposalPerson> propPersons) {
        for (ProposalPerson propPerson : propPersons) {
            if (!(budgetPerson.getPersonId() != null ? budgetPerson.getPersonId().equals(propPerson.getPersonId()) : budgetPerson.getRolodexId() != null && budgetPerson.getRolodexId().equals(propPerson.getRolodexId()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isPersonNonMITPerson(ProposalPerson proposalPerson) {
        return proposalPerson.getPersonId() == null;
    }

    protected List<BudgetCategoryMapping> getBudgetCategoryMappings(Map<String, String> conditionMap) {
        Collection budgetCategoryCollection = this.businessObjectService.findMatching(BudgetCategoryMapping.class, conditionMap);
        ArrayList<BudgetCategoryMapping> budgetCategoryMappings = new ArrayList<BudgetCategoryMapping>();
        if (budgetCategoryCollection != null) {
            budgetCategoryMappings.addAll(budgetCategoryCollection);
        }
        return budgetCategoryMappings;
    }

    protected CompensationInfo getCompensation(KeyPersonInfo keyPerson, BudgetPeriod budgetPeriod, String proposalNumber) {
        CompensationInfo compensationInfo = new CompensationInfo();
        BudgetDecimal summerMonths = BudgetDecimal.ZERO;
        BudgetDecimal academicMonths = BudgetDecimal.ZERO;
        BudgetDecimal calendarMonths = BudgetDecimal.ZERO;
        BudgetDecimal totalSal = BudgetDecimal.ZERO;
        BudgetDecimal fringe = BudgetDecimal.ZERO;
        BudgetDecimal baseAmount = BudgetDecimal.ZERO;
        BudgetDecimal totalSalCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal fringeCostSharing = BudgetDecimal.ZERO;
        BudgetDecimal numberOfMonths = BudgetDecimal.ZERO;
        String budgetCatagoryCodePersonnel = this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetCategoryCodePersonnel");
        for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
            for (BudgetPersonnelDetails personDetails : lineItem.getBudgetPersonnelDetailsList()) {
                if (!this.s2SUtilService.keyPersonEqualsBudgetPerson(keyPerson, personDetails)) continue;
                numberOfMonths = this.s2SUtilService.getNumberOfMonths(personDetails.getStartDate(), personDetails.getEndDate());
                if (personDetails.getPeriodTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetPeriodTypeAcademicMonths"))) {
                    academicMonths = lineItem.getSubmitCostSharingFlag().booleanValue() ? (BudgetDecimal)academicMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01))) : (BudgetDecimal)academicMonths.add(personDetails.getPercentCharged().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                } else if (personDetails.getPeriodTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetPeriodTypeSummerMonths"))) {
                    summerMonths = lineItem.getSubmitCostSharingFlag().booleanValue() ? (BudgetDecimal)summerMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01))) : (BudgetDecimal)summerMonths.add(personDetails.getPercentCharged().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                } else if (StringUtils.isNotBlank((String)personDetails.getBudgetPerson().getTbnId())) {
                    if (lineItem.getBudgetCategory().getBudgetCategoryCode().equals(budgetCatagoryCodePersonnel)) {
                        calendarMonths = lineItem.getSubmitCostSharingFlag().booleanValue() ? (BudgetDecimal)calendarMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01))) : (BudgetDecimal)calendarMonths.add(personDetails.getPercentCharged().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                    }
                } else {
                    calendarMonths = lineItem.getSubmitCostSharingFlag() != false ? (BudgetDecimal)calendarMonths.add(personDetails.getPercentEffort().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01))) : (BudgetDecimal)calendarMonths.add(personDetails.getPercentCharged().multiply(numberOfMonths).multiply(new BudgetDecimal(0.01)));
                }
                if (StringUtils.isNotBlank((String)personDetails.getBudgetPerson().getTbnId())) {
                    if (lineItem.getBudgetCategory().getBudgetCategoryCode().equals(budgetCatagoryCodePersonnel)) {
                        totalSal = (BudgetDecimal)totalSal.add(personDetails.getSalaryRequested());
                    }
                } else {
                    totalSal = (BudgetDecimal)totalSal.add(personDetails.getSalaryRequested());
                }
                if (this.canBudgetLineItemCostSharingInclude(budgetPeriod.getBudget(), lineItem)) {
                    if (StringUtils.isNotBlank((String)personDetails.getBudgetPerson().getTbnId())) {
                        if (lineItem.getBudgetCategory().getBudgetCategoryCode().equals(budgetCatagoryCodePersonnel)) {
                            totalSalCostSharing = (BudgetDecimal)totalSalCostSharing.add(personDetails.getCostSharingAmount());
                        }
                    } else {
                        totalSalCostSharing = (BudgetDecimal)totalSalCostSharing.add(personDetails.getCostSharingAmount());
                    }
                }
                for (BudgetPersonnelCalculatedAmount personCalculatedAmt : personDetails.getBudgetPersonnelCalculatedAmounts()) {
                    personCalculatedAmt.refreshReferenceObject("rateClass");
                    if ((!personCalculatedAmt.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeEmployeeBenefits")) || personCalculatedAmt.getRateTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateTypeSupportStaffSalaries"))) && (!personCalculatedAmt.getRateClass().getRateClassType().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateClassTypeVacation")) || personCalculatedAmt.getRateTypeCode().equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetRateTypeAdministrativeSalaries")))) continue;
                    if (StringUtils.isNotBlank((String)personDetails.getBudgetPerson().getTbnId())) {
                        if (lineItem.getBudgetCategory().getBudgetCategoryCode().equals(budgetCatagoryCodePersonnel)) {
                            fringe = (BudgetDecimal)fringe.add(personCalculatedAmt.getCalculatedCost());
                        }
                    } else {
                        fringe = (BudgetDecimal)fringe.add(personCalculatedAmt.getCalculatedCost());
                    }
                    if (!this.canBudgetLineItemCostSharingInclude(budgetPeriod.getBudget(), lineItem)) continue;
                    if (StringUtils.isNotBlank((String)personDetails.getBudgetPerson().getTbnId())) {
                        if (!lineItem.getBudgetCategory().getBudgetCategoryCode().equals(budgetCatagoryCodePersonnel)) continue;
                        fringeCostSharing = (BudgetDecimal)fringeCostSharing.add(personCalculatedAmt.getCalculatedCostSharing());
                        continue;
                    }
                    fringeCostSharing = (BudgetDecimal)fringeCostSharing.add(personCalculatedAmt.getCalculatedCostSharing());
                }
                BudgetPerson budgetPerson = personDetails.getBudgetPerson();
                if (budgetPerson == null) continue;
                baseAmount = budgetPerson.getCalculationBase();
                String apptTypeCode = budgetPerson.getAppointmentType().getAppointmentTypeCode();
                if (apptTypeCode.equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetAppointmentTypeSumEmployee")) || apptTypeCode.equals(this.getParameterService().getParameterValueAsString(ProposalDevelopmentDocument.class, "s2sBudgetAppointmentTypeTmpEmployee"))) continue;
                baseAmount = budgetPerson.getCalculationBase();
            }
        }
        compensationInfo.setAcademicMonths(academicMonths.setScale());
        compensationInfo.setCalendarMonths(calendarMonths.setScale());
        compensationInfo.setSummerMonths(summerMonths.setScale());
        compensationInfo.setRequestedSalary(totalSal);
        compensationInfo.setBaseSalary(baseAmount);
        compensationInfo.setCostSharingAmount(totalSalCostSharing);
        compensationInfo.setFringe(fringe);
        compensationInfo.setFundsRequested((BudgetDecimal)totalSal.add(fringe));
        compensationInfo.setFringeCostSharing(fringeCostSharing);
        compensationInfo.setNonFundsRequested((BudgetDecimal)totalSalCostSharing.add(fringeCostSharing));
        return compensationInfo;
    }

    protected List<KeyPersonInfo> getNKeyPersons(List<KeyPersonInfo> keyPersons, boolean firstN, int n) {
        int size = keyPersons.size();
        for (int i = size - 1; i > 0; --i) {
            KeyPersonInfo keyPersonInfo = keyPersons.get(i);
            KeyPersonInfo previousKeyPersonInfo = keyPersons.get(i - 1);
            if (keyPersonInfo.getPersonId() != null && previousKeyPersonInfo.getPersonId() != null && keyPersonInfo.getPersonId().equals(previousKeyPersonInfo.getPersonId())) {
                keyPersons.remove(i);
                continue;
            }
            if (keyPersonInfo.getRolodexId() == null || previousKeyPersonInfo.getRolodexId() == null || !keyPersonInfo.getRolodexId().equals(previousKeyPersonInfo.getRolodexId())) continue;
            keyPersons.remove(i);
        }
        size = keyPersons.size();
        if (firstN) {
            ArrayList<KeyPersonInfo> firstNPersons = new ArrayList<KeyPersonInfo>();
            if (size > n) {
                size = n;
            }
            for (int i = 0; i < size; ++i) {
                firstNPersons.add(keyPersons.get(i));
            }
            return firstNPersons;
        }
        ArrayList<KeyPersonInfo> extraPersons = new ArrayList<KeyPersonInfo>();
        for (int i = n; i < size; ++i) {
            extraPersons.add(keyPersons.get(i));
        }
        return extraPersons;
    }

    @Override
    public BudgetDocument getFinalBudgetVersion(ProposalDevelopmentDocument pdDoc) throws S2SException {
        BudgetDocument budgetDocument = null;
        BudgetVersionOverview versionOverview = pdDoc.getFinalBudgetVersion() == null ? null : pdDoc.getFinalBudgetVersion().getBudgetVersionOverview();
        try {
            if (versionOverview != null) {
                budgetDocument = (BudgetDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(versionOverview.getDocumentNumber());
            } else {
                List<BudgetDocumentVersion> budgetVersions = pdDoc.getBudgetDocumentVersions();
                QueryList<BudgetVersionOverview> budgetVersionOverviews = new QueryList<BudgetVersionOverview>();
                for (BudgetDocumentVersion budgetDocumentVersion : budgetVersions) {
                    budgetVersionOverviews.add(budgetDocumentVersion.getBudgetVersionOverview());
                }
                if (!budgetVersionOverviews.isEmpty()) {
                    budgetVersionOverviews.sort("budgetVersionNumber", false);
                    BudgetVersionOverview budgetVersionOverview = (BudgetVersionOverview)budgetVersionOverviews.get(0);
                    budgetDocument = (BudgetDocument)KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(budgetVersionOverview.getDocumentNumber());
                }
            }
        }
        catch (WorkflowException e) {
            LOG.error((Object)"Error while getting Budget veraion", (Throwable)e);
            throw new S2SException((Exception)((Object)e));
        }
        return budgetDocument;
    }

    @Override
    public BudgetDecimal getProposalPersonSalary(ProposalDevelopmentDocument pdDoc, ProposalPerson proposalPerson) throws S2SException {
        Budget budget;
        BudgetDecimal salary = BudgetDecimal.ZERO;
        BudgetDocument budgetDoc = this.getFinalBudgetVersion(pdDoc);
        Budget budget2 = budget = budgetDoc == null ? null : budgetDoc.getBudget();
        if (budget != null) {
            for (BudgetPeriod budgetPeriod : budget.getBudgetPeriods()) {
                for (BudgetLineItem lineItem : budgetPeriod.getBudgetLineItems()) {
                    for (BudgetPersonnelDetails budgetPersonnelDetails : lineItem.getBudgetPersonnelDetailsList()) {
                        if (!this.s2SUtilService.proposalPersonEqualsBudgetPerson(proposalPerson, budgetPersonnelDetails)) continue;
                        salary = (BudgetDecimal)salary.add(budgetPersonnelDetails.getSalaryRequested());
                    }
                }
            }
        }
        return salary;
    }

    public void setS2SUtilService(S2SUtilService s2SUtilService) {
        this.s2SUtilService = s2SUtilService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public void setRolodexService(RolodexService rolodexService) {
        this.rolodexService = rolodexService;
    }
}

