/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.service.S2SUtilService;

public class S2SCertificateReader {
    private String keyStoreLocation;
    private String keyStorePassword;
    private String trustStoreLocation;
    private String trustStorePassword;
    private String jksType = "JKS";
    private KeyStore keyStore = null;
    private KeyStore trustStore = null;
    private static final Log LOG = LogFactory.getLog(S2SCertificateReader.class);

    public KeyStore getKeyStore() throws S2SException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        try {
            this.keyStore = KeyStore.getInstance(this.jksType);
            this.keyStore.load(new FileInputStream(S2SCertificateReader.getS2SUtilService().getProperty(this.keyStoreLocation)), S2SCertificateReader.getS2SUtilService().getProperty(this.keyStorePassword).toCharArray());
        }
        catch (KeyStoreException e) {
            this.keyStore = null;
            LOG.error((Object)("Error while creating Keystore with cert " + this.keyStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.keystore.creation", e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            this.keyStore = null;
            LOG.error((Object)("JCE provider doesnt support certificate algorithm " + this.keyStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.keystore.no.algorithm", e.getMessage());
        }
        catch (CertificateException e) {
            this.keyStore = null;
            LOG.error((Object)("Error while creating keystore " + this.keyStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.keystore.badcertificate", e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.keyStore = null;
            LOG.error((Object)("File not found " + this.keyStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.keystore.not.found", e.getMessage());
        }
        catch (IOException e) {
            this.keyStore = null;
            LOG.error((Object)("IO Exception while reading keystore file " + this.keyStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.keystore.cannot.read", e.getMessage());
        }
        return this.keyStore;
    }

    private static S2SUtilService getS2SUtilService() {
        return KraServiceLocator.getService(S2SUtilService.class);
    }

    public KeyStore getTrustStore() throws S2SException {
        if (this.trustStore != null) {
            return this.trustStore;
        }
        try {
            this.trustStore = KeyStore.getInstance(this.jksType);
            this.trustStore.load(new FileInputStream(S2SCertificateReader.getS2SUtilService().getProperty(this.trustStoreLocation)), S2SCertificateReader.getS2SUtilService().getProperty(this.trustStorePassword).toCharArray());
        }
        catch (KeyStoreException e) {
            this.trustStore = null;
            LOG.error((Object)("Error while creating Keystore with cert " + this.trustStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.truststore.creation", e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            this.trustStore = null;
            LOG.error((Object)("JCE provider doesnt support certificate algorithm " + this.trustStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.truststore.no.algorithm", e.getMessage());
        }
        catch (CertificateException e) {
            this.trustStore = null;
            LOG.error((Object)("Error while creating keystore " + this.trustStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.truststore.badcertificate", e.getMessage());
        }
        catch (FileNotFoundException e) {
            this.trustStore = null;
            LOG.error((Object)("File not found " + this.trustStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.truststore.not.found", e.getMessage());
        }
        catch (IOException e) {
            this.trustStore = null;
            LOG.error((Object)("IO Exception while reading keystore file " + this.trustStoreLocation), (Throwable)e);
            throw new S2SException("error.s2s.truststore.cannot.read", e.getMessage());
        }
        return this.trustStore;
    }

    public String getKeyStoreLocation() {
        return this.keyStoreLocation;
    }

    public void setKeyStoreLocation(String keyStoreLocation) {
        this.keyStoreLocation = keyStoreLocation;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getTrustStoreLocation() {
        return this.trustStoreLocation;
    }

    public void setTrustStoreLocation(String trustStoreLocation) {
        this.trustStoreLocation = trustStoreLocation;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public String getJksType() {
        return this.jksType;
    }

    public void setJksType(String jksType) {
        this.jksType = jksType;
    }
}

