/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import gov.grants.apply.webservices.applicantintegrationservices_v1.GetApplicationListRequest;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetApplicationListResponse;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetApplicationStatusDetailRequest;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetApplicationStatusDetailResponse;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetOpportunityListRequest;
import gov.grants.apply.webservices.applicantintegrationservices_v1.GetOpportunityListResponse;
import gov.grants.apply.webservices.applicantintegrationservices_v1.SubmitApplicationRequest;
import gov.grants.apply.webservices.applicantintegrationservices_v1.SubmitApplicationResponse;
import gov.grants.apply.webservices.applicantintegrationservices_v1_0.ApplicantIntegrationPortType;
import gov.grants.apply.webservices.applicantintegrationservices_v1_0.ErrorMessage;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.service.S2SConnectorService;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.s2s.service.impl.S2SCertificateReader;
import org.kuali.rice.krad.service.BusinessObjectService;

public class S2SConnectorServiceBase
implements S2SConnectorService {
    private static final String JKS_TYPE = "JKS";
    protected static final Log LOG = LogFactory.getLog(S2SConnectorServiceBase.class);
    private S2SUtilService s2SUtilService;
    private BusinessObjectService businessObjectService;
    private static final String KEY_PROPOSAL_NUMBER = "proposalNumber";
    private static final String MULTI_CAMPUS_ENABLED = "MULTI_CAMPUS_ENABLED";
    private static final String MULTI_CAMPUS_ENABLED_VALUE = "1";
    private static final String KEY_OPPORTUNITY_ID = "OpportunityID";
    private static final String KEY_CFDA_NUMBER = "CFDANumber";
    private static final String KEY_SUBMISSION_TITLE = "SubmissionTitle";
    protected String serviceHost;
    protected String servicePort;
    protected S2SCertificateReader s2sCertificateReader;

    @Override
    public GetOpportunityListResponse getOpportunityList(String cfdaNumber, String opportunityId, String competitionId) throws S2SException {
        ApplicantIntegrationPortType port = this.configureApplicantIntegrationSoapPort(null, false);
        GetOpportunityListRequest getOpportunityListRequest = new GetOpportunityListRequest();
        getOpportunityListRequest.setCFDANumber(cfdaNumber);
        getOpportunityListRequest.setCompetitionID(competitionId);
        getOpportunityListRequest.setOpportunityID(opportunityId);
        try {
            return port.getOpportunityList(getOpportunityListRequest);
        }
        catch (SOAPFaultException soapFault) {
            LOG.error((Object)"Error while getting list of opportunities", (Throwable)soapFault);
            if (soapFault.getMessage().indexOf("Connection refused") != -1) {
                throw new S2SException("error.grantsgov.opportunity.server.unavailable", soapFault.getMessage());
            }
            throw new S2SException("error.s2s.unknown", soapFault.getMessage());
        }
        catch (ErrorMessage e) {
            LOG.error((Object)"Error while getting list of opportunities", (Throwable)e);
            throw new S2SException("error.s2s.unknown", e.getMessage());
        }
    }

    @Override
    public GetApplicationStatusDetailResponse getApplicationStatusDetail(String ggTrackingId, String proposalNumber) throws S2SException {
        ApplicantIntegrationPortType port = this.getApplicantIntegrationSoapPort(proposalNumber);
        GetApplicationStatusDetailRequest applicationStatusDetailRequest = new GetApplicationStatusDetailRequest();
        applicationStatusDetailRequest.setGrantsGovTrackingNumber(ggTrackingId);
        try {
            return port.getApplicationStatusDetail(applicationStatusDetailRequest);
        }
        catch (ErrorMessage e) {
            LOG.error((Object)"Error while getting proposal submission status details", (Throwable)e);
            throw new S2SException("error.grantsgov.server.status.refresh", e.getMessage());
        }
    }

    @Override
    public GetApplicationListResponse getApplicationList(String opportunityId, String cfdaNumber, String proposalNumber) throws S2SException {
        GetApplicationListRequest applicationListRequest = new GetApplicationListRequest();
        List<GetApplicationListRequest.ApplicationFilter> filterList = applicationListRequest.getApplicationFilter();
        GetApplicationListRequest.ApplicationFilter applicationFilter = new GetApplicationListRequest.ApplicationFilter();
        applicationFilter.setFilter(KEY_OPPORTUNITY_ID);
        applicationFilter.setFilterValue(opportunityId);
        filterList.add(applicationFilter);
        if (cfdaNumber != null) {
            applicationFilter = new GetApplicationListRequest.ApplicationFilter();
            applicationFilter.setFilter(KEY_CFDA_NUMBER);
            applicationFilter.setFilterValue(cfdaNumber);
            filterList.add(applicationFilter);
        }
        applicationFilter = new GetApplicationListRequest.ApplicationFilter();
        applicationFilter.setFilter(KEY_SUBMISSION_TITLE);
        applicationFilter.setFilterValue(proposalNumber);
        filterList.add(applicationFilter);
        ApplicantIntegrationPortType port = this.getApplicantIntegrationSoapPort(proposalNumber);
        try {
            return port.getApplicationList(applicationListRequest);
        }
        catch (ErrorMessage e) {
            LOG.error((Object)"Error occured while fetching application list", (Throwable)e);
            throw new S2SException("error.grantsgov.server.applicationList.refresh", e.getMessage());
        }
    }

    @Override
    public SubmitApplicationResponse submitApplication(String xmlText, Map<String, DataHandler> attachments, String proposalNumber) throws S2SException {
        ApplicantIntegrationPortType port = this.getApplicantIntegrationSoapPort(proposalNumber);
        Client client = ClientProxy.getClient((Object)port);
        Iterator<String> it = attachments.keySet().iterator();
        final ArrayList<AttachmentImpl> atts = new ArrayList<AttachmentImpl>();
        while (it.hasNext()) {
            String key = it.next();
            AttachmentImpl attachment = new AttachmentImpl(key, attachments.get(key));
            atts.add(attachment);
        }
        List outInterceptors = client.getOutInterceptors();
        outInterceptors.add(new AttachmentOutInterceptor(){

            public void handleMessage(Message message) {
                message.setAttachments((Collection)atts);
            }
        });
        SubmitApplicationRequest request = new SubmitApplicationRequest();
        request.setGrantApplicationXML(xmlText);
        try {
            return port.submitApplication(request);
        }
        catch (ErrorMessage e) {
            LOG.error((Object)"Error occured while submitting proposal to Grants Gov", (Throwable)e);
            throw new S2SException("error.grantsgov.server.submit.application", e.getMessage());
        }
        catch (SOAPFaultException e) {
            LOG.error((Object)"Error occured while submitting proposal to Grants Gov", (Throwable)e);
            throw new S2SException("error.s2s.unknown", e.getMessage());
        }
    }

    protected ApplicantIntegrationPortType getApplicantIntegrationSoapPort(String proposalNumber) throws S2SException {
        HashMap<String, String> proposalMap = new HashMap<String, String>();
        proposalMap.put(KEY_PROPOSAL_NUMBER, proposalNumber);
        DevelopmentProposal pdDoc = (DevelopmentProposal)this.businessObjectService.findByPrimaryKey(DevelopmentProposal.class, proposalMap);
        String multiCampusEnabledStr = this.s2SUtilService.getParameterValue(MULTI_CAMPUS_ENABLED);
        boolean mulitCampusEnabled = multiCampusEnabledStr.equals(MULTI_CAMPUS_ENABLED_VALUE);
        return this.configureApplicantIntegrationSoapPort(pdDoc.getApplicantOrganization().getOrganization().getDunsNumber(), mulitCampusEnabled);
    }

    protected ApplicantIntegrationPortType configureApplicantIntegrationSoapPort(String alias, boolean mulitCampusEnabled) throws S2SException {
        System.clearProperty("java.protocol.handler.pkgs");
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setAddress(this.getS2SSoapHost());
        factory.setServiceClass(ApplicantIntegrationPortType.class);
        ApplicantIntegrationPortType applicantWebService = (ApplicantIntegrationPortType)factory.create();
        Client client = ClientProxy.getClient((Object)applicantWebService);
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(0L);
        httpClientPolicy.setReceiveTimeout(0L);
        httpClientPolicy.setAllowChunking(false);
        HTTPConduit conduit = (HTTPConduit)client.getConduit();
        conduit.setClient(httpClientPolicy);
        TLSClientParameters tlsConfig = new TLSClientParameters();
        this.setPossibleCypherSuites(tlsConfig);
        this.configureKeyStoreAndTrustStore(tlsConfig, alias, mulitCampusEnabled);
        conduit.setTlsClientParameters(tlsConfig);
        return applicantWebService;
    }

    protected void setPossibleCypherSuites(TLSClientParameters tlsConfig) {
        FiltersType filters = new FiltersType();
        filters.getInclude().add("SSL_RSA_WITH_RC4_128_MD5");
        filters.getInclude().add("SSL_RSA_WITH_RC4_128_SHA");
        filters.getInclude().add("SSL_RSA_WITH_3DES_EDE_CBC_SHA");
        filters.getInclude().add(".*_EXPORT_.*");
        filters.getInclude().add(".*_EXPORT1024_.*");
        filters.getInclude().add(".*_WITH_DES_.*");
        filters.getInclude().add(".*_WITH_3DES_.*");
        filters.getInclude().add(".*_WITH_RC4_.*");
        filters.getInclude().add(".*_WITH_NULL_.*");
        filters.getInclude().add(".*_DH_anon_.*");
        tlsConfig.setDisableCNCheck(true);
        tlsConfig.setCipherSuitesFilter(filters);
    }

    protected void configureKeyStoreAndTrustStore(TLSClientParameters tlsConfig, String alias, boolean mulitCampusEnabled) throws S2SException {
        KeyStore keyStore = this.s2sCertificateReader.getKeyStore();
        try {
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            if (alias != null && mulitCampusEnabled) {
                KeyStore keyStoreAlias = KeyStore.getInstance(this.s2sCertificateReader.getJksType());
                Certificate[] certificates = keyStore.getCertificateChain(alias);
                Key key = keyStore.getKey(alias, this.s2SUtilService.getProperty(this.s2sCertificateReader.getKeyStorePassword()).toCharArray());
                keyStoreAlias.load(null, null);
                keyStoreAlias.setKeyEntry(alias, key, this.s2SUtilService.getProperty(this.s2sCertificateReader.getKeyStorePassword()).toCharArray(), certificates);
                keyManagerFactory.init(keyStoreAlias, this.s2SUtilService.getProperty(this.s2sCertificateReader.getKeyStorePassword()).toCharArray());
            } else {
                keyManagerFactory.init(keyStore, this.s2SUtilService.getProperty(this.s2sCertificateReader.getKeyStorePassword()).toCharArray());
            }
            KeyManager[] km = keyManagerFactory.getKeyManagers();
            tlsConfig.setKeyManagers(km);
            KeyStore trustStore = this.s2sCertificateReader.getTrustStore();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] tm = trustManagerFactory.getTrustManagers();
            tlsConfig.setTrustManagers(tm);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)e);
            throw new S2SException("error.s2s.keystore.config", e.getMessage());
        }
        catch (KeyStoreException e) {
            LOG.error((Object)e);
            throw new S2SException("error.s2s.keystore.config", e.getMessage());
        }
        catch (UnrecoverableKeyException e) {
            LOG.error((Object)e);
            throw new S2SException("error.s2s.keystore.config", e.getMessage());
        }
        catch (CertificateException e) {
            LOG.error((Object)e);
            throw new S2SException("error.s2s.keystore.config", e.getMessage());
        }
        catch (IOException e) {
            LOG.error((Object)e);
            throw new S2SException("error.s2s.keystore.config", e.getMessage());
        }
    }

    protected String getS2SSoapHost() throws S2SException {
        StringBuilder host = new StringBuilder();
        host.append(this.s2SUtilService.getProperty(this.getServiceHost()));
        String port = this.s2SUtilService.getProperty(this.getServicePort());
        if (!host.toString().endsWith("/") && !port.startsWith("/")) {
            host.append("/");
        }
        host.append(port);
        return host.toString();
    }

    public void setS2SUtilService(S2SUtilService s2SUtilService) {
        this.s2SUtilService = s2SUtilService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public S2SUtilService getS2SUtilService() {
        return this.s2SUtilService;
    }

    public String getServiceHost() {
        return this.serviceHost;
    }

    public void setServiceHost(String serviceHost) {
        this.serviceHost = serviceHost;
    }

    public String getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(String servicePort) {
        this.servicePort = servicePort;
    }

    public S2SCertificateReader getS2sCertificateReader() {
        return this.s2sCertificateReader;
    }

    public void setS2sCertificateReader(S2SCertificateReader s2sCertificateReader) {
        this.s2sCertificateReader = s2sCertificateReader;
    }
}

