/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlOptions;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.formmapping.FormMappingInfo;
import org.kuali.kra.s2s.formmapping.FormMappingLoader;
import org.kuali.kra.s2s.generator.S2SFormGenerator;
import org.kuali.kra.s2s.generator.S2SGeneratorNotFoundException;
import org.kuali.kra.s2s.service.S2SFormGeneratorService;

public class S2SFormGeneratorServiceImpl
implements S2SFormGeneratorService {
    private static final Log LOG = LogFactory.getLog(S2SFormGeneratorServiceImpl.class);

    @Override
    public final S2SFormGenerator getS2SGenerator(String nameSpace) throws S2SException, S2SGeneratorNotFoundException {
        S2SFormGenerator formGenerator;
        FormMappingInfo formInfo = new FormMappingLoader().getFormInfo(nameSpace);
        try {
            formGenerator = (S2SFormGenerator)Class.forName(formInfo.getMainClass()).newInstance();
        }
        catch (InstantiationException e) {
            LOG.error((Object)("Cannot instantiate " + formInfo.getMainClass()), (Throwable)e);
            throw new S2SException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)("Illegal access : " + formInfo.getMainClass()), (Throwable)e);
            throw new S2SException(e);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("No class found : " + formInfo.getMainClass()), (Throwable)e);
            throw new S2SException(e);
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error from " + formInfo.getMainClass()), (Throwable)e);
            throw new S2SException("Could not generate form for " + formInfo.getMainClass(), e);
        }
        return formGenerator;
    }

    @Override
    public XmlOptions getXmlOptionsPrefixes() {
        XmlOptions xmlOptions = new XmlOptions();
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        prefixMap.put("http://apply.grants.gov/system/MetaGrantApplication", "");
        prefixMap.put("http://apply.grants.gov/forms/RR_SubawardBudget-V1.0", "RR_SubawardBudget");
        prefixMap.put("http://apply.grants.gov/forms/RR_SubawardBudget-V1.1", "RR_SubawardBudget");
        prefixMap.put("http://apply.grants.gov/forms/RR_SubawardBudget-V1.2", "RR_SubawardBudget");
        xmlOptions.setSaveSuggestedPrefixes(prefixMap);
        return xmlOptions;
    }
}

