/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import gov.grants.apply.system.universalCodesV20.CountryCodeDataType;
import gov.grants.apply.system.universalCodesV20.StateCodeDataType;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalYnq;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.service.S2SGeneratorUtilService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class S2SGeneratorUtilServiceImpl
implements S2SGeneratorUtilService {
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;
    private static final String SUBMISSION_TYPE_CODE = "submissionTypeCode";
    private static final String SUBMISSION_TYPE_DESCRIPTION = "submissionTypeDescription";
    private static final String YNQ_QUESTION_ID_TYPE_EQ = "EQ";
    private static final String YNQ_NOT_REVIEWED = "N";
    private static final String DATE_FORMAT = "MM/dd/yyyy";

    @Override
    public Map<String, String> getSubmissionType(ProposalDevelopmentDocument pdDoc) {
        HashMap<String, String> submissionInfo = new HashMap<String, String>();
        S2sOpportunity opportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (opportunity != null) {
            opportunity.refreshNonUpdateableReferences();
            String submissionTypeCode = opportunity.getS2sSubmissionTypeCode();
            String submissionTypeDescription = opportunity.getS2sSubmissionType().getDescription();
            String revisionCode = opportunity.getRevisionCode();
            String revisionOtherDescription = opportunity.getRevisionOtherDescription();
            submissionInfo.put(SUBMISSION_TYPE_CODE, submissionTypeCode);
            submissionInfo.put(SUBMISSION_TYPE_DESCRIPTION, submissionTypeDescription);
            submissionInfo.put("revisionCode", revisionCode);
            if (revisionOtherDescription != null) {
                submissionInfo.put("revisionOtherDescription", revisionOtherDescription);
            }
        }
        return submissionInfo;
    }

    @Override
    public DepartmentalPerson getDepartmentalPerson(ProposalDevelopmentDocument pdDoc) {
        boolean count = false;
        DepartmentalPerson depPerson = new DepartmentalPerson();
        if (count < true) {
            Organization organization = pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
            Rolodex rolodex = pdDoc.getDevelopmentProposal().getApplicantOrganization().getRolodex();
            if (rolodex != null) {
                depPerson.setFirstName(rolodex.getFirstName());
                depPerson.setMiddleName(rolodex.getMiddleName());
                depPerson.setLastName(rolodex.getLastName());
                StringBuilder fullName = new StringBuilder();
                if (rolodex.getFirstName() != null) {
                    fullName.append(rolodex.getFirstName());
                    fullName.append(" ");
                }
                if (rolodex.getMiddleName() != null) {
                    fullName.append(rolodex.getMiddleName());
                    fullName.append(" ");
                }
                if (rolodex.getLastName() != null) {
                    fullName.append(rolodex.getLastName());
                }
                depPerson.setFullName(fullName.toString());
                depPerson.setEmailAddress(rolodex.getEmailAddress());
                depPerson.setOfficePhone(rolodex.getPhoneNumber());
                depPerson.setPrimaryTitle(rolodex.getTitle());
                depPerson.setAddress1(rolodex.getAddressLine1());
                depPerson.setAddress2(rolodex.getAddressLine2());
                depPerson.setAddress3(rolodex.getAddressLine3());
                depPerson.setCity(rolodex.getCity());
                depPerson.setCountryCode(rolodex.getCountryCode());
                depPerson.setFaxNumber(rolodex.getFaxNumber());
                depPerson.setPostalCode(rolodex.getPostalCode());
                depPerson.setState(rolodex.getState());
                depPerson.setPersonId(Integer.toString(rolodex.getRolodexId()));
                depPerson.setDirDept(organization.getOrganizationName());
            }
        }
        return depPerson;
    }

    @Override
    public Map<String, String> getEOStateReview(ProposalDevelopmentDocument pdDoc) {
        HashMap<String, String> stateReview = new HashMap<String, String>();
        for (ProposalYnq proposalYnq : pdDoc.getDevelopmentProposal().getProposalYnqs()) {
            if (!proposalYnq.getQuestionId().equals(YNQ_QUESTION_ID_TYPE_EQ)) continue;
            stateReview.put("answer", proposalYnq.getAnswer());
            stateReview.put("reviewDate", String.valueOf(proposalYnq.getReviewDate().getTime()));
        }
        if (stateReview.size() == 0) {
            stateReview.put("answer", YNQ_NOT_REVIEWED);
            stateReview.put("reviewDate", null);
        }
        return stateReview;
    }

    @Override
    public String getFederalId(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        return null;
    }

    @Override
    public String getParameterValue(String parameter) {
        return this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, parameter);
    }

    @Override
    public CountryCodeDataType.Enum getCountryCodeDataType(String countryCode) {
        CountryCodeDataType.Enum countryCodeDataType = null;
        Country country = S2SGeneratorUtilServiceImpl.getCountryService().getCountryByAlternateCode(countryCode);
        if (country != null) {
            countryCodeDataType = CountryCodeDataType.Enum.forString((String)(country.getAlternateCode() + ": " + country.getName().toUpperCase()));
        }
        return countryCodeDataType;
    }

    protected static CountryService getCountryService() {
        return KraServiceLocator.getService(CountryService.class);
    }

    @Override
    public StateCodeDataType.Enum getStateCodeDataType(String stateName) {
        StateCodeDataType.Enum stateCodeDataType = null;
        String countryCode = this.parameterService.getParameterValueAsString("KR-NS", "All", "DEFAULT_COUNTRY");
        State state = S2SGeneratorUtilServiceImpl.getStateService().getState(countryCode, stateName);
        if (state != null) {
            stateCodeDataType = StateCodeDataType.Enum.forString((String)(state.getCode() + ": " + state.getName()));
        }
        return stateCodeDataType;
    }

    protected static StateService getStateService() {
        return KraServiceLocator.getService(StateService.class);
    }

    protected String formatDate(String dateStr, String formatStr) {
        int year = 0;
        int month = 0;
        int day = 0;
        if (dateStr == null || formatStr == null) {
            return null;
        }
        year = Integer.parseInt(dateStr.substring(0, 4));
        month = Integer.parseInt(dateStr.substring(5, 7));
        day = Integer.parseInt(dateStr.substring(8, 10));
        return this.formatDate("" + month + "/" + day + "/" + year, "/-:,");
    }

    @Override
    public Calendar convertDateStringToCalendar(String dateStr) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (dateStr != null) {
            if (dateStr.indexOf(45) != -1) {
                dateStr = this.formatDate(dateStr, DATE_FORMAT);
            }
            calendar.set(Integer.parseInt(dateStr.substring(6, 10)), Integer.parseInt(dateStr.substring(0, 2)) - 1, Integer.parseInt(dateStr.substring(3, 5)));
            return calendar;
        }
        return null;
    }

    @Override
    public Calendar getCurrentCalendar() {
        return this.dateTimeService.getCurrentCalendar();
    }

    @Override
    public Calendar convertDateToCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        cal.setTime(date);
        return cal;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

