/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import java.util.List;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.s2s.service.S2SProposalValidatorService;
import org.kuali.kra.s2s.validator.S2SErrorMessages;

public class S2SProposalValidatorServiceImpl
implements S2SProposalValidatorService {
    private static final String OPPORTUNITY_ID_REQUIRED = "proposalvalidation.opportunityId_required";
    private static final String CFDA_NUMBER_REQUIRED = "proposalvalidation.cfdaNumber_required";

    public boolean validate(ProposalDevelopmentDocument pdDoc, List<String> errors) {
        boolean validationStatus = true;
        pdDoc.getDevelopmentProposal().getS2sOpportunity().refreshNonUpdateableReferences();
        if (pdDoc.getDevelopmentProposal().getS2sOpportunity().getOpportunityId() == null) {
            errors.add(S2SErrorMessages.getProperty(OPPORTUNITY_ID_REQUIRED, "proposalvalidation.opportunityId_required Is not found"));
            validationStatus = false;
        }
        if (pdDoc.getDevelopmentProposal().getCfdaNumber() == null) {
            errors.add(S2SErrorMessages.getProperty(CFDA_NUMBER_REQUIRED, "proposalvalidation.cfdaNumber_required Is not found"));
            validationStatus = false;
        }
        return validationStatus;
    }
}

