/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.CitizenshipType;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.infrastructure.CitizenshipTypes;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.proposaladmindetails.ProposalAdminDetails;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.Narrative;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalSite;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentS2sQuestionnaireService;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.s2s.bo.S2sAppSubmission;
import org.kuali.kra.s2s.bo.S2sOpportunity;
import org.kuali.kra.s2s.generator.bo.DepartmentalPerson;
import org.kuali.kra.s2s.generator.bo.KeyPersonInfo;
import org.kuali.kra.s2s.service.S2SUtilService;
import org.kuali.kra.service.CitizenshipTypeService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.location.api.country.Country;
import org.kuali.rice.location.api.country.CountryService;
import org.kuali.rice.location.api.state.State;
import org.kuali.rice.location.api.state.StateService;

public class S2SUtilServiceImpl
implements S2SUtilService {
    private static final String FEDERAL_ID_COMES_FROM_CURRENT_AWARD = "FEDERAL_ID_COMES_FROM_CURRENT_AWARD";
    private BusinessObjectService businessObjectService;
    private DateTimeService dateTimeService;
    private ConfigurationService kualiConfigurationService;
    private ParameterService parameterService;
    private ProposalDevelopmentService proposalDevelopmentService;
    private KcPersonService kcPersonService;
    private SponsorService sponsorService;
    private NarrativeService narrativeService;
    private CitizenshipTypeService citizenshipTypeService;
    private UnitService unitService;
    private ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService;
    private static final String SUBMISSION_TYPE_CODE = "submissionTypeCode";
    private static final String SUBMISSION_TYPE_DESCRIPTION = "submissionTypeDescription";
    private static final String PROPOSAL_YNQ_STATE_REVIEW = "EO";
    private static final String YNQ_NOT_REVIEWED = "X";
    private static final int DIVISION_NAME_MAX_LENGTH = 30;
    private static final String PROPOSAL_CONTACT_TYPE = "PROPOSAL_CONTACT_TYPE";
    private static final String CONTACT_TYPE_O = "O";
    private static final Log LOG = LogFactory.getLog(S2SUtilServiceImpl.class);
    private static final Integer UNIT_HEIRARCHY_NODE = 3;
    public static final String PROPOSAL_YNQ_QUESTION_129 = "129";
    public static final String PROPOSAL_YNQ_QUESTION_130 = "130";
    public static final String PROPOSAL_YNQ_QUESTION_131 = "131";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final Integer MODULE_ITEM_CODE_THREE = 3;
    private static final String MODULE_SUB_ITEM_CODE = "moduleSubItemCode";
    private static final Integer MODULE_SUB_ITEM_CODE_ZERO = 0;
    private static final String MODULE_SUB_ITEM_KEY = "moduleSubItemKey";
    private static final Integer MODULE_SUB_ITEM_KEY_ZERO = 0;
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private static final String QUESTIONNAIRE_ID = "questionnaireId";
    private static final String QUESTIONNAIRE_REF_ID_FK = "questionnaireRefIdFk";
    private static final String PI_CUSTOM_DATA = "PI_CITIZENSHIP_FROM_CUSTOM_DATA";

    @Override
    public Map<String, String> getSubmissionType(ProposalDevelopmentDocument pdDoc) {
        HashMap<String, String> submissionInfo = new HashMap<String, String>();
        S2sOpportunity opportunity = pdDoc.getDevelopmentProposal().getS2sOpportunity();
        if (opportunity != null) {
            opportunity.refreshNonUpdateableReferences();
            String submissionTypeCode = opportunity.getS2sSubmissionTypeCode();
            String submissionTypeDescription = "";
            if (opportunity.getS2sSubmissionType() != null) {
                submissionTypeDescription = opportunity.getS2sSubmissionType().getDescription();
            }
            String revisionCode = opportunity.getRevisionCode();
            String revisionOtherDescription = opportunity.getRevisionOtherDescription();
            submissionInfo.put(SUBMISSION_TYPE_CODE, submissionTypeCode);
            submissionInfo.put(SUBMISSION_TYPE_DESCRIPTION, submissionTypeDescription);
            submissionInfo.put("revisionCode", revisionCode);
            if (revisionOtherDescription != null) {
                submissionInfo.put("revisionOtherDescription", revisionOtherDescription);
            }
        }
        return submissionInfo;
    }

    @Override
    public DepartmentalPerson getDepartmentalPerson(ProposalDevelopmentDocument pdDoc) {
        int count = 0;
        DepartmentalPerson depPerson = new DepartmentalPerson();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("devProposalNumber", pdDoc.getDevelopmentProposal().getProposalNumber());
        List proposalAdminDetailsList = (List)this.businessObjectService.findMatching(ProposalAdminDetails.class, fieldValues);
        count = proposalAdminDetailsList.size();
        if (count < 1) {
            Rolodex rolodex;
            Organization organization = pdDoc.getDevelopmentProposal().getApplicantOrganization().getOrganization();
            Rolodex rolodex2 = rolodex = organization == null ? null : organization.getRolodex();
            if (rolodex != null) {
                depPerson.setFirstName(rolodex.getFirstName());
                depPerson.setMiddleName(rolodex.getMiddleName());
                depPerson.setLastName(rolodex.getLastName());
                StringBuilder fullName = new StringBuilder();
                if (rolodex.getFirstName() != null) {
                    fullName.append(rolodex.getFirstName());
                    fullName.append(" ");
                }
                if (rolodex.getMiddleName() != null) {
                    fullName.append(rolodex.getMiddleName());
                    fullName.append(" ");
                }
                if (rolodex.getLastName() != null) {
                    fullName.append(rolodex.getLastName());
                }
                depPerson.setFullName(fullName.toString());
                depPerson.setEmailAddress(rolodex.getEmailAddress());
                depPerson.setOfficePhone(rolodex.getPhoneNumber());
                depPerson.setPrimaryTitle(rolodex.getTitle());
                depPerson.setAddress1(rolodex.getAddressLine1());
                depPerson.setAddress2(rolodex.getAddressLine2());
                depPerson.setAddress3(rolodex.getAddressLine3());
                depPerson.setCity(rolodex.getCity());
                depPerson.setCounty(rolodex.getCounty());
                depPerson.setCountryCode(rolodex.getCountryCode());
                depPerson.setFaxNumber(rolodex.getFaxNumber());
                depPerson.setPostalCode(rolodex.getPostalCode());
                depPerson.setState(rolodex.getState());
                depPerson.setPersonId(Integer.toString(rolodex.getRolodexId()));
                depPerson.setDirDept(organization.getOrganizationName());
            }
        } else {
            ProposalAdminDetails proposalAdminDetails = (ProposalAdminDetails)((Object)proposalAdminDetailsList.get(0));
            KcPerson person = null;
            person = this.kcPersonService.getKcPersonByUserName(proposalAdminDetails.getSignedBy());
            if (person != null) {
                depPerson.setFirstName(person.getFirstName());
                depPerson.setMiddleName(person.getMiddleName());
                depPerson.setLastName(person.getLastName());
                depPerson.setFullName(person.getFullName());
                depPerson.setEmailAddress(person.getEmailAddress());
                depPerson.setOfficePhone(person.getPhoneNumber());
                depPerson.setPrimaryTitle(person.getPrimaryTitle());
                depPerson.setAddress1(person.getAddressLine1());
                depPerson.setAddress2(person.getAddressLine2());
                depPerson.setAddress3(person.getAddressLine3());
                depPerson.setCity(person.getCity());
                depPerson.setCounty(person.getCounty());
                depPerson.setCountryCode(person.getCountryCode());
                depPerson.setFaxNumber(person.getFaxNumber());
                depPerson.setPostalCode(person.getPostalCode());
                depPerson.setState(person.getState());
                depPerson.setPersonId(person.getPersonId());
                depPerson.setDirDept(person.getContactOrganizationName());
            }
        }
        return depPerson;
    }

    @Override
    public List<ProposalPerson> getNKeyPersons(List<ProposalPerson> proposalPersons, boolean firstN, int n) {
        int size = proposalPersons.size();
        for (int i = size - 1; i > 0; --i) {
            ProposalPerson proposalPerson = proposalPersons.get(i);
            ProposalPerson previousProposalPerson = proposalPersons.get(i - 1);
            if (proposalPerson.getPersonId() != null && previousProposalPerson.getPersonId() != null && proposalPerson.getPersonId().equals(previousProposalPerson.getPersonId())) {
                proposalPersons.remove(i);
                continue;
            }
            if (proposalPerson.getRolodexId() == null || previousProposalPerson.getRolodexId() == null || !proposalPerson.getRolodexId().equals(previousProposalPerson.getRolodexId())) continue;
            proposalPersons.remove(i);
        }
        size = proposalPersons.size();
        if (firstN) {
            ArrayList<ProposalPerson> firstNPersons = new ArrayList<ProposalPerson>();
            if (size > n) {
                size = n;
            }
            for (int i = 0; i < size; ++i) {
                firstNPersons.add(proposalPersons.get(i));
            }
            return firstNPersons;
        }
        ArrayList<ProposalPerson> extraPersons = new ArrayList<ProposalPerson>();
        for (int i = n; i < size; ++i) {
            extraPersons.add(proposalPersons.get(i));
        }
        return extraPersons;
    }

    @Override
    public Map<String, String> getEOStateReview(ProposalDevelopmentDocument pdDoc) {
        HashMap<String, String> stateReview = new HashMap<String, String>();
        ProposalDevelopmentModuleQuestionnaireBean moduleQuestionnaireBean = new ProposalDevelopmentModuleQuestionnaireBean(pdDoc.getDevelopmentProposal());
        QuestionnaireAnswerService questionnaireAnswerService = KraServiceLocator.getService(QuestionnaireAnswerService.class);
        List<AnswerHeader> answerHeaders = questionnaireAnswerService.getQuestionnaireAnswer(moduleQuestionnaireBean);
        for (Answer answers : answerHeaders.get(0).getAnswers()) {
            if (answers.getQuestion().getQuestionId() != null && answers.getQuestion().getQuestionId().equals(PROPOSAL_YNQ_QUESTION_129) && stateReview.get("answer") == null) {
                stateReview.put("answer", answers.getAnswer());
            }
            if (answers.getQuestion().getQuestionId() != null && answers.getQuestion().getQuestionId().equals(PROPOSAL_YNQ_QUESTION_130) && stateReview.get("reviewDate") == null) {
                stateReview.put("reviewDate", answers.getAnswer());
            }
            if (answers.getQuestion().getQuestionId() == null || !answers.getQuestion().getQuestionId().equals(PROPOSAL_YNQ_QUESTION_131) || stateReview.get("stateReviewData") != null) continue;
            stateReview.put("stateReviewData", answers.getAnswer());
        }
        if (stateReview.size() == 0) {
            stateReview.put("answer", YNQ_NOT_REVIEWED);
            stateReview.put("reviewDate", null);
        }
        return stateReview;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getFederalId(ProposalDevelopmentDocument proposalDevelopmentDocument) {
        String federalIdComesFromAwardStr = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, FEDERAL_ID_COMES_FROM_CURRENT_AWARD);
        Boolean federalIdComesFromAward = federalIdComesFromAwardStr != null && federalIdComesFromAwardStr.equalsIgnoreCase("Y");
        DevelopmentProposal proposal = proposalDevelopmentDocument.getDevelopmentProposal();
        Award currentAward = null;
        String federalId = null;
        if (StringUtils.isNotBlank((String)proposal.getCurrentAwardNumber())) {
            currentAward = this.proposalDevelopmentService.getProposalCurrentAwardVersion(proposalDevelopmentDocument);
        }
        InstitutionalProposal institutionalProposal = null;
        if (StringUtils.isNotBlank((String)proposal.getContinuedFrom())) {
            institutionalProposal = this.proposalDevelopmentService.getProposalContinuedFromVersion(proposalDevelopmentDocument);
        }
        if (this.isProposalTypeRenewalRevisionContinuation(proposal.getProposalTypeCode())) {
            if (!StringUtils.isBlank((String)proposal.getSponsorProposalNumber())) {
                federalId = proposal.getSponsorProposalNumber();
            } else {
                if (currentAward == null || StringUtils.isBlank((String)currentAward.getSponsorAwardNumber()) || !federalIdComesFromAward.booleanValue()) return null;
                federalId = currentAward.getSponsorAwardNumber();
            }
        } else if (this.isProposalTypeNew(proposal.getProposalTypeCode()) && proposal.getS2sOpportunity() != null && this.isSubmissionTypeChangeCorrected(proposal.getS2sOpportunity().getS2sSubmissionTypeCode())) {
            if (!StringUtils.isBlank((String)proposal.getSponsorProposalNumber())) {
                federalId = proposal.getSponsorProposalNumber();
            } else if (institutionalProposal != null) {
                federalId = this.getGgTrackingIdFromProposal(institutionalProposal);
            }
        } else if (this.isProposalTypeResubmission(proposal.getProposalTypeCode())) {
            if (!StringUtils.isBlank((String)proposal.getSponsorProposalNumber())) {
                federalId = proposal.getSponsorProposalNumber();
            } else if (institutionalProposal != null && !StringUtils.isBlank((String)institutionalProposal.getSponsorProposalNumber())) {
                federalId = institutionalProposal.getSponsorProposalNumber();
            }
            if (this.isProposalTypeResubmission(proposal.getProposalTypeCode()) && proposal.getSponsorCode().equals(this.parameterService.getParameterValueAsString("KC-GEN", "All", "NSF_SPONSOR_CODE"))) {
                return null;
            }
        }
        if (federalId == null || !this.sponsorService.isSponsorNihMultiplePi(proposal)) return federalId;
        return this.fromatFederalId(federalId);
    }

    @Override
    public String getGgTrackingIdFromProposal(InstitutionalProposal proposal) {
        DevelopmentProposal newestDevProp = this.getNewestDevPropFromInstProp(proposal);
        if (newestDevProp != null && newestDevProp.getS2sOpportunity() != null) {
            S2sAppSubmission appSubmission = null;
            int submissionNo = 0;
            for (S2sAppSubmission s2AppSubmission : newestDevProp.getS2sAppSubmission()) {
                if (s2AppSubmission.getSubmissionNumber() <= submissionNo || !StringUtils.isNotBlank((String)s2AppSubmission.getGgTrackingId())) continue;
                appSubmission = s2AppSubmission;
                submissionNo = s2AppSubmission.getSubmissionNumber();
            }
            if (appSubmission != null) {
                return appSubmission.getGgTrackingId();
            }
            return null;
        }
        return null;
    }

    protected DevelopmentProposal getNewestDevPropFromInstProp(InstitutionalProposal instProp) {
        Integer listDetailSize = 0;
        ProposalAdminDetails curDetail = new ProposalAdminDetails();
        HashMap<String, Long> detailFieldValues = new HashMap<String, Long>();
        detailFieldValues.put("instProposalId", instProp.getProposalId());
        List details = (List)this.businessObjectService.findMatchingOrderBy(ProposalAdminDetails.class, detailFieldValues, "devProposalNumber", true);
        listDetailSize = details.size();
        if (listDetailSize > 1) {
            curDetail = (ProposalAdminDetails)((Object)details.get(listDetailSize - 2));
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("proposalNumber", curDetail.getDevelopmentProposal().getProposalNumber());
            List s2sSubmissionDetails = (List)this.businessObjectService.findMatchingOrderBy(S2sAppSubmission.class, fieldValues, "proposalNumber", true);
            curDetail.getDevelopmentProposal().setS2sAppSubmission(s2sSubmissionDetails);
            return curDetail.getDevelopmentProposal();
        }
        if (listDetailSize == 1) {
            curDetail = (ProposalAdminDetails)((Object)details.get(0));
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("proposalNumber", curDetail.getDevelopmentProposal().getProposalNumber());
            List s2sSubmissionDetails = (List)this.businessObjectService.findMatchingOrderBy(S2sAppSubmission.class, fieldValues, "proposalNumber", true);
            curDetail.getDevelopmentProposal().setS2sAppSubmission(s2sSubmissionDetails);
            return curDetail.getDevelopmentProposal();
        }
        return null;
    }

    protected String fromatFederalId(String federalId) {
        int in;
        if (federalId.length() > 7 && (in = federalId.indexOf(45, 8)) != -1) {
            federalId = federalId.substring(6, in);
        }
        return federalId;
    }

    protected boolean isSubmissionTypeChangeCorrected(String submissionTypeCode) {
        return StringUtils.equalsIgnoreCase((String)submissionTypeCode, (String)this.getParameterValue("s2s.submissiontype.changedCorrected"));
    }

    @Override
    public String getParameterValue(String parameter) {
        String parameterValue = null;
        try {
            parameterValue = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, parameter);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Parameter not found - " + parameter), (Throwable)e);
        }
        return parameterValue;
    }

    protected boolean isProposalTypeRenewalRevisionContinuation(String proposalTypeCode) {
        String proposalTypeCodeRenewal = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.renewal");
        String proposalTypeCodeRevision = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.revision");
        String proposalTypeCodeContinuation = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.continuation");
        return !StringUtils.isEmpty((String)proposalTypeCode) && (proposalTypeCode.equals(proposalTypeCodeRenewal) || proposalTypeCode.equals(proposalTypeCodeRevision) || proposalTypeCode.equals(proposalTypeCodeContinuation));
    }

    protected boolean isProposalTypeResubmission(String proposalTypeCode) {
        String proposalTypeCodeResubmission = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.resubmission");
        return !StringUtils.isEmpty((String)proposalTypeCode) && proposalTypeCode.equals(proposalTypeCodeResubmission);
    }

    protected boolean isProposalTypeNew(String proposalTypeCode) {
        String proposalTypeCodeNew = this.parameterService.getParameterValueAsString(ProposalDevelopmentDocument.class, "proposaldevelopment.proposaltype.new");
        return !StringUtils.isEmpty((String)proposalTypeCode) && proposalTypeCode.equals(proposalTypeCodeNew);
    }

    @Override
    public String getProperty(String key) {
        String value = this.kualiConfigurationService.getPropertyValueAsString(key);
        return value == null ? "" : value;
    }

    @Override
    public Calendar convertDateStringToCalendar(String dateStr) {
        Calendar calendar = null;
        if (dateStr != null) {
            calendar = this.dateTimeService.getCurrentCalendar();
            calendar.set(Integer.parseInt(dateStr.substring(6, 10)), Integer.parseInt(dateStr.substring(0, 2)) - 1, Integer.parseInt(dateStr.substring(3, 5)));
        }
        return calendar;
    }

    @Override
    public Calendar getCurrentCalendar() {
        return this.dateTimeService.getCurrentCalendar();
    }

    @Override
    public Calendar convertDateToCalendar(Date date) {
        Calendar calendar = null;
        if (date != null) {
            calendar = this.dateTimeService.getCalendar((java.util.Date)date);
        }
        return calendar;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ConfigurationService getKualiConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    @Override
    public String getDivisionName(ProposalDevelopmentDocument pdDoc) {
        String divisionName = null;
        if (pdDoc != null && pdDoc.getDevelopmentProposal().getOwnedByUnit() != null) {
            Unit ownedByUnit = pdDoc.getDevelopmentProposal().getOwnedByUnit();
            while (ownedByUnit.getParentUnit() != null) {
                ownedByUnit = ownedByUnit.getParentUnit();
            }
            divisionName = ownedByUnit.getUnitName();
            if (divisionName.length() > 30) {
                divisionName = divisionName.substring(0, 30);
            }
        }
        return divisionName;
    }

    @Override
    public ProposalPerson getPrincipalInvestigator(ProposalDevelopmentDocument pdDoc) {
        ProposalPerson proposalPerson = null;
        if (pdDoc != null) {
            for (ProposalPerson person : pdDoc.getDevelopmentProposal().getProposalPersons()) {
                if (!"PI".equals(person.getProposalPersonRoleId())) continue;
                proposalPerson = person;
            }
        }
        return proposalPerson;
    }

    @Override
    public List<ProposalPerson> getCoInvestigators(ProposalDevelopmentDocument pdDoc) {
        ArrayList<ProposalPerson> investigators = new ArrayList<ProposalPerson>();
        if (pdDoc != null) {
            for (ProposalPerson person : pdDoc.getDevelopmentProposal().getProposalPersons()) {
                if (!"COI".equals(person.getProposalPersonRoleId())) continue;
                investigators.add(person);
            }
        }
        return investigators;
    }

    @Override
    public List<ProposalPerson> getKeyPersons(ProposalDevelopmentDocument pdDoc) {
        ArrayList<ProposalPerson> keyPersons = new ArrayList<ProposalPerson>();
        if (pdDoc != null) {
            for (ProposalPerson person : pdDoc.getDevelopmentProposal().getProposalPersons()) {
                if (!"KP".equals(person.getProposalPersonRoleId())) continue;
                keyPersons.add(person);
            }
        }
        return keyPersons;
    }

    @Override
    public Country getCountryFromCode(String countryCode) {
        if (countryCode == null) {
            return null;
        }
        Country country = S2SUtilServiceImpl.getCountryService().getCountryByAlternateCode(countryCode);
        if (country == null) {
            country = S2SUtilServiceImpl.getCountryService().getCountry(countryCode);
        }
        return country;
    }

    protected static CountryService getCountryService() {
        return KraServiceLocator.getService(CountryService.class);
    }

    @Override
    public State getStateFromName(String countryAlternateCode, String stateName) {
        Country country = this.getCountryFromCode(countryAlternateCode);
        State state = S2SUtilServiceImpl.getStateService().getState(country.getCode(), stateName);
        return state;
    }

    protected static StateService getStateService() {
        return KraServiceLocator.getService(StateService.class);
    }

    @Override
    public boolean proposalPersonEqualsBudgetPerson(ProposalPerson proposalPerson, BudgetPersonnelDetails budgetPersonnelDetails) {
        boolean equal = false;
        if (proposalPerson != null && budgetPersonnelDetails != null) {
            String budgetPersonId = budgetPersonnelDetails.getPersonId();
            if (proposalPerson.getPersonId() != null && proposalPerson.getPersonId().equals(budgetPersonId) || proposalPerson.getRolodexId() != null && proposalPerson.getRolodexId().toString().equals(budgetPersonId)) {
                equal = true;
            }
        }
        return equal;
    }

    @Override
    public boolean keyPersonEqualsBudgetPerson(KeyPersonInfo keyPersonInfo, BudgetPersonnelDetails budgetPersonnelDetails) {
        boolean equal = false;
        if (keyPersonInfo != null && budgetPersonnelDetails != null) {
            String budgetPersonId = budgetPersonnelDetails.getPersonId();
            if (keyPersonInfo.getPersonId() != null && keyPersonInfo.getPersonId().equals(budgetPersonId) || keyPersonInfo.getRolodexId() != null && keyPersonInfo.getRolodexId().toString().equals(budgetPersonId)) {
                equal = true;
            }
        }
        return equal;
    }

    public void setProposalDevelopmentService(ProposalDevelopmentService proposalDevelopmentService) {
        this.proposalDevelopmentService = proposalDevelopmentService;
    }

    @Override
    public String convertStringArrayToString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String convertStringListToString(List<String> stringList) {
        String retVal = "";
        if (stringList != null) {
            for (int i = 0; i < stringList.size(); ++i) {
                retVal = retVal + stringList.get(i);
                if (i == stringList.size() - 1) continue;
                retVal = retVal + ", ";
            }
        }
        return retVal;
    }

    public List<Answer> getQuestionnaireAnswers(ProposalDevelopmentDocument pdDoc, Integer questionnaireId) {
        ArrayList<Answer> questionnaireAnswers = new ArrayList<Answer>();
        String proposalNumber = pdDoc.getDevelopmentProposal().getProposalNumber();
        Questionnaire questionnaire = this.getHighestSequenceNumberQuestionnair(questionnaireId);
        if (questionnaire != null) {
            HashMap<String, Object> fieldValues = new HashMap<String, Object>();
            fieldValues.put(MODULE_ITEM_KEY, proposalNumber);
            fieldValues.put(MODULE_ITEM_CODE, MODULE_ITEM_CODE_THREE);
            fieldValues.put(MODULE_SUB_ITEM_CODE, MODULE_SUB_ITEM_CODE_ZERO);
            fieldValues.put(MODULE_SUB_ITEM_KEY, MODULE_SUB_ITEM_KEY_ZERO);
            fieldValues.put(QUESTIONNAIRE_REF_ID_FK, questionnaire.getQuestionnaireRefId());
            Collection answerHeaderList = this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
            for (AnswerHeader answerHeader : answerHeaderList) {
                questionnaireAnswers.addAll(answerHeader.getAnswers());
            }
        }
        return questionnaireAnswers;
    }

    @Override
    public List<Answer> getQuestionnaireAnswersForPI(ProposalDevelopmentDocument pdDoc) {
        ArrayList<Answer> questionnaireAnswers = new ArrayList<Answer>();
        DevelopmentProposal proposal = pdDoc.getDevelopmentProposal();
        ProposalPerson person = proposal.getPrincipalInvestigator();
        ProposalPersonModuleQuestionnaireBean bean = new ProposalPersonModuleQuestionnaireBean(proposal, person);
        List<AnswerHeader> headers = KraServiceLocator.getService(QuestionnaireAnswerService.class).getQuestionnaireAnswer(bean);
        for (AnswerHeader answerHeader : headers) {
            questionnaireAnswers.addAll(answerHeader.getAnswers());
        }
        return questionnaireAnswers;
    }

    @Override
    public List<Answer> getQuestionnaireAnswers(DevelopmentProposal developmentProposal, String namespace, String formname) {
        List<AnswerHeader> answerHeaders = this.getProposalDevelopmentS2sQuestionnaireService().getProposalAnswerHeaderForForm(developmentProposal, namespace, formname);
        ArrayList<Answer> questionnaireAnswers = new ArrayList<Answer>();
        for (AnswerHeader answerHeader : answerHeaders) {
            Questionnaire questionnaire = answerHeader.getQuestionnaire();
            List<QuestionnaireQuestion> questionnaireQuestions = questionnaire.getQuestionnaireQuestions();
            for (QuestionnaireQuestion questionnaireQuestion : questionnaireQuestions) {
                Answer questionAnswer = this.getAnswer(questionnaireQuestion, answerHeader);
                questionnaireAnswers.add(questionAnswer);
            }
        }
        return questionnaireAnswers;
    }

    protected Answer getAnswer(QuestionnaireQuestion questionnaireQuestion, AnswerHeader answerHeader) {
        List<Answer> answers = answerHeader.getAnswers();
        for (Answer answer : answers) {
            if (!answer.getQuestionnaireQuestionsIdFk().equals(questionnaireQuestion.getQuestionnaireQuestionsId())) continue;
            return answer;
        }
        return null;
    }

    protected Questionnaire getHighestSequenceNumberQuestionnair(Integer questionnaireId) {
        Questionnaire highestQuestionnairSequenceNumber = null;
        HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
        fieldValues.put(QUESTIONNAIRE_ID, questionnaireId);
        Collection questionnairs = this.businessObjectService.findMatchingOrderBy(Questionnaire.class, fieldValues, SEQUENCE_NUMBER, Boolean.FALSE.booleanValue());
        if (questionnairs.size() > 0) {
            ArrayList questionnairList = new ArrayList();
            questionnairList.addAll(questionnairs);
            highestQuestionnairSequenceNumber = (Questionnaire)questionnairList.get(0);
        }
        return highestQuestionnairSequenceNumber;
    }

    @Override
    public DepartmentalPerson getContactPerson(ProposalDevelopmentDocument pdDoc) {
        Unit leadUnit;
        String contactType = this.getContactType();
        boolean isNumber = true;
        try {
            Integer.parseInt(contactType);
        }
        catch (NumberFormatException e) {
            isNumber = false;
        }
        DepartmentalPerson depPerson = new DepartmentalPerson();
        if (isNumber && (leadUnit = pdDoc.getDevelopmentProposal().getOwnedByUnit()) != null) {
            leadUnit.refreshReferenceObject("unitAdministrators");
            KcPerson unitAdmin = null;
            for (UnitAdministrator admin : leadUnit.getUnitAdministrators()) {
                if (!contactType.equals(admin.getUnitAdministratorTypeCode())) continue;
                unitAdmin = this.getKcPersonService().getKcPersonByPersonId(admin.getPersonId());
                depPerson.setLastName(unitAdmin.getLastName());
                depPerson.setFirstName(unitAdmin.getFirstName());
                if (unitAdmin.getMiddleName() != null) {
                    depPerson.setMiddleName(unitAdmin.getMiddleName());
                }
                depPerson.setEmailAddress(unitAdmin.getEmailAddress());
                depPerson.setOfficePhone(unitAdmin.getOfficePhone());
                depPerson.setFaxNumber(unitAdmin.getFaxNumber());
                depPerson.setPrimaryTitle(unitAdmin.getPrimaryTitle());
                depPerson.setAddress1(unitAdmin.getAddressLine1());
                depPerson.setAddress2(unitAdmin.getAddressLine2());
                depPerson.setAddress3(unitAdmin.getAddressLine3());
                depPerson.setCity(unitAdmin.getCity());
                depPerson.setCounty(unitAdmin.getCounty());
                depPerson.setCountryCode(unitAdmin.getCountryCode());
                depPerson.setPostalCode(unitAdmin.getPostalCode());
                depPerson.setState(unitAdmin.getState());
                break;
            }
            if (unitAdmin == null) {
                Unit parentUnit = this.getUnitService().getTopUnit();
                for (UnitAdministrator parentAdmin : parentUnit.getUnitAdministrators()) {
                    if (!contactType.equals(parentAdmin.getUnitAdministratorTypeCode())) continue;
                    KcPerson parentUnitAdmin = this.getKcPersonService().getKcPersonByPersonId(parentAdmin.getPersonId());
                    depPerson.setLastName(parentUnitAdmin.getLastName());
                    depPerson.setFirstName(parentUnitAdmin.getFirstName());
                    if (parentUnitAdmin.getMiddleName() != null) {
                        depPerson.setMiddleName(parentUnitAdmin.getMiddleName());
                    }
                    depPerson.setEmailAddress(parentUnitAdmin.getEmailAddress());
                    depPerson.setOfficePhone(parentUnitAdmin.getOfficePhone());
                    depPerson.setFaxNumber(parentUnitAdmin.getFaxNumber());
                    depPerson.setPrimaryTitle(parentUnitAdmin.getPrimaryTitle());
                    depPerson.setAddress1(parentUnitAdmin.getAddressLine1());
                    depPerson.setAddress2(parentUnitAdmin.getAddressLine2());
                    depPerson.setAddress3(parentUnitAdmin.getAddressLine3());
                    depPerson.setCity(parentUnitAdmin.getCity());
                    depPerson.setCounty(parentUnitAdmin.getCounty());
                    depPerson.setCountryCode(parentUnitAdmin.getCountryCode());
                    depPerson.setPostalCode(parentUnitAdmin.getPostalCode());
                    depPerson.setState(parentUnitAdmin.getState());
                    break;
                }
            }
        }
        return depPerson;
    }

    @Override
    public void deleteSystemGeneratedAttachments(ProposalDevelopmentDocument pdDoc) {
        List<Narrative> narratives = pdDoc.getDevelopmentProposal().getNarratives();
        ArrayList<Integer> deletedItems = new ArrayList<Integer>();
        Integer i = 0;
        for (Narrative narrative : narratives) {
            if (narrative.getNarrativeType() != null && "Y".equals(narrative.getNarrativeType().getSystemGenerated())) {
                deletedItems.add(i);
            }
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        for (int lineToDelete = deletedItems.size() - 1; lineToDelete >= 0; --lineToDelete) {
            this.getNarrativeService().deleteProposalAttachment(pdDoc, (Integer)deletedItems.get(lineToDelete));
        }
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    protected String getContactType() {
        String contactType = this.getParameterValue(PROPOSAL_CONTACT_TYPE);
        if (contactType == null || contactType.length() == 0) {
            contactType = CONTACT_TYPE_O;
        }
        return contactType;
    }

    @Override
    public BudgetDecimal getNumberOfMonths(Date dateStart, Date dateEnd) {
        BudgetDecimal monthCount = BudgetDecimal.ZERO;
        int fullMonthCount = 0;
        Calendar startDate = Calendar.getInstance();
        Calendar endDate = Calendar.getInstance();
        startDate.setTime(dateStart);
        endDate.setTime(dateEnd);
        startDate.clear(10);
        startDate.clear(12);
        startDate.clear(13);
        startDate.clear(14);
        endDate.clear(10);
        endDate.clear(12);
        endDate.clear(13);
        endDate.clear(14);
        if (startDate.after(endDate)) {
            return BudgetDecimal.ZERO;
        }
        int startMonthDays = startDate.getActualMaximum(5) - startDate.get(5);
        int startMonthMaxDays = startDate.getActualMaximum(5);
        BudgetDecimal startMonthFraction = new BudgetDecimal(++startMonthDays).divide(new BudgetDecimal(startMonthMaxDays));
        int endMonthDays = endDate.get(5);
        int endMonthMaxDays = endDate.getActualMaximum(5);
        BudgetDecimal endMonthFraction = new BudgetDecimal(endMonthDays).divide(new BudgetDecimal(endMonthMaxDays));
        startDate.set(5, 1);
        endDate.set(5, 1);
        while (startDate.getTimeInMillis() < endDate.getTimeInMillis()) {
            startDate.set(2, startDate.get(2) + 1);
            ++fullMonthCount;
        }
        monthCount = (BudgetDecimal)((BudgetDecimal)((BudgetDecimal)monthCount.add(new BudgetDecimal(--fullMonthCount))).add(startMonthFraction)).add(endMonthFraction);
        return monthCount;
    }

    @Override
    public String getCognizantFedAgency(DevelopmentProposal developmentProposal) {
        StringBuilder fedAgency = new StringBuilder();
        ProposalSite applicantOrganization = developmentProposal.getApplicantOrganization();
        if (applicantOrganization != null && applicantOrganization.getOrganization() != null && applicantOrganization.getOrganization().getCognizantAuditor() != null) {
            applicantOrganization.getOrganization().refreshReferenceObject("cognizantAuditorRolodex");
            Rolodex rolodex = applicantOrganization.getOrganization().getCognizantAuditorRolodex();
            fedAgency.append(rolodex.getOrganization());
            fedAgency.append(", ");
            fedAgency.append(StringUtils.trimToEmpty((String)rolodex.getFirstName()));
            fedAgency.append(" ");
            fedAgency.append(StringUtils.trimToEmpty((String)rolodex.getLastName()));
            fedAgency.append(" ");
            if (rolodex.getPhoneNumber() != null) {
                if (rolodex.getPhoneNumber().length() < 180) {
                    fedAgency.append(rolodex.getPhoneNumber());
                } else {
                    fedAgency.append(rolodex.getPhoneNumber().substring(0, 180));
                }
            }
        }
        if (fedAgency.toString().length() == 0) {
            fedAgency.append("Unknown");
        }
        return fedAgency.toString();
    }

    public SponsorService getSponsorService() {
        return this.sponsorService;
    }

    public void setSponsorService(SponsorService sponsorService) {
        this.sponsorService = sponsorService;
    }

    public NarrativeService getNarrativeService() {
        return this.narrativeService;
    }

    public void setNarrativeService(NarrativeService narrativeService) {
        this.narrativeService = narrativeService;
    }

    public void setCitizenshipTypeService(CitizenshipTypeService citizenshipTypeService) {
        this.citizenshipTypeService = citizenshipTypeService;
    }

    @Override
    public CitizenshipTypes getCitizenship(ProposalPerson proposalPerson) {
        String citizenSource = "1";
        String piCitizenShipValue = this.getParameterValue(PI_CUSTOM_DATA);
        if (piCitizenShipValue != null) {
            citizenSource = piCitizenShipValue;
        }
        if (citizenSource.equals("0")) {
            CitizenshipTypes citizenShipType = this.citizenshipTypeService.getCitizenshipDataFromExternalSource();
            return citizenShipType;
        }
        String allowOverride = this.parameterService.getParameterValueAsString("KC-GEN", "A", "ALLOW_PROPOSAL_PERSON_TO_OVERRIDE_KC_PERSON_EXTENDED_ATTRIBUTES");
        CitizenshipType citizenShip = "Y".equals(allowOverride) && proposalPerson.getProposalPersonExtendedAttributes() != null ? proposalPerson.getProposalPersonExtendedAttributes().getCitizenshipType() : proposalPerson.getPerson().getExtendedAttributes().getCitizenshipType();
        Object retVal = null;
        String citizenShipCode = String.valueOf(citizenShip.getCitizenshipTypeCode());
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-GEN", "A", "NON_US_CITIZEN_WITH_TEMPORARY_VISA_TYPE_CODE"))) {
            return CitizenshipTypes.NON_US_CITIZEN_WITH_TEMPORARY_VISA;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-GEN", "A", "PERMANENT_RESIDENT_OF_US_TYPE_CODE"))) {
            return CitizenshipTypes.PERMANENT_RESIDENT_OF_US;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-GEN", "A", "US_CITIZEN_OR_NONCITIZEN_NATIONAL_TYPE_CODE"))) {
            return CitizenshipTypes.US_CITIZEN_OR_NONCITIZEN_NATIONAL;
        }
        if (citizenShipCode.equals(this.parameterService.getParameterValueAsString("KC-GEN", "A", "PERMANENT_RESIDENT_OF_US_PENDING"))) {
            return CitizenshipTypes.PERMANENT_RESIDENT_OF_US_PENDING;
        }
        throw new IllegalArgumentException("Invalid citizenship type provided");
    }

    public ProposalDevelopmentS2sQuestionnaireService getProposalDevelopmentS2sQuestionnaireService() {
        return this.proposalDevelopmentS2sQuestionnaireService;
    }

    public void setProposalDevelopmentS2sQuestionnaireService(ProposalDevelopmentS2sQuestionnaireService proposalDevelopmentS2sQuestionnaireService) {
        this.proposalDevelopmentS2sQuestionnaireService = proposalDevelopmentS2sQuestionnaireService;
    }

    public UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    @Override
    public String removeTimezoneFactor(String applicationXmlText) {
        Calendar cal = this.dateTimeService.getCurrentCalendar();
        int dstOffsetMilli = cal.get(16);
        int zoneOffsetMilli = cal.get(15);
        zoneOffsetMilli = cal.getTimeZone().useDaylightTime() ? zoneOffsetMilli + dstOffsetMilli : zoneOffsetMilli;
        int zoneOffset = zoneOffsetMilli / 3600000;
        String timezoneId = TimeZone.getTimeZone("GMT" + zoneOffset).getID();
        String offset = timezoneId.substring(timezoneId.length() - 6);
        String filteredApplicationStr = StringUtils.remove((String)applicationXmlText, (String)offset);
        return filteredApplicationStr;
    }
}

