/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.kuali.kra.s2s.service.S2SValidatorService;
import org.kuali.kra.s2s.validator.S2SErrorHandler;
import org.kuali.rice.kns.util.AuditError;
import org.w3c.dom.Node;

public class S2SValidatorServiceImpl
implements S2SValidatorService {
    @Override
    public boolean validate(XmlObject formObject, List<AuditError> errors) {
        ArrayList<String> formErrors = new ArrayList<String>();
        boolean result = false;
        result = this.validateXml(formObject, formErrors);
        for (String validationError : formErrors) {
            errors.add(S2SErrorHandler.getError("/GrantApplication/Forms" + validationError));
        }
        return result;
    }

    protected boolean validateXml(XmlObject formObject, List<String> errors) {
        XmlOptions validationOptions = new XmlOptions();
        ArrayList validationErrors = new ArrayList();
        validationOptions.setErrorListener(validationErrors);
        boolean isValid = formObject.validate(validationOptions);
        if (!isValid) {
            LOG.error((Object)("Errors occured during validation of XML from form generator" + validationErrors));
            for (XmlError error : validationErrors) {
                LOG.info((Object)("Validation error:" + error));
                Node node = error.getCursorLocation().getDomNode();
                errors.add(this.getXPath(node));
            }
            LOG.debug((Object)("Error XPaths:" + errors));
        }
        return isValid;
    }

    protected String getXPath(Node node) {
        if (node == null || node.getNodeType() == 9) {
            return "";
        }
        return this.getXPath(node.getParentNode()) + "/" + node.getNodeName();
    }
}

