/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.util;

import java.io.OutputStream;
import java.security.MessageDigest;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.MessageDigestAlgorithm;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.DigesterOutputStream;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.util.GrantApplicationXpath;
import org.kuali.kra.s2s.util.XPathExecutor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GrantApplicationHash {
    static final Log log = LogFactory.getLog((String)GrantApplicationHash.class.getName());
    static MessageDigest messageDigester = null;

    private GrantApplicationHash() {
    }

    public static final String computeGrantFormsHash(String xml) throws S2SException {
        try {
            GrantApplicationXpath xpath = new GrantApplicationXpath(xml);
            return GrantApplicationHash._hash(xpath);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new S2SException(e.getMessage());
        }
    }

    public static final String computeAttachmentHash(byte[] attachment) throws Exception {
        byte[] rawDigest = messageDigester.digest(attachment);
        return Base64.encode((byte[])rawDigest);
    }

    public static final String computeGrantFormsHash(GrantApplicationXpath xpath) throws Exception {
        return GrantApplicationHash._hash(xpath);
    }

    public static final String computeGrantFormsHash(Document xml) throws Exception {
        XPathExecutor executor = new XPathExecutor(null);
        executor.setDoc(xml);
        GrantApplicationXpath xpath = new GrantApplicationXpath(null);
        xpath.setExecutor(executor);
        return GrantApplicationHash._hash(xpath);
    }

    private static String _hash(GrantApplicationXpath xpath) throws TransformerException, XMLSignatureException, InvalidCanonicalizerException, CanonicalizationException {
        Node formsNode = xpath.getFormsNode();
        DigesterOutputStream digester = GrantApplicationHash._createDigesterOutputStream(xpath.getExecutor().getDoc());
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/2001/10/xml-exc-c14n#");
        canonicalizer.setWriter((OutputStream)digester);
        canonicalizer.canonicalizeSubtree(formsNode);
        byte[] hash = digester.getDigestValue();
        return Base64.encode((byte[])hash);
    }

    private static DigesterOutputStream _createDigesterOutputStream(Document doc) throws XMLSignatureException {
        DigesterOutputStream stream = null;
        if (doc != null) {
            stream = new DigesterOutputStream(MessageDigestAlgorithm.getInstance((Document)doc, (String)"http://www.w3.org/2000/09/xmldsig#sha1"));
        }
        return stream;
    }

    static {
        Init.init();
        try {
            messageDigester = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception ex) {
            log.fatal((Object)"Unable to get instance of java.security.MessageDigester", (Throwable)ex);
        }
    }
}

