/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.validator;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.s2s.S2SException;
import org.kuali.kra.s2s.bo.S2sOppForms;
import org.kuali.kra.s2s.formmapping.FormMappingInfo;
import org.kuali.kra.s2s.formmapping.FormMappingLoader;
import org.kuali.kra.s2s.generator.S2SGeneratorNotFoundException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OpportunitySchemaParser {
    private static final String SCHEMA_LOCATION = "schemaLocation";
    private static final String NAMESPACE = "namespace";
    private static final char CH_COLON = ':';
    private static final String XMLNS = "xmlns:";
    private static final String MIN_OCCURS = "minOccurs";
    private static final String REF = "ref";
    private static final String ELEMENT = "element";
    private static final String ALL = "all";
    private static final String IMPORT = "import";
    private static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    private static final Log LOG = LogFactory.getLog(OpportunitySchemaParser.class);

    public ArrayList<S2sOppForms> getForms(String schema) throws S2SException {
        Node topElementName;
        Document document;
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        ArrayList<S2sOppForms> schemaList = new ArrayList<S2sOppForms>();
        try {
            builder = domFactory.newDocumentBuilder();
            InputStream is = (InputStream)new URL(schema).getContent();
            document = builder.parse(is);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Exception Occured", (Throwable)e);
            throw new S2SException("error.grantsgov.form.parsing", e.getMessage(), schema);
        }
        catch (SAXException e) {
            LOG.error((Object)"Exception Occured", (Throwable)e);
            throw new S2SException("error.grantsgov.form.xmlprocess", e.getMessage(), schema);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception Occured", (Throwable)e);
            throw new S2SException("error.grantsgov.form.schema.server.down", e.getMessage(), schema);
        }
        Element schemaElement = document.getDocumentElement();
        NodeList importList = document.getElementsByTagNameNS(XSD_NS, IMPORT);
        Node allForms = document.getElementsByTagNameNS(XSD_NS, ALL).item(0);
        if (allForms == null && (topElementName = schemaElement.getElementsByTagNameNS(XSD_NS, ELEMENT).item(0).getAttributes().item(0)).getNodeName().equals("name") && !topElementName.getNodeValue().equals("GrantApplication")) {
            throw new S2SException("error.grantsgov.no.form.element", "", "");
        }
        NodeList formsList = ((Element)allForms).getElementsByTagNameNS(XSD_NS, ELEMENT);
        String[] formNames = new String[formsList.getLength()];
        for (int formIndex = 0; formIndex < formsList.getLength(); ++formIndex) {
            Node form = formsList.item(formIndex);
            String fullFormName = ((Element)form).getAttribute(REF);
            String formName = fullFormName.substring(0, fullFormName.indexOf(58));
            String minOccurs = ((Element)form).getAttribute(MIN_OCCURS);
            String nameSpace = schemaElement.getAttribute(XMLNS + formName);
            FormMappingInfo info = null;
            try {
                info = new FormMappingLoader().getFormInfo(nameSpace);
            }
            catch (S2SGeneratorNotFoundException e) {
                // empty catch block
            }
            String displayFormName = info == null ? formName : info.getFormName();
            formNames[formIndex] = nameSpace;
            for (int impIndex = 0; impIndex < importList.getLength(); ++impIndex) {
                Node importNode = importList.item(impIndex);
                if (!((Element)importNode).getAttribute(NAMESPACE).equalsIgnoreCase(nameSpace)) continue;
                String schemaUrl = ((Element)importNode).getAttribute(SCHEMA_LOCATION);
                S2sOppForms oppForm = new S2sOppForms();
                oppForm.setFormName(displayFormName);
                oppForm.setOppNameSpace(nameSpace);
                oppForm.setSchemaUrl(schemaUrl);
                boolean mandatory = minOccurs == null || minOccurs.trim().equals("") || Integer.parseInt(minOccurs) > 0;
                oppForm.setMandatory(mandatory);
                boolean available = info != null;
                oppForm.setAvailable(available);
                oppForm.setInclude(mandatory && available);
                schemaList.add(oppForm);
            }
        }
        return schemaList;
    }

    private boolean isAvailable(String nameSpace) {
        try {
            FormMappingInfo info = new FormMappingLoader().getFormInfo(nameSpace);
            return info != null;
        }
        catch (S2SGeneratorNotFoundException e) {
            return false;
        }
    }
}

