/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.s2s.validator;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.kuali.rice.kns.util.AuditError;

public class S2SErrorHandler {
    private static Map<String, AuditError> auditErrorMap;
    private static final String ERROR_MAP_FILE = "/S2SErrorMessages.xml";
    private static final String ERROR_MAP_FILE_V2 = "/org/kuali/kra/s2s/s2sform/S2SErrorMessagesV2.xml";

    public static AuditError getError(String key) {
        if (auditErrorMap == null) {
            auditErrorMap = new HashMap<String, AuditError>();
            S2SErrorHandler.loadErrors(ERROR_MAP_FILE);
            if (new S2SErrorHandler().getClass().getResourceAsStream(ERROR_MAP_FILE_V2) != null) {
                S2SErrorHandler.loadErrors(ERROR_MAP_FILE_V2);
            }
        }
        AuditError error = auditErrorMap.get(key);
        AuditError defaultError = new AuditError("noField", key + " is not valid", "grantsGov.Opportunity");
        return error == null ? defaultError : error;
    }

    private static void loadErrors(String errorMapFile) {
        InputStream stream = null;
        try {
            stream = new S2SErrorHandler().getClass().getResourceAsStream(errorMapFile);
            org.w3c.dom.Document errorsDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(stream);
            Document document = new DOMBuilder().build(errorsDocument);
            Element root = document.getRootElement();
            for (Element errorElement : root.getChildren("Error")) {
                String errorKey = errorElement.getChildTextTrim("ErrorKey");
                String messageKey = errorElement.getChildTextTrim("MessageKey");
                String errorMessage = errorElement.getChildTextTrim("Message");
                String errorFixLink = errorElement.getChildTextTrim("FixLink");
                errorFixLink = errorFixLink == null || errorFixLink.equals("") ? "grantsGov.Opportunity" : errorFixLink;
                AuditError s2sError = new AuditError(errorKey == null ? "noField" : errorKey, errorMessage, errorFixLink);
                auditErrorMap.put(messageKey, s2sError);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

