/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.expr;

import java.text.ParseException;
import java.util.Date;
import org.kuali.kra.scheduling.expr.CronExpression;
import org.kuali.kra.scheduling.expr.util.CronSpecialChars;
import org.kuali.kra.scheduling.util.Time24HrFmt;

public class WeekCronExpression
extends CronExpression {
    private CronSpecialChars[] weekdays;

    public WeekCronExpression(Date startDate, Time24HrFmt time, CronSpecialChars[] weekdays) throws ParseException {
        super(startDate, time);
        this.weekdays = weekdays;
    }

    @Override
    public String getExpression() {
        StringBuilder exp = new StringBuilder();
        exp.append("0").append((Object)CronSpecialChars.SPACE);
        exp.append(this.getTime().getMinutes()).append((Object)CronSpecialChars.SPACE);
        exp.append(this.getTime().getHours()).append((Object)CronSpecialChars.SPACE);
        exp.append((Object)CronSpecialChars.QUESTION).append((Object)CronSpecialChars.SPACE);
        exp.append((Object)CronSpecialChars.STAR).append((Object)CronSpecialChars.SPACE);
        exp.append(this.toStringWeekDays(this.weekdays, CronSpecialChars.COMMASEPRATOR));
        return exp.toString();
    }

    private String toStringWeekDays(CronSpecialChars[] day, CronSpecialChars seperator) {
        StringBuilder sb = new StringBuilder();
        for (CronSpecialChars str : day) {
            sb.append((Object)str).append((Object)seperator);
        }
        return sb.substring(0, sb.length() - 1);
    }
}

