/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.quartz;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.springframework.scheduling.quartz.CronTriggerBean;

public class KcCronTriggerBean
extends CronTriggerBean {
    private static final Log LOG = LogFactory.getLog(KcCronTriggerBean.class);
    private String defaultCronExpression = "0 0 5 * * ?";
    private String parameterNamespace;
    private String parameterComponent;
    private String cronExpressionParameterName = "pessimisticLocking.cronExpression";
    private String triggerEnabledParameterName;
    private String startTimeParameterName;
    private ParameterService parameterService;
    private DateTimeService dateTimeService;

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void afterPropertiesSet() throws Exception {
        this.setCronExpression(this.getSystemCronExpression());
        this.setStartTime(this.getCronStartTime());
        super.afterPropertiesSet();
    }

    protected String getSystemCronExpression() {
        if (StringUtils.isNotBlank((String)this.cronExpressionParameterName) && this.getParameterService().parameterExists(this.parameterNamespace, this.parameterComponent, this.cronExpressionParameterName).booleanValue()) {
            String param = this.getParameterService().getParameterValueAsString(this.parameterNamespace, this.parameterComponent, this.cronExpressionParameterName);
            if (param != null) {
                return param;
            }
            LOG.warn((Object)("parameter [" + this.cronExpressionParameterName + "] not found using default value of [" + this.defaultCronExpression + "]."));
        }
        return this.defaultCronExpression;
    }

    protected Date getCronStartTime() {
        Calendar yearInAdvance = this.dateTimeService.getCurrentCalendar();
        yearInAdvance.add(1, 2);
        Date disabledStartTime = yearInAdvance.getTime();
        Date cronStartTime = this.dateTimeService.getCurrentDate();
        if (!this.isTriggerEnabled()) {
            return disabledStartTime;
        }
        if (!StringUtils.isBlank((String)this.startTimeParameterName) && this.getParameterService().parameterExists(this.parameterNamespace, this.parameterComponent, this.startTimeParameterName).booleanValue()) {
            String CUSTOM_DATE_FORMAT = "dd-MMM-yyyy hh:mm a";
            SimpleDateFormat dateFormat = new SimpleDateFormat(CUSTOM_DATE_FORMAT);
            try {
                String parmStartTime = this.getParameterService().getParameterValueAsString(this.parameterNamespace, this.parameterComponent, this.startTimeParameterName);
                if (!StringUtils.isBlank((String)parmStartTime)) {
                    try {
                        cronStartTime = this.dateTimeService.convertToDate(parmStartTime);
                    }
                    catch (ParseException e) {
                        cronStartTime = dateFormat.parse(parmStartTime);
                    }
                }
            }
            catch (Exception e) {
                cronStartTime = disabledStartTime;
                String defaultDateStr = dateFormat.format(cronStartTime);
                LOG.error((Object)("Not able to get the starttime for " + this.getJobName() + " scheduler from system param table. Set it to " + defaultDateStr), (Throwable)e);
            }
        }
        return cronStartTime;
    }

    protected boolean isTriggerEnabled() {
        if (StringUtils.isNotBlank((String)this.triggerEnabledParameterName)) {
            if (this.getParameterService().parameterExists(this.parameterNamespace, this.parameterComponent, this.triggerEnabledParameterName).booleanValue()) {
                return this.getParameterService().getParameterValueAsBoolean(this.parameterNamespace, this.parameterComponent, this.triggerEnabledParameterName);
            }
            return false;
        }
        return true;
    }

    public String getDefaultCronExpression() {
        return this.defaultCronExpression;
    }

    public void setDefaultCronExpression(String defaultCronExpression) {
        this.defaultCronExpression = defaultCronExpression;
    }

    public String getCronExpressionParameterName() {
        return this.cronExpressionParameterName;
    }

    public void setCronExpressionParameterName(String cronExpressionParameterName) {
        this.cronExpressionParameterName = cronExpressionParameterName;
    }

    public String getTriggerEnabledParameterName() {
        return this.triggerEnabledParameterName;
    }

    public void setTriggerEnabledParameterName(String triggerEnabledParameterName) {
        this.triggerEnabledParameterName = triggerEnabledParameterName;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public String getStartTimeParameterName() {
        return this.startTimeParameterName;
    }

    public void setStartTimeParameterName(String startTimeParameterName) {
        this.startTimeParameterName = startTimeParameterName;
    }

    protected DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public String getParameterNamespace() {
        return this.parameterNamespace;
    }

    public void setParameterNamespace(String parameterNamespace) {
        this.parameterNamespace = parameterNamespace;
    }

    public String getParameterComponent() {
        return this.parameterComponent;
    }

    public void setParameterComponent(String parameterComponent) {
        this.parameterComponent = parameterComponent;
    }
}

