/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.sequence;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.kuali.kra.scheduling.sequence.ScheduleSequence;
import org.kuali.kra.scheduling.sequence.ScheduleSequenceDecorator;
import org.quartz.CronTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public class XMonthlyScheduleSequenceDecorator
extends ScheduleSequenceDecorator {
    private Integer frequency;

    public XMonthlyScheduleSequenceDecorator(ScheduleSequence scheduleSequence, Integer frequency) {
        super(scheduleSequence);
        this.frequency = frequency;
    }

    @Override
    public List<Date> executeScheduleSequence(String expression, Date startDate, Date endDate) throws ParseException {
        CronTrigger ct = new CronTrigger("t", "g", "j", "g", new Date(), null, expression);
        ct.setTimeZone(TimeZone.getDefault());
        ArrayList<Date> dates = TriggerUtils.computeFireTimesBetween((Trigger)ct, null, (Date)startDate, (Date)endDate);
        if (this.frequency != 1) {
            ArrayList<Date> filteredDates = new ArrayList<Date>();
            int i = 0;
            for (Date date : dates) {
                if (i % this.frequency == 0) {
                    filteredDates.add(date);
                }
                ++i;
            }
            dates = filteredDates;
        }
        return dates;
    }
}

