/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.scheduling.util;

import java.io.Serializable;
import java.text.ParseException;
import org.apache.commons.lang.StringUtils;

public class Time24HrFmt
implements Serializable {
    private static final long serialVersionUID = 2554984023134603437L;
    private String hours;
    private String minutes;
    public static final String splitChr = ":";
    public static final String MSG1 = "Time format exception, expects hh:mm";
    public static final String MSG2 = "Time format exception, expects hh as 0-23 & mm as 0-59";
    public static final String MSG3 = "Time format exception, expects hh as 0-23";
    public static final String MSG4 = "Time format exception, expects mm as 0-59";

    public Time24HrFmt(String time) throws ParseException {
        this.parseTime(time);
    }

    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    private void parseTime(String time) throws ParseException {
        Integer mins;
        Integer hrs;
        String[] result = time.split(splitChr);
        if (result.length != 2) {
            throw new ParseException(MSG1, 0);
        }
        try {
            hrs = new Integer(result[0]);
            mins = new Integer(result[1]);
        }
        catch (NumberFormatException e) {
            throw new ParseException(MSG2, 0);
        }
        if (hrs < 0 || hrs > 23) {
            throw new ParseException(MSG3, 0);
        }
        if (mins < 0 || mins > 59) {
            throw new ParseException(MSG4, 0);
        }
        this.hours = result[0];
        this.minutes = result[1];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hours == null ? 0 : this.hours.hashCode());
        result = 31 * result + (this.minutes == null ? 0 : this.minutes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Time24HrFmt other = (Time24HrFmt)obj;
        return StringUtils.equals((String)this.hours, (String)other.hours) && StringUtils.equals((String)this.minutes, (String)other.minutes);
    }

    public String toString() {
        return this.hours + splitChr + this.minutes;
    }
}

