/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.home.AwardBasisOfPayment;
import org.kuali.kra.award.home.AwardMethodOfPayment;
import org.kuali.kra.award.home.ValidAwardBasisPayment;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.service.AwardPaymentAndInvoicesService;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.util.ValuesFinderUtility;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardPaymentAndInvoicesServiceImpl
implements AwardPaymentAndInvoicesService {
    static final String AWARDTYPECODE = "awardTypeCode";
    static final String VALIDAWARDBASISPAYMENT_ID = "validAwardBasisPaymentId";
    static final String BASISOFPAYMENTCODE = "basisOfPaymentCode";
    static final String METHODOFPAYMENTCODE = "methodOfPaymentCode";
    private static final String SEMICOLON_AS_DELIMITOR = ";";
    private static final String COMMA_AS_DELIMITOR = ",";
    private static final String AWARDBASISOFPAYMENT_CODE = "basisOfPaymentCode";
    private static final String AWARDMETHODOFPAYMENT_CODE = "methodOfPaymentCode";
    BusinessObjectService businessObjectService;

    @Override
    public String getEncodedValidAwardBasisPaymentsByAwardTypeCode(Integer awardTypeCode) {
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        results.add((KeyValue)new ConcreteKeyValue("", "select"));
        List<ValidAwardBasisPayment> found = this.getValidAwardBasisPaymentsByAwardTypeCode(awardTypeCode);
        for (ValidAwardBasisPayment current : found) {
            current.refresh();
            results.add((KeyValue)new ConcreteKeyValue(current.getBasisOfPaymentCode(), current.getBasisOfPayment().getDescription()));
        }
        return ValuesFinderUtility.processKeyValueList(results);
    }

    @Override
    public String getEncodedValidBasisMethodPaymentsByBasisCode(String basisOfPaymentCode) {
        ArrayList<KeyValue> results = new ArrayList<KeyValue>();
        results.add((KeyValue)new ConcreteKeyValue("", "select"));
        List<ValidBasisMethodPayment> found = this.getValidBasisMethodPaymentByBasisCode(basisOfPaymentCode);
        for (ValidBasisMethodPayment current : found) {
            current.refresh();
            results.add((KeyValue)new ConcreteKeyValue(current.getMethodOfPaymentCode(), current.getMethodOfPayment().getDescription()));
        }
        return ValuesFinderUtility.processKeyValueList(results);
    }

    @Override
    public List<ValidAwardBasisPayment> getValidAwardBasisPaymentsByAwardTypeCode(Integer awardTypeCode) {
        ArrayList<ValidAwardBasisPayment> results = new ArrayList<ValidAwardBasisPayment>(this.businessObjectService.findMatchingOrderBy(ValidAwardBasisPayment.class, ServiceHelper.getInstance().buildCriteriaMap(AWARDTYPECODE, awardTypeCode), VALIDAWARDBASISPAYMENT_ID, true));
        return results;
    }

    @Override
    public List<ValidBasisMethodPayment> getValidBasisMethodPaymentByBasisCode(String basisOfPaymentCode) {
        ArrayList<ValidBasisMethodPayment> results = new ArrayList<ValidBasisMethodPayment>(this.businessObjectService.findMatchingOrderBy(ValidBasisMethodPayment.class, ServiceHelper.getInstance().buildCriteriaMap(new String[]{"basisOfPaymentCode"}, new String[]{basisOfPaymentCode}), "methodOfPaymentCode", true));
        return results;
    }

    @Override
    public List<ValidBasisMethodPayment> getValidBasisMethodPaymentByMethodCode(String methodOfPaymentCode) {
        ArrayList<ValidBasisMethodPayment> results = new ArrayList<ValidBasisMethodPayment>(this.businessObjectService.findMatchingOrderBy(ValidBasisMethodPayment.class, ServiceHelper.getInstance().buildCriteriaMap("methodOfPaymentCode", methodOfPaymentCode), "basisOfPaymentCode", true));
        return results;
    }

    @Override
    public ValidAwardBasisPayment getValidAwardBasisPayment(Integer validAwardBasisPaymentId) {
        ValidAwardBasisPayment vBasisPayment = (ValidAwardBasisPayment)this.businessObjectService.findByPrimaryKey(ValidAwardBasisPayment.class, ServiceHelper.getInstance().buildCriteriaMap(VALIDAWARDBASISPAYMENT_ID, validAwardBasisPaymentId));
        return vBasisPayment;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public String getAwardBasisOfPaymentDescription(String awardBasisOfPaymentId) {
        AwardBasisOfPayment basisOfPayment = (AwardBasisOfPayment)this.businessObjectService.findByPrimaryKey(AwardBasisOfPayment.class, ServiceHelper.getInstance().buildCriteriaMap("basisOfPaymentCode", awardBasisOfPaymentId));
        return basisOfPayment != null ? basisOfPayment.getDescription() : "";
    }

    @Override
    public String getAwardMethodOfPaymentDescription(String awardMethodOfPaymentId) {
        AwardMethodOfPayment awardMethodOfPayment = (AwardMethodOfPayment)this.businessObjectService.findByPrimaryKey(AwardMethodOfPayment.class, ServiceHelper.getInstance().buildCriteriaMap("methodOfPaymentCode", awardMethodOfPaymentId));
        return awardMethodOfPayment != null ? awardMethodOfPayment.getDescription() : "";
    }
}

