/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardCommentService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardCommentServiceImpl
implements AwardCommentService {
    private BusinessObjectService businessObjectService;
    private AwardService awardService;
    private String AWARD_COMMENT_SCREEN_FLAG = "awardCommentScreenFlag";
    private String AWARD_COMMENT_TYPE_CODE = "commentTypeCode";
    private String AWARD_ID = "awardId";

    @Override
    public List<CommentType> retrieveCommentTypes() {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(this.AWARD_COMMENT_SCREEN_FLAG, "Y");
        List commentTypeList = (List)this.getBusinessObjectService().findMatching(CommentType.class, queryMap);
        return commentTypeList;
    }

    @Override
    public List<String> retrieveCommentHistoryFlags(String awardNumber) {
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("awardNumber", awardNumber);
        List rawList = (List)this.getBusinessObjectService().findMatching(AwardComment.class, queryMap);
        HashMap rawMap = new HashMap();
        String tempCode2 = null;
        for (AwardComment awardComment : rawList) {
            tempCode2 = awardComment.getCommentTypeCode();
            ArrayList<AwardComment> commentList = (ArrayList<AwardComment>)rawMap.get(tempCode2);
            if (commentList == null) {
                commentList = new ArrayList<AwardComment>();
                rawMap.put(tempCode2, commentList);
            }
            if (commentList.size() != 0 && awardComment.sameText((AwardComment)commentList.get(commentList.size() - 1))) continue;
            commentList.add(awardComment);
        }
        ArrayList<String> resultList = new ArrayList<String>();
        block1: for (String tempCode2 : rawMap.keySet()) {
            List awardCommentList = (List)rawMap.get(tempCode2);
            String lastComment = null;
            for (AwardComment awardComment : awardCommentList) {
                String tempComment = awardComment.getComments();
                if (awardComment.isDisabled()) continue;
                if (awardComment.isEntered() && !awardComment.isDisabled()) {
                    if (lastComment == null) {
                        lastComment = awardComment.getComments();
                    } else if (!lastComment.equals(tempComment) && !resultList.contains(tempComment)) {
                        resultList.add(tempCode2);
                        continue block1;
                    }
                } else if (lastComment != null && !resultList.contains(tempComment)) {
                    resultList.add(tempCode2);
                    continue block1;
                }
                lastComment = awardComment.isEntered() ? tempComment : null;
            }
        }
        return resultList;
    }

    @Override
    public List<AwardComment> retrieveCommentHistoryByType(String awardCommentTypeCode, String awardId) {
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        Award award = this.getAward(awardId);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(this.AWARD_COMMENT_TYPE_CODE, awardCommentTypeCode);
        queryMap.put("awardNumber", award.getAwardNumber());
        return this.filterAwardComment((List)this.getBusinessObjectService().findMatching(AwardComment.class, queryMap), award.getAwardNumber(), award.getSequenceNumber());
    }

    protected Award getAward(String awardId) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(this.AWARD_ID, awardId);
        return (Award)this.getBusinessObjectService().findByPrimaryKey(Award.class, queryMap);
    }

    protected List<AwardComment> filterAwardComment(List<AwardComment> results, String awardNumber, Integer sequenceNum) {
        ArrayList<AwardComment> returnList = new ArrayList<AwardComment>();
        ArrayList<String> comments = new ArrayList<String>();
        for (AwardComment awardComment : results) {
            if (sequenceNum < awardComment.getSequenceNumber() || !awardComment.isEntered() || awardComment.isDisabled() || !comments.isEmpty() && awardComment.getComments().equals(comments.get(comments.size() - 1))) continue;
            returnList.add(awardComment);
            comments.add(awardComment.getComments());
        }
        Collections.sort(returnList);
        return returnList;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public AwardService getAwardService() {
        if (this.awardService == null) {
            this.awardService = KraServiceLocator.getService(AwardService.class);
        }
        return this.awardService;
    }
}

