/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.paymentschedule.FrequencyBaseConstants;
import org.kuali.kra.scheduling.sequence.DefaultScheduleSequence;
import org.kuali.kra.scheduling.sequence.TrimDatesScheduleSequenceDecorator;
import org.kuali.kra.scheduling.sequence.XMonthlyScheduleSequenceDecorator;
import org.kuali.kra.scheduling.service.ScheduleService;
import org.kuali.kra.scheduling.util.Time24HrFmt;
import org.kuali.kra.service.AwardScheduleGenerationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.PersistenceService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardScheduleGenerationServiceImpl
implements AwardScheduleGenerationService {
    public static final String ZERO_HOURS = "00:00";
    public static final String FREQUENCY_OBJECT_STRING = "frequency";
    private ScheduleService scheduleService;
    private PersistenceService persistenceService;
    private ParameterService parameterService;
    private AwardAmountInfoService awardAmountInfoService;

    protected void initializeDatesForThisAward(Award award, Map<String, Date> mapOfDates) {
        AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
        mapOfDates.put(FrequencyBaseConstants.AWARD_EXECUTION_DATE.getfrequencyBase(), award.getAwardExecutionDate());
        mapOfDates.put(FrequencyBaseConstants.AWARD_EFFECTIVE_DATE.getfrequencyBase(), award.getAwardEffectiveDate());
        mapOfDates.put(FrequencyBaseConstants.AWARD_EXPIRATION_DATE_OF_OBLIGATION.getfrequencyBase(), awardAmountInfo.getObligationExpirationDate());
        mapOfDates.put(FrequencyBaseConstants.FINAL_EXPIRATION_DATE.getfrequencyBase(), awardAmountInfo.getFinalExpirationDate());
        mapOfDates.put(FrequencyBaseConstants.AWARD_EFFECTIVE_DATE_OF_OBLIGATION.getfrequencyBase(), awardAmountInfo.getCurrentFundEffectiveDate());
    }

    @Override
    public List<Date> generateSchedules(Award award, List<AwardReportTerm> awardReportTerms, boolean isThisNotPaymentPanel) throws ParseException {
        ArrayList<Date> dates = new ArrayList<Date>();
        HashMap<String, Date> mapOfDates = new HashMap<String, Date>();
        this.initializeDatesForThisAward(award, mapOfDates);
        this.refreshAwardReportTerms(awardReportTerms);
        int index = 0;
        for (AwardReportTerm awardReportTerm : awardReportTerms) {
            if (this.canGenerateSchedules(awardReportTerm, isThisNotPaymentPanel)) {
                dates.addAll(this.getDates(awardReportTerm, mapOfDates, index));
            }
            ++index;
        }
        return dates;
    }

    protected List<Date> getDates(AwardReportTerm awardReportTerm, Map<String, Date> mapOfDates, int index) throws ParseException {
        Date startDate;
        List<Date> dates = new ArrayList<Date>();
        Date endDate = null;
        GregorianCalendar calendar = new GregorianCalendar();
        String SF_269_EXPENDITURE_REPORT_CODE = "33";
        String FREQUENCY_ANNUAL = "Annual";
        if (awardReportTerm.getReportCode().equalsIgnoreCase("33") && awardReportTerm.getFrequencyBaseCode().equalsIgnoreCase(FrequencyBaseConstants.AWARD_EXPIRATION_DATE_OF_OBLIGATION.getfrequencyBase()) && awardReportTerm.getFrequency().getDescription().equalsIgnoreCase("Annual") && mapOfDates.get(FrequencyBaseConstants.AWARD_EXPIRATION_DATE_OF_OBLIGATION.getfrequencyBase()) != null) {
            calendar.setTime(mapOfDates.get(FrequencyBaseConstants.AWARD_EXPIRATION_DATE_OF_OBLIGATION.getfrequencyBase()));
            startDate = calendar.getTime();
        } else {
            startDate = this.getStartDate(awardReportTerm, mapOfDates);
        }
        if (StringUtils.isNotBlank((String)awardReportTerm.getFrequencyBaseCode())) {
            endDate = this.getEndDate(awardReportTerm.getFrequencyBaseCode(), startDate, mapOfDates);
        }
        if (startDate != null && endDate != null) {
            calendar.setTime(startDate);
            if (awardReportTerm.getFrequency().getRepeatFlag().booleanValue() && awardReportTerm.getFrequency().getNumberOfMonths() != null) {
                if (endDate.before(startDate)) {
                    endDate = startDate;
                }
                XMonthlyScheduleSequenceDecorator scheduleSequence = new XMonthlyScheduleSequenceDecorator(new TrimDatesScheduleSequenceDecorator(new DefaultScheduleSequence()), awardReportTerm.getFrequency().getNumberOfMonths());
                dates = this.scheduleService.getScheduledDates(startDate, endDate, new Time24HrFmt(ZERO_HOURS), scheduleSequence, calendar.get(5));
            } else {
                dates.add(startDate);
            }
        }
        return dates;
    }

    protected boolean canGenerateSchedules(AwardReportTerm awardReportTerm, boolean isThisNotPaymentPanel) {
        return isThisNotPaymentPanel || StringUtils.equalsIgnoreCase((String)awardReportTerm.getReportClassCode(), (String)this.getParameterService().getParameterValueAsString(AwardDocument.class, "reportClassForPaymentsAndInvoices"));
    }

    protected Date getStartDate(AwardReportTerm awardReportTerm, Map<String, Date> mapOfDates) {
        GregorianCalendar calendar = new GregorianCalendar();
        Date date = null;
        boolean startDateIsNull = false;
        if (mapOfDates.containsKey(awardReportTerm.getFrequencyBaseCode()) && mapOfDates.get(awardReportTerm.getFrequencyBaseCode()) != null) {
            calendar.setTime(mapOfDates.get(awardReportTerm.getFrequencyBaseCode()));
        } else if (awardReportTerm.getDueDate() != null) {
            calendar.setTimeInMillis(awardReportTerm.getDueDate().getTime());
        } else {
            startDateIsNull = true;
        }
        if (!startDateIsNull && awardReportTerm.getFrequency() != null) {
            date = this.getStartDateFromTheBaseDate(calendar, awardReportTerm.getFrequency());
        }
        return date;
    }

    protected Date getStartDateFromTheBaseDate(Calendar calendar, Frequency frequency) {
        this.addOffSetPeriodToStartDate(frequency, calendar);
        this.addNumberOfMonthsToStartDate(frequency, calendar);
        return calendar.getTime();
    }

    protected void addOffSetPeriodToStartDate(Frequency frequency, Calendar calendar) {
        if (frequency != null) {
            if (frequency.getNumberOfDays() != null) {
                calendar.add(6, frequency.getNumberOfDays());
            } else if (frequency.getAdvanceNumberOfDays() != null) {
                calendar.add(6, -frequency.getAdvanceNumberOfDays().intValue());
            } else if (frequency.getAdvanceNumberOfMonths() != null) {
                calendar.add(2, -frequency.getAdvanceNumberOfMonths().intValue());
            }
        }
    }

    protected void addNumberOfMonthsToStartDate(Frequency frequency, Calendar calendar) {
        if (frequency.getNumberOfMonths() != null) {
            calendar.add(2, frequency.getNumberOfMonths());
        }
    }

    protected Date getEndDate(String frequencyBaseCode, Date startDate, Map<String, Date> mapOfDates) {
        GregorianCalendar calendar = new GregorianCalendar();
        if (frequencyBaseCode.equals(FrequencyBaseConstants.FINAL_EXPIRATION_DATE.getfrequencyBase())) {
            calendar.setTime(startDate);
            ((Calendar)calendar).add(1, Integer.parseInt(this.getParameterService().getParameterValueAsString(AwardDocument.class, "scheduleGenerationPeriodInYearsWhenFrequencyBaseCodeIsFinalExpirationDate")));
        } else {
            calendar.setTime(mapOfDates.get(FrequencyBaseConstants.FINAL_EXPIRATION_DATE.getfrequencyBase()));
        }
        return calendar.getTime();
    }

    public ScheduleService getScheduleService() {
        return this.scheduleService;
    }

    public void setScheduleService(ScheduleService scheduleService) {
        this.scheduleService = scheduleService;
    }

    void refreshAwardReportTerms(List<AwardReportTerm> awardReportTerms) {
        ArrayList<AwardReportTerm> persistableObjects = new ArrayList<AwardReportTerm>();
        ArrayList<String> referenceObjectNames = new ArrayList<String>();
        for (AwardReportTerm awardReportTerm : awardReportTerms) {
            persistableObjects.add(awardReportTerm);
            referenceObjectNames.add(FREQUENCY_OBJECT_STRING);
        }
        if (!awardReportTerms.isEmpty()) {
            this.getPersistenceService().retrieveReferenceObjects(persistableObjects, referenceObjectNames);
        }
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        return this.awardAmountInfoService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }
}

