/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;

public class CustomAttributeDocumentMaintainableImpl
extends KualiMaintainableImpl {
    public void prepareForSave() {
        CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)this.getBusinessObject();
        boolean needsTranslated = true;
        int val = 0;
        try {
            val = Integer.parseInt(customAttributeDocument.getDocumentTypeName());
            needsTranslated = true;
        }
        catch (Exception e) {
            needsTranslated = false;
        }
        if (needsTranslated) {
            customAttributeDocument.setDocumentTypeName(this.convertModuleNumberToDocumentTypeCode(val));
        }
        super.prepareForSave();
    }

    public String convertModuleNumberToDocumentTypeCode(int moduleNumber) {
        String documentTypeCode = null;
        switch (moduleNumber) {
            case 1: {
                documentTypeCode = "AWRD";
                break;
            }
            case 2: {
                documentTypeCode = "INPR";
                break;
            }
            case 3: {
                documentTypeCode = "PRDV";
                break;
            }
            case 7: {
                documentTypeCode = "PROT";
                break;
            }
            case 8: {
                documentTypeCode = "COI";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid typeName provided: " + documentTypeCode);
            }
        }
        return documentTypeCode;
    }
}

