/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.ArgValueLookup;
import org.kuali.kra.bo.CustomAttribute;
import org.kuali.kra.bo.CustomAttributeDataType;
import org.kuali.kra.bo.CustomAttributeDocValue;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.DocumentCustomData;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.infrastructure.PropertyConstants;
import org.kuali.kra.service.CustomAttributeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.document.attribute.WorkflowAttributeDefinition;
import org.kuali.rice.kns.service.BusinessObjectDictionaryService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CustomAttributeServiceImpl
implements CustomAttributeService {
    private static final String ARGVALUELOOKUPE_CLASS = "org.kuali.kra.bo.ArgValueLookup";
    private BusinessObjectService businessObjectService;

    @Override
    public Map<String, CustomAttributeDocument> getDefaultCustomAttributeDocuments(String documentTypeCode, List<? extends DocumentCustomData> customDataList) {
        HashMap<String, CustomAttributeDocument> customAttributeDocuments = new HashMap<String, CustomAttributeDocument>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(PropertyConstants.DOCUMENT.TYPE_NAME.toString(), documentTypeCode);
        List customAttributeDocumentList = (List)this.getBusinessObjectService().findMatching(CustomAttributeDocument.class, queryMap);
        HashSet<Object> customIds = new HashSet();
        if (customDataList != null) {
            customIds = this.getCurrentCustomAttributeIds(customDataList);
        }
        for (CustomAttributeDocument customAttributeDocument : customAttributeDocumentList) {
            boolean customAttributeExists = false;
            if (!customIds.isEmpty() && customIds.contains(customAttributeDocument.getCustomAttributeId().longValue())) {
                customAttributeExists = true;
            }
            if (!customAttributeDocument.isActive() && !customAttributeExists) continue;
            customAttributeDocuments.put(customAttributeDocument.getCustomAttributeId().toString(), customAttributeDocument);
        }
        return customAttributeDocuments;
    }

    protected HashSet<Long> getCurrentCustomAttributeIds(List<? extends DocumentCustomData> customDataList) {
        HashSet<Long> customIds = new HashSet<Long>();
        for (DocumentCustomData documentCustomData : customDataList) {
            customIds.add(documentCustomData.getCustomAttributeId());
        }
        return customIds;
    }

    protected List<CustomAttributeDocument> getCustomAttributeDocuments(String documentTypeCode) {
        ArrayList<CustomAttributeDocument> newCustomAttributeDocuments = new ArrayList<CustomAttributeDocument>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(PropertyConstants.DOCUMENT.TYPE_NAME.toString(), documentTypeCode);
        List customAttributeDocuments = (List)this.getBusinessObjectService().findMatching(CustomAttributeDocument.class, queryMap);
        for (CustomAttributeDocument customAttributeDocument : customAttributeDocuments) {
            newCustomAttributeDocuments.add(this.copyCustomAttributeDocument(customAttributeDocument));
        }
        return newCustomAttributeDocuments;
    }

    protected CustomAttributeDocument copyCustomAttributeDocument(CustomAttributeDocument customAttributeDocument) {
        CustomAttributeDocument newCustomAttributeDocument = new CustomAttributeDocument();
        newCustomAttributeDocument.setCustomAttributeId(customAttributeDocument.getCustomAttributeId());
        newCustomAttributeDocument.setDocumentTypeName(customAttributeDocument.getDocumentTypeName());
        newCustomAttributeDocument.setRequired(customAttributeDocument.isRequired());
        newCustomAttributeDocument.setTypeName(customAttributeDocument.getTypeName());
        newCustomAttributeDocument.setDocumentType(customAttributeDocument.getDocumentType());
        newCustomAttributeDocument.setCustomAttribute(this.copyCustomAttribute(customAttributeDocument.getCustomAttribute()));
        newCustomAttributeDocument.setActive(customAttributeDocument.isActive());
        return newCustomAttributeDocument;
    }

    protected CustomAttribute copyCustomAttribute(CustomAttribute customAttribute) {
        CustomAttribute newCustomAttribute = new CustomAttribute();
        newCustomAttribute.setId(customAttribute.getId());
        newCustomAttribute.setDataLength(customAttribute.getDataLength());
        newCustomAttribute.setDataTypeCode(customAttribute.getDataTypeCode());
        newCustomAttribute.setDefaultValue(customAttribute.getDefaultValue());
        newCustomAttribute.setGroupName(customAttribute.getGroupName());
        newCustomAttribute.setLabel(customAttribute.getLabel());
        newCustomAttribute.setLookupClass(customAttribute.getLookupClass());
        newCustomAttribute.setLookupReturn(customAttribute.getLookupReturn());
        newCustomAttribute.setName(customAttribute.getName());
        newCustomAttribute.setValue(customAttribute.getValue());
        newCustomAttribute.setCustomAttributeDataType(customAttribute.getCustomAttributeDataType());
        return newCustomAttribute;
    }

    public Map<String, CustomAttributeDocument> getDefaultAwardCustomAttributeDocuments() {
        HashMap<String, CustomAttributeDocument> customAttributeDocuments = new HashMap<String, CustomAttributeDocument>();
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("documentTypeCode", "AWRD");
        List customAttributeDocumentList = (List)this.getBusinessObjectService().findMatching(CustomAttributeDocument.class, queryMap);
        for (CustomAttributeDocument customAttributeDocument : customAttributeDocumentList) {
            if (!customAttributeDocument.isActive()) continue;
            customAttributeDocuments.put(customAttributeDocument.getCustomAttributeId().toString(), customAttributeDocument);
        }
        return customAttributeDocuments;
    }

    public void saveCustomAttributeValues(ResearchDocumentBase document) {
        Map<String, CustomAttributeDocument> customAttributeDocuments = document.getCustomAttributeDocuments();
        if (customAttributeDocuments != null) {
            for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = customAttributeDocumentEntry.getValue();
                Integer customAttributeId = customAttributeDocument.getCustomAttributeId();
                String documentNumber = document.getDocumentNumber();
                HashMap<String, Object> primaryKeys = new HashMap<String, Object>();
                primaryKeys.put("customAttributeId", customAttributeId);
                primaryKeys.put("documentNumber", documentNumber);
                CustomAttributeDocValue customAttributeDocValue = (CustomAttributeDocValue)this.businessObjectService.findByPrimaryKey(CustomAttributeDocValue.class, primaryKeys);
                if (customAttributeDocValue == null) {
                    customAttributeDocValue = new CustomAttributeDocValue();
                    customAttributeDocValue.setCustomAttributeId(customAttributeDocument.getCustomAttributeId().longValue());
                    customAttributeDocValue.setDocumentNumber(document.getDocumentNumber());
                }
                customAttributeDocValue.setValue(customAttributeDocument.getCustomAttribute().getValue());
                this.businessObjectService.save((PersistableBusinessObject)customAttributeDocValue);
            }
        }
    }

    @Override
    public void setCustomAttributeKeyValue(String documentNumber, Map<String, CustomAttributeDocument> customAttributeDocuments, String attributeName, String networkId) {
        WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)networkId, (String)documentNumber);
        workflowDocument.clearAttributeContent();
        WorkflowAttributeDefinition customDataDef = WorkflowAttributeDefinition.Builder.create((String)attributeName).build();
        WorkflowAttributeDefinition.Builder refToUpdate = WorkflowAttributeDefinition.Builder.create((WorkflowAttributeDefinition)customDataDef);
        if (customAttributeDocuments != null) {
            for (Map.Entry<String, CustomAttributeDocument> customAttributeDocumentEntry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = customAttributeDocumentEntry.getValue();
                if (!StringUtils.isNotBlank((String)customAttributeDocument.getCustomAttribute().getValue())) continue;
                refToUpdate.addPropertyDefinition(customAttributeDocument.getCustomAttribute().getName(), StringEscapeUtils.escapeXml((String)customAttributeDocument.getCustomAttribute().getValue()));
            }
        }
        workflowDocument.addAttributeDefinition(refToUpdate.build());
        workflowDocument.saveDocumentData();
    }

    @Override
    public void setBusinessObjectService(BusinessObjectService bos) {
        this.businessObjectService = bos;
    }

    @Override
    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public CustomAttributeDataType getCustomAttributeDataType(String dataTypeCode) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)dataTypeCode)) {
            primaryKeys.put("dataTypeCode", dataTypeCode);
            return (CustomAttributeDataType)this.businessObjectService.findByPrimaryKey(CustomAttributeDataType.class, primaryKeys);
        }
        return null;
    }

    @Override
    public List getLookupReturns(String lookupClass) throws Exception {
        List<String> lookupReturns = new ArrayList();
        if (ARGVALUELOOKUPE_CLASS.equals(lookupClass)) {
            for (ArgValueLookup argValueLookup : (List)this.businessObjectService.findAll(ArgValueLookup.class)) {
                if (lookupReturns.contains(argValueLookup.getArgumentName())) continue;
                lookupReturns.add(argValueLookup.getArgumentName());
            }
            Collections.sort(lookupReturns);
        } else {
            BusinessObjectDictionaryService businessDictionaryService = (BusinessObjectDictionaryService)KraServiceLocator.getService("businessObjectDictionaryService");
            lookupReturns = businessDictionaryService.getLookupFieldNames(Class.forName(lookupClass));
        }
        return lookupReturns;
    }

    @Override
    public String getLookupReturnsForAjaxCall(String lookupClass) throws Exception {
        List lookupFieldNames = this.getLookupReturns(lookupClass);
        String attributeNames = "";
        for (Object attributeName : lookupFieldNames) {
            attributeNames = attributeNames + "," + attributeName + ";" + (ARGVALUELOOKUPE_CLASS.equals(lookupClass) ? attributeName : KraServiceLocator.getService(DataDictionaryService.class).getAttributeLabel(lookupClass, attributeName.toString()));
        }
        return attributeNames;
    }
}

