/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.infrastructure.DeepCopyIgnore;
import org.kuali.kra.service.DeepCopyPostProcessor;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public class DeepCopyPostProcessorImpl
implements DeepCopyPostProcessor {
    @Override
    public Serializable processDeepCopyWithDeepCopyIgnore(Serializable source) {
        Serializable copiedObject = ObjectUtils.deepCopy((Serializable)source);
        return this.processDeepCopyIgnoreAnnotation(copiedObject);
    }

    private Serializable processDeepCopyIgnoreAnnotation(Serializable copiedObject) {
        ArrayList<Field> list = new ArrayList<Field>();
        this.findAllFields(copiedObject.getClass(), list);
        for (Field field : list) {
            List objectList;
            DeepCopyIgnore deepCopyIgnoreAnn;
            if (field.isAnnotationPresent(DeepCopyIgnore.class) && (deepCopyIgnoreAnn = field.getAnnotation(DeepCopyIgnore.class)) != null) {
                try {
                    ObjectUtils.setObjectProperty((Object)copiedObject, (String)field.getName(), null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!field.getType().isAssignableFrom(List.class) || (objectList = (List)ObjectUtils.getPropertyValue((Object)copiedObject, (String)field.getName())) == null) continue;
            for (Serializable objectFromList : objectList) {
                this.processDeepCopyWithDeepCopyIgnore(objectFromList);
            }
        }
        return copiedObject;
    }

    private void findAllFields(Class klass, List<Field> allFields) {
        Field[] fields = klass.getDeclaredFields();
        allFields.addAll(Arrays.asList(fields));
        klass = klass.getSuperclass();
        if (klass != null && !klass.equals(KraPersistableBusinessObjectBase.class)) {
            this.findAllFields(klass, allFields);
        }
    }

    public void fixProperty(Object object, Class clazz, Object propertyValue, String ... methodNames) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        for (int i = 0; i < methodNames.length; ++i) {
            String methodName = methodNames[i];
            objectMap.clear();
            this.fixProperty(objectMap, methodName, clazz, propertyValue, objectMap);
        }
    }

    public void fixProperty(Object object, String methodName, Class clazz, Object propertyValue, Map<String, Object> objectMap) {
        if (ObjectUtils.isNotNull((Object)object) && object instanceof PersistableBusinessObject) {
            Method[] methods;
            PersistableBusinessObject objectWId = (PersistableBusinessObject)object;
            if (objectMap.get(objectWId.getObjectId()) != null) {
                return;
            }
            objectMap.put(((PersistableBusinessObject)object).getObjectId(), object);
            for (Method method : methods = object.getClass().getMethods()) {
                if (method.getName().equals(methodName)) {
                    if (object instanceof BudgetDocument) continue;
                    try {
                        if (clazz.equals(Long.class)) {
                            method.invoke(object, (Long)propertyValue);
                            continue;
                        }
                        method.invoke(object, (Integer)propertyValue);
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (!this.isPropertyGetterMethod(method, methods)) continue;
                Object value = null;
                try {
                    value = method.invoke(object, new Object[0]);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (value == null) continue;
                if (value instanceof Collection) {
                    Collection c = (Collection)value;
                    for (Object entry : c) {
                        this.fixProperty(entry, methodName, clazz, propertyValue, objectMap);
                    }
                    continue;
                }
                this.fixProperty(value, methodName, clazz, propertyValue, objectMap);
            }
        }
    }

    private boolean isPropertyGetterMethod(Method method, Method[] methods) {
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
            String setterName = method.getName().replaceFirst("get", "set");
            for (Method m : methods) {
                if (!m.getName().equals(setterName)) continue;
                return true;
            }
        }
        return false;
    }
}

