/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kuali.kra.bo.KcAttachment;
import org.kuali.kra.service.KcAttachmentService;
import org.kuali.rice.krad.util.ObjectUtils;

public class KcAttachmentServiceImpl
implements KcAttachmentService {
    private Map<String, String> mimeTypeIcons;
    private String defaultIcon;
    private static final String REPLACEMENT_CHARACTER = "_";
    private static final String REGEX_TITLE_FILENAME_PATTERN = "([^0-9a-zA-Z\\.\\-_])";
    private static final String REGEX_TITLE_SPECIAL_CHARACTER_PATTERN = "([^\\x00-\\x7F])";

    @Override
    public String getFileTypeIcon(KcAttachment attachment) {
        String iconPath = this.getMimeTypeIcons().get(attachment.getType());
        if (iconPath == null) {
            return this.getDefaultIcon();
        }
        return iconPath;
    }

    protected Map<String, String> getMimeTypeIcons() {
        return this.mimeTypeIcons;
    }

    public void setMimeTypeIcons(Map<String, String> mimeTypeIcons) {
        this.mimeTypeIcons = mimeTypeIcons;
    }

    protected String getDefaultIcon() {
        return this.defaultIcon;
    }

    public void setDefaultIcon(String defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @Override
    public String getInvalidCharacters(String text) {
        Pattern pattern;
        Matcher matcher;
        if (ObjectUtils.isNotNull((Object)text) && (matcher = (pattern = Pattern.compile(REGEX_TITLE_FILENAME_PATTERN)).matcher(text)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public String checkAndReplaceInvalidCharacters(String text) {
        String cleanText = text;
        if (ObjectUtils.isNotNull((Object)text)) {
            Pattern pattern = Pattern.compile(REGEX_TITLE_FILENAME_PATTERN);
            Matcher matcher = pattern.matcher(text);
            cleanText = matcher.replaceAll(REPLACEMENT_CHARACTER);
        }
        return cleanText;
    }

    @Override
    public boolean getSpecialCharacter(String text) {
        Pattern pattern;
        Matcher matcher;
        return ObjectUtils.isNotNull((Object)text) && (matcher = (pattern = Pattern.compile(REGEX_TITLE_SPECIAL_CHARACTER_PATTERN)).matcher(text)).find();
    }

    @Override
    public String checkAndReplaceSpecialCharacters(String text) {
        String cleanText = text;
        if (ObjectUtils.isNotNull((Object)text)) {
            Pattern pattern = Pattern.compile(REGEX_TITLE_SPECIAL_CHARACTER_PATTERN);
            Matcher matcher = pattern.matcher(text);
            cleanText = matcher.replaceAll(REPLACEMENT_CHARACTER);
        }
        return cleanText;
    }
}

