/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.MultiCampusIdentityService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.entity.EntityContract;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcPersonServiceImpl
implements KcPersonService {
    private IdentityService identityService;
    private PersonService personService;
    private ParameterService parameterService;
    private MultiCampusIdentityService multiCampusIdentityService;

    @Override
    public List<KcPerson> getKcPersons(Map<String, String> fieldValues) {
        if (fieldValues == null) {
            throw new IllegalArgumentException("the fieldValues are null");
        }
        this.modifyFieldValues(fieldValues);
        List people = this.personService.findPeople(fieldValues, true);
        return this.createKcPersonsFromPeople(people);
    }

    @Override
    public void modifyFieldValues(Map<String, String> fieldValues) {
        boolean multiCampusEnabled = this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        if (StringUtils.isNotBlank((String)fieldValues.get("userName"))) {
            String userNameSearchValue = fieldValues.get("userName");
            if (multiCampusEnabled) {
                String campusCode = fieldValues.get("campusCode");
                userNameSearchValue = this.multiCampusIdentityService.getMultiCampusPrincipalName(userNameSearchValue, campusCode);
            }
            fieldValues.put("principalName", userNameSearchValue);
        }
        if (StringUtils.isNotBlank((String)fieldValues.get("personId"))) {
            String personIdSearchValue = fieldValues.get("personId");
            fieldValues.put("principalId", personIdSearchValue);
        }
        if (StringUtils.isNotBlank((String)fieldValues.get("officePhone"))) {
            String officePhoneSerachValue = fieldValues.get("officePhone");
            fieldValues.put("phoneNumber", officePhoneSerachValue);
        }
        if (StringUtils.isNotBlank((String)fieldValues.get("organizationIdentifier"))) {
            String primaryDeptCodeSearchValue = fieldValues.get("organizationIdentifier");
            fieldValues.put("primaryDepartmentCode", primaryDeptCodeSearchValue);
        }
    }

    @Override
    public KcPerson getKcPersonByUserName(String userName) {
        KcPerson person = null;
        if (StringUtils.isEmpty((String)userName)) {
            throw new IllegalArgumentException("the userName is null or empty");
        }
        boolean multiCampusEnabled = this.parameterService.getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
        if (multiCampusEnabled) {
            String campusCode = (String)GlobalVariables.getUserSession().retrieveObject("userCampusCode");
            String multiCampusUserName = this.multiCampusIdentityService.getMultiCampusPrincipalName(userName, campusCode);
            Entity entity = this.identityService.getEntityByPrincipalName(multiCampusUserName);
            if (entity != null) {
                person = KcPerson.fromEntityAndUserName((EntityContract)entity, multiCampusUserName);
            }
        } else {
            Entity entity = this.identityService.getEntityByPrincipalName(userName);
            if (entity != null) {
                person = KcPerson.fromEntityAndUserName((EntityContract)entity, userName);
            }
        }
        return person;
    }

    @Override
    public KcPerson getKcPersonByPersonId(String personId) {
        if (StringUtils.isEmpty((String)personId)) {
            throw new IllegalArgumentException("the personId is null or empty");
        }
        return KcPerson.fromEntityAndPersonId((EntityContract)this.identityService.getEntityByPrincipalId(personId), personId);
    }

    protected List<KcPerson> createKcPersonsFrom(List<? extends EntityContract> entities) {
        ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
        for (EntityContract entityContract : entities) {
            for (PrincipalContract principal : entityContract.getPrincipals()) {
                persons.add(KcPerson.fromEntityAndPersonId(entityContract, principal.getPrincipalId()));
            }
        }
        return persons;
    }

    @Override
    public List<KcPerson> createKcPersonsFromPeople(List<Person> people) {
        ArrayList<KcPerson> persons = new ArrayList<KcPerson>();
        for (Person person : people) {
            persons.add(KcPerson.fromPersonId(person.getPrincipalId()));
        }
        return persons;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setMultiCampusIdentityService(MultiCampusIdentityService multiCampusIdentityService) {
        this.multiCampusIdentityService = multiCampusIdentityService;
    }
}

