/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ojb.broker.OptimisticLockException;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.framework.postprocessor.ProcessDocReport;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.PostProcessorService;
import org.kuali.rice.krad.service.impl.PostProcessorServiceImpl;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcPostProcessorServiceImpl
extends PostProcessorServiceImpl
implements PostProcessorService {
    private static final Log LOG = LogFactory.getLog(KcPostProcessorServiceImpl.class);
    private WorkflowDocumentService workflowDocumentService;

    protected void performKCWorkaround(DocumentRouteStatusChange statusChangeEvent) throws Exception {
        try {
            this.establishPostProcessorUserSession();
            String routeHeaderId = statusChangeEvent.getDocumentId();
            List actionsTaken = this.workflowDocumentService.getActionsTaken(routeHeaderId);
            ActionTaken lastActionTaken = null;
            for (ActionTaken actionTaken : actionsTaken) {
                if (lastActionTaken != null && !actionTaken.getActionDate().toDate().after(lastActionTaken.getActionDate().toDate())) continue;
                lastActionTaken = actionTaken;
            }
            if (lastActionTaken != null) {
                String lastPrincipalId = lastActionTaken.getPrincipalId();
                GlobalVariables.getUserSession().addObject("lastActionPrincipalId", (Object)lastPrincipalId);
            }
        }
        catch (WorkflowException e) {
            LOG.error((Object)"caught exception while handling route status change", (Throwable)e);
            throw new RuntimeException("post processor caught exception while handling route status change: " + e.getMessage(), e);
        }
    }

    public ProcessDocReport doRouteStatusChange(final DocumentRouteStatusChange statusChangeEvent) throws Exception {
        return (ProcessDocReport)GlobalVariables.doInNewGlobalVariables((UserSession)this.establishPostProcessorUserSession(), (Callable)new Callable<ProcessDocReport>(){

            @Override
            public ProcessDocReport call() throws Exception {
                DocumentService documentService = KRADServiceLocatorWeb.getDocumentService();
                try {
                    Document document;
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)new StringBuffer("started handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                    }
                    if ((document = documentService.getByDocumentHeaderId(statusChangeEvent.getDocumentId())) == null) {
                        if (!"X".equals(statusChangeEvent.getNewRouteStatus())) {
                            throw new RuntimeException("unable to load document " + statusChangeEvent.getDocumentId());
                        }
                    } else {
                        KcPostProcessorServiceImpl.this.performKCWorkaround(statusChangeEvent);
                        document.doRouteStatusChange(statusChangeEvent);
                        if (!document.getDocumentHeader().getWorkflowDocument().isSaved()) {
                            documentService.updateDocument(document);
                        }
                    }
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)new StringBuffer("finished handling route status change from ").append(statusChangeEvent.getOldRouteStatus()).append(" to ").append(statusChangeEvent.getNewRouteStatus()).append(" for document ").append(statusChangeEvent.getDocumentId()));
                    }
                }
                catch (Exception e) {
                    KcPostProcessorServiceImpl.this.logAndRethrow("route status", e);
                }
                return new ProcessDocReport(true, "");
            }
        });
    }

    private void logAndRethrow(String changeType, Exception e) throws RuntimeException {
        LOG.error((Object)("caught exception while handling " + changeType + " change"), (Throwable)e);
        this.logOptimisticDetails(5, e);
        throw new RuntimeException("post processor caught exception while handling " + changeType + " change: " + e.getMessage(), e);
    }

    private void logOptimisticDetails(int depth, Throwable t) {
        if (depth > 0 && t != null) {
            if (t instanceof OptimisticLockException) {
                OptimisticLockException o = (OptimisticLockException)t;
                LOG.error((Object)("source of OptimisticLockException = " + o.getSourceObject().getClass().getName() + " ::= " + o.getSourceObject()));
            } else {
                Throwable cause = t.getCause();
                if (cause != t) {
                    this.logOptimisticDetails(--depth, cause);
                }
            }
        }
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }
}

