/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.AbstractScienceKeyword;
import org.kuali.kra.bo.ScienceKeyword;
import org.kuali.kra.document.KeywordsManager;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KeywordsService;
import org.kuali.kra.web.struts.form.MultiLookupFormBase;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class KeywordsServiceImpl
implements KeywordsService {
    private static final Log LOG = LogFactory.getLog(KeywordsServiceImpl.class);

    public void addKeyword(KeywordsManager document, ScienceKeyword scienceKeyword) {
        if (!this.isDuplicateKeyword(scienceKeyword.getScienceKeywordCode(), document.getKeywords())) {
            document.addKeyword(scienceKeyword);
        }
    }

    public void deleteKeyword(KeywordsManager keywordsDocument) {
        List scienceKeywords = keywordsDocument.getKeywords();
        for (int i = scienceKeywords.size() - 1; i >= 0; --i) {
            AbstractScienceKeyword abstractScienceKeyword = (AbstractScienceKeyword)((Object)scienceKeywords.get(i));
            if (!abstractScienceKeyword.getSelectKeyword().booleanValue()) continue;
            scienceKeywords.remove((Object)abstractScienceKeyword);
        }
    }

    @Override
    public Boolean hasKeywordsPanelEnabledForModule(String moduleCode) {
        return null;
    }

    protected boolean isDuplicateKeyword(String newScienceKeywordCode, List<AbstractScienceKeyword> keywords) {
        for (AbstractScienceKeyword abstractScienceKeyword : keywords) {
            if (!newScienceKeywordCode.equals(abstractScienceKeyword.getScienceKeywordCode())) continue;
            return true;
        }
        return false;
    }

    public void addKeywords(KeywordsManager document, MultiLookupFormBase multiLookUpForm) {
        try {
            String lookupResultsSequenceNumber;
            if ("multipleValues".equals(multiLookUpForm.getRefreshCaller()) && StringUtils.isNotBlank((String)(lookupResultsSequenceNumber = multiLookUpForm.getLookupResultsSequenceNumber()))) {
                Class<ScienceKeyword> lookupResultsBOClass = Class.forName(multiLookUpForm.getLookupResultsBOClassName());
                Collection rawValues = KNSServiceLocator.getLookupResultsService().retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, GlobalVariables.getUserSession().getPrincipalId());
                if (lookupResultsBOClass.isAssignableFrom(ScienceKeyword.class)) {
                    KeywordsService keywordsService = KraServiceLocator.getService(KeywordsService.class);
                    for (ScienceKeyword scienceKeyword : rawValues) {
                        keywordsService.addKeyword(document, scienceKeyword);
                    }
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
        }
    }
}

