/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.document.CommitteeDocument;
import org.kuali.kra.iacuc.committee.bo.IacucCommittee;
import org.kuali.kra.iacuc.committee.document.CommonCommitteeDocument;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.ValidationException;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.rules.rule.event.RouteDocumentEvent;
import org.kuali.rice.krad.service.impl.DocumentServiceImpl;
import org.springframework.dao.OptimisticLockingFailureException;

public class KraDocumentServiceImpl
extends DocumentServiceImpl {
    private static Log LOG = LogFactory.getLog(KraDocumentServiceImpl.class);

    public Document validateAndPersistDocument(Document document, KualiDocumentEvent event) throws ValidationException {
        if (document == null) {
            LOG.error((Object)"document passed to validateAndPersist was null");
            throw new IllegalArgumentException("invalid (null) document");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("validating and preparing to persist document " + document.getDocumentNumber()));
        }
        document.validateBusinessRules(event);
        document.prepareForSave(event);
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("storing document " + document.getDocumentNumber()));
            }
            if (document instanceof CommitteeDocument) {
                Committee committee = (Committee)((CommitteeDocument)document).getCommittee();
                ((CommitteeDocument)document).setCommitteeList(new ArrayList());
                this.getDocumentDao().save(document);
                ((CommitteeDocument)document).getCommitteeList().add(committee);
                if (event instanceof RouteDocumentEvent) {
                    this.getDocumentDao().save(document);
                }
            } else if (document instanceof CommonCommitteeDocument) {
                IacucCommittee committee = (IacucCommittee)((CommonCommitteeDocument)document).getCommittee();
                ((CommonCommitteeDocument)document).setCommitteeList(new ArrayList());
                this.getDocumentDao().save(document);
                ((CommonCommitteeDocument)document).getCommitteeList().add(committee);
                if (event instanceof RouteDocumentEvent) {
                    this.getDocumentDao().save(document);
                }
            } else {
                this.getDocumentDao().save(document);
            }
        }
        catch (OptimisticLockingFailureException e) {
            LOG.error((Object)("exception encountered on store of document " + e.getMessage()));
            throw e;
        }
        document.postProcessSave(event);
        return document;
    }
}

