/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.CoPiInfoDO;
import org.kuali.kra.proposaldevelopment.bo.CostShareInfoDO;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalDevelopmentApproverViewDO;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestPolicy;
import org.kuali.rice.kew.api.action.RoutingReportCriteria;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.actionlist.ActionListService;
import org.kuali.rice.kew.api.document.DocumentDetail;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class KraWorkflowServiceImpl
implements KraWorkflowService {
    static Log LOG = LogFactory.getLog(KraWorkflowService.class);
    protected WorkflowDocumentActionsService workflowDocumentActionsService;
    protected WorkflowDocumentService workflowDocumentService;
    protected ActionListService actionListService;
    private static List<String> approvalCodes = new ArrayList<String>();

    public void setWorkflowDocumentActionsService(WorkflowDocumentActionsService workflowDocumentActionsService) {
        this.workflowDocumentActionsService = workflowDocumentActionsService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    @Override
    public boolean hasWorkflowPermission(String userId, Document doc) {
        boolean hasPermission = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null && this.isInWorkflow(doc)) {
            String routeHeaderId = workflowDoc.getDocumentId();
            hasPermission = this.workflowDocumentActionsService.isUserInRouteLog(routeHeaderId, userId, true);
        }
        return hasPermission;
    }

    @Override
    public boolean isClosed(Document doc) {
        boolean isClosed = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null) {
            isClosed = workflowDoc.isApproved() || workflowDoc.isCanceled() || workflowDoc.isDisapproved() || workflowDoc.isException();
        }
        return isClosed;
    }

    @Override
    public boolean isEnRoute(Document doc) {
        boolean isEnRoute = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null) {
            isEnRoute = workflowDoc.isEnroute();
        }
        return isEnRoute;
    }

    @Override
    public boolean isInWorkflow(Document doc) {
        boolean isInWorkflow = false;
        WorkflowDocument workflowDoc = this.getWorkflowDocument(doc);
        if (workflowDoc != null) {
            isInWorkflow = !workflowDoc.isInitiated() && !workflowDoc.isSaved();
        }
        return isInWorkflow;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc, String principalId) {
        return WorkflowDocumentFactory.loadDocument((String)principalId, (String)doc.getDocumentHeader().getWorkflowDocument().getDocumentId());
    }

    @Override
    public boolean isUserApprovalRequested(Document doc, String principalId) {
        boolean hasApprovalRequest = false;
        WorkflowDocument workDoc = this.getWorkflowDocument(doc, principalId);
        if (workDoc != null) {
            hasApprovalRequest = workDoc.isApprovalRequested();
        }
        return hasApprovalRequest;
    }

    @Override
    public boolean isUserActionRequested(Document doc, String principalId) {
        boolean hasActionRequest = false;
        WorkflowDocument workDoc = this.getWorkflowDocument(doc, principalId);
        if (workDoc != null) {
            hasActionRequest = workDoc.isApprovalRequested() || workDoc.isAcknowledgeRequested() || workDoc.isFYIRequested();
        }
        return hasActionRequest;
    }

    @Override
    public boolean isDocumentOnNode(Document document, String nodeName) {
        boolean result = false;
        try {
            result = document != null && document.getDocumentHeader().getWorkflowDocument().getNodeNames().contains(nodeName);
            return result;
        }
        catch (Exception we) {
            LOG.error((Object)String.format("Exception generated when trying to determine if document %s is on %s node.  Reason:%s", nodeName, document.getDocumentNumber(), we.getMessage()));
            throw new RuntimeException(String.format("Exception generated when trying determine if document %s is on %s route node.  Reason:%s", nodeName, document.getDocumentNumber(), we.getMessage()), we);
        }
    }

    @Override
    public boolean isUserAdHocRequestRecipient(Document document, String principalId, String nodeName) {
        try {
            List actionRequestsForCurrentUser = this.workflowDocumentService.getActionRequestsForPrincipalAtNode(document.getDocumentNumber(), nodeName, principalId);
            for (ActionRequest actionRequest : actionRequestsForCurrentUser) {
                if (!actionRequest.isAdHocRequest() || !actionRequest.isPending()) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return false;
    }

    @Override
    public boolean isUserRouteRespRequestRecipient(Document document, String principalId, String nodeName) {
        try {
            List actionRequestsForCurrentUser = this.workflowDocumentService.getActionRequestsForPrincipalAtNode(document.getDocumentNumber(), nodeName, principalId);
            for (ActionRequest actionRequest : actionRequestsForCurrentUser) {
                if (!actionRequest.isPending() || !actionRequest.isRouteModuleRequest()) continue;
                return true;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return false;
    }

    @Override
    public ProposalDevelopmentApproverViewDO populateApproverViewDO(ProposalDevelopmentForm proposalDevelopmentForm) {
        ProposalDevelopmentApproverViewDO approverViewDO = new ProposalDevelopmentApproverViewDO();
        DevelopmentProposal proposal = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposalList().get(0);
        ProposalDevelopmentService proposalService = KraServiceLocator.getService(ProposalDevelopmentService.class);
        Budget budget = proposalService.getFinalBudget(proposal);
        int numberOfCostShare = 0;
        int numberOfCoPI = 0;
        ArrayList<CoPiInfoDO> coPiInfos = new ArrayList();
        coPiInfos = proposalService.getCoPiPiInfo(proposal);
        approverViewDO.setCoPiInfos(coPiInfos);
        if (coPiInfos != null) {
            numberOfCoPI = coPiInfos.size();
        }
        ArrayList<CostShareInfoDO> costShareInfos = new ArrayList();
        if (budget != null) {
            costShareInfos = proposalService.getCostShareInfo(budget);
            approverViewDO.setCostShareInfos(costShareInfos);
            if (costShareInfos != null) {
                numberOfCostShare = costShareInfos.size();
            }
        }
        if (budget != null) {
            approverViewDO.setDirectCost(budget.getTotalDirectCost());
            approverViewDO.setIndirectCost(budget.getTotalIndirectCost());
            approverViewDO.setTotalCost(budget.getTotalCost());
        }
        if (numberOfCoPI > numberOfCostShare) {
            for (int i = 0; i < numberOfCoPI - numberOfCostShare; ++i) {
                CostShareInfoDO costShareInfo = new CostShareInfoDO();
                costShareInfos.add(costShareInfo);
            }
        } else if (numberOfCoPI < numberOfCostShare) {
            for (int i = 0; i < numberOfCostShare - numberOfCoPI; ++i) {
                CoPiInfoDO coPiInfo = new CoPiInfoDO();
                coPiInfos.add(coPiInfo);
            }
        }
        approverViewDO.setActivityType(proposal.getActivityType().getDescription());
        approverViewDO.setDueDate(proposal.getDeadlineDate());
        approverViewDO.setStartDate(proposal.getRequestedStartDateInitial());
        approverViewDO.setEndDate(proposal.getRequestedEndDateInitial());
        approverViewDO.setProjectTitle(proposal.getTitle());
        approverViewDO.setLeadUnit(proposal.getOwnedByUnitNumber());
        approverViewDO.setProposalNumber(proposal.getProposalNumber());
        approverViewDO.setProposalType(proposal.getProposalType().getDescription());
        approverViewDO.setSponsorName(proposal.getSponsorName());
        approverViewDO.setPiName(proposal.getPrincipalInvestigatorName());
        return approverViewDO;
    }

    @Override
    public boolean canPerformWorkflowAction(ProposalDevelopmentDocument document) {
        if (document.getDocumentHeader().getDocumentNumber() == null) {
            return false;
        }
        KcTransactionalDocumentAuthorizerBase documentAuthorizer = (KcTransactionalDocumentAuthorizerBase)KNSServiceLocator.getDocumentHelperService().getDocumentAuthorizer((Document)document);
        Person user = GlobalVariables.getUserSession().getPerson();
        Set<String> documentActions = documentAuthorizer.getDocumentActions((Document)document, user, null);
        boolean canApprove = documentActions.contains("canApprove");
        boolean canDisapprove = documentActions.contains("canDisapprove");
        return canApprove || canDisapprove;
    }

    @Override
    public boolean isFinalApproval(WorkflowDocument workflowDoc) {
        RoutingReportCriteria.Builder reportCriteriaBuilder = RoutingReportCriteria.Builder.createByDocumentId((String)workflowDoc.getDocumentId());
        HashSet<String> approvalNodes = new HashSet<String>();
        Object currentRequest = null;
        DocumentDetail results1 = this.workflowDocumentActionsService.executeSimulation(reportCriteriaBuilder.build());
        for (ActionRequest actionRequest : results1.getActionRequests()) {
            if (!actionRequest.isPending() || !actionRequest.isApprovalRequest()) continue;
            if (actionRequest.isUserRequest() && this.willReceiveFutureRequests(workflowDoc, actionRequest.getPrincipalId())) {
                approvalNodes.add(actionRequest.getNodeName());
                continue;
            }
            if (actionRequest.isGroupRequest()) {
                approvalNodes.add(actionRequest.getNodeName());
                continue;
            }
            if (!actionRequest.isRoleRequest() || this.requestAlreadyApproved(workflowDoc, actionRequest)) continue;
            approvalNodes.add(actionRequest.getNodeName());
        }
        if (currentRequest != null) {
            approvalNodes.remove(currentRequest);
        }
        return approvalNodes.size() == 0;
    }

    @Override
    public boolean requestAlreadyApproved(WorkflowDocument workflowDoc, ActionRequest actionRequest) {
        boolean result = false;
        for (ActionRequest childRequest : actionRequest.getChildRequests()) {
            if (childRequest.isUserRequest()) {
                boolean futureRequests = this.willReceiveFutureRequests(workflowDoc, childRequest.getPrincipalId());
                if (actionRequest.getRequestPolicy() == ActionRequestPolicy.ALL && futureRequests) {
                    result = false;
                    continue;
                }
                if (actionRequest.getRequestPolicy() != ActionRequestPolicy.FIRST || futureRequests) continue;
                result = true;
                continue;
            }
            if (childRequest.isGroupRequest()) {
                if (actionRequest.getRequestPolicy() != ActionRequestPolicy.ALL) continue;
                result = false;
                continue;
            }
            if (!childRequest.isRoleRequest()) continue;
            if (this.requestAlreadyApproved(workflowDoc, childRequest)) {
                if (actionRequest.getRequestPolicy() != ActionRequestPolicy.FIRST) continue;
                result = true;
                continue;
            }
            if (actionRequest.getRequestPolicy() != ActionRequestPolicy.ALL) continue;
            result = false;
        }
        return result;
    }

    private boolean willReceiveFutureRequests(WorkflowDocument workflowDoc, String principalId) {
        boolean doNotReceiveFutureRequests = false;
        Map variables = workflowDoc.getVariables();
        if (variables != null && CollectionUtils.isNotEmpty(variables.keySet())) {
            for (String variableKey : variables.keySet()) {
                String variableValue = (String)variables.get(variableKey);
                if (!variableKey.startsWith("_receive_future_requests") || !variableValue.toUpperCase().equals("NO") || !variableKey.contains(principalId)) continue;
                doNotReceiveFutureRequests = true;
                break;
            }
        }
        return !doNotReceiveFutureRequests;
    }

    @Override
    public boolean hasPendingApprovalRequests(WorkflowDocument workflowDoc) {
        return !this.actionListService.getActionItems(workflowDoc.getDocumentId(), approvalCodes).isEmpty();
    }

    protected ActionListService getActionListService() {
        return this.actionListService;
    }

    public void setActionListService(ActionListService actionListService) {
        this.actionListService = actionListService;
    }

    static {
        approvalCodes.add("C");
        approvalCodes.add("A");
    }
}

