/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.SponsorHierarchy;
import org.kuali.kra.dao.SponsorHierarchyDao;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.Sponsorable;
import org.kuali.kra.web.struts.form.SponsorHierarchyForm;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class SponsorServiceImpl
implements SponsorService,
Constants {
    private SponsorHierarchyDao sponsorHierarchyDao;
    private BusinessObjectService businessObjectService;
    private ParameterService parameterService;
    private static final String sessionKey = "org.kuali.kra.service.impl.SponsorServiceImpl.actionList";
    private static final Integer HIERARCHY_MAX_HEIGHT = 10;
    private static final Log LOG = LogFactory.getLog(SponsorServiceImpl.class);

    @Override
    public String getSponsorName(String sponsorCode) {
        String sponsorName = null;
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)sponsorCode)) {
            primaryKeys.put("sponsorCode", sponsorCode);
            Sponsor sponsor = (Sponsor)this.businessObjectService.findByPrimaryKey(Sponsor.class, primaryKeys);
            if (sponsor != null) {
                sponsorName = sponsor.getSponsorName();
            }
        }
        return sponsorName;
    }

    @Override
    public Sponsor getSponsor(String sponsorCode) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)sponsorCode)) {
            primaryKeys.put("sponsorCode", sponsorCode);
            Sponsor sponsor = (Sponsor)this.businessObjectService.findByPrimaryKey(Sponsor.class, primaryKeys);
            return sponsor;
        }
        return null;
    }

    @Override
    public String getTopSponsorHierarchy() {
        String topSponsorHierarchy = "";
        List sponsorHierarchies = (List)this.getTopSponsorHierarchyList();
        Collections.sort(sponsorHierarchies);
        for (Object hierarchyName : sponsorHierarchies) {
            topSponsorHierarchy = topSponsorHierarchy + hierarchyName + ";1;";
        }
        if (topSponsorHierarchy.length() >= 3) {
            topSponsorHierarchy = topSponsorHierarchy.substring(0, topSponsorHierarchy.length() - 3);
        }
        return topSponsorHierarchy;
    }

    @Override
    public Collection getTopSponsorHierarchyList() {
        Iterator sponsorHierarchyList = this.sponsorHierarchyDao.getTopSponsorHierarchy();
        ArrayList<String> sponsorHierarchies = new ArrayList<String>();
        while (sponsorHierarchyList.hasNext()) {
            Object[] names = (Object[])sponsorHierarchyList.next();
            String name = (String)names[0];
            sponsorHierarchies.add(name);
        }
        Collections.sort(sponsorHierarchies);
        return sponsorHierarchies;
    }

    @Override
    public String getSubSponsorHierarchiesForTreeView(String hierarchyName, String depth, String groups) {
        String returnSponsorHierarchy = null;
        String[] ascendantList = groups.split(";1;");
        if (Integer.parseInt(depth) < 10) {
            returnSponsorHierarchy = this.getSubSponsorHierarchy(hierarchyName, Integer.parseInt(depth) + 1, ascendantList);
        }
        if (StringUtils.isBlank(returnSponsorHierarchy) && StringUtils.isNotBlank((String)(returnSponsorHierarchy = this.getSponsorCodesForGroup(hierarchyName, Integer.parseInt(depth) + 1, ascendantList)))) {
            returnSponsorHierarchy = "((leafNodes));1;" + returnSponsorHierarchy;
        }
        return returnSponsorHierarchy;
    }

    protected String getSubSponsorHierarchy(String hierarchyName, int level, String[] levelName) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hierarchyName", hierarchyName);
        for (int i = 1; i < level; ++i) {
            values.put("level" + i, levelName[i - 1]);
        }
        Collection sponsors = this.getBusinessObjectService().findMatchingOrderBy(SponsorHierarchy.class, values, "level" + level + "Sortid", true);
        try {
            Method getLevel = SponsorHierarchy.class.getDeclaredMethod("getLevel" + level, null);
            Method getSortId = SponsorHierarchy.class.getDeclaredMethod("getLevel" + level + "Sortid", null);
            String retVal = null;
            ArrayList<String> uniqueLevel = new ArrayList<String>();
            for (SponsorHierarchy sponsor : sponsors) {
                String levelValue = (String)getLevel.invoke((Object)sponsor, null);
                Integer sortValue = (Integer)getSortId.invoke((Object)sponsor, null);
                if (levelValue == null || uniqueLevel.contains(levelValue + ":1:" + sortValue)) continue;
                uniqueLevel.add(levelValue + ":1:" + sortValue);
            }
            for (String uniqueItem : uniqueLevel) {
                if (retVal == null) {
                    retVal = uniqueItem.split(":1:")[0];
                    continue;
                }
                retVal = retVal + ";1;" + uniqueItem.split(":1:")[0];
            }
            return retVal;
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting sponsor hierarchy information", (Throwable)e);
            return null;
        }
    }

    protected String getSponsorCodesForGroup(String hierarchyName, int level, String[] levelName) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hierarchyName", hierarchyName);
        for (int i = 1; i < level; ++i) {
            values.put("level" + i, levelName[i - 1]);
        }
        int groupingNumber = 300;
        try {
            String sysParam = this.parameterService.getParameterValueAsString("KC-PD", "A", "numberPerSponsorHierarchyGroup");
            groupingNumber = Integer.parseInt(sysParam);
        }
        catch (Exception e) {
            LOG.debug((Object)"System param for numberPerSponsorHierarchyGroup is not defined");
        }
        Collection sponsors = this.getBusinessObjectService().findMatchingOrderBy(SponsorHierarchy.class, values, "sponsorCode", true);
        String retVal = null;
        int i = groupingNumber;
        for (SponsorHierarchy sponsor : sponsors) {
            if (StringUtils.isBlank(retVal)) {
                retVal = sponsor.getSponsorCode() + ":" + sponsor.getSponsor().getSponsorName();
                --i;
                continue;
            }
            if (i-- > 0) {
                retVal = retVal + ";1;" + sponsor.getSponsorCode() + ":" + sponsor.getSponsor().getSponsorName();
                continue;
            }
            retVal = retVal + "#1#" + sponsor.getSponsorCode() + ":" + sponsor.getSponsor().getSponsorName();
            i = groupingNumber;
        }
        return retVal;
    }

    protected String getSponsorCodesForDeletedGroup(String hierarchyName, int level, String[] levelName) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("hierarchyName", hierarchyName);
        for (int i = 1; i < level; ++i) {
            values.put("level" + i, levelName[i - 1]);
        }
        Collection sponsors = this.getBusinessObjectService().findMatching(SponsorHierarchy.class, values);
        String retVal = null;
        for (SponsorHierarchy sponsor : sponsors) {
            if (StringUtils.isBlank(retVal)) {
                retVal = sponsor.getSponsorCode();
                continue;
            }
            retVal = retVal + ";" + sponsor.getSponsorCode();
        }
        return retVal;
    }

    @Override
    public void copySponsorHierarchy(SponsorHierarchyForm sponsorHierarchyForm) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("hierarchyName", sponsorHierarchyForm.getSelectedSponsorHierarchy());
        List sponsors = (List)this.businessObjectService.findMatching(SponsorHierarchy.class, fieldValues);
        ArrayList<SponsorHierarchy> newSponsors = new ArrayList<SponsorHierarchy>();
        for (Object sponsorHierarchyObj : sponsors) {
            SponsorHierarchy sponsorHierarchy = (SponsorHierarchy)sponsorHierarchyObj;
            sponsorHierarchy.setHierarchyName(sponsorHierarchyForm.getNewHierarchyName());
            newSponsors.add(sponsorHierarchy);
        }
        this.businessObjectService.save(newSponsors);
    }

    @Override
    public void deleteSponsorHierarchy(SponsorHierarchyForm sponsorHierarchyForm) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("hierarchyName", sponsorHierarchyForm.getSelectedSponsorHierarchy());
        List sponsors = (List)this.businessObjectService.findMatching(SponsorHierarchy.class, fieldValues);
        this.businessObjectService.delete(sponsors);
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public SponsorHierarchyDao getSponsorHierarchyDao() {
        return this.sponsorHierarchyDao;
    }

    public void setSponsorHierarchyDao(SponsorHierarchyDao sponsorHierarchyDao) {
        this.sponsorHierarchyDao = sponsorHierarchyDao;
    }

    @Override
    public String loadToSponsorHierachyMt(String hierarchyName) {
        String sponsorCodes = "";
        Iterator sponsorHierarchyList = this.sponsorHierarchyDao.getAllSponsors(hierarchyName);
        ArrayList sponsorHierarchies = new ArrayList();
        while (sponsorHierarchyList.hasNext()) {
            sponsorCodes = sponsorCodes + ((Object[])sponsorHierarchyList.next())[0] + ";";
        }
        return sponsorCodes;
    }

    @Override
    public String getSponsorCodes(String hierarchyName, String depth, String groups) {
        String sponsorCodes = "";
        String[] ascendantList = groups.split(";1;");
        return this.getSponsorCodesForDeletedGroup(hierarchyName, Integer.parseInt(depth) + 1, ascendantList);
    }

    @Override
    public void updateSponsorCodes(String sponsorCodes) {
        if (GlobalVariables.getUserSession().retrieveObject("sponsorCodes") != null) {
            GlobalVariables.getUserSession().removeObject("sponsorCodes");
        }
        GlobalVariables.getUserSession().addObject("sponsorCodes", (Object)sponsorCodes);
    }

    @Override
    public void insertSponsor(String hierarchyName, String[] sponsorCodes, String[] levels, Integer[] sortIds) {
        for (String sponsorCode : sponsorCodes) {
            SponsorAction newAction = new SponsorAction();
            newAction.actionType = SponsorActionType.INSERT;
            newAction.hierarchyName = hierarchyName;
            newAction.sponsorCode = sponsorCode;
            newAction.setLevels(levels);
            newAction.setSortIds(sortIds);
            this.addActionToBeSaved(newAction);
        }
    }

    @Override
    public void deleteSponsor(String hierarchyName, String sponsorCode, String[] levels) {
        SponsorAction newAction = new SponsorAction();
        newAction.actionType = SponsorActionType.DELETE;
        newAction.hierarchyName = hierarchyName;
        newAction.sponsorCode = sponsorCode;
        newAction.setLevels(levels);
        this.addActionToBeSaved(newAction);
    }

    @Override
    public void updateGroupName(String hierarchyName, Integer levelToChange, String oldGroupName, String newGroupName, String[] levels) {
        SponsorAction newAction = new SponsorAction();
        newAction.actionType = SponsorActionType.UPDATE_NAME;
        newAction.hierarchyName = hierarchyName;
        newAction.levelToChange = levelToChange;
        newAction.oldGroupName = oldGroupName;
        newAction.newGroupName = newGroupName;
        newAction.setLevels(levels);
        this.addActionToBeSaved(newAction);
    }

    @Override
    public void changeSponsorSortOrder(String hierarchyName, Integer levelToChange, Boolean moveDown, String[] levels) {
        SponsorAction newAction = new SponsorAction();
        newAction.actionType = SponsorActionType.UPDATE_SORT;
        newAction.hierarchyName = hierarchyName;
        newAction.levelToChange = levelToChange;
        newAction.moveDown = moveDown;
        newAction.setLevels(levels);
        this.addActionToBeSaved(newAction);
    }

    protected void addActionToBeSaved(SponsorAction action) {
        ArrayList<SponsorAction> actions = (ArrayList<SponsorAction>)GlobalVariables.getUserSession().retrieveObject(sessionKey);
        if (actions == null) {
            actions = new ArrayList<SponsorAction>();
            GlobalVariables.getUserSession().addObject(sessionKey, actions);
        }
        actions.add(action);
    }

    @Override
    public void executeActions() {
        List actions = (List)GlobalVariables.getUserSession().retrieveObject(sessionKey);
        if (actions != null) {
            for (SponsorAction action : actions) {
                Collection sponsors;
                if (action.actionType == SponsorActionType.INSERT) {
                    SponsorHierarchy newSponsor = new SponsorHierarchy();
                    newSponsor.setHierarchyName(action.hierarchyName);
                    newSponsor.setSponsorCode(action.sponsorCode);
                    newSponsor.setLevel1(action.levels[0]);
                    newSponsor.setLevel2(action.levels[1]);
                    newSponsor.setLevel3(action.levels[2]);
                    newSponsor.setLevel4(action.levels[3]);
                    newSponsor.setLevel5(action.levels[4]);
                    newSponsor.setLevel6(action.levels[5]);
                    newSponsor.setLevel7(action.levels[6]);
                    newSponsor.setLevel8(action.levels[7]);
                    newSponsor.setLevel9(action.levels[8]);
                    newSponsor.setLevel10(action.levels[9]);
                    newSponsor.setLevel1Sortid(action.sortIds[0]);
                    newSponsor.setLevel2Sortid(action.sortIds[1]);
                    newSponsor.setLevel3Sortid(action.sortIds[2]);
                    newSponsor.setLevel4Sortid(action.sortIds[3]);
                    newSponsor.setLevel5Sortid(action.sortIds[4]);
                    newSponsor.setLevel6Sortid(action.sortIds[5]);
                    newSponsor.setLevel7Sortid(action.sortIds[6]);
                    newSponsor.setLevel8Sortid(action.sortIds[7]);
                    newSponsor.setLevel9Sortid(action.sortIds[8]);
                    newSponsor.setLevel10Sortid(action.sortIds[9]);
                    this.getBusinessObjectService().save((PersistableBusinessObject)newSponsor);
                    continue;
                }
                if (action.actionType == SponsorActionType.DELETE) {
                    this.getBusinessObjectService().deleteMatching(SponsorHierarchy.class, this.getFieldValues(action));
                    continue;
                }
                if (action.actionType == SponsorActionType.UPDATE_NAME) {
                    sponsors = this.getBusinessObjectService().findMatching(SponsorHierarchy.class, this.getFieldValues(action));
                    for (SponsorHierarchy sponsor : sponsors) {
                        this.updateGroup(sponsor, action.levelToChange, action.newGroupName);
                        this.getBusinessObjectService().save((PersistableBusinessObject)sponsor);
                    }
                    continue;
                }
                if (action.actionType != SponsorActionType.UPDATE_SORT) continue;
                sponsors = this.getBusinessObjectService().findMatching(SponsorHierarchy.class, this.getFieldValues(action));
                for (SponsorHierarchy sponsor : sponsors) {
                    this.updateSortId(sponsor, action.levelToChange, action.moveDown);
                    this.getBusinessObjectService().save((PersistableBusinessObject)sponsor);
                }
            }
            actions.clear();
        }
    }

    protected void updateGroup(SponsorHierarchy sponsor, Integer level, String newGroupName) {
        try {
            Method setLevelMethod = SponsorHierarchy.class.getMethod("setLevel" + level, String.class);
            setLevelMethod.invoke((Object)sponsor, newGroupName);
        }
        catch (Exception e) {
            LOG.debug((Object)"Error setting group name on sponsor", (Throwable)e);
        }
    }

    protected void updateSortId(SponsorHierarchy sponsor, Integer level, Boolean moveDown) {
        int changeBy = 1;
        if (moveDown.booleanValue()) {
            changeBy = -1;
        }
        try {
            Method setSortIdMethod = SponsorHierarchy.class.getMethod("setLevel" + level + "Sortid", Integer.class);
            Method getSortIdMethod = SponsorHierarchy.class.getMethod("getLevel" + level + "Sortid", null);
            setSortIdMethod.invoke((Object)sponsor, this.getNewSortId((Integer)getSortIdMethod.invoke((Object)sponsor, (Object[])null), changeBy));
        }
        catch (Exception e) {
            LOG.debug((Object)"Error setting new sortId on sponsor", (Throwable)e);
        }
    }

    protected Integer getNewSortId(Integer currentSortId, int changeBy) {
        if (currentSortId == null) {
            currentSortId = 0;
        }
        return currentSortId + changeBy;
    }

    protected Map<String, String> getFieldValues(SponsorAction action) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("hierarchyName", action.hierarchyName);
        if (StringUtils.isNotBlank((String)action.sponsorCode)) {
            fieldValues.put("sponsorCode", action.sponsorCode);
        }
        for (int i = 0; i < action.levels.length; ++i) {
            if (!StringUtils.isNotBlank((String)action.levels[i])) continue;
            fieldValues.put("level" + (i + 1), action.levels[i]);
        }
        if (StringUtils.isNotBlank((String)action.oldGroupName)) {
            fieldValues.put("level" + action.levelToChange, action.oldGroupName);
        }
        return fieldValues;
    }

    @Override
    public void clearCurrentActions() {
        GlobalVariables.getUserSession().removeObject(sessionKey);
    }

    protected boolean evaluateWhetherSponsorHierarchyIncludesNih(SponsorHierarchy sponsorHierarchy) {
        String nihIndicator = this.findNihIndicatorForSponsorHierarchyLevel();
        return sponsorHierarchy.isNihSponsorInAnylevel(nihIndicator);
    }

    protected String findNihIndicatorForSponsorHierarchyLevel() {
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", "sponsorLevelHierarchy");
    }

    protected String findSponsorHierarchyName() {
        return this.parameterService.getParameterValueAsString("KC-GEN", "All", "sponsorGroupHierarchyName");
    }

    protected Collection<SponsorHierarchy> loadSponsorHierarchies(String sponsorCode) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("sponsorCode", sponsorCode);
        valueMap.put("hierarchyName", this.findSponsorHierarchyName());
        ArrayList sponsorHierarchies = this.businessObjectService.findMatching(SponsorHierarchy.class, valueMap);
        if (sponsorHierarchies == null) {
            sponsorHierarchies = new ArrayList();
        }
        return sponsorHierarchies;
    }

    @Override
    public boolean isSponsorNihMultiplePi(Sponsorable sponsorable) {
        return this.isSponsorInHierarchy(sponsorable, "NIH Multiple PI");
    }

    @Override
    public boolean isSponsorNihOsc(Sponsorable sponsorable) {
        return this.isSponsorInHierarchy(sponsorable, "NIH Other Significant Contributor");
    }

    protected boolean isSponsorInHierarchy(Sponsorable sponsorable, String sponsorHierarchy) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("sponsorCode", sponsorable.getSponsorCode());
        valueMap.put("hierarchyName", sponsorHierarchy);
        int matchingHierarchies = this.businessObjectService.countMatching(SponsorHierarchy.class, valueMap);
        return matchingHierarchies > 0;
    }

    @Override
    public List<String> getUniqueGroupingNames(String hierarchyName, Integer level) {
        List<String> result = this.getSponsorHierarchyDao().getUniqueNamesAtLevel(hierarchyName, level);
        Collections.sort(result);
        return result;
    }

    @Override
    public boolean validateSponsor(Sponsor sponsor) {
        boolean valid = true;
        if (sponsor == null || !sponsor.isActive()) {
            valid = false;
        }
        return valid;
    }

    static /* synthetic */ Integer access$000() {
        return HIERARCHY_MAX_HEIGHT;
    }

    protected class SponsorAction {
        public SponsorActionType actionType;
        public String hierarchyName;
        public String sponsorCode;
        public String[] levels = new String[SponsorServiceImpl.access$000().intValue()];
        public Integer[] sortIds = new Integer[SponsorServiceImpl.access$000().intValue()];
        public Integer levelToChange;
        public String oldGroupName;
        public String newGroupName;
        public Boolean moveDown;

        protected SponsorAction() {
        }

        public void setLevels(String[] newLevels) {
            for (int i = 0; i < this.levels.length && i < newLevels.length; ++i) {
                this.levels[i] = newLevels[i];
            }
        }

        public void setSortIds(Integer[] sortIds) {
            for (int i = 0; i < sortIds.length && i < sortIds.length; ++i) {
                this.sortIds[i] = sortIds[i];
            }
        }
    }

    protected static enum SponsorActionType {
        INSERT,
        UPDATE_NAME,
        UPDATE_SORT,
        DELETE;

    }
}

