/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.authorization.TaskAuthorizer;
import org.kuali.kra.authorization.TaskAuthorizerGroup;
import org.kuali.kra.irb.auth.GenericProtocolAuthorizer;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.springframework.transaction.annotation.Transactional;

public class TaskAuthorizationServiceImpl
implements TaskAuthorizationService {
    private Set<String> taskAuthorizerGroupNames = new HashSet<String>();
    private List<TaskAuthorizerGroup> taskAuthorizerGroups = new ArrayList<TaskAuthorizerGroup>();

    @Override
    @Transactional
    public boolean isAuthorized(String userId, Task task) {
        boolean isAuthorized = true;
        String groupName = task.getGroupName();
        for (TaskAuthorizerGroup taskAuthorizerGroup : this.getTaskAuthorizerGroups()) {
            TaskAuthorizer taskAuthorizer;
            if (!StringUtils.equals((String)taskAuthorizerGroup.getGroupName(), (String)groupName)) continue;
            if (task.getGenericTaskName() == null || "".equals(task.getGenericTaskName().trim())) {
                taskAuthorizer = taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName());
            } else if (taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName()) instanceof GenericProtocolAuthorizer) {
                taskAuthorizer = (GenericProtocolAuthorizer)taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName());
                ((GenericProtocolAuthorizer)taskAuthorizer).setGenericTaskName(task.getGenericTaskName());
            } else if (taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName()) instanceof org.kuali.kra.protocol.auth.GenericProtocolAuthorizer) {
                taskAuthorizer = (org.kuali.kra.protocol.auth.GenericProtocolAuthorizer)taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName());
                ((org.kuali.kra.protocol.auth.GenericProtocolAuthorizer)taskAuthorizer).setGenericTaskName(task.getGenericTaskName());
            } else {
                taskAuthorizer = null;
                RuntimeException rte = new RuntimeException("An unexpected GenericProtocolAuthorizer was found, " + taskAuthorizerGroup.getTaskAuthorizer(task.getTaskName()).getClass());
                rte.printStackTrace();
            }
            if (taskAuthorizer == null) break;
            isAuthorized = taskAuthorizer.isAuthorized(userId, task);
            break;
        }
        return isAuthorized;
    }

    public List<TaskAuthorizerGroup> getTaskAuthorizerGroups() {
        if (this.taskAuthorizerGroups.isEmpty()) {
            for (String taskAuthorizerGroupName : this.taskAuthorizerGroupNames) {
                this.taskAuthorizerGroups.add((TaskAuthorizerGroup)GlobalResourceLoader.getService((String)taskAuthorizerGroupName));
            }
        }
        return this.taskAuthorizerGroups;
    }

    public void setTaskAuthorizerGroups(List<TaskAuthorizerGroup> taskAuthorizerGroups) {
        this.taskAuthorizerGroups = taskAuthorizerGroups;
    }

    public Set<String> getTaskAuthorizerGroupNames() {
        return this.taskAuthorizerGroupNames;
    }

    public void setTaskAuthorizerGroupNames(Set<String> taskAuthorizerGroupNames) {
        this.taskAuthorizerGroupNames = taskAuthorizerGroupNames;
    }
}

