/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KraWorkflowService;
import org.kuali.kra.service.TimeAndMoneyExistenceService;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;

public class TimeAndMoneyExistenceServiceImpl
implements TimeAndMoneyExistenceService {
    private KraWorkflowService kraWorkflowService;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;

    @Override
    public boolean validateTimeAndMoneyRule(Award award, String rootAwardNumber) throws WorkflowException {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Boolean timeAndMoneyDocumentDoesNotExist = Boolean.TRUE;
        fieldValues.put("rootAwardNumber", rootAwardNumber);
        BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        List timeAndMoneyDocuments = (List)businessObjectService.findMatching(TimeAndMoneyDocument.class, fieldValues);
        TimeAndMoneyDocument timeAndMoneyDocument = null;
        for (TimeAndMoneyDocument t : timeAndMoneyDocuments) {
            timeAndMoneyDocument = (TimeAndMoneyDocument)this.documentService.getByDocumentHeaderId(t.getDocumentNumber());
            timeAndMoneyDocument.setAwardNumber(award.getAwardNumber());
            timeAndMoneyDocument.setAward(award);
            if (this.kraWorkflowService.isInWorkflow((Document)timeAndMoneyDocument)) continue;
            timeAndMoneyDocumentDoesNotExist = Boolean.FALSE;
            break;
        }
        return timeAndMoneyDocumentDoesNotExist;
    }

    @Override
    public void addAwardVersionErrorMessage() {
        GlobalVariables.getMessageMap().addToErrorPath("document");
        GlobalVariables.getMessageMap().addToErrorPath("award");
        GlobalVariables.getMessageMap().putError("version", "error.award.cannot.be.versioned", new String[0]);
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        GlobalVariables.getMessageMap().removeFromErrorPath("award");
    }

    public KraWorkflowService getKraWorkflowService() {
        return this.kraWorkflowService;
    }

    public void setKraWorkflowService(KraWorkflowService kraWorkflowService) {
        this.kraWorkflowService = kraWorkflowService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

