/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.PermissionAttributes;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.kra.service.UnitAuthorizationService;
import org.kuali.kra.service.UnitService;
import org.kuali.kra.service.impl.KraAuthorizationServiceImpl;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.role.RoleService;

public class UnitAuthorizationServiceImpl
implements UnitAuthorizationService {
    private static final Log LOG = LogFactory.getLog(KraAuthorizationServiceImpl.class);
    private UnitService unitService;
    private SystemAuthorizationService systemAuthorizationService;
    private RoleService roleManagementService;
    private PermissionService permissionService;

    protected RoleService getRoleService() {
        return this.roleManagementService;
    }

    public void setRoleManagementService(RoleService roleManagementService) {
        this.roleManagementService = roleManagementService;
    }

    protected UnitService getUnitService() {
        return this.unitService;
    }

    public void setUnitService(UnitService unitService) {
        this.unitService = unitService;
    }

    protected SystemAuthorizationService getSystemAuthorizationService() {
        return this.systemAuthorizationService;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public boolean hasPermission(String userId, String unitNumber, String namespaceCode, String permissionName) {
        boolean userHasPermission = false;
        Map<String, String> permissionAttributes = PermissionAttributes.getAttributes(permissionName);
        if (unitNumber != null) {
            HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
            qualifiedRoleAttributes.put("unitNumber", unitNumber);
            userHasPermission = this.permissionService.isAuthorized(userId, namespaceCode, permissionName, qualifiedRoleAttributes);
        }
        return userHasPermission;
    }

    @Override
    public boolean hasPermission(String userId, String namespaceCode, String permissionName) {
        boolean userHasPermission = false;
        Map<String, String> permissionAttributes = PermissionAttributes.getAttributes(permissionName);
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", "*");
        userHasPermission = this.permissionService.isAuthorized(userId, namespaceCode, permissionName, qualifiedRoleAttributes);
        return userHasPermission;
    }

    @Override
    public boolean hasMatchingQualifiedUnits(String userId, String namespaceCode, String permissionName, String unitNumber) {
        List<Object> roleIds = new ArrayList();
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", unitNumber);
        roleIds = this.systemAuthorizationService.getRoleIdsForPermission(permissionName, namespaceCode);
        List qualifiers = this.roleManagementService.getNestedRoleQualifiersForPrincipalByRoleIds(userId, roleIds, qualifiedRoleAttributes);
        ArrayList<String> units = new ArrayList<String>();
        for (Map qualifier : qualifiers) {
            String tmpUnitNumber = (String)qualifier.get("unitNumber");
            if (!StringUtils.isNotEmpty((String)tmpUnitNumber)) continue;
            units.add(tmpUnitNumber);
        }
        return CollectionUtils.isNotEmpty(units);
    }

    @Override
    public List<Unit> getUnits(String userId, String namespaceCode, String permissionName) {
        LinkedHashSet<Unit> units = new LinkedHashSet<Unit>();
        List<Object> roleIds = new ArrayList();
        HashMap<String, String> qualifiedRoleAttributes = new HashMap<String, String>();
        qualifiedRoleAttributes.put("unitNumber", "*");
        HashMap qualification = new HashMap(qualifiedRoleAttributes);
        roleIds = this.systemAuthorizationService.getRoleIdsForPermission(permissionName, namespaceCode);
        List qualifiers = this.roleManagementService.getNestedRoleQualifiersForPrincipalByRoleIds(userId, roleIds, qualification);
        for (Map qualifier : qualifiers) {
            Unit unit = this.unitService.getUnit((String)qualifier.get("unitNumber"));
            if (unit == null) continue;
            units.add(unit);
            if (!qualifier.containsKey("subunits") || !StringUtils.equalsIgnoreCase((String)"Y", (String)((String)qualifier.get("subunits")))) continue;
            this.addDescendantUnits(unit, units);
        }
        return new ArrayList<Unit>(units);
    }

    protected void addDescendantUnits(Unit parentUnit, Set<Unit> units) {
        List<Unit> subunits = this.unitService.getSubUnits(parentUnit.getUnitNumber());
        if (CollectionUtils.isNotEmpty(subunits)) {
            units.addAll(subunits);
            for (Unit subunit : subunits) {
                this.addDescendantUnits(subunit, units);
            }
        }
    }
}

