/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.UnitCorrespondent;
import org.kuali.kra.dao.UnitLookupDao;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.UnitService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class UnitServiceImpl
implements UnitService {
    private BusinessObjectService businessObjectService;
    private static final String COLUMN = ":";
    private static final String SEPARATOR = ";1;";
    private static final String DASH = "-";
    private static final String UNIT_NUMBER = "unitNumber";
    private static final String DEFAULT_GROUP_FLAG = "defaultGroupFlag";
    private int numberOfUnits;
    private UnitLookupDao unitLookupDao;

    @Override
    public Unit getUnitCaseInsensitive(String unitNumber) {
        Unit unit = null;
        if (StringUtils.isNotEmpty((String)unitNumber)) {
            unit = this.getUnitLookupDao().findUnitbyNumberCaseInsensitive(unitNumber);
        }
        return unit;
    }

    @Override
    public String getUnitName(String unitNumber) {
        String unitName = null;
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)unitNumber)) {
            primaryKeys.put(UNIT_NUMBER, unitNumber);
            Unit unit = (Unit)this.businessObjectService.findByPrimaryKey(Unit.class, primaryKeys);
            if (unit != null) {
                unitName = unit.getUnitName();
            }
        }
        return unitName;
    }

    @Override
    public Collection<Unit> getUnits() {
        return this.businessObjectService.findAll(Unit.class);
    }

    @Override
    public Unit getUnit(String unitNumber) {
        Unit unit = null;
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        if (StringUtils.isNotEmpty((String)unitNumber)) {
            primaryKeys.put(UNIT_NUMBER, unitNumber);
            unit = (Unit)this.businessObjectService.findByPrimaryKey(Unit.class, primaryKeys);
        }
        return unit;
    }

    @Override
    public List<Unit> getSubUnits(String unitNumber) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("parentUnitNumber", unitNumber);
        units.addAll(this.businessObjectService.findMatching(Unit.class, fieldValues));
        return units;
    }

    @Override
    public List<Unit> getAllSubUnits(String unitNumber) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        List<Unit> subUnits = this.getSubUnits(unitNumber);
        units.addAll(subUnits);
        for (Unit subUnit : subUnits) {
            units.addAll(this.getAllSubUnits(subUnit.getUnitNumber()));
        }
        return units;
    }

    @Override
    public List<Unit> getUnitHierarchyForUnit(String unitNumber) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        Unit thisUnit = this.getUnit(unitNumber);
        if (thisUnit != null) {
            units.addAll(this.getUnitParentsAndSelf(thisUnit));
        }
        return units;
    }

    private List<Unit> getUnitParentsAndSelf(Unit unit) {
        ArrayList<Unit> units = new ArrayList<Unit>();
        if (!StringUtils.isEmpty((String)unit.getParentUnitNumber())) {
            units.addAll(this.getUnitHierarchyForUnit(unit.getParentUnitNumber()));
        }
        units.add(unit);
        return units;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    @Override
    public String getSubUnitsForTreeView(String unitNumber) {
        String subUnits = null;
        int startIdx = unitNumber.indexOf("px\">", unitNumber.indexOf("<tr>"));
        for (Unit unit : this.getSubUnits(unitNumber.substring(startIdx + 4, unitNumber.indexOf(COLUMN, startIdx) - 1))) {
            if (StringUtils.isNotBlank(subUnits)) {
                subUnits = subUnits + "#SEPARATOR#" + unit.getUnitNumber() + " " + COLUMN + " " + unit.getUnitName();
                continue;
            }
            subUnits = unit.getUnitNumber() + " " + COLUMN + " " + unit.getUnitName();
        }
        return subUnits;
    }

    @Override
    public Unit getTopUnit() {
        Unit topUnit = null;
        List allUnits = (List)this.getUnits();
        if (CollectionUtils.isNotEmpty((Collection)allUnits)) {
            for (Unit unit : allUnits) {
                if (!StringUtils.isEmpty((String)unit.getParentUnitNumber())) continue;
                topUnit = unit;
                break;
            }
        }
        return topUnit;
    }

    @Override
    public String getInitialUnitsForUnitHierarchy() {
        Unit instituteUnit = this.getTopUnit();
        int parentIdx = 0;
        String subUnits = instituteUnit.getUnitNumber() + " " + COLUMN + " " + instituteUnit.getUnitName() + SEPARATOR;
        this.numberOfUnits = 0;
        for (Unit unit : this.getSubUnits(instituteUnit.getUnitNumber())) {
            subUnits = subUnits + parentIdx + DASH + unit.getUnitNumber() + " " + COLUMN + " " + unit.getUnitName() + SEPARATOR;
            ++this.numberOfUnits;
            for (Unit unit1 : this.getSubUnits(unit.getUnitNumber())) {
                subUnits = subUnits + this.numberOfUnits + DASH + unit1.getUnitNumber() + " " + COLUMN + " " + unit1.getUnitName() + SEPARATOR;
            }
        }
        subUnits = subUnits.substring(0, subUnits.length() - 3);
        return subUnits;
    }

    @Override
    public String getInitialUnitsForUnitHierarchy(int depth) {
        Unit instituteUnit = this.getTopUnit();
        int parentIdx = 0;
        String subUnits = instituteUnit.getUnitNumber() + " " + COLUMN + " " + instituteUnit.getUnitName() + SEPARATOR;
        this.numberOfUnits = 0;
        for (Unit unit : this.getSubUnits(instituteUnit.getUnitNumber())) {
            subUnits = subUnits + parentIdx + DASH + unit.getUnitNumber() + " " + COLUMN + " " + unit.getUnitName() + SEPARATOR;
            ++this.numberOfUnits;
            if (depth - 2 <= 0) continue;
            subUnits = subUnits + this.getSubUnits(unit, depth - 2);
        }
        subUnits = subUnits.substring(0, subUnits.length() - 3);
        return subUnits;
    }

    protected String getSubUnits(Unit unit, int level) {
        String subUnits = "";
        int parentNum = this.numberOfUnits;
        --level;
        for (Unit unit1 : this.getSubUnits(unit.getUnitNumber())) {
            subUnits = subUnits + parentNum + DASH + unit1.getUnitNumber() + " " + COLUMN + " " + unit1.getUnitName() + SEPARATOR;
            ++this.numberOfUnits;
            if (level <= 0) continue;
            subUnits = subUnits + this.getSubUnits(unit1, level);
        }
        return subUnits;
    }

    @Override
    public List<UnitAdministrator> retrieveUnitAdministratorsByUnitNumber(String unitNumber) {
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(UNIT_NUMBER, unitNumber);
        List unitAdministrators = (List)this.getBusinessObjectService().findMatching(UnitAdministrator.class, queryMap);
        return unitAdministrators;
    }

    @Override
    public int getMaxUnitTreeDepth() {
        return this.getBusinessObjectService().findAll(Unit.class).size();
    }

    public UnitLookupDao getUnitLookupDao() {
        return this.unitLookupDao;
    }

    public void setUnitLookupDao(UnitLookupDao unitLookupDao) {
        this.unitLookupDao = unitLookupDao;
    }

    @Override
    public List<UnitCorrespondent> retrieveUnitCorrespondentsByUnitNumber(String unitNumber) {
        this.businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put(UNIT_NUMBER, unitNumber);
        List unitCorrespondents = (List)this.getBusinessObjectService().findMatching(UnitCorrespondent.class, queryMap);
        return unitCorrespondents;
    }
}

