/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ObjectUtils;

public class VersionHistoryServiceImpl
implements VersionHistoryService {
    public static final String VERSION_STATUS_FIELD = "statusForOjb";
    public static final String SEQUENCE_OWNER_CLASS_NAME_FIELD = "sequenceOwnerClassName";
    public static final String SEQUENCE_OWNER_REFERENCE_VERSION_NAME = "sequenceOwnerVersionNameValue";
    public static final String SEQUENCE_OWNER_REFERENCE_SEQ_NUMBER = "sequenceOwnerSequenceNumber";
    public static final String SEQUENCE_OWNER_SEQUENCE_NUMBER_FIELD = "sequenceOwnerSequenceNumber";
    private BusinessObjectService bos;

    protected VersionHistory createVersionHistory(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner, VersionStatus versionStatus, String userId) {
        VersionHistory versionHistory = new VersionHistory(sequenceOwner, versionStatus, userId, new java.sql.Date(new Date().getTime()));
        ArrayList<VersionHistory> list = new ArrayList<VersionHistory>();
        list.add(versionHistory);
        this.bos.save(list);
        return versionHistory;
    }

    @Override
    public VersionHistory updateVersionHistory(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner, VersionStatus versionStatus, String userId) {
        VersionHistory currentVersion = this.getVersionHistory(sequenceOwner.getClass(), this.getVersionName(sequenceOwner), sequenceOwner.getSequenceNumber());
        if (currentVersion == null) {
            currentVersion = this.createVersionHistory(sequenceOwner, versionStatus, userId);
        }
        currentVersion.setStatus(versionStatus);
        if (versionStatus == VersionStatus.ACTIVE) {
            this.archiveActiveVersions(sequenceOwner.getClass(), this.getVersionName(sequenceOwner), currentVersion);
        }
        this.bos.save((PersistableBusinessObject)currentVersion);
        return currentVersion;
    }

    protected void archiveActiveVersions(Class klass, String versionName, VersionHistory currentVersion) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.ACTIVE.toString());
        for (VersionHistory version : this.bos.findMatching(VersionHistory.class, fieldValues)) {
            if (version.equals((Object)currentVersion)) continue;
            version.setStatus(VersionStatus.ARCHIVED);
            this.bos.save((PersistableBusinessObject)version);
        }
    }

    protected VersionHistory getVersionHistory(Class klass, String versionName, Integer sequenceNumber) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put("sequenceOwnerSequenceNumber", sequenceNumber);
        List history = (List)this.getBusinessObjectService().findMatching(VersionHistory.class, fieldValues);
        if (history != null && !history.isEmpty()) {
            return (VersionHistory)((Object)history.get(0));
        }
        return null;
    }

    private VersionHistory getPendingVersionHistory(List<VersionHistory> list) {
        VersionHistory returnVal = null;
        for (VersionHistory vh : list) {
            if (!vh.getStatus().equals((Object)VersionStatus.PENDING)) continue;
            returnVal = vh;
        }
        return returnVal;
    }

    private VersionHistory getActiveVersionHistory(List<VersionHistory> list) {
        VersionHistory returnVal = null;
        for (VersionHistory vh : list) {
            if (!vh.getStatus().equals((Object)VersionStatus.ACTIVE)) continue;
            returnVal = vh;
        }
        return returnVal;
    }

    @Override
    public VersionHistory findActiveVersion(Class<? extends SequenceOwner> klass, String versionName) {
        ArrayList<VersionHistory> histories = new ArrayList<VersionHistory>(this.bos.findMatching(VersionHistory.class, this.buildFieldValueMapForActiveVersionHistory(klass, versionName)));
        VersionHistory activeVersionHistory = this.findActiveVersionHistory(histories);
        return activeVersionHistory;
    }

    @Override
    public List<VersionHistory> loadVersionHistory(Class<? extends SequenceOwner> klass, String versionName) {
        List<VersionHistory> histories = this.findVersionHistory(klass, versionName);
        if (histories.size() > 0) {
            String versionFieldName = histories.get(0).getSequenceOwnerVersionNameField();
            Map<Integer, SequenceOwner<SequenceOwner<?>>> map = this.findSequenceOwners(klass, versionFieldName, versionName);
            for (VersionHistory vh : histories) {
                SequenceOwner<? extends SequenceOwner<?>> owner = map.get(vh.getSequenceOwnerSequenceNumber());
                if (owner == null) continue;
                vh.setSequenceOwner(owner);
            }
        }
        return histories;
    }

    public void setBusinessObjectService(BusinessObjectService bos) {
        this.bos = bos;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.bos;
    }

    @Override
    public VersionHistory findPendingVersion(Class<? extends SequenceOwner> klass, String versionName, String sequenceNumber) {
        VersionHistory pendingVersionHistory = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put("sequenceOwnerSequenceNumber", sequenceNumber);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.PENDING.name());
        ArrayList histories = new ArrayList(this.bos.findMatching(VersionHistory.class, fieldValues));
        if (CollectionUtils.isNotEmpty(histories)) {
            pendingVersionHistory = (VersionHistory)((Object)histories.get(0));
        }
        return pendingVersionHistory;
    }

    @Override
    public VersionHistory findPendingVersion(Class<? extends SequenceOwner> klass, String versionName) {
        VersionHistory pendingVersionHistory = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.PENDING.name());
        ArrayList histories = new ArrayList(this.bos.findMatching(VersionHistory.class, fieldValues));
        if (CollectionUtils.isNotEmpty(histories)) {
            pendingVersionHistory = (VersionHistory)((Object)histories.get(0));
        }
        return pendingVersionHistory;
    }

    protected Map<String, Object> buildFieldValueMapForActiveVersionHistory(Class<? extends SequenceOwner> klass, String versionName) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        fieldValues.put(VERSION_STATUS_FIELD, VersionStatus.ACTIVE.name());
        return fieldValues;
    }

    protected VersionHistory findActiveVersionHistory(List<VersionHistory> histories) {
        VersionHistory activeVersionHistory = null;
        if (histories.size() > 0) {
            if (histories.size() == 1 && histories.get(0).getStatus() == VersionStatus.ACTIVE) {
                activeVersionHistory = histories.get(0);
            } else {
                for (VersionHistory vh : histories) {
                    if (vh.getStatus() != VersionStatus.ACTIVE) continue;
                    activeVersionHistory = vh;
                    break;
                }
            }
        }
        return activeVersionHistory;
    }

    @Deprecated
    protected Map<Integer, SequenceOwner<? extends SequenceOwner<?>>> findSequenceOwners(Class klass, String versionField, String versionName) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(versionField, versionName);
        Collection c = this.bos.findMatching(klass, fieldValues);
        TreeMap map = new TreeMap();
        for (SequenceOwner owner : c) {
            map.put(owner.getSequenceNumber(), owner);
        }
        return map;
    }

    protected void resetExistingVersionsToArchived(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner, List<VersionHistory> versionHistories, VersionStatus versionStatus) {
        List<VersionHistory> existingEntries = this.loadVersionHistory(sequenceOwner.getClass(), this.getVersionName(sequenceOwner));
        for (VersionHistory versionHistory : existingEntries) {
            if (versionStatus == VersionStatus.CANCELED && versionHistory.getStatus() == VersionStatus.ACTIVE) continue;
            versionHistory.setStatus(VersionStatus.ARCHIVED);
        }
        versionHistories.addAll(existingEntries);
    }

    protected String getVersionName(SequenceOwner<? extends SequenceOwner<?>> sequenceOwner) {
        return ObjectUtils.getPropertyValue(sequenceOwner, (String)sequenceOwner.getVersionNameField()).toString();
    }

    @Override
    public List<VersionHistory> findVersionHistory(Class<? extends SequenceOwner> klass, String versionName) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(SEQUENCE_OWNER_CLASS_NAME_FIELD, klass.getName());
        fieldValues.put(SEQUENCE_OWNER_REFERENCE_VERSION_NAME, versionName);
        return new ArrayList<VersionHistory>(this.bos.findMatching(VersionHistory.class, fieldValues));
    }

    public void loadSequenceOwner(Class klass, VersionHistory versionHistory) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(versionHistory.getSequenceOwnerVersionNameField(), versionHistory.getSequenceOwnerVersionNameValue());
        fieldValues.put("sequenceNumber", versionHistory.getSequenceOwnerSequenceNumber());
        Collection c = this.bos.findMatching(klass, fieldValues);
        for (SequenceOwner sequenceOwner : c) {
            versionHistory.setSequenceOwner(sequenceOwner);
        }
    }

    @Override
    public VersionHistory getActiveOrNewestVersion(Class<? extends SequenceOwner> klass, String versionName) {
        List<VersionHistory> versions = this.findVersionHistory(klass, versionName);
        VersionHistory history = null;
        for (VersionHistory version : versions) {
            if (history == null) {
                history = version;
                continue;
            }
            if (version.isActiveVersion()) {
                history = version;
                continue;
            }
            if (history.isActiveVersion() || version.getSequenceOwnerSequenceNumber() <= history.getSequenceOwnerSequenceNumber() || version.getStatus() == VersionStatus.CANCELED) continue;
            history = version;
        }
        return history;
    }
}

