/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.bo;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiable;
import org.kuali.kra.negotiations.bo.NegotiationPersonDTO;
import org.kuali.kra.proposaldevelopment.bo.ProposalType;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.OrganizationService;
import org.kuali.kra.service.UnitService;
import org.kuali.kra.subaward.bo.SubAwardAmountInfo;
import org.kuali.kra.subaward.bo.SubAwardAmountReleased;
import org.kuali.kra.subaward.bo.SubAwardCloseout;
import org.kuali.kra.subaward.bo.SubAwardContact;
import org.kuali.kra.subaward.bo.SubAwardFundingSource;
import org.kuali.kra.subaward.bo.SubAwardStatus;
import org.kuali.kra.subaward.customdata.SubAwardCustomData;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.springframework.util.AutoPopulatingList;

public class SubAward
extends KraPersistableBusinessObjectBase
implements Permissionable,
SequenceOwner<SubAward>,
Negotiable {
    private static final long serialVersionUID = 1L;
    private static final String ROLODEX_ID_FIELD_NAME = "rolodexId";
    public static final String NOTIFICATION_TYPE_SUBMIT = "501";
    private Long subAwardId;
    private String subAwardCode;
    private Integer sequenceNumber;
    private String organizationId;
    private Date startDate;
    private Date endDate;
    private Integer subAwardTypeCode;
    private String purchaseOrderNum;
    private String title;
    private Integer statusCode;
    private String statusDescription;
    private String accountNumber;
    private String vendorNumber;
    private String requisitionerId;
    private String requisitionerUnit;
    private String archiveLocation;
    private Date closeoutDate;
    private String closeoutIndicator;
    private String fundingSourceIndicator;
    private String comments;
    private Integer siteInvestigator;
    private SubAwardDocument subAwardDocument;
    private SubAwardFundingSource subAwardFundingSource;
    private SubAwardContact subAwardContact;
    private SubAwardCloseout subAwardCloseout;
    private SubAwardAmountInfo subAwardAmountInfo;
    private String organizationName;
    private String requisitionerName;
    private String requisitionerUnitName;
    private String requisitionerUserName;
    private String siteInvestigatorName;
    private String siteInvestigatorId;
    private Organization organization;
    private Unit unit;
    private Rolodex rolodex;
    private transient String rolodexFirstName;
    private SubAwardStatus subAwardStatus;
    private AwardType subAwardType;
    private KcPerson kcPerson;
    private String subAwardSequenceStatus;
    private static boolean newVersion;
    private KualiDecimal totalObligatedAmount;
    private KualiDecimal totalAnticipatedAmount;
    private KualiDecimal totalAmountReleased;
    private KualiDecimal totalAvailableAmount;
    private transient String docIdStatus;
    private transient String lastUpdate;
    private String awardNumber;
    private transient boolean editSubAward = false;
    private transient boolean defaultOpen = true;
    private List<SubAwardFundingSource> subAwardFundingSourceList;
    private List<SubAwardAmountInfo> subAwardAmountInfoList;
    private List<SubAwardContact> subAwardContactsList;
    private List<SubAwardCloseout> subAwardCloseoutList;
    private List<SubAwardCustomData> subAwardCustomDataList;

    public Rolodex getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(Rolodex rolodex) {
        this.rolodex = rolodex;
    }

    public KcPerson getKcPerson() {
        return this.kcPerson;
    }

    public void setKcPerson(KcPerson kcPerson) {
        this.kcPerson = kcPerson;
    }

    public String getSubAwardSequenceStatus() {
        return this.subAwardSequenceStatus;
    }

    public void setSubAwardSequenceStatus(String subAwardSequenceStatus) {
        this.subAwardSequenceStatus = subAwardSequenceStatus;
    }

    public String getRolodexFirstName() {
        if (this.getRolodex() == null) {
            return this.rolodexFirstName;
        }
        return this.getRolodex().getFirstName();
    }

    public void setRolodexFirstName(String rolodexFirstName) {
        this.rolodexFirstName = rolodexFirstName;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization organization) {
        this.organization = organization;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String getOrganizationName() {
        Organization organization = this.getOrganization();
        if (organization != null) {
            return organization.getOrganizationName();
        }
        return this.organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public String getRequisitionerName() {
        this.getRequisitionerUserName();
        return this.requisitionerName;
    }

    public void setRequisitionerName(String requisitionerName) {
        this.requisitionerName = requisitionerName;
    }

    public String getRequisitionerUnitName() {
        return this.requisitionerUnitName;
    }

    public void setRequisitionerUnitName(String requisitionerUnitName) {
        this.requisitionerUnitName = requisitionerUnitName;
    }

    public String getRequisitionerUserName() {
        if (this.requisitionerId != null) {
            KcPerson requisitioner = this.getRequisitioner();
            if (requisitioner != null) {
                this.requisitionerName = requisitioner.getFullName();
                this.requisitionerUserName = requisitioner.getUserName();
            }
        } else {
            this.requisitionerName = null;
        }
        return this.requisitionerUserName;
    }

    public void setRequisitionerUserName(String requisitionerUserName) {
        if (requisitionerUserName != null) {
            KcPerson requisitioner = KraServiceLocator.getService(KcPersonService.class).getKcPersonByUserName(requisitionerUserName);
            if (requisitioner != null) {
                this.requisitionerId = requisitioner.getPersonId();
            }
        } else {
            this.requisitionerName = null;
        }
        this.requisitionerUserName = requisitionerUserName;
    }

    public KcPerson getRequisitioner() {
        if (this.requisitionerId != null) {
            return KraServiceLocator.getService(KcPersonService.class).getKcPersonByPersonId(this.requisitionerId);
        }
        return null;
    }

    public String getSiteInvestigatorName() {
        return this.siteInvestigatorName;
    }

    public void setSiteInvestigatorName(String siteInvestigatorName) {
        this.siteInvestigatorName = siteInvestigatorName;
    }

    public SubAward() {
        this.initializeCollections();
        this.initialize();
    }

    protected void initialize() {
        this.setSequenceNumber(1);
        this.subAwardSequenceStatus = VersionStatus.PENDING.name();
        this.setNewVersion(false);
    }

    public Long getSubAwardId() {
        return this.subAwardId;
    }

    public void setSubAwardId(Long subAwardId) {
        this.subAwardId = subAwardId;
    }

    public String getSubAwardCode() {
        return this.subAwardCode;
    }

    public void setSubAwardCode(String subAwardCode) {
        this.subAwardCode = subAwardCode;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getOrganizationId() {
        OrganizationService organizationService = KraServiceLocator.getService(OrganizationService.class);
        this.organization = organizationService.getOrganization(this.organizationId);
        return this.organizationId;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public Integer getSubAwardTypeCode() {
        return this.subAwardTypeCode;
    }

    public void setSubAwardTypeCode(Integer subAwardTypeCode) {
        this.subAwardTypeCode = subAwardTypeCode;
    }

    public String getPurchaseOrderNum() {
        return this.purchaseOrderNum;
    }

    public void setPurchaseOrderNum(String purchaseOrderNum) {
        this.purchaseOrderNum = purchaseOrderNum;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getVendorNumber() {
        return this.vendorNumber;
    }

    public void setVendorNumber(String vendorNumber) {
        this.vendorNumber = vendorNumber;
    }

    public String getRequisitionerId() {
        return this.requisitionerId;
    }

    public void setRequisitionerId(String requisitionerId) {
        this.requisitionerId = requisitionerId;
    }

    public String getRequisitionerUnit() {
        if (this.requisitionerUnit != null) {
            UnitService unitService = KraServiceLocator.getService(UnitService.class);
            this.unit = unitService.getUnit(this.requisitionerUnit);
        }
        return this.requisitionerUnit;
    }

    public void setRequisitionerUnit(String requisitionerUnit) {
        this.requisitionerUnit = requisitionerUnit;
    }

    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    public Date getCloseoutDate() {
        return this.closeoutDate;
    }

    public void setCloseoutDate(Date closeoutDate) {
        this.closeoutDate = closeoutDate;
    }

    public String getCloseoutIndicator() {
        return this.closeoutIndicator;
    }

    public void setCloseoutIndicator(String closeoutIndicator) {
        this.closeoutIndicator = closeoutIndicator;
    }

    public String getFundingSourceIndicator() {
        return this.fundingSourceIndicator;
    }

    public void setFundingSourceIndicator(String fundingSourceIndicator) {
        this.fundingSourceIndicator = fundingSourceIndicator;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Integer getSiteInvestigator() {
        if (this.siteInvestigator != null) {
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            this.rolodex = (Rolodex)businessObjectService.findByPrimaryKey(Rolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, this.siteInvestigator));
            this.siteInvestigatorId = this.rolodex.getRolodexId().toString();
        } else {
            this.rolodex = null;
        }
        return this.siteInvestigator;
    }

    public void setSiteInvestigator(Integer siteInvestigator) {
        if (siteInvestigator != null) {
            BusinessObjectService businessObjectService = KraServiceLocator.getService(BusinessObjectService.class);
            this.rolodex = (NonOrganizationalRolodex)businessObjectService.findByPrimaryKey(NonOrganizationalRolodex.class, this.getIdentifierMap(ROLODEX_ID_FIELD_NAME, siteInvestigator));
            this.siteInvestigatorId = this.rolodex.getRolodexId().toString();
        }
        this.siteInvestigator = siteInvestigator;
    }

    public SubAwardFundingSource getSubAwardFundingSource() {
        return this.subAwardFundingSource;
    }

    public void setSubAwardFundingSource(SubAwardFundingSource subAwardFundingSource) {
        this.subAwardFundingSource = subAwardFundingSource;
    }

    public SubAwardContact getSubAwardContact() {
        return this.subAwardContact;
    }

    public void setSubAwardContact(SubAwardContact subAwardContact) {
        this.subAwardContact = subAwardContact;
    }

    public SubAwardCloseout getSubAwardCloseout() {
        return this.subAwardCloseout;
    }

    public void setSubAwardCloseout(SubAwardCloseout subAwardCloseout) {
        this.subAwardCloseout = subAwardCloseout;
    }

    public SubAwardAmountInfo getSubAwardAmountInfo() {
        return this.subAwardAmountInfo;
    }

    public void setSubAwardAmountInfo(SubAwardAmountInfo subAwardAmountInfo) {
        this.subAwardAmountInfo = subAwardAmountInfo;
    }

    public List<SubAwardFundingSource> getSubAwardFundingSourceList() {
        return this.subAwardFundingSourceList;
    }

    public void setSubAwardFundingSourceList(List<SubAwardFundingSource> subAwardFundingSourceList) {
        this.subAwardFundingSourceList = subAwardFundingSourceList;
    }

    public List<SubAwardAmountInfo> getSubAwardAmountInfoList() {
        return this.subAwardAmountInfoList;
    }

    public void setSubAwardAmountInfoList(List<SubAwardAmountInfo> subAwardAmountInfoList) {
        this.subAwardAmountInfoList = subAwardAmountInfoList;
    }

    public List<SubAwardAmountReleased> getSubAwardAmountReleasedList() {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("subAwardCode", this.getSubAwardCode());
        return (List)KraServiceLocator.getService(BusinessObjectService.class).findMatchingOrderBy(SubAwardAmountReleased.class, values, "createdDate", false);
    }

    public List<SubAwardContact> getSubAwardContactsList() {
        return this.subAwardContactsList;
    }

    public void setSubAwardContactsList(List<SubAwardContact> subAwardContactsList) {
        this.subAwardContactsList = subAwardContactsList;
    }

    public List<SubAwardCloseout> getSubAwardCloseoutList() {
        return this.subAwardCloseoutList;
    }

    public void setSubAwardCloseoutList(List<SubAwardCloseout> subAwardCloseoutList) {
        this.subAwardCloseoutList = subAwardCloseoutList;
    }

    public List<SubAwardCustomData> getSubAwardCustomDataList() {
        return this.subAwardCustomDataList;
    }

    public void setSubAwardCustomDataList(List<SubAwardCustomData> subAwardCustomDataList) {
        this.subAwardCustomDataList = subAwardCustomDataList;
    }

    public String getStatusDescription() {
        SubAwardStatus status = this.getSubAwardStatus();
        this.statusDescription = status != null ? status.getDescription() : null;
        return this.statusDescription;
    }

    protected void initializeCollections() {
        this.subAwardFundingSourceList = new AutoPopulatingList(SubAwardFundingSource.class);
        this.subAwardAmountInfoList = new AutoPopulatingList(SubAwardAmountInfo.class);
        this.subAwardContactsList = new AutoPopulatingList(SubAwardContact.class);
        this.subAwardCloseoutList = new AutoPopulatingList(SubAwardCloseout.class);
        this.subAwardCustomDataList = new AutoPopulatingList(SubAwardCustomData.class);
    }

    public void setSubAwardDocument(SubAwardDocument subAwardDocument) {
        this.subAwardDocument = subAwardDocument;
    }

    public SubAwardDocument getSubAwardDocument() {
        if (this.subAwardDocument == null) {
            this.refreshReferenceObject("subAwardDocument");
        }
        return this.subAwardDocument;
    }

    public void setSubAwardStatus(SubAwardStatus subAwardStatus) {
        this.subAwardStatus = subAwardStatus;
    }

    public SubAwardStatus getSubAwardStatus() {
        if (this.subAwardStatus == null && this.statusCode != null) {
            this.refreshReferenceObject("subAwardStatus");
        }
        return this.subAwardStatus;
    }

    public void setSubAwardType(AwardType subAwardType) {
        this.subAwardType = subAwardType;
    }

    public AwardType getSubAwardType() {
        return this.subAwardType;
    }

    @Override
    public String getDocumentNumberForPermission() {
        if (this.subAwardId != null) {
            return this.subAwardId.toString();
        }
        return null;
    }

    @Override
    public String getDocumentKey() {
        return "SubAwardDocument";
    }

    @Override
    public List<String> getRoleNames() {
        return null;
    }

    @Override
    public String getNamespace() {
        return "KC-SUBAWARD";
    }

    @Override
    public String getLeadUnitNumber() {
        return this.getUnit() != null ? this.getUnit().getUnitNumber() : "";
    }

    @Override
    public String getDocumentRoleTypeCode() {
        return null;
    }

    @Override
    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
        if (this.getSubAwardDocument() != null) {
            qualifiedRoleAttributes.put("documentNumber", this.getSubAwardDocument().getDocumentNumber());
        }
    }

    @Override
    public void incrementSequenceNumber() {
        SubAward subAward = this;
        Integer n = subAward.sequenceNumber;
        Integer n2 = subAward.sequenceNumber = Integer.valueOf(subAward.sequenceNumber + 1);
    }

    @Override
    public void setSequenceOwner(SubAward newlyVersionedOwner) {
    }

    @Override
    public SubAward getSequenceOwner() {
        return this;
    }

    @Override
    public void resetPersistenceState() {
        this.subAwardId = null;
    }

    @Override
    public Integer getOwnerSequenceNumber() {
        return null;
    }

    @Override
    public String getVersionNameField() {
        return "subAwardCode";
    }

    public void setNewVersion(boolean newVersion) {
        SubAward.newVersion = newVersion;
    }

    public boolean getNewVersion() {
        return newVersion;
    }

    public KualiDecimal getTotalObligatedAmount() {
        return this.totalObligatedAmount;
    }

    public String getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(String lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public void setTotalObligatedAmount(KualiDecimal totalObligatedAmount) {
        this.totalObligatedAmount = totalObligatedAmount;
    }

    public KualiDecimal getTotalAnticipatedAmount() {
        return this.totalAnticipatedAmount;
    }

    public void setTotalAnticipatedAmount(KualiDecimal totalAnticipatedAmount) {
        this.totalAnticipatedAmount = totalAnticipatedAmount;
    }

    public KualiDecimal getTotalAmountReleased() {
        return this.totalAmountReleased;
    }

    public void setTotalAmountReleased(KualiDecimal totalAmountReleased) {
        this.totalAmountReleased = totalAmountReleased;
    }

    public KualiDecimal getTotalAvailableAmount() {
        return this.totalAvailableAmount;
    }

    public void setTotalAvailableAmount(KualiDecimal totalAvailableAmount) {
        this.totalAvailableAmount = totalAvailableAmount;
    }

    public String getDocIdStatus() {
        return this.docIdStatus;
    }

    public void setDocIdStatus(String docIdStatus) {
        this.docIdStatus = docIdStatus;
    }

    public String getSiteInvestigatorId() {
        if (this.siteInvestigatorId == null && this.siteInvestigator != null) {
            this.siteInvestigatorId = this.siteInvestigator.toString();
        }
        return this.siteInvestigatorId;
    }

    public void setSiteInvestigatorId(String siteInvestigatorId) {
        this.siteInvestigatorId = siteInvestigatorId;
    }

    @Override
    public String getAssociatedDocumentId() {
        return this.getSubAwardCode();
    }

    @Override
    public String getLeadUnitName() {
        return this.getUnit() != null ? this.getUnit().getUnitName() : "";
    }

    @Override
    public String getPiName() {
        return "";
    }

    @Override
    public String getPiEmployeeName() {
        return "";
    }

    @Override
    public String getPiNonEmployeeName() {
        return "";
    }

    @Override
    public String getAdminPersonName() {
        return "";
    }

    @Override
    public String getSponsorCode() {
        return "";
    }

    @Override
    public String getSponsorName() {
        return "";
    }

    @Override
    public String getPrimeSponsorCode() {
        return "";
    }

    @Override
    public String getPrimeSponsorName() {
        return "";
    }

    @Override
    public String getSponsorAwardNumber() {
        return "";
    }

    @Override
    public String getSubAwardOrganizationName() {
        return this.getOrganization() != null ? this.getOrganization().getOrganizationName() : "";
    }

    @Override
    public List<NegotiationPersonDTO> getProjectPeople() {
        ArrayList<NegotiationPersonDTO> people = new ArrayList<NegotiationPersonDTO>();
        if (this.getKcPerson() != null) {
            people.add(new NegotiationPersonDTO(this.getKcPerson(), "admin"));
        }
        return people;
    }

    @Override
    public String getNegotiableProposalTypeCode() {
        return "";
    }

    @Override
    public ProposalType getNegotiableProposalType() {
        return null;
    }

    @Override
    public String getSubAwardRequisitionerName() {
        return this.getRequisitionerName();
    }

    @Override
    public String getSubAwardRequisitionerUnitNumber() {
        return this.getUnit() != null ? this.getUnit().getUnitNumber() : "";
    }

    @Override
    public String getSubAwardRequisitionerUnitName() {
        return this.getUnit() != null ? this.getUnit().getUnitName() : "";
    }

    @Override
    public String getSubAwardRequisitionerId() {
        return this.getRequisitionerId();
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public boolean isEditSubAward() {
        return this.editSubAward;
    }

    public void setEditSubAward(boolean editSubAward) {
        this.editSubAward = editSubAward;
    }

    protected Map<String, Object> getIdentifierMap(String identifierField, Object identifierValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(identifierField, identifierValue);
        return map;
    }

    public boolean isDefaultOpen() {
        return this.defaultOpen;
    }

    public void setDefaultOpen(boolean defaultOpen) {
        this.defaultOpen = defaultOpen;
    }
}

