/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.subaward.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.subaward.document.SubAwardDocument;
import org.kuali.kra.subaward.document.authorization.SubAwardTask;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public class SubAwardDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        String userId = user.getPrincipalId();
        SubAwardDocument subawardDocument = (SubAwardDocument)document;
        if (subawardDocument.getSubAward().getSubAwardId() == null) {
            if (this.canCreateSubAward(user.getPrincipalId())) {
                editModes.add("fullEntry");
            } else {
                editModes.add("unviewable");
            }
        } else {
            if (this.canExecuteSubAwardTask(userId, subawardDocument, "modifySubaward")) {
                editModes.add("fullEntry");
            } else if (this.canExecuteSubAwardTask(userId, subawardDocument, "viewSubaward")) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (this.canExecuteSubAwardTask(userId, subawardDocument, "createSubaward")) {
                editModes.add("createSubaward");
            }
        }
        return editModes;
    }

    private boolean canExecuteSubAwardTask(String userId, SubAwardDocument subawardDocument, String taskName) {
        SubAwardTask task = new SubAwardTask(taskName, subawardDocument);
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    private boolean canCreateSubAward(String userId) {
        ApplicationTask task = new ApplicationTask("createSubaward");
        return this.getTaskAuthorizationService().isAuthorized(userId, task);
    }

    public boolean canOpen(Document document, Person user) {
        SubAwardDocument subAwardDocument = (SubAwardDocument)document;
        if (subAwardDocument.getSubAward().getSubAwardId() == null) {
            return this.canCreateSubAward(user.getPrincipalId());
        }
        return this.canExecuteSubAwardTask(user.getPrincipalId(), (SubAwardDocument)document, "viewSubaward");
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateSubAward(user.getPrincipalId());
    }

    @Override
    public boolean canEdit(Document document, Person user) {
        return this.canExecuteSubAwardTask(user.getPrincipalId(), (SubAwardDocument)document, "modifySubaward");
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    @Override
    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

